/* BSE - Bedevilled Sound Engine
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#include	<bse.h>




int
main (int argc, char *argv[])
{
  BseErrorType error;
  BseIoData *io_data;
  BseSample *sample;
  gchar *f_name;
  BseStream *pcm_stream;
  const gchar *pcm_device;


  /* BSE Initialization
   */
  bse_init (&argc, &argv);

  /* Setup output stream, we use the soundcard (PCM).
   */
  pcm_stream = bse_pcm_stream_new ();
  if (!pcm_stream)
    {
      g_warning ("No PCM Streams available on this platform");
      return -1;
    }
  pcm_device = bse_pcm_stream_get_default_device ();
  
  /* Read samples
   */
  f_name = "../sample.bsw";
  f_name = "./test.bsw";
  f_name = "./song.bss";
  f_name = "./bolingo-cut.bse";
  f_name = "/samples/bolingo.bse";
  printf ("start reading...\n");
  io_data = bse_io_load_auto (f_name, BSE_IO_DATA_SAMPLES | BSE_IO_DATA_BINARY_APPENDIX);
  if (io_data->error)
    printf ("reading \"%s\" failed: %s\n", f_name, bse_error_type_get_description (io_data->error));
  else
    printf ("no errors encountered loading \"%s\"\n", f_name);

  error = bse_load_wav ("/public/sound/wav/koks.wav", &sample);
  if (error)
  {
    g_print ("WAVE file loading failed: %s\n", bse_error_type_get_description (error));
    return -1;
  }
  // bse_io_data_destroy (io_data);


  /* Open output stream, PCM streams provide a default device name.
   */
  error = bse_stream_open (pcm_stream, pcm_device, FALSE, TRUE);
  if (!error)
    {
      BseStreamAttribs attributes;
      BseStreamAttribMask attribute_mask = BSE_SA_NONE;
      
      attributes.n_channels = 1;
      attributes.play_frequency = 22150;
      attributes.play_frequency = 44100;
      attribute_mask |= BSE_SA_N_CHANNELS | BSE_SA_PLAY_FREQUENCY;
      
      error = bse_stream_set_attribs (pcm_stream, attribute_mask, &attributes);
      if (!error)
	{
	  g_print ("Using %s stream \"%s\" with %uHz in %u channel mode\n",
		   pcm_stream->type_name,
		   pcm_stream->name,
		   attributes.play_frequency,
		   attributes.n_channels);
	  g_print ("output buffer size: %d\n", bse_get_obuffer_size ());
	}
    }
  if (error)
    {
      g_warning ("Opening PCM stream `%s' failed: %s\n",
		 pcm_device,
		 bse_error_type_get_description (error));
      return -1;
    }



  sample = bse_sample_lookup ("bolingo");
  g_assert (sample != NULL);

  g_print ("Sample to play: blurb-\"%s\" n_channels(%d) rec_freq(%d)\n",
	   bse_sample_get_blurb (sample),
	   sample->n_channels,
	   sample->recording_freq);
  
  bse_stream_start (pcm_stream);

  {
    BseSampleValue *v = sample->munk[0].values;
    gint left = sample->munk[0].n_values;
    gint n = pcm_stream->attribs.fragment_size * 2;

    if (n > left)
      n = left;
    while (left > 0)
      {
	if (bse_stream_would_block (pcm_stream, n))
	  {
	    do
	      {
		printf ("waiting...\n");
		usleep (100 * 1000);
	      }
	    while (bse_stream_would_block (pcm_stream, n));
	  }
      bse_stream_write (pcm_stream, n, v);
      
      v += n;
      left -= n;
      if (n > left)
	n = left;
    }
  }

  bse_stream_unref (pcm_stream);

  return 0;
}

/*
x()
{
  gboolean break = FALSE;
  
  bse_song_play_init(song);
  while (bse_song_elapses() && !break)
  {
    while (!bse_pcm_would_block())
    {
      BseSampleValue *values;
      
      bse_fill_buffer (n_values, values);
      bse_pcm_play(n_values, values);
    }
    
    gtk_main_iteration ();
  }
  bse_song_play_shutdown();
}
*/
