/* BSE - Bedevilled Sound Engine
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#include	"bsevoice.h"



/* --- functions --- */
BseVoice*
bse_voice_block_alloc (guint          n_voices)
{
  BseVoice *voices;
  guint i;

  g_return_val_if_fail (n_voices > 0, NULL);

  voices = g_new0 (BseVoice, n_voices);

  for (i = 0; i < n_voices; i++)
    {
      voices[i].note = NULL;
      voices[i].next_note = NULL;
      voices[i].sample_pos = NULL;
      voices[i].sample_end_pos = NULL;
      voices[i].last_instrument = NULL;
      voices[i].last_sample = NULL;

      bse_voice_reset (voices + i);
    }

  return voices;
}

void
bse_voice_block_free (BseVoice       *voices)
{
  g_return_if_fail (voices != NULL);

  g_free (voices);
}

void
bse_voice_reset (BseVoice *voice)
{
  g_return_if_fail (voice != NULL);

  voice->note = NULL;
  voice->next_note = NULL;
  voice->volume = 0;
  voice->balance = 0;
  voice->channel_index = 0;
  voice->active = FALSE;
  
  voice->sample_munk_index = 0;
  voice->sample_rate = 0;
  voice->sample_rate_offset = 0;
  voice->sample_pos_frac = 0;
  voice->sample_pos = 0;
  voice->sample_end_pos = 0;

  voice->last_instrument = 0;
  voice->last_sample = 0;
  voice->last_volume = 0;

  voice->envelope_switch = 0;
  voice->envelope_volume = 0;

  voice->lfo = NULL;
}
