/* BSE - Bedevilled Sound Engine
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __BSE_MIXER_H__
#define __BSE_MIXER_H__

#include	<bse/bsesong.h>
#include	<bse/bseinstrument.h>
#include	<bse/bsevoice.h>
#include	<bse/bsepattern.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */



/* --- prototypes --- */
void		bse_mixer_init			(guint		n_buffers);
gboolean	bse_mixer_active		(void);
void		bse_mixer_shutdown		(void);
void		bse_mixer_activate_voice	(BseVoice	*voice,
						 BseNote	*note);
void		bse_mixer_fill_buffer		(BseMixerValue	*mixer_buffer,
						 guint           n_voices,
						 BseVoice       *voices);
void		bse_mixer_set_n_output_channels	(guint		n_channels);
void		bse_mixer_set_mix_freq		(guint		mixing_freq);
void		bse_mixer_set_n_values		(guint		n_values);
BseMixerValue*	bse_mixer_get_buffer		(guint		buffer_index);
guint		bse_mixer_get_n_output_channels	(void);
guint		bse_mixer_get_mix_freq		(void);
guint		bse_mixer_get_n_buffer_values	(void);






#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif /* __BSE_MIXER_H__ */
