/* BSE - Bedevilled Sound Engine
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * bsedefs.h: structure prototypes for libbse
 */
#ifndef __BSE_DEFS_H__
#define __BSE_DEFS_H__

#include	<bse/bseenums.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */



/* --- data types --- */
typedef	gint16			BseSampleValue;
typedef	gint32			BseMixerValue;


/* --- global structure typedefs --- */
typedef struct	_BseCallbackNode	BseCallbackNode;
typedef struct	_BseEffect		BseEffect;
typedef struct	_BseInstrument		BseInstrument;
typedef struct	_BseIoData		BseIoData;
typedef struct	_BseLfo			BseLfo;
typedef struct	_BseMunk		BseMunk;
typedef struct	_BseNote		BseNote;
typedef struct	_BsePattern		BsePattern;
typedef struct	_BsePcmConfig		BsePcmConfig;
typedef struct	_BseSample		BseSample;
typedef struct	_BseSampleClass		BseSampleClass;
typedef struct	_BseSampleHashEntry	BseSampleHashEntry;
typedef	struct	_BseSequencer		BseSequencer;
typedef struct	_BseSong		BseSong;
typedef struct	_BseSongClass		BseSongClass;
typedef	struct	_BseStream		BseStream;
typedef	struct	_BseStreamAttribs	BseStreamAttribs;
typedef struct	_BseValueBlock		BseValueBlock;
typedef struct	_BseVoice		BseVoice;


/* --- function types --- */
typedef void	(*BseGenericCB)		(gpointer	 callback_data);
typedef void	(*BseSequencerTickCB)	(gpointer	 callback_data,
					 BseSong	*song,
					 BsePattern	*pattern,
					 guint		 row);
typedef void	(*BsePercentageCB)	(gpointer	 callback_data,
					 const gchar	*job_description,
					 gfloat		 percentage);
typedef	BseIoData* (*BseSampleLookupCB)	(gpointer	 callback_data,
					 const gchar	*sample_name,
					 const gchar	*sample_path);
typedef void	(*BsePrintFunc)		(gpointer	 func_data,
					 gchar		*str);


/* --- calback node --- */
struct _BseCallbackNode
{
  BseGenericCB		 callback;
  gpointer		 callback_data;
  BseCallbackNode	*next;
};






#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif /* __BSE_DEFS_H__ */
