/* BEAST - Bedevilled Audio System
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __BST_SHELL_H__
#define __BST_SHELL_H__

#include	<bse/bse.h>
#include	<gtk/gtk.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */


#define	BST_SHELL(object)		(GTK_CHECK_CAST (object, bst_shell_get_type (), BstShell))
#define	BST_SHELL_CLASS(klass)		(GTK_CHECK_CLASS_CAST (klass, bst_shell_get_type (), BstShellClass))
#define	BST_IS_SHELL(object)		(GTK_CHECK_TYPE (object, bst_shell_get_type ()))


typedef	struct	_BstShell		BstShell;
typedef	struct	_BstShellClass		BstShellClass;


struct	_BstShell
{
  GtkWindow	window;

  GtkObject	*menubar_factory;
  GtkWidget	*clist;

  GList		*orphan_samples;

  /* dialogs
   */
  GtkWidget *dialog_song_new;
  GtkFileSelection *dialog_file_open;
};

struct	_BstShellClass
{
  GtkWindowClass	parent_class;

  gchar			*factories_path;

  void	(*test_signal)	(void);
};

typedef enum
{
  BST_SHELL_OP_NONE,
  BST_SHELL_OP_SONG_NEW,
  BST_SHELL_OP_OPEN_SONG,
  BST_SHELL_OP_OPEN_SAMPLE,
  BST_SHELL_OP_OPEN_ANY,
  BST_SHELL_OP_PREFERENCES,
  BST_SHELL_OP_ABOUT,
  BST_SHELL_OP_DELETE,
  BST_SHELL_OP_UPDATE_SONGS,
  BST_SHELL_OP_UPDATE_SAMPLES,
  BST_SHELL_OP_UPDATE_ALL,
  BST_SHELL_OP_LAST
} BstShellOps;


GtkType		bst_shell_get_type		(void);
BstShell*	bst_shell_get			(void);
void		bst_shell_adapt_sample		(BstShell	*shell,
						 BseSample	*sample);
void		bst_shell_operation		(BstShell	*shell,
						 BstShellOps	 shell_op);
void		bst_shell_update_samples	(BstShell	*shell);
void		bst_shell_update_songs		(BstShell	*shell);
     


#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif /* __BST_SHELL_H__ */
