/* BEAST - Bedevilled Audio System
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __BST_RCARGS_H__
#define __BST_RCARGS_H__

#include	"bstrc.h"


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */


/* argument definitions
 */
#define	BST_RCARGS_DEFS()	\
  BST_RCARG_ITERATOR (Bool,		TRACK_SHELL_MOVEMENTS	) \
  BST_RCARG_ITERATOR (Long,		SHELL_INIT_X		) \
  BST_RCARG_ITERATOR (Long,		SHELL_INIT_Y		) \
  BST_RCARG_ITERATOR (Bool,		AUTO_PATTERN_VIEW	) \
  BST_RCARG_ITERATOR (Bool,		AUTO_INSTRUMENT_LIST	) \
  BST_RCARG_ITERATOR (String,		KEYTABLE		) \
  BST_RCARG_ITERATOR (StringList,	SAMPLE_PATH_LIST	)

/* value access definitions for the arguments
 */
#define	BST_RCVAL_TRACK_SHELL_MOVEMENTS	  (BST_RCVAL (Bool, TRACK_SHELL_MOVEMENTS)->value)
#define	BST_RCVAL_SHELL_INIT_X		  (BST_RCVAL (Long, SHELL_INIT_X)->value)
#define	BST_RCVAL_SHELL_INIT_Y		  (BST_RCVAL (Long, SHELL_INIT_Y)->value)
#define	BST_RCVAL_AUTO_PATTERN_VIEW	  (BST_RCVAL (Bool, AUTO_PATTERN_VIEW)->value)
#define	BST_RCVAL_AUTO_INSTRUMENT_LIST	  (BST_RCVAL (Bool, AUTO_INSTRUMENT_LIST)->value)
#define	BST_RCVAL_KEYTABLE		  (BST_RCVAL (String, KEYTABLE)->value)
#define	BST_RCVAL_SAMPLE_PATH_LIST	  (BST_RCVAL (StringList, SAMPLE_PATH)->value)
#define	BST_RCVAL_SAMPLE_PATH_COUNT(n)	  (g_slist_length (BST_RCVAL_SAMPLE_PATH_LIST ()))
#define	BST_RCVAL_SAMPLE_PATH_NTH(n)	  (g_slist_nth_data (BST_RCVAL_SAMPLE_PATH_LIST (), (n)))

/* initialization function for arguments setup
 */
void	bst_rc_args_init	(void);


/* argument identification enum
 */
enum
{
#define BST_RCARG_ITERATOR	BST_RCARG_ITERATOR_ENUMS
  BST_RCARGS_DEFS ()
#undef	BST_RCARG_ITERATOR
  BST_RCIDX_LAST
};

extern	BstRcUnion		*bst_rc_args[BST_RCIDX_LAST];

  


     

#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif /* __BST_RCARGS_H__ */
