/* BEAST - Bedevilled Audio System
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __BST_PATTERN_VIEW_H__
#define __BST_PATTERN_VIEW_H__

#include	<bse/bse.h>
#include	<gtk/gtk.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */


#define	BST_PATTERN_VIEW(object)	(GTK_CHECK_CAST (object, bst_pattern_view_get_type (), BstPatternView))
#define	BST_PATTERN_VIEW_CLASS(klass)	(GTK_CHECK_CLASS_CAST (klass, bst_pattern_view_get_type (), BstPatternViewClass))
#define	BST_IS_PATTERN_VIEW(object)	(GTK_CHECK_TYPE (object, bst_pattern_view_get_type ()))


typedef	struct	_BstPatternView		BstPatternView;
typedef	struct	_BstPatternViewClass	BstPatternViewClass;


struct	_BstPatternView
{
  GtkWindow	window;

  GtkWidget	*main_vbox;
  GtkWidget	*pe;
};

struct	_BstPatternViewClass
{
  GtkWindowClass	parent_class;
};


GtkType		bst_pattern_view_get_type	(void);
GtkWidget*	bst_pattern_view_new		(BsePattern	*pattern);



#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif /* __BST_PATTERN_VIEW_H__ */
