/* BEAST - Bedevilled Audio System
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#include "bstpatternview.h"
#include "bstpatterneditor.h"



/* --- prototypes --- */
static void	bst_pattern_view_init		(BstPatternView		*pv);


/* --- static variables --- */
static GtkWindowClass	*parent_class = NULL;


/* --- functions --- */
GtkType
bst_pattern_view_get_type (void)
{
  static GtkType pv_type = 0;
  
  if (!pv_type)
    {
      GtkTypeInfo pv_info =
      {
	"BstPatternView",
	sizeof (BstPatternView),
	sizeof (BstPatternViewClass),
	(GtkClassInitFunc) NULL,
	(GtkObjectInitFunc) bst_pattern_view_init,
	(GtkArgSetFunc) NULL,
	(GtkArgGetFunc) NULL,
      };
      
      pv_type = gtk_type_unique (gtk_window_get_type (), &pv_info);
    }
  
  return pv_type;
}

static void
bst_pattern_view_init (BstPatternView	*pv)
{
  GtkWindow *window;
  GtkWidget *button;
  
  window = GTK_WINDOW (pv);
  
  gtk_widget_set (GTK_WIDGET (pv),
		  "GtkWindow::type", GTK_WINDOW_TOPLEVEL,
		  "GtkWindow::allow_shrink", TRUE,
		  "GtkWindow::allow_grow", TRUE,
		  "GtkWindow::auto_shrink", FALSE,
		  NULL);
  pv->main_vbox =
    gtk_widget_new (gtk_vbox_get_type (),
		    "GtkBox::homogeneous", FALSE,
		    "GtkBox::spacing", 5,
		    "GtkContainer::border_width", 5,
		    "GtkWidget::parent", window,
		    "GtkWidget::visible", TRUE,
		    NULL);
  button =
    gtk_widget_new (gtk_button_get_type (),
		    "GtkButton::label", "Close",
		    "GtkObject::object_signal::clicked", gtk_widget_destroy, window,
		    "GtkWidget::visible", TRUE,
		    NULL);
  gtk_box_pack_start (GTK_BOX (pv->main_vbox), button, FALSE, TRUE, 0);
  pv->pe = NULL;
}

GtkWidget*
bst_pattern_view_new (BsePattern     *pattern)
{
  BstPatternView *pv;
  GtkWidget *widget;
  gchar *string;

  g_return_val_if_fail (pattern != NULL, NULL);

  string = g_strconcat (pattern->song->name, " [Pattern View]", NULL);
  widget =
    gtk_widget_new (bst_pattern_view_get_type (),
		    "GtkWindow::title", string,
		    NULL);
  pv = BST_PATTERN_VIEW (widget);
  pv->pe = bst_pattern_editor_new (pattern);
  gtk_widget_set (pv->pe,
		  "GtkWidget::parent", pv->main_vbox,
		  "GtkWidget::visible", TRUE,
		  "GtkObject::signal::pattern_step", bst_pattern_editor_dfl_stepper, NULL,
		  NULL);

  return widget;
}
