;;; xlib-keysymdb.el --- XKeysymDB for xlib.

;; Copyright (C) 2004 by Free Software Foundation, Inc.

;; Author: Zajcev Evgeny <zevlg@yandex.ru>
;; Created: Tue Dec  7 20:23:10 MSK 2004
;; Keywords: xlib
;; X-CVS: $Id: xlib-keysymdb.el,v 1.3 2005/01/01 04:40:15 youngs Exp $

;; This file is part of XEmacs.

;; XEmacs is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; XEmacs is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Synched up with: Not in FSF

;;; Commentary:

;;

;;; Code:

(defconst x-XKeysymDB
  [(hpmute_acute        . #x100000A8)
    (hpmute_grave        . #x100000A9)
    (hpmute_asciicircum  . #x100000AA)
    (hpmute_diaeresis    . #x100000AB)
    (hpmute_asciitilde   . #x100000AC)
    (hplira              . #x100000AF)
    (hpguilder           . #x100000BE)
    (hpYdiaeresis        . #x100000EE)
    (hpIO                . #x100000EE)
    (hplongminus         . #x100000F6)
    (hpblock             . #x100000FC)
    (apLineDel           . #x1000FF00)
    (apCharDel           . #x1000FF01)
    (apCopy              . #x1000FF02)
    (apCut               . #x1000FF03)
    (apPaste             . #x1000FF04)
    (apMove              . #x1000FF05)
    (apGrow              . #x1000FF06)
    (apCmd               . #x1000FF07)
    (apShell             . #x1000FF08)
    (apLeftBar           . #x1000FF09)
    (apRightBar          . #x1000FF0A)
    (apLeftBox           . #x1000FF0B)
    (apRightBox          . #x1000FF0C)
    (apUpBox             . #x1000FF0D)
    (apDownBox           . #x1000FF0E)
    (apPop               . #x1000FF0F)
    (apRead              . #x1000FF10)
    (apEdit              . #x1000FF11)
    (apSave              . #x1000FF12)
    (apExit              . #x1000FF13)
    (apRepeat            . #x1000FF14)
    (hpModelock1         . #x1000FF48)
    (hpModelock2         . #x1000FF49)
    (hpReset             . #x1000FF6C)
    (hpSystem            . #x1000FF6D)
    (hpUser              . #x1000FF6E)
    (hpClearLine         . #x1000FF6F)
    (hpInsertLine        . #x1000FF70)
    (hpDeleteLine        . #x1000FF71)
    (hpInsertChar        . #x1000FF72)
    (hpDeleteChar        . #x1000FF73)
    (hpBackTab           . #x1000FF74)
    (hpKP_BackTab        . #x1000FF75)
    (apKP_parenleft      . #x1000FFA8)
    (apKP_parenright     . #x1000FFA9)

    (I2ND_FUNC_L         . #x10004001)
    (I2ND_FUNC_R         . #x10004002)
    (IREMOVE             . #x10004003)
    (IREPEAT             . #x10004004)
    (IA1                 . #x10004101)
    (IA2                 . #x10004102)
    (IA3                 . #x10004103)
    (IA4                 . #x10004104)
    (IA5                 . #x10004105)
    (IA6                 . #x10004106)
    (IA7                 . #x10004107)
    (IA8                 . #x10004108)
    (IA9                 . #x10004109)
    (IA10                . #x1000410A)
    (IA11                . #x1000410B)
    (IA12                . #x1000410C)
    (IA13                . #x1000410D)
    (IA14                . #x1000410E)
    (IA15                . #x1000410F)
    (IB1                 . #x10004201)
    (IB2                 . #x10004202)
    (IB3                 . #x10004203)
    (IB4                 . #x10004204)
    (IB5                 . #x10004205)
    (IB6                 . #x10004206)
    (IB7                 . #x10004207)
    (IB8                 . #x10004208)
    (IB9                 . #x10004209)
    (IB10                . #x1000420A)
    (IB11                . #x1000420B)
    (IB12                . #x1000420C)
    (IB13                . #x1000420D)
    (IB14                . #x1000420E)
    (IB15                . #x1000420F)
    (IB16                . #x10004210)

    (DRemove             . #x1000FF00)
    (Dring_accent        . #x1000FEB0)
    (Dcircumflex_accent  . #x1000FE5E)
    (Dcedilla_accent     . #x1000FE2C)
    (Dacute_accent       . #x1000FE27)
    (Dgrave_accent       . #x1000FE60)
    (Dtilde              . #x1000FE7E)
    (Ddiaeresis          . #x1000FE22)

    (osfCopy             . #x1004FF02)
    (osfCut              . #x1004FF03)
    (osfPaste            . #x1004FF04)
    (osfBackTab          . #x1004FF07)
    (osfBackSpace        . #x1004FF08)
    (osfClear            . #x1004FF0B)
    (osfEscape           . #x1004FF1B)
    (osfAddMode          . #x1004FF31)
    (osfPrimaryPaste     . #x1004FF32)
    (osfQuickPaste       . #x1004FF33)
    (osfPageLeft         . #x1004FF40)
    (osfPageUp           . #x1004FF41)
    (osfPageDown         . #x1004FF42)
    (osfPageRight        . #x1004FF43)
    (osfActivate         . #x1004FF44)
    (osfMenuBar          . #x1004FF45)
    (osfLeft             . #x1004FF51)
    (osfUp               . #x1004FF52)
    (osfRight            . #x1004FF53)
    (osfDown             . #x1004FF54)
    (osfPrior            . #x1004FF55)
    (osfNext             . #x1004FF56)
    (osfEndLine          . #x1004FF57)
    (osfBeginLine        . #x1004FF58)
    (osfEndData          . #x1004FF59)
    (osfBeginData        . #x1004FF5A)
    (osfPrevMenu         . #x1004FF5B)
    (osfNextMenu         . #x1004FF5C)
    (osfPrevField        . #x1004FF5D)
    (osfNextField        . #x1004FF5E)
    (osfSelect           . #x1004FF60)
    (osfInsert           . #x1004FF63)
    (osfUndo             . #x1004FF65)
    (osfMenu             . #x1004FF67)
    (osfCancel           . #x1004FF69)
    (osfHelp             . #x1004FF6A)
    (osfSelectAll        . #x1004FF71)
    (osfDeselectAll      . #x1004FF72)
    (osfReselect         . #x1004FF73)
    (osfExtend           . #x1004FF74)
    (osfRestore          . #x1004FF78)
    (osfSwitchDirection  . #x1004FF7E)
    (osfPriorMinor       . #x1004FFF5)
    (osfNextMinor        . #x1004FFF6)
    (osfRightLine        . #x1004FFF7)
    (osfLeftLine         . #x1004FFF8)
    (osfDelete           . #x1004FFFF)

    (SunFA_Grave         . #x1005FF00)
    (SunFA_Circum        . #x1005FF01)
    (SunFA_Tilde         . #x1005FF02)
    (SunFA_Acute         . #x1005FF03)
    (SunFA_Diaeresis     . #x1005FF04)
    (SunFA_Cedilla       . #x1005FF05)
    (SunF36              . #x1005FF10)
    (SunF37              . #x1005FF11)
    (SunSys_Req          . #x1005FF60)
    (SunProps            . #x1005FF70)
    (SunFront            . #x1005FF71)
    (SunCopy             . #x1005FF72)
    (SunOpen             . #x1005FF73)
    (SunPaste            . #x1005FF74)
    (SunCut              . #x1005FF75)
    (SunPowerSwitch      . #x1005FF76)
    (SunAudioLowerVolume . #x1005FF77)
    (SunAudioMute        . #x1005FF78)
    (SunAudioRaiseVolume . #x1005FF79)
    (SunVideoDegauss             . #x1005FF7A)
    (SunVideoLowerBrightness     . #x1005FF7B)
    (SunVideoRaiseBrightness     . #x1005FF7C)
    (SunPowerSwitchShift . #x1005FF7D)

    (SunCompose          . #xFF20)
    (SunPageUp           . #xFF55)
    (SunPageDown         . #xFF56)
    (SunPrint_Screen     . #xFF61)
    (SunUndo             . #xFF65)
    (SunAgain            . #xFF66)
    (SunFind             . #xFF68)
    (SunStop             . #xFF69)
    (SunAltGraph         . #xFF7E)

    (WYSetup             . #x1006FF00)

    (ncdSetup            . #x1006FF00)

    (XeroxPointerButton1 . #x10070001)
    (XeroxPointerButton2 . #x10070002)
    (XeroxPointerButton3 . #x10070003)
    (XeroxPointerButton4 . #x10070004)
    (XeroxPointerButton5 . #x10070005)

;; ! The definitions here should match <X11/XF86keysym.h>
    (XF86ModeLock                . #x1008FF01)
    (XF86Standby         . #x1008FF10)
    (XF86AudioLowerVolume        . #x1008FF11)
    (XF86AudioMute       . #x1008FF12)
    (XF86AudioRaiseVolume        . #x1008FF13)
    (XF86AudioPlay       . #x1008FF14)
    (XF86AudioStop       . #x1008FF15)
    (XF86AudioPrev       . #x1008FF16)
    (XF86AudioNext       . #x1008FF17)
    (XF86HomePage        . #x1008FF18)
    (XF86Mail            . #x1008FF19)
    (XF86Start           . #x1008FF1A)
    (XF86Search          . #x1008FF1B)
    (XF86AudioRecord     . #x1008FF1C)
    (XF86Calculator      . #x1008FF1D)
    (XF86Memo            . #x1008FF1E)
    (XF86ToDoList        . #x1008FF1F)
    (XF86Calendar        . #x1008FF20)
    (XF86PowerDown       . #x1008FF21)
    (XF86ContrastAdjust  . #x1008FF22)
    (XF86RockerUp        . #x1008FF23)
    (XF86RockerDown      . #x1008FF24)
    (XF86RockerEnter     . #x1008FF25)
    (XF86Back            . #x1008FF26)
    (XF86Forward         . #x1008FF27)
    (XF86Stop            . #x1008FF28)
    (XF86Refresh         . #x1008FF29)
    (XF86PowerOff        . #x1008FF2A)
    (XF86WakeUp          . #x1008FF2B)
    (XF86Eject           . #x1008FF2C)
    (XF86ScreenSaver     . #x1008FF2D)
    (XF86WWW             . #x1008FF2E)
    (XF86Sleep           . #x1008FF2F)
    (XF86Favorites       . #x1008FF30)
    (XF86AudioPause      . #x1008FF31)
    (XF86AudioMedia      . #x1008FF32)
    (XF86MyComputer      . #x1008FF33)
    (XF86VendorHome      . #x1008FF34)
    (XF86LightBulb       . #x1008FF35)
    (XF86Shop            . #x1008FF36)
    (XF86History         . #x1008FF37)
    (XF86OpenURL         . #x1008FF38)
    (XF86AddFavorite     . #x1008FF39)
    (XF86HotLinks        . #x1008FF3A)
    (XF86BrightnessAdjust        . #x1008FF3B)
    (XF86Finance         . #x1008FF3C)
    (XF86Community       . #x1008FF3D)
;;! Allocate 1008FF3E-F next

    (XF86Launch0         . #x1008FF40)
    (XF86Launch1         . #x1008FF41)
    (XF86Launch2         . #x1008FF42)
    (XF86Launch3         . #x1008FF43)
    (XF86Launch4         . #x1008FF44)
    (XF86Launch5         . #x1008FF45)
    (XF86Launch6         . #x1008FF46)
    (XF86Launch7         . #x1008FF47)
    (XF86Launch8         . #x1008FF48)
    (XF86Launch9         . #x1008FF49)
    (XF86LaunchA         . #x1008FF4A)
    (XF86LaunchB         . #x1008FF4B)
    (XF86LaunchC         . #x1008FF4C)
    (XF86LaunchD         . #x1008FF4D)
    (XF86LaunchE         . #x1008FF4E)
    (XF86LaunchF         . #x1008FF4F)

    (usldead_acute       . #x100000A8)
    (usldead_grave       . #x100000A9)
    (usldead_diaeresis   . #x100000AB)
    (usldead_asciicircum . #x100000AA)
    (usldead_asciitilde  . #x100000AC)
    (usldead_cedilla     . #x1000FE2C)
    (usldead_ring        . #x1000FEB0)])

(defconst x-XKeysymDB-length 245)

(defun X-XKeysymDB-sym->keysym (sym)
  "Lookup SYM in keysym db."
  (let ((i 0)
        (ret nil))
    (while (< i x-XKeysymDB-length)
      (when (eq (car (aref x-XKeysymDB i)) sym)
        (setq ret (aref x-XKeysymDB i)
              i x-XKeysymDB-length))
      (incf i))
    (cdr ret)))

(defun X-XKeysymDB-keysym->sym (keysym)
  "Lookup KEYSIM in keysym db."
  (let ((i 0)
        (ret nil))
    (while (< i x-XKeysymDB-length)
      (when (= (cdr (aref x-XKeysymDB i)) keysym)
        (setq ret (aref x-XKeysymDB i)
              i x-XKeysymDB-length))
      (incf i))
    (car ret)))

(provide 'xlib-keysymdb)

;;; xlib-keysymdb.el ends here
