;;; tex-jp.el - Support for Japanese TeX. -*- coding: euc-jp -*-
;;
;; Support for Japanese TeX by KOBAYASHI Shinji <koba@flab.fujitsu.co.jp>
;; based on many patches developed by Japanese NetNews community.
;; Japanese message translation by MATUI Takao <mat@nuis.ac.jp>.

;;; Code:

(require 'latex)

;;; Customization

(setq TeX-format-list
      (append '(("JLATEX" japanese-latex-mode
		 "\\\\\\(documentstyle[^%\n]*{j\\|documentclass[^%\n]*{j\\)")
		("JTEX" japanese-plain-tex-mode
		 "-- string likely in Japanese TeX --"))
	      TeX-format-list))

(setq TeX-command-list
      (append (list (list "jTeX" "jtex '\\nonstopmode\\input %t'"
			  'TeX-run-TeX nil t)
		    (list "pTeX" "ptex '\\nonstopmode\\input %t'"
                          'TeX-run-TeX nil t)
		    (list "jBibTeX" "jbibtex %s" 'TeX-run-BibTeX nil nil))
	      TeX-command-list))
       
(setq LaTeX-command-style
      (append (if (string-equal LaTeX-version "2")
		  '(("^ams" "amsjlatex")
		    ("^jslides$" "jslitex")
		    ("^j-?\\(article\\|report\\|book\\)$" "jlatex"))
                '(("^j-\\(article\\|report\\|book\\)$" "jlatex")
                  ("^j\\(article\\|report\\|book\\)$" "platex")
                  ("." "jlatex")))
	      LaTeX-command-style))

(setcdr (assoc "%l" TeX-expand-list)
	(list 'TeX-style-check LaTeX-command-style))

(defvar japanese-TeX-error-messages t
  "If non-nil, explain TeX error messages in Japanese.")

(if (or (boundp 'MULE)
	(featurep 'mule))
    (if (string-match "XEmacs" emacs-version)
	(progn
	  (defvar TeX-japanese-process-input-coding-system 
	    (find-coding-system 'euc-japan)
	    "TeX-process' coding system with standard input.")
	  (defvar TeX-japanese-process-output-coding-system 
	    (find-coding-system 'junet)
	    "TeX-process' coding system with standard output."))
      (progn
	(defvar TeX-japanese-process-input-coding-system *euc-japan*
	  "TeX-process' coding system with standard input.")
	(defvar TeX-japanese-process-output-coding-system *junet*
	  "TeX-process' coding system with standard output."))))

(if (boundp 'NEMACS)
    (defvar TeX-process-kanji-code 2
      "TeX-process' kanji code with standard I/O.
0:No-conversion  1:Shift-JIS  2:JIS  3:EUC/AT&T/DEC"))

(defvar japanese-LaTeX-default-style "j-article"
  "*Default when creating new Japanese documents.")
(make-variable-buffer-local 'japanese-LaTeX-default-style)

(defvar japanese-LaTeX-style-list
  '(("book")
    ("article")
    ("letter")
    ("slides")
    ("report")
    ("jbook")
    ("j-book")
    ("jarticle")
    ("j-article")
    ("jslides")
    ("jreport")
    ("j-report"))
  "*List of Japanese document styles.")
(make-variable-buffer-local 'japanese-LaTeX-style-list)

;;; Coding system

(if (boundp 'MULE)
    (setq TeX-after-start-process-function
	  (function (lambda (process)
		      (set-process-coding-system
		       process
		       TeX-japanese-process-input-coding-system
		       TeX-japanese-process-output-coding-system)))))
(if (boundp 'NEMACS)
    (setq TeX-after-start-process-function
	  (function
	   (lambda (process)
	     (set-process-kanji-code process TeX-process-kanji-code)))))

(if (and (string-match "XEmacs" emacs-version)
	 (featurep 'mule))
    (setq TeX-after-start-process-function
	  (function (lambda (process)
		      (set-process-input-coding-system
		       process
		       TeX-japanese-process-input-coding-system)
		      (set-process-output-coding-system
		       process
		       TeX-japanese-process-output-coding-system)))))

;;; Japanese Parsing

(if (or (boundp 'MULE)
	(featurep 'mule))
(progn

(defconst LaTeX-auto-regexp-list 
  (append
   '(("\\\\newcommand{?\\\\\\(\\([a-zA-Z]\\|\\cj\\)+\\)}?\\[\\([0-9]+\\)\\]\
\\[\\([^\]\\\\\n\r]+\\)\\]"
      (1 3 4) LaTeX-auto-optional)
     ("\\\\newcommand{?\\\\\\(\\([a-zA-Z]\\|\\cj\\)+\\)}?\\[\\([0-9]+\\)\\]"
      (1 3) LaTeX-auto-arguments)
     ("\\\\newcommand{?\\\\\\(\\([a-zA-Z]\\|\\cj\\)+\\)}?" 1 TeX-auto-symbol)
     ("\\\\newenvironment{?\\(\\([a-zA-Z]\\|\\cj\\)+\\)}?\\[\\([0-9]+\\)\\]"
      (1 3) LaTeX-auto-env-args)
     ("\\\\newenvironment{?\\(\\([a-zA-Z]\\|\\cj\\)+\\)}?" 1 LaTeX-auto-environment)
     ("\\\\newtheorem{\\(\\([a-zA-Z]\\|\\cj\\)+\\)}" 1 LaTeX-auto-environment)
     ("\\\\input{\\(\\.*[^#}%\\\\\\.\n\r]+\\)\\(\\.[^#}%\\\\\\.\n\r]+\\)?}"
      1 TeX-auto-file)
     ("\\\\include{\\(\\.*[^#}%\\\\\\.\n\r]+\\)\\(\\.[^#}%\\\\\\.\n\r]+\\)?}"
      1 TeX-auto-file)
     ("\\\\usepackage\\(\\[[^\]\\\\]*\\]\\)?\
{\\(\\([^#}\\\\\\.%]\\|%[^\n\r]*[\n\r]\\)+\\)}"
      (2) LaTeX-auto-style)
     ("\\\\bibitem{\\(\\([a-zA-Z]\\|\\cj\\)[^, \n\r\t%\"#'()={}]*\\)}" 1 LaTeX-auto-bibitem)
     ("\\\\bibitem\\[[^][\n\r]+\\]{\\(\\([a-zA-Z]\\|\\cj\\)[^, \n\r\t%\"#'()={}]*\\)}"
      1 LaTeX-auto-bibitem)
     ("\\\\bibliography{\\([^#}\\\\\n\r]+\\)}" 1 LaTeX-auto-bibliography))
   LaTeX-auto-label-regexp-list
   LaTeX-auto-minimal-regexp-list)
  "List of regular expression matching common LaTeX macro definitions.")

(defconst plain-TeX-auto-regexp-list
  '(("\\\\def\\\\\\(\\([a-zA-Z]\\|\\cj\\)+\\)[^a-zA-Z@]" 1
     TeX-auto-symbol-check)
    ("\\\\let\\\\\\(\\([a-zA-Z]\\|\\cj\\)+\\)[^a-zA-Z@]" 1
     TeX-auto-symbol-check)
    ("\\\\font\\\\\\(\\([a-zA-Z]\\|\\cj\\)+\\)[^a-zA-Z@]" 1 TeX-auto-symbol)
    ("\\\\chardef\\\\\\(\\([a-zA-Z]\\|\\cj\\)+\\)[^a-zA-Z@]" 1 TeX-auto-symbol)
    ("\\\\new\\(count|dimen|muskip|skip\\)\\\\\\(\\([a-z]\\|\\cj\\)+\\)[^a-zA-Z@]"
     2 TeX-auto-symbol)
    ("\\\\newfont{?\\\\\\(\\([a-zA-Z]\\|\\cj\\)+\\)}?" 1 TeX-auto-symbol)
    ("\\\\typein\\[\\\\\\(\\([a-zA-Z]\\|\\cj\\)+\\)\\]" 1 TeX-auto-symbol)
    ("\\\\input +\\(\\.*[^#%\\\\\\.\n\r]+\\)\\(\\.[^#%\\\\\\.\n\r]+\\)?"
     1 TeX-auto-file)
    ("\\\\mathchardef\\\\\\(\\([a-zA-Z]\\|\\cj\\)+\\)[^a-zA-Z@]" 1
     TeX-auto-symbol))
  "List of regular expression matching common LaTeX macro definitions.")

(defconst BibTeX-auto-regexp-list
  '(("@[Ss][Tt][Rr][Ii][Nn][Gg]" 1 ignore)
    ("@[a-zA-Z]+[{(][ \t]*\\(\\([a-zA-Z]\\|\\cj\\)[^, \n\r\t%\"#'()={}]*\\)"
     1 LaTeX-auto-bibitem))
  "List of regexp-list expressions matching BibTeX items.")

))

(if (boundp 'NEMACS)
(progn

(defconst LaTeX-auto-regexp-list 
  (append
   '(("\\\\newcommand{?\\\\\\(\\([a-zA-Z]\\|\\z\\)+\\)}?\\[\\([0-9]+\\)\\]\
\\[\\([^\]\\\\\n\r]+\\)\\]"
      (1 3 4) LaTeX-auto-optional)
     ("\\\\newcommand{?\\\\\\(\\([a-zA-Z]\\|\\z\\)+\\)}?\\[\\([0-9]+\\)\\]"
      (1 3) LaTeX-auto-arguments)
     ("\\\\newcommand{?\\\\\\(\\([a-zA-Z]\\|\\z\\)+\\)}?" 1 TeX-auto-symbol)
     ("\\\\newenvironment{?\\(\\([a-zA-Z]\\|\\z\\)+\\)}?\\[\\([0-9]+\\)\\]"
      (1 3) LaTeX-auto-env-args)
     ("\\\\newenvironment{?\\(\\([a-zA-Z]\\|\\z\\)+\\)}?" 1 LaTeX-auto-environment)
     ("\\\\newtheorem{\\(\\([a-zA-Z]\\|\\z\\)+\\)}" 1 LaTeX-auto-environment)
     ("\\\\input{\\(\\.*[^#}%\\\\\\.\n\r]+\\)\\(\\.[^#}%\\\\\\.\n\r]+\\)?}"
      1 TeX-auto-file)
     ("\\\\include{\\(\\.*[^#}%\\\\\\.\n\r]+\\)\\(\\.[^#}%\\\\\\.\n\r]+\\)?}"
      1 TeX-auto-file)
     ("\\\\usepackage\\(\\[[^\]\\\\]*\\]\\)?\
{\\(\\([^#}\\\\\\.%]\\|%[^\n\r]*[\n\r]\\)+\\)}"
      (2) LaTeX-auto-style)
     ("\\\\bibitem{\\(\\([a-zA-Z]\\|\\z\\)[^, \n\r\t%\"#'()={}]*\\)}" 1 LaTeX-auto-bibitem)
     ("\\\\bibitem\\[[^][\n\r]+\\]{\\(\\([a-zA-Z]\\|\\z\\)[^, \n\r\t%\"#'()={}]*\\)}"
      1 LaTeX-auto-bibitem)
     ("\\\\bibliography{\\([^#}\\\\\n\r]+\\)}" 1 LaTeX-auto-bibliography))
   LaTeX-auto-label-regexp-list
   LaTeX-auto-minimal-regexp-list)
  "List of regular expression matching common LaTeX macro definitions.")

(defconst plain-TeX-auto-regexp-list
  '(("\\\\def\\\\\\(\\([a-zA-Z]\\|\\z\\)+\\)[^a-zA-Z@]" 1
     TeX-auto-symbol-check)
    ("\\\\let\\\\\\(\\([a-zA-Z]\\|\\z\\)+\\)[^a-zA-Z@]" 1
     TeX-auto-symbol-check)
    ("\\\\font\\\\\\(\\([a-zA-Z]\\|\\z\\)+\\)[^a-zA-Z@]" 1 TeX-auto-symbol)
    ("\\\\chardef\\\\\\(\\([a-zA-Z]\\|\\z\\)+\\)[^a-zA-Z@]" 1 TeX-auto-symbol)
    ("\\\\new\\(count|dimen|muskip|skip\\)\\\\\\(\\([a-z]\\|\\z\\)+\\)[^a-zA-Z@]"
     2 TeX-auto-symbol)
    ("\\\\newfont{?\\\\\\(\\([a-zA-Z]\\|\\z\\)+\\)}?" 1 TeX-auto-symbol)
    ("\\\\typein\\[\\\\\\(\\([a-zA-Z]\\|\\z\\)+\\)\\]" 1 TeX-auto-symbol)
    ("\\\\input +\\(\\.*[^#%\\\\\\.\n\r]+\\)\\(\\.[^#%\\\\\\.\n\r]+\\)?"
     1 TeX-auto-file)
    ("\\\\mathchardef\\\\\\(\\([a-zA-Z]\\|\\z\\)+\\)[^a-zA-Z@]" 1
     TeX-auto-symbol))
  "List of regular expression matching common LaTeX macro definitions.")

(defconst BibTeX-auto-regexp-list
  '(("@[Ss][Tt][Rr][Ii][Nn][Gg]" 1 ignore)
    ("@[a-zA-Z]+[{(][ \t]*\\(\\([a-zA-Z]\\|\\z\\)[^, \n\r\t%\"#'()={}]*\\)"
     1 LaTeX-auto-bibitem))
  "List of regexp-list expressions matching BibTeX items.")

))

(defconst TeX-auto-full-regexp-list 
  (append LaTeX-auto-regexp-list plain-TeX-auto-regexp-list)
  "Full list of regular expression matching TeX macro definitions.")

;;; Japanese TeX modes

(defvar japanese-TeX-mode nil
  "Flag to determine if Japanese initialization is needed.")

(add-hook 'plain-TeX-mode-hook 'japanese-plain-tex-mode-initialization)

;;;###autoload
(defun japanese-plain-tex-mode ()
  "Major mode for editing files of input for Japanese plain TeX.
Set japanese-TeX-mode to t, and enters plain-tex-mode."
  (interactive)
  (setq japanese-TeX-mode t)
  (plain-tex-mode))

(defun japanese-plain-tex-mode-initialization ()
  "Japanese plain-TeX specific initializations."
  (if japanese-TeX-mode
      (setq TeX-command-default "jTeX")))

(add-hook 'LaTeX-mode-hook 'japanese-latex-mode-initialization)

;;;###autoload
(defun japanese-latex-mode ()
  "Major mode for editing files of input for Japanese plain TeX.
Set japanese-TeX-mode to t, and enters latex-mode."
  (interactive)
  (setq japanese-TeX-mode t)
  (latex-mode))

(defun japanese-latex-mode-initialization ()
  "Japanese LaTeX specific initializations."
  (if japanese-TeX-mode
      (progn
	(setq LaTeX-default-style japanese-LaTeX-default-style)
	(setq LaTeX-style-list japanese-LaTeX-style-list)
	(setq TeX-command-BibTeX "jBibTeX")
	(setq japanese-TeX-mode nil))))

;;; MULE and NEMACS paragraph filling.

(if (boundp 'MULE)
(if (string-lessp emacs-version "19")
(defun LaTeX-fill-region-as-paragraph (from to &optional justify-flag)
  "Fill region as one paragraph: break lines to fit fill-column.
Prefix arg means justify too.
From program, pass args FROM, TO and JUSTIFY-FLAG."
  (interactive "*r\nP")
  (save-restriction
    (goto-char from)
    (skip-chars-forward "\n")
    (LaTeX-indent-line)
    (beginning-of-line)
    (narrow-to-region (point) to)
    (setq from (point))

    ;; Delete whitespace at beginning of line from every line,
    ;; except the first line.
    (goto-char (point-min))
    (forward-line 1)
    (while (not (eobp))
      (delete-horizontal-space)
      (forward-line 1))

    ;; Ignore the handling routine related with `fill-prefix'.

    ;; from is now before the text to fill,
    ;; but after any fill prefix on the first line.

    ;; Make sure sentences ending at end of line get an extra space.
    (goto-char from)
    ;;; patch by S.Tomura 88-Jun-30
    ;;
    ;; . + CR             ==> . + SPC + SPC 
    ;; . + SPC + CR +     ==> . + SPC + 
    ;;(while (re-search-forward "[.?!][])""']*$" nil t)
    ;;  (insert ? ))
    (while (re-search-forward "[.?!][])\"']*$" nil t)
      (if (eobp)
	  nil
	;; replace CR by two spaces.
	(delete-char 1)			; delete newline
	(insert "  ")))
    ;; end of patch
    ;; The change all newlines to spaces.
    ;; patched by S.Tomura 87-Dec-7
    ;; bug fixed by S.Tomura 88-May-25
    ;; modified by  S.Tomura 88-Jun-21
    ;;(subst-char-in-region from (point-max) ?\n ?\ )
    ;; modified by K.Handa 92-Mar-2
    ;; Spacing is not necessary for charcters of no word-separater.
    ;; The regexp word-across-newline is used for this check.
    (if (not (stringp word-across-newline))
	(subst-char-in-region from (point-max) ?\n ?\ )
      (goto-char from)
      (end-of-line)
      (while (not (eobp))
	(delete-char 1)
	(if (eobp) nil			; 92.6.30 by K.Handa
	  (if (not (looking-at word-across-newline))
	      (progn
		(forward-char -1)
		(if (and (not (eq (following-char) ? ))
			 (not (looking-at word-across-newline)))
		    (progn
		      (forward-char 1)
		      (insert ? ))
		  (forward-char 1))))
	  (end-of-line))))
    ;; After the following processing, there's two spaces at end of sentence
    ;; and single space at end of line within sentence.
    ;; end of patch
    ;; Flush excess spaces, except in the paragraph indentation.
    (goto-char from)
    (skip-chars-forward " \t")
    (while (re-search-forward "   *" nil t)
      (delete-region
       (+ (match-beginning 0)
	  (if (save-excursion
	       (skip-chars-backward " ])\"'")
	       (memq (preceding-char) '(?. ?? ?!)))
	      2 1))
       (match-end 0)))
    (goto-char (point-max))
    (delete-horizontal-space)
    (insert "  ")
    (goto-char (point-min))
    (let ((prefixcol 0)
	  ;; patch by K.Handa 92-Mar-2
	  (re-break-point (concat "[ \t\n]\\|" word-across-newline))
	  ;; end of patch
	  )
      (while (not (eobp))
	(move-to-column (1+ fill-column))
	(if (eobp)
	    nil
	  ;; patched by S.Tomura 87-Jun-2
	  ;; Big change by K.Handa 92-Mar-2
	  ;; Move back to start of word.
	  ;; (skip-chars-backward "^ \n")
	  ;; (if (if (zerop prefixcol) (bolp) (>= prefixcol (current-column)))
	  ;;    ;; Move back over whitespace before the word.
	  ;;    (skip-chars-forward "^ \n")
	  ;;  ;; Normally, move back over the single space between the words.
	  ;;  (forward-char -1))

	  ;; At first, find breaking point at the left of fill-column,
	  ;; but after kinsoku-shori, the point may be right of fill-column.
	  ;; 92.4.15 by K.Handa -- re-search-backward will back to prev line.
	  ;; 92.4.27 by T.Enami -- We might have gone back too much...
	  (let ((p (point)) ch)
	    (re-search-backward re-break-point nil 'mv)
	    (setq ch (following-char))
	    (if (or (= ch ? ) (= ch ?\t))
		(skip-chars-backward " \t")
	      (forward-char 1)
	      (if (<= p (point))
		  (forward-char -1))))
	  (kinsoku-shori)
	  ;; Check if current column is at the right of prefixcol.
	  ;; If not, find break-point at the right of fill-column.
	  ;; This time, force kinsoku-shori-nobashi.
	  (if (>= prefixcol (current-column))
	      (progn
		(move-to-column (1+ fill-column))
		;; 92.4.15 by K.Handa -- suppress error in re-search-forward
		(re-search-forward re-break-point nil t)
		(forward-char -1)
		(kinsoku-shori-nobashi))))
	;; end of patch S.Tomura

	;; Replace all whitespace here with one newline.
	;; Insert before deleting, so we don't forget which side of
	;; the whitespace point or markers used to be on.
	;; patch by S. Tomura 88-Jun-20
	;; 92.4.27 by K.Handa
	(skip-chars-backward " \t")
	(if mc-flag
	    ;; ʬ  WAN means chars which match word-across-newline.
	    ;; (0)     | SPC + SPC* <EOB>	--> NL
	    ;; (1) WAN | SPC + SPC*		--> WAN + SPC + NL
	    ;; (2)     | SPC + SPC* + WAN	--> SPC + NL  + WAN
	    ;; (3) '.' | SPC + nonSPC		--> '.' + SPC + NL + nonSPC
	    ;; (4) '.' | SPC + SPC		--> '.' + NL
	    ;; (5)     | SPC*			--> NL
	    (let ((start (point))	; 92.6.30 by K.Handa
		  (ch (following-char)))
	      (if (and (= ch ? )
		       (progn		; not case (0) -- 92.6.30 by K.Handa
			 (skip-chars-forward " \t")
			 (not (eobp)))
		       (or
			(progn		; case (1)
			  (goto-char start)
			  (forward-char -1)
			  (looking-at word-across-newline))
			(progn		; case (2)
			  (goto-char start)
			  (skip-chars-forward " \t")
			  (and (not (eobp))
			       (looking-at word-across-newline)))
			(progn		; case (3)
			  (goto-char (1+ start))
			  (and (not (eobp))
			       (/= (following-char) ? )
			       (progn
				 (skip-chars-backward " ])\"'")
				 (memq (preceding-char) '(?. ?? ?!)))))))
		  ;; We should keep one SPACE before NEWLINE. (1),(2),(3)
		  (goto-char (1+ start))
		;; We should delete all SPACES around break point. (4),(5)
		(goto-char start))))
	;; end of patch
	(if (equal (preceding-char) ?\\)
	    (insert ? ))
	(insert ?\n)
	(delete-horizontal-space)

	;; Ignore the handling routine related with `fill-prefix'.

	(LaTeX-indent-line)
	(setq prefixcol (current-column))
	;; Justify the line just ended, if desired.
	(and justify-flag (not (eobp))
	     (progn
	       (forward-line -1)
	       (justify-current-line)
	       (forward-line 1)))
	)
      (goto-char (point-max))
      (delete-horizontal-space))))
(defun LaTeX-fill-region-as-paragraph (from to &optional justify-flag)
  "Fill region as one paragraph: break lines to fit fill-column.\n\
Prefix arg means justify too.\n\
From program, pass args FROM, TO and JUSTIFY-FLAG."
  (interactive "*r\nP")
  (save-restriction
    (goto-char from)
    (skip-chars-forward " \n")
    (LaTeX-indent-line)
    (beginning-of-line)
    (narrow-to-region (point) to)
    (setq from (point))
    
    ;; Delete whitespace at beginning of line from every line,
    ;; except the first line.
    (goto-char (point-min))
    (forward-line 1)
    (while (not (eobp))
      (delete-horizontal-space)
      (forward-line 1))

    ;; from is now before the text to fill,
    ;; but after any fill prefix on the first line.
    
    ;; Make sure sentences ending at end of line get an extra space.
    (goto-char from)
    ;; patch by S.Tomura 88-Jun-30
    ;;
    ;; . + CR             ==> . + SPC + SPC 
    ;; . + SPC + CR +     ==> . + SPC + 
    ;; (while (re-search-forward "[.?!][])\"']*$" nil t)
    ;;   (insert ? ))
    (while (re-search-forward "[.?!][])}\"']*$" nil t)
      (if (eobp)
	  nil
	;; replace CR by two spaces.
	;; insert before delete to preserve marker.
	(insert "  ")
	;; delete newline
	(delete-char 1)))
    ;; end of patch
    ;; The change all newlines to spaces.
    ;; (subst-char-in-region from (point-max) ?\n ?\ )
    ;; patched by S.Tomura 87-Dec-7
    ;; bug fixed by S.Tomura 88-May-25
    ;; modified by  S.Tomura 88-Jun-21
    ;; modified by K.Handa 92-Mar-2
    ;; Spacing is not necessary for charcters of no word-separater.
    ;; The regexp word-across-newline is used for this check.
    (if (not (stringp word-across-newline))
	(subst-char-in-region from (point-max) ?\n ?\ )
      ;;
      ;; WAN     +NL+WAN       --> WAN            + WAN
      ;; not(WAN)+NL+WAN       --> not(WAN)       + WAN
      ;; WAN     +NL+not(WAN)  --> WAN            + not(WAN)
      ;; SPC     +NL+not(WAN)  --> SPC            + not(WAN)
      ;; not(WAN)+NL+not(WAN)  --> not(WAN) + SPC + not(WAN)
      ;;
      (goto-char from)
      (end-of-line)
      (while (not (eobp))
	;; 92.8.26 , 92.8.30 by S. Tomura
	
	;; Insert SPC only when point is between nonWAN.  Insert
	;; before deleting to preserve marker if possible.
	(if (or (prog2		; check following char.
		    (forward-char)	; skip newline
		    (or (eobp)
			(looking-at word-across-newline))
		  (forward-char -1))
		(prog2		; check previous char.
		    (forward-char -1)
		    (or (eq (following-char) ?\ )
			(looking-at word-across-newline))
		  (forward-char)))
	    nil
	  (insert ?\ ))
	(delete-char 1)		; delete newline
	(end-of-line)))
    ;; Flush excess spaces, except in the paragraph indentation.
    (goto-char from)
    (skip-chars-forward " \t")
    (while (re-search-forward "   *" nil t)
      (delete-region
       (+ (match-beginning 0)
	  (if (save-excursion
		(skip-chars-backward " ])\"'")
		(memq (preceding-char) '(?. ?? ?!)))
	      2 1))
       (match-end 0)))
    (goto-char (point-max))
    (delete-horizontal-space)
    (insert "  ")
    (goto-char (point-min))
    (let ((prefixcol 0) linebeg
	  ;; patch by K.Handa 92-Mar-2
	  (re-break-point (concat "[ \n]\\|" word-across-newline))
	  ;; end of patch
	  )
      (while (not (eobp))
	(setq linebeg (point))
	(move-to-column (1+ fill-column))
	(if (eobp)
	    nil
	  ;;(skip-chars-backward "^ \n")
	  (fill-move-backward-to-break-point re-break-point)
	  (if sentence-end-double-space
	      (while (and (> (point) (+ linebeg 2))
			  (eq (preceding-char) ?\ )
			  (not (eq (following-char) ?\ ))
			  (eq (char-after (- (point) 2)) ?\.))
		(forward-char -2)
		(fill-move-backward-to-break-point re-break-point linebeg)))
	  (kinsoku-shori)
	  (if (if (zerop prefixcol)
		  (save-excursion
		    (skip-chars-backward " " linebeg)
		    (bolp))
		(>= prefixcol (current-column)))
	      ;; Keep at least one word even if fill prefix exceeds margin.
	      ;; This handles all but the first line of the paragraph.
	      ;; Meanwhile, don't stop at a period followed by one space.
	      (let ((first t))
		(move-to-column prefixcol)
		(while (and (not (eobp))
			    (or first
				(and (not (bobp))
				     sentence-end-double-space
				     (save-excursion (forward-char -1)
						     (and (looking-at "\\. ")
							  (not (looking-at "\\.  ")))))))
		  (skip-chars-forward " ")
		  ;; (skip-chars-forward "^ \n")
		  (fill-move-forward-to-break-point re-break-point)
		  (setq first nil)))
	    ;; Normally, move back over the single space between the words.
	    (if (eq (preceding-char) ? )
		(forward-char -1))))
	(if mc-flag
	    ;; ʬ  WAN means chars which match word-across-newline.
	    ;; (0)     | SPC + SPC* <EOB>	--> NL
	    ;; (1) WAN | SPC + SPC*		--> WAN + SPC + NL
	    ;; (2)     | SPC + SPC* + WAN	--> SPC + NL  + WAN
	    ;; (3) '.' | SPC + nonSPC		--> '.' + SPC + NL + nonSPC
	    ;; (4) '.' | SPC + SPC		--> '.' + NL
	    ;; (5)     | SPC*			--> NL
	    (let ((start (point))	; 92.6.30 by K.Handa
		  (ch (following-char)))
	      (if (and (= ch ? )
		       (progn		; not case (0) -- 92.6.30 by K.Handa
			 (skip-chars-forward " \t")
			 (not (eobp)))
		       (or
			(progn	; case (1)
			  (goto-char start)
			  (forward-char -1)
			  (looking-at word-across-newline))
			(progn	; case (2)
			  (goto-char start)
			  (skip-chars-forward " \t")
			  (and (not (eobp))
			       (looking-at word-across-newline)
			       ;; never leave space after the end of sentence
			       (not (fill-end-of-sentence-p))))
			(progn	; case (3)
			  (goto-char (1+ start))
			  (and (not (eobp))
			       (/= (following-char) ? )
			       (fill-end-of-sentence-p)))))
		  ;; We should keep one SPACE before NEWLINE. (1),(2),(3)
		  (goto-char (1+ start))
		;; We should delete all SPACES around break point. (4),(5)
		(goto-char start))))
	;; end of patch
	(delete-horizontal-space)
	(if (equal (preceding-char) ?\\)
	    (insert ? ))
	(insert ?\n)
	(LaTeX-indent-line)
	(setq prefixcol (current-column))
	(and justify-flag (not (eobp))
	     (progn
	       (forward-line -1)
	       (justify-current-line)
	       (forward-line 1)))
	)
      (goto-char (point-max))
      (delete-horizontal-space))))))

(if (boundp 'NEMACS)
(defun LaTeX-fill-region-as-paragraph (from to &optional justify-flag)
  "Fill region as one paragraph: break lines to fit fill-column.
Prefix arg means justify too.
From program, pass args FROM, TO and JUSTIFY-FLAG."
  (interactive "r\nP")
  (save-restriction
    (goto-char from)
    (skip-chars-forward " \n")
    (LaTeX-indent-line)
    (beginning-of-line)
    (narrow-to-region (point) to)
    (setq from (point))

    ;; Delete whitespace at beginning of line from every line,
    ;; except the first line.
    (goto-char (point-min))
    (forward-line 1)
    (while (not (eobp))
      (delete-horizontal-space)
      (forward-line 1))

    ;; from is now before the text to fill,
    ;; but after any fill prefix on the first line.

    ;; Make sure sentences ending at end of line get an extra space.
    (goto-char from)
    ;;; patch by S.Tomura 88-Jun-30
    ;;
    ;; . + CR             ==> . + SPC + SPC 
    ;; . + SPC + CR +     ==> . + SPC + 
    ;;(while (re-search-forward "[.?!][])""']*$" nil t)
    ;;  (insert ? ))
    (while (re-search-forward "[.?!][])""']*$" nil t)
      (if (eobp)
	  nil
      (delete-char 1)
      (insert "  "))) ;; replace CR by two spaces.
    ;; end of patch
    ;; The change all newlines to spaces.
    ;; patched by S.Tomura 87-Dec-7
    ;; bug fixed by S.Tomura 88-May-25
    ;; modified by  S.Tomura 88-Jun-21
    ;;(subst-char-in-region from (point-max) ?\n ?\ )
    ;;ܸθθˤ϶Ϥʤ
    (goto-char from)
    (end-of-line)
    (while (not (eobp))
      (delete-char 1)
      (if (and (< ?  (preceding-char)) ;; + SPC + CR + X ==> + SPC + X
	       (< (preceding-char) 128)
	       (<= ?  (following-char))
	       (< (following-char) 128))
	   (insert ?\  ))
      (end-of-line))
    ;; νʸˤtwo spacesꡢʳsingle spaceˤʤäƤ롣
    ;; end of patch
    ;; Flush excess spaces, except in the paragraph indentation.
    (goto-char from)
    (skip-chars-forward " \t")
    (while (re-search-forward "   *" nil t)
      (delete-region
       (+ (match-beginning 0)
	  (if (save-excursion
	       (skip-chars-backward " ])\"'")
	       (memq (preceding-char) '(?. ?? ?!)))
	      2 1))
       (match-end 0)))
    (goto-char from)
    (skip-chars-forward " \t")
    (while (re-search-forward " " nil t)
      (if (<= 128 (following-char))
	  (let ((dummy 0))
	    (backward-char 1) 
	    (if (<= 128 (preceding-char))
		(delete-char 1))
	    (forward-char 1))))
    (goto-char (point-max))
    (delete-horizontal-space)
    (insert "  ")
    (goto-char (point-min))
    (let ((prefixcol 0))
      (while (not (eobp))
	;; patched by S.Tomura 88-Jun-2
	;;(move-to-column (1+ fill-column))
	(move-to-column fill-column)
	;; end of patch
	;; patched by S.Tomura 88-Jun-16, 89-Oct-2, 89-Oct-19
	;; ɤξˤfill-column礭ʤ뤳Ȥ롣
	(or (>= fill-column (current-column)) (backward-char 1))
	;; end of patch
	(if (eobp)
	    nil
	  ;; patched by S.Tomura 87-Jun-2
	  ;;(skip-chars-backward "^ \n")
	  ;;(if (if (zerop prefixcol) (bolp) (>= prefixcol (current-column)))
	  ;;    (skip-chars-forward "^ \n")
	  ;;  (forward-char -1)))
	  ;; §Ȥfill-column꺸¦ʬõ
	  ;; Find a point to break lines
	     (skip-chars-backward " \t") ;; skip SPC and TAB
	     (if (or (<= 128 (preceding-char))
		     (<= 128 (following-char)) ;; 88-Aug-25
		     (= (following-char) ? )
		     (= (following-char) ?\t))
		 (kinsoku-shori)
	       (if(re-search-backward "[ \t\n]\\|\\z" ;; 89-Nov-17
				      (point-min) (point-min))
		   (forward-char 1))
	       (skip-chars-backward " \t")
	       (kinsoku-shori))
	     ;; prifixcol걦¦ʬõ
	     ;; ξʬfill-column걦¦ˤʤ롣
	     (if (>= prefixcol (current-column))
		 (progn
		   (move-to-column prefixcol)
		   (if (re-search-forward "[ \t]\\|\\z" ;; 89-Nov-17
					  (point-max) (point-max))
		       (backward-char 1))
		   (skip-chars-backward " \t")
		   (kinsoku-shori)
		   ;; ܤʤʬ롣
		   (if (>= prefixcol (current-column)) (goto-char (point-max))))))
	;; end of patch S.Tomura
	;; patch by S. Tomura 88-Jun-20
	;;(delete-horizontal-space)
        ;;ʬ
        ;;  | SPC + SPC   -->  + SPC + CR
	;; | SPC + SPC* +   --> SPC  + CR + 
        ;; . | SPC + SPC +      --> . + CR
        ;; . | SPC + nonSPC     --> . + SPC + CR + nonSPC
        ;;
        ;; . | Ⱦ             --> ʬ䤷ʤ
        ;; . |              --> ʬ䤷ʤ
	(if (not kanji-flag) (delete-horizontal-space)
	  (let ((start) (end))
	    (skip-chars-backward " \t")
	    (setq start (point))
	    (skip-chars-forward  " \t")
	    (setq end (point))
	    (delete-region start end)
	    (if (and (not
		      (and (save-excursion
			     (skip-chars-backward " ])\"'")
			     (memq (preceding-char) '(?. ?? ?!)))
			   (= end (+ start 2))))
		     (or (and (or (<= 128 (preceding-char))
				  (<= 128 (following-char)))
			      (< start end)
			      (not (eobp)))
			 (and (memq (preceding-char) '(?. ?? ?!))
			      (= (1+ start) end)
			      (not (eobp)))))
		(insert ?  ))))
	;; end of patch
	(if (equal (preceding-char) ?\\)
	    (insert ? ))
	(insert ?\n)
	(LaTeX-indent-line)
	(setq prefixcol (current-column))
	(and justify-flag (not (eobp))
	     (progn
	       (forward-line -1)
	       (justify-current-line)
	       (forward-line 1)))
	)
      (goto-char (point-max))
      (delete-horizontal-space)))))

;;; Support for various self-insert-command

(cond ((fboundp 'can-n-egg-self-insert-command)
       (fset 'tex-jp-self-insert-command 'can-n-egg-self-insert-command))
      ((fboundp 'egg-self-insert-command)
       (fset 'tex-jp-self-insert-command 'egg-self-insert-command))
      ((fboundp 'canna-self-insert-command)
       (fset 'tex-jp-self-insert-command 'canna-self-insert-command))
      (t
       (fset 'tex-jp-self-insert-command 'self-insert-command)))

(defun TeX-insert-punctuation ()
  "Insert point or comma, cleaning up preceding space."
  (interactive)
  (if (TeX-looking-at-backward "\\\\/\\(}+\\)" 50)
      (replace-match "\\1" t))
  (call-interactively 'tex-jp-self-insert-command))

;;; Error Messages

(if japanese-TeX-error-messages
    (setq TeX-error-description-list
  '(("Bad \\\\line or \\\\vector argument.*" .
"ηꤹ롤\\lineޤ\\vectorκǽΰǤ")

    ("Bad math environment delimiter.*" .
"⡼ǿ⡼ɳϥޥ\\[ޤ\\(ޤϡ⡼ɳ
⡼ɽλޥ\\[ޤ\\(TeXĤޤϡ⡼
ɤΥǥߥޥåƤʤäꡤ̤ΥХ󥹤ȤƤʤäꤹ
뤿ޤ")

    ("Bad use of \\\\\\\\.*" .
"\\\\ޥɤѥ饰ˤޤλȤ̵̣Ǥ
Υ顼å\\\\centeringĶflushingĶǻȤ줿
뤤centering/flushingͭʤȤǻȤ줿ޤ")

    ("\\\\begin{[^ ]*} ended by \\\\end{[^ ]*}." .
"б\\begin̿Τʤ\\end̿LaTeXĤޤ\\end̿δ
ְ̾㤨;ʬ\\begin̿᤬뤫\\end̿魯줿Τ
줫Ǥ礦")

    ("Can be used only in preamble." .
"ץꥢ֥ǤȤʤ\\documentstyle\\nofiles\\includeonly
\\makeindex\\makeglossaryΤΤ줫\\begin{document}
ǻȤƤΤLaTeXФޤΥ顼\\begin{document}
;ʬˤäˤޤ")

    ("Command name [^ ]* already used.*" .
"ǤƤ̿̾ޤϴĶ̾Ф\\newcommand
\\newenvironment\\newlength\\newsavebox\\newtheoremΤΤ
줫¹Ԥ褦ȤƤޤ(ĶƱ̾̿᤬ư
ŪΤǡ¸ߤĶƱ̾̿Ǥޤ)
̾ͤ뤫\\newcommand\\newenvironmentξʤб
\\renew...̿ȤʤФʤޤ")

    ("Counter too large." .
"ʸǽդ줿Ρֹ֤դ줿ꥹȴĶΥ٥뤬
26礭ֹޤĹꥹȤȤäƤ뤫
󥿤ꤷƤޤäΤ줫Ǥ礦")

    ("Environment [^ ]* undefined." .
"ƤʤĶФ\\begin̿LaTeXĤޤ餯
Ķְ̾㤨ΤǤ礦")

    ("Float(s) lost." .
"parboxΤʤfigureĶtableĶޤ\\marginpar̿᤬ޤ
\(ʤparboxminipageĶ\\parbox̿ˤäƺ뤫
ʤɤФLaTeXΤǤ\)ϽϻΥ顼ʤΤǡ
ȤʤäƤĶ뤤̿ϡLaTeXȯ
ˤǽޤϤƤʤޡɽ˵ʤɤĤ
뤫⤷ޤ󤬡餬ǤȤϸ¤ޤ")

    ("Illegal character in array arg." .
"arrayĶޤtabularĶΰޤ\\multicolumn̿2
ʸޤ")

    ("Missing \\\\begin{document}." .
"\\begin{document}̿LaTeXϤԤʤäƤޤޤ
\\begin{document}̿˺줿ץꥢ֥˲ְ㤤ΤǤ礦
Ǥְ㤤ˤʸ䡤θˤǽ⤢ޤ㤨С
Ϥ̤ȴȤ̿̾\\˺줿ʤɤǤ")

    ("Missing p-arg in array arg.*" .
"arrayĶtabularĶΰ뤤\\multicolumn̿2ˡ
̤˰Ϥޤ줿ɽΤĤƤʤpޤ")

    ("Missing @-exp in array arg." .
"arrayĶtabularĶΰ뤤\\multicolumn̿2ˡ
@ɽΤĤƤʤ@ޤ")

    ("No such counter." .
"\\setcounter̿ޤ\\addtocounter̿ǡ¸ߤʤ󥿤ꤵ
ޤ餯ΥץߥǤ礦顼auxե
ϡ\\newcounter̿ץꥢ֥γǻȤäΤȻפޤ")

    ("Not in outer par mode." .
"figureĶtableĶ뤤\\marginpar̿᤬⡼ɤޤparbox
ǻȤޤ")

    ("\\\\pushtabs and \\\\poptabs don't match." .
"\\pushtabsбʤ\\poptabsߤĤäޤϡб\\poptabs
⤿ʤ\\pushtabsΤ\\end{tabbing}Ƥޤޤ")

    ("Something's wrong--perhaps a missing \\\\item." .
"ꥹȴĶ\\item̿᤬ʤΤǤ⤢ꤽʥǤ
thebibliographyĶǰ˺줿ˤޤ")

    ("Tab overflow." .
"\\=LaTeXǵ륿֥ȥåפκĶƤޤ")

    ("There's no line here to end." .
"\\newline̿ޤ\\\\̿᤬ѥ饰մ֤ˤޤλȤ
̵̣Ǥ⤷Ԥ򤢤ΤǤ顤\\vspaceȤäƤ")

    ("This may be a LaTeX bug." .
"ޤä櫓狼ʤʤäƤޤޤ֤󤳤˸Ф줿
顼ΤȻפޤLaTeXΤΥХǤǽ⤢ޤ
⤷Υ顼ϥեФǽΥ顼Ǥꡤְ㤤
ʤϡΥե¸ơ륬ɤ˽񤫤ƤǤ
ԤϢƤ")

    ("Too deeply nested." .
"ꥹȴĶҤޤʳҤ뤫ϻȤäƤ
ԥ塼˰¸ޤʤȤ4ʳޤǤϵƤޤ(̤
ǽʬǤ礦)")

    ("Too many unprocessed floats." .
"Υ顼1ڡ\\marginpar̿᤬¿뤿⤢
ޤäȤꤽʤΤϡ³Ķƿޤɽ¸褦Ȥ
ǤĹʸǤƤȤLaTeXϿޤɽġ¸ڡ
ʬԤʤˤޤΥ顼ϡڡؤʬ䤬
Ԥʤˡޤˤ¿figureĶtableĶĤä
ޤϴĶΤΤĤʸν˰ư
вǤޤޤΥ顼``logjam''ˤä뤳Ȥ⤢
``logjam''ȤϡLaTeXи̤ˤɽϤǤʤǡ
ĤޤäƤοɽΤοɽϤǤʤʤ뤳Ȥ򤤤ޤ
Υθϡ礭1ڡʤϻꤵ줿ΰ˼ޤ
褦ʿޤɽǤǽޤϡpץ󤬻
Ƥʤȵ䤹ʤޤ")

    ("Undefined tab position." .
"\\>\\+\\-ޤ\\<̿ǡ¸ߤʤְ֡ʤ\\=̿
Ƥʤְ֤ꤷ褦ȤƤޤ")

    ("\\\\< in mid line." .
"\\<̿᤬tabbingĶιԤ˸ޤ̿ϹԤƬˤʤ
ʤޤ")

    ("Counter too large." .
"ʸޤϵǽŤƤޤʸޤϵȤ
ڤäƤޤޤ餯\\thanks̿λȤǤ")

    ("Double subscript." .
"1Ĥ2ĤβդʸĤƤޤ㤨x_{2}_{3}Τ褦ˡ
Τ褦ɽ̵̣Ǥ")

    ("Double superscript." .
"1Ĥ2ĤξդʸĤƤޤ㤨x^{2}^{3}Τ褦ˡ
Τ褦ɽ̵̣Ǥ")

    ("Extra alignment tab has been changed to \\\\cr." .
"arrayĶޤtabularĶ1ˤܤ¿ޤȡ
νޤǤˤ&ο¿ޤ餯κǸ\\\\Ĥ
Τ˺줿ΤǤ礦")

    ("Extra \\}, or forgotten \\$." .
"̤ޤϿ⡼ɤΥǥߥбƤޤ󡥤餯{\\[
\\(뤤$ΤΤ줫˺줿ΤǤ礦")

    ("Font [^ ]* not loaded: Not enough room left." .
"ʸϸ³¿ΥեȤȤäƤޤ⤷ʸʬȤ
̡ΥեȤȤƤΤʤ顤ʬ䤷ƽϲ褵ޤ")

    ("I can't find file `.*'." .
"ɬפʥե뤬ĤޤǤ⤷Ĥʤեγĥ
texξ硤ʤꤷե롤ʤᥤեޤ
\\input̿ᡦ\\include̿ե뤬ĤʤΤǤ
ĥҤstyǤС¸ߤʤʸ񥹥ޤϥ륪ץ
ꤷ褦ȤƤޤ")

    ("Illegal parameter number in definition of .*" .
"Ϥ餯\\newcommand\\renewcommand\\newenvironmentޤ
\\renewenvironment̿Τʤ#Ȥʤä顼
Ǥ\\#̿ȤƻȤС#Ȥʸϡ㤨2ܤ
ꤹ#2Τ褦ˡѥ᡼ȤƤȤޤ󡥤ޤ
Υ顼ϡˤ4ĤΥޥɤߤҤˤʤäƤ
䡤\\newenvironment̿ᡦ\\renewenvironment̿#2Τ褦ʥѥ᡼
ǸΰǻȤƤˤޤ")

    ("Illegal unit of measure ([^ ]* inserted)." .
"⤷
      ! Missing number, treated as zero.
Ȥ顼ľǤСΥ顼θ⤽ƱǤ
ǤʤϡLaTeXȤlengthԤƤΤnumber
줿Ȥ̣ƤޤΥ顼κǤ⤢꤬ʸĹ0
ɽ魯0inΤ褦ɽ0ȤƤޤȤˤޤ
̿ΰ˺줿ˤ⤳Υ顼뤳Ȥޤ")

    ("Misplaced alignment tab character \\&." .
"arrayޤtabularĶǤιܶڤˤΤ߻Ȥ٤ʸ&̤ʸ
ˤޤ֤\\&ϤäΤǤ礦")

    ("Missing control sequence inserted." .
"Υ顼ϡ餯̿̾ǤʤΤ\\newcommand\\renewcommand
\\newlengthޤ\\newsavebox1ȤƻȤäΤǤ礦")

    ("Missing number, treated as zero." .
"Υ顼ϤƤȤnumberޤlengthɬפȤƤ̿
ФưͿʤäޤ˺줿Τƥ
([])ץλȴְ㤨ƤޤäΤɤ餫
礦ޤ\\valueΤ褦̿length̿\\protect
֤ˤ⤳Υ顼ޤ")

    ("Missing [{}] inserted." .
"TeXϴˤ櫓狼ʤʤäƤޤ顼åˤäƼ
Ϥ֤Ϥ˴ְ㤤äȤˤʤäƤޤäƤ
Ǥ礦")

    ("Missing \\$ inserted." .
"餯⡼ǤȤʤ̿TeX⡼ɳǸФ
ΤȻפޤä˵ҤƤʤ¤ꡤLaTeX Book(Lamport,
ϥ)3.3ˤźʬصʤɤΥޥɤϤ٤
⡼ɤǤȤʤΤȤȤդƤȤ̿᤬
ĶˤäȤƤ⡤box̿ΰϤ᤿
ǤϡTeXϤޤ⡼ɤäƤʤΤǤޤΥ顼ϡ
⡼TeXԤ򸡽Фˤޤ")

    ("Not a letter." .
"\\hyphenation̿ΰˤʤˤʤΤޤ")

    ("Paragraph ended before [^ ]* was complete." .
"̿ΰʶԤäƤޤäƤޤ餯ν
Ĥ̤ĤΤ˺줿ΤǤ礦")

    ("\\\\[^ ]*font [^ ]* is undefined .*" .
"Υ顼ϤޤŪǤʤեȤ⡼ɤǻȤ줿
ޤ㤨Сο\\sc̿᤬Ȥȡfootnotesize
small capsեȤƤӤ뤳Ȥˤʤޤ\\load̿
ȤвǤޤ")

    ("Font .* not found." .                                    
"̤Τfamily/series/shape/sizeȤ߹碌ΥեȤꤵޤ
Υ顼륱2Ĺͤޤ
   1) \\sizeޥǻȤʤ򤷤褦Ȥ
   2) ǤʤСԤΤȤ˹Ԥäơեơ֥뤬
      äƤʸĤƤޤ礦!")

    ("TeX capacity exceeded, sorry .*" .
"TeXȤäƤޤ¹ԤǤޤƤʤ
Υ顼ϡ֤TeXˤʤʸ
ǽϤʤǤϤޤTeX˥Ȥ餻
ϡ餯Ϥե顼Ǥʤ
TeX̤ĶȤ򤷤褦ȤΤɤƤξɤ
ФΤȽǤˡʲޤ⤷꤬ϥե
顼ˤϡġΥ顼褷ƤˡȤΤ褤Ǥ
LaTeXûեǥȤ뤳ȤϤäˤޤ󤫤顤
顼ε֤˽ڡڡʤСޤ
㤤ʤϥե꤬ϤǤ

顼åκǸˡTeXȤäƤޤäμब
ƤޤΤŪʤΤˤĤơͤ븶ʲ˵
ޤ

buffer size
===========
ᡦ\\caption\\addcontentsline뤤\\addtocontents̿ΰ
ͿƥȤĹ뤳ȤޤΥ顼
Ƥ\\end{document}Ƥޤ\\tableofcontents
\\listoffigures뤤\\listoftables̿¹ԤƤˤⵯ
Ȥޤ褹ˤϡäûƥȤ򥪥ץ
ȤͿƤܼɽƤ⡤ФĹ
ɤߤˤʤϤǤ

exception dictionary
====================
TeXäƤΰʾ˥ϥե͡Ϳ褦ȤƤޤ
ޤȤʤñ\\hyphenation̿ơ\\-̿Ȥ
Ƥ

hash size 
=========
̿̾ޤ߻ȥ٥¿ޤ

input stack size 
================
Υ顼Ϥ餯̿θˤΤǤ㤨С̿
ƵŪȤʤäƤꡤʬȤȤä\\gnuƤޤ

          \\newcommand{\\gnu}{a \\gnu} % Ϥ

\\gnu̿򸫤ĤTeX\\gnu򤦤ߤΤꤷ褦Ȥ
Ƥ򤤤ĤޤǤɤĤŤ䤬``input stack''ȤäƤ
ޤޤ

main memory size 
================
ϡTeXûեƤ˻ȤǽΤ
ΤҤȤĤǤmain memoryȤΤϼ3ĤξΤ줫Ǥ
\(1\)Ĺʣ̿¿(2)indexޤglossary
ƤȤ1ڡˤޤˤ¿\\indexޤ\\glossary̿᤬
롥(3)ΤξTeXݻʤ褦ʡޤˤʣʥڡ
褦Ȥǽ2Ĥβˡ餫Ǥ̿
ο뤤\\index\\glossary̿ο򸺤餹ȤǤ3ܤ
äǤϡ礭tabbintabulararraypictureĶ
뤳Ȥޤϰ֤ꤵΤԤäƤޤɽ
TeXΥ꤬äѤˤʤäƤΤ⤷ޤTeX̤Ķ
ƤޤäΤɤĴ٤뤿ˤϡ顼εäľ
\\clearpage̿Ƥ⤦٥ѥ¹ԤƤߤƤ⤷
Ǥ꤬­ʤʤ褦ʤ顤ʤ餫μʤ֤ɬפ
ޤTeXڡǤ뤫ɤꤹ뤿ˤΤ
ФʤʤȤȤפƤ\\newpage̿
СλĤ˺ΥڡTeX˽Ϥ뤳
;͵Ǥ뤫⤷ޤ(\\pagebreak̿ǤϤǤ)⤷ޤɽ
ίޤäƤ뤳ȤʤΤʤСɽäȸ˰ưȤ
뤤ϤäλǽϤ褦ˤвǤޤ⤷ޤʸ
Ƥʤ顤Ȥꤢ\\clearpage̿Ƥơ
ǤޤǤê夲Ƥޤ礦ϥե뤬Ѥ
꤬ä⤢ΤǤ

pool size 
=========
߻Ȥ\\label¿뤫̿¿뤫Τɤ餫Ǥ
ΤˤС٥̾̿̾˻Ȥäʸ¿Ȥ
ȤǤǤ顤äû̾ȤФϲ褷ޤ
Υ顼ϡ\\setcounterʤɤΥ̿\\newenvironment
\\newtheorem̿ΰν򼨤̤˺줿ˤޤ

save size 
=========
Υ顼ϡͭϰϤ̿ᡦĶޤˤ⿼Ҥˤʤä
ޤȤС\\multiput̿ΰpictureĶꡤ
Τʤ\\footnotesizeꡤͭϰϤ\\multiput̿
äơΰ... Ȥ褦ʾǤ")

    ("Text line contains an invalid character." .
"ʸޤޤƤޤեθˤäƥƥ
ǥʸƤޤäΤǤ礦ºݤ˲Τ
ǥˤޤϥեĴ٤ƤߤơŦ줿ʸĤ
ʤˤϥ륬ɤ򸫤Ƥ")

    ("Undefined control sequence."   .  
"TeX̤̿̾ȯޤ餯ϤθǤ礦⤷
Υ顼LaTeX̿νϡ̿ϴְä֤֤
Ƥޤ㤨СꥹȴĶǤʤΤ\\item̿᤬Ȥ줿ʤ
Ǥޤ\\documentstyle̿᤬ʤˤ⤳Υ顼ޤ")

    ("Use of [^ ]* doesn't match its definition." .
"餯Τ̿ȻפޤλȤְäƤ
ޤְäƤΤ\\@array̿ξϡarrayĶtabularĶǤ
@ɽΰˤʤˤ꤬ΤǤ礦fragile̿᤬\\protect
ʤΤ⤷ޤ")

    ("You can't use `macro parameter character \\#' in [^ ]* mode." .
"üʸ#̤ΥƥȤ˸ޤ餯\\#Ƚ񤭤ä
ΤǤ礦")

    ("Overfull \\\\hbox .*" .
"ʬΤŬڤʾ꤬ĤʤäΤǡ1Ԥ˼ޤ٤ʬ̰ʾ
νϤԤʤƤޤޤ")

    ("Overfull \\\\vbox .*" .
"ڡʬΤŬڤʾ꤬ĤʤäΤǡ1ڡ˼ޤ٤
ʬ̰ʾνϤԤʤƤޤޤ")

    ("Underfull \\\\hbox .*" .
";ʬʿľڡʤɤϤΤƤ⤷С
\\\\̿ޤ\\newline̿˴طΤΤǤ
2Ĥ\\\\̿᤬³ƤʤɤǤηٹsloppyparĶ
\\sloppyλѡ뤤\\linebreak̿ʤɤˤ⤢ޤ")

    ("Underfull \\\\vbox .*" .
"ڡʬ䤹뤿Ŭڤʾ꤬Ĥ줺ʬʥƥȤΤʤ
ڡǤƤޤޤ")

;; New list items should be placed here 
;; 
;; ("err-regexp" . "context") 
;; 
;; the err-regexp item should match anything

    (".*" . "ʤإץåޤ"))))

(provide 'tex-jp)

;;; tex-jp.el ends here
