enum {
  ENC_ISO_8859_1  = 1 << 0,
  ENC_ISO_8859_2  = 1 << 1,
  ENC_ISO_8859_3  = 1 << 2,
  ENC_ISO_8859_4  = 1 << 3,
  ENC_ISO_8859_5  = 1 << 4,
  ENC_ISO_8859_6  = 1 << 5,
  ENC_ISO_8859_7  = 1 << 6,
  ENC_ISO_8859_8  = 1 << 7,
  ENC_ISO_8859_9  = 1 << 8,
  ENC_ISO_8859_10 = 1 << 9,
  ENC_ISO_8859_13 = 1 << 10,
  ENC_ISO_8859_14 = 1 << 11,
  ENC_ISO_8859_15 = 1 << 12,
  ENC_KOI8_R      = 1 << 13,
  ENC_TIS_620     = 1 << 14,
  ENC_JIS_0208    = 1 << 15,
  ENC_GB_2312     = 1 << 16,
  ENC_KSC_5601    = 1 << 17,
  ENC_ISO_10646   = 1 << 18
};

Charset charsets[] = {
  { 0,  "ISO-8859-1",   "iso8859-1",       conv_ucs4 },
  { 1,  "ISO-8859-2",   "iso8859-2",       conv_8bit },
  { 2,  "ISO-8859-3",   "iso8859-3",       conv_8bit },
  { 3,  "ISO-8859-4",   "iso8859-4",       conv_8bit },
  { 4,  "ISO-8859-5",   "iso8859-5",       conv_8bit },
  { 5,  "ISO-8859-6",   "iso8859-6",       conv_8bit },
  { 6,  "ISO-8859-7",   "iso8859-7",       conv_8bit },
  { 7,  "ISO-8859-8",   "iso8859-8",       conv_8bit },
  { 8,  "ISO-8859-9",   "iso8859-9",       conv_8bit },
  { 9,  "ISO-8859-10",  "iso8859-10",      conv_8bit },
  { 10, "ISO-8859-13",  "iso8859-13",      conv_8bit },
  { 11, "ISO-8859-14",  "iso8859-14",      conv_8bit },
  { 12, "ISO-8859-15",  "iso8859-15",      conv_8bit },
  { 13, "KOI8-R",       "koi8-r",          conv_8bit },
  { 14, "TIS-620",      "tis620.2529-1",   conv_8bit },
  { 15, "EUC-JP",       "jisx0208.1983-0", conv_euc },
  { 16, "EUC-CN",       "gb2312.1980-0",   conv_euc },
  { 17, "EUC-KR",       "ksc5601.1987-0",  conv_euc },
  { 18, "ISO-10646",    "iso10646-1",      conv_ucs4 }
};

CharsetOrdering charset_orderings[] = {
	{ "zh-cn", { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 18, 15, 17 } },
	{ "zh-tw", { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 18, 15, 17 } },
	{ "ja", { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 18, 16, 17 } },
	{ NULL, { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 18, 15, 16, 17 } },
};

const guint32 char_mask_map[] = {
  0,
  ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KOI8_R,
  ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KOI8_R|ENC_TIS_620,
  ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208|ENC_KOI8_R|ENC_TIS_620,
  ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_ISO_8859_1|ENC_ISO_8859_15|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208,
  ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_3|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208,
  ENC_GB_2312|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_6|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_15|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_GB_2312|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208|ENC_KSC_5601,
  ENC_GB_2312|ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KOI8_R,
  ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208,
  ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_5|ENC_ISO_8859_6|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_ISO_8859_1|ENC_ISO_8859_15|ENC_ISO_8859_4|ENC_ISO_8859_9,
  ENC_GB_2312|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208|ENC_KOI8_R|ENC_KSC_5601,
  ENC_GB_2312|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_3|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KOI8_R|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_3|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_3|ENC_ISO_8859_8|ENC_ISO_8859_9,
  ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208|ENC_KSC_5601,
  ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_3|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KOI8_R|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_3|ENC_ISO_8859_7|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_3|ENC_ISO_8859_9,
  ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9,
  ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_4|ENC_ISO_8859_9,
  ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9,
  ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_4|ENC_ISO_8859_9,
  ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_9,
  ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_3|ENC_ISO_8859_9,
  ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_15|ENC_KSC_5601,
  ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_9,
  ENC_GB_2312|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208|ENC_KSC_5601,
  ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9,
  ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2,
  ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_GB_2312|ENC_ISO_8859_1|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_3|ENC_ISO_8859_9,
  ENC_GB_2312|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9,
  ENC_GB_2312|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_9,
  ENC_GB_2312|ENC_ISO_8859_10|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_9,
  ENC_GB_2312|ENC_ISO_8859_1|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_ISO_8859_8|ENC_ISO_8859_9|ENC_JIS_0208|ENC_KOI8_R|ENC_KSC_5601,
  ENC_ISO_8859_1|ENC_ISO_8859_14|ENC_ISO_8859_15|ENC_ISO_8859_9,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_4,
  ENC_GB_2312|ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_4,
  ENC_ISO_8859_2,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_2|ENC_ISO_8859_4,
  ENC_ISO_8859_13|ENC_ISO_8859_2,
  ENC_ISO_8859_3,
  ENC_ISO_8859_14|ENC_ISO_8859_3,
  ENC_ISO_8859_10|ENC_ISO_8859_2|ENC_ISO_8859_4,
  ENC_ISO_8859_10|ENC_ISO_8859_2|ENC_ISO_8859_4|ENC_KSC_5601,
  ENC_GB_2312|ENC_ISO_8859_2,
  ENC_ISO_8859_3|ENC_ISO_8859_9,
  ENC_ISO_8859_3|ENC_KSC_5601,
  ENC_ISO_8859_10|ENC_ISO_8859_4,
  ENC_ISO_8859_3|ENC_ISO_8859_9|ENC_KSC_5601,
  ENC_KSC_5601,
  ENC_ISO_8859_10|ENC_ISO_8859_4|ENC_KSC_5601,
  ENC_ISO_8859_13|ENC_ISO_8859_2|ENC_KSC_5601,
  ENC_ISO_8859_15|ENC_KSC_5601,
  ENC_ISO_8859_13|ENC_ISO_8859_4,
  ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_9,
  ENC_ISO_8859_10|ENC_ISO_8859_13|ENC_ISO_8859_15|ENC_ISO_8859_2|ENC_ISO_8859_4,
  ENC_ISO_8859_14,
  ENC_ISO_8859_14|ENC_ISO_8859_15,
  ENC_ISO_8859_13|ENC_ISO_8859_2|ENC_ISO_8859_3,
  ENC_GB_2312,
  ENC_GB_2312|ENC_ISO_8859_2|ENC_ISO_8859_4|ENC_KSC_5601,
  ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_KSC_5601,
  ENC_ISO_8859_2|ENC_ISO_8859_3|ENC_ISO_8859_4|ENC_KSC_5601,
  ENC_ISO_8859_2|ENC_ISO_8859_4|ENC_KSC_5601,
  ENC_ISO_8859_2|ENC_KSC_5601,
  ENC_ISO_8859_7,
  ENC_GB_2312|ENC_ISO_8859_7|ENC_JIS_0208|ENC_KSC_5601,
  ENC_GB_2312|ENC_ISO_8859_5|ENC_JIS_0208|ENC_KOI8_R|ENC_KSC_5601,
  ENC_ISO_8859_5,
  ENC_ISO_8859_8,
  ENC_ISO_8859_6,
  ENC_TIS_620,
  ENC_JIS_0208,
  ENC_GB_2312|ENC_ISO_8859_10|ENC_ISO_8859_7|ENC_JIS_0208|ENC_KSC_5601,
  ENC_GB_2312|ENC_JIS_0208,
  ENC_GB_2312|ENC_ISO_8859_13|ENC_ISO_8859_7|ENC_JIS_0208|ENC_KSC_5601,
  ENC_GB_2312|ENC_ISO_8859_13|ENC_JIS_0208|ENC_KSC_5601,
  ENC_ISO_8859_13,
  ENC_JIS_0208|ENC_KSC_5601,
  ENC_GB_2312|ENC_JIS_0208|ENC_KSC_5601,
  ENC_ISO_8859_15,
  ENC_GB_2312|ENC_ISO_8859_5|ENC_KSC_5601,
  ENC_GB_2312|ENC_KSC_5601,
  ENC_KOI8_R,
  ENC_GB_2312|ENC_JIS_0208|ENC_KOI8_R|ENC_KSC_5601,
  ENC_GB_2312|ENC_KOI8_R,
  ENC_GB_2312|ENC_KOI8_R|ENC_KSC_5601,
  ENC_KOI8_R|ENC_KSC_5601,
};

const guchar char_masks[] = {
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  3,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  2,  1,
  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,
  1,  5,  6,  7,  8,  9, 10, 11, 12, 13,  5, 14, 15, 16, 17, 18,
 19, 20, 21, 22, 23, 24, 25, 26, 27, 28,  5, 14, 29, 30, 29,  5,
 31, 32, 32, 33, 34, 35, 36, 37, 31, 34, 31, 32, 31, 32, 32, 38,
 39, 31, 31, 40, 32, 35, 34, 41, 36, 31, 32, 42, 34, 43, 39, 44,
 45, 46, 32, 33, 34, 35, 36, 37, 45, 47, 45, 32, 45, 46, 32, 38,
 39, 31, 45, 48, 32, 35, 34, 49, 36, 45, 46, 42, 47, 43, 39, 50,
 51, 52, 53, 53, 54, 54, 55, 55, 56, 56, 57, 57, 54, 54, 53, 53,
 58, 59, 51, 52,  0,  0, 51, 51, 54, 54, 53, 60, 56, 56, 61, 61,
 57, 57, 51, 51, 56, 56, 62, 62, 63, 63, 51, 52,  0,  0, 51, 51,
 61, 64, 65, 65, 56, 56, 51, 51, 66, 53, 53, 51, 51, 53, 53, 65,
 65, 67, 67, 55, 55, 51, 51, 53, 53, 65, 66, 66, 51, 52,  0,  0,
 53, 53, 68, 68, 53, 53, 69, 69, 53, 53, 55, 55, 56, 56, 70, 70,
 71, 71, 53, 53, 53, 53, 66, 66, 63, 63, 51, 52, 56, 56, 53, 53,
 53, 53, 51, 51, 72, 72, 72, 72, 73, 55, 55, 74, 74, 71, 71,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 75,  0,
 75,  0, 75,  0, 75,  0, 75,  0, 75,  0, 75,  0, 75,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 76,  0, 75,  0,  0,  0,  0,  0,  0,
 65,  0,  0,  0,  0,  0,  0,  0, 77, 78, 65, 79,  0, 80,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 81, 81, 81,  0, 81, 81, 81,  0, 81,  0, 81, 81,
 81, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82,
 82, 82,  0, 82, 82, 82, 82, 82, 82, 82, 81, 81, 81, 81, 81, 81,
 81, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82,
 82, 82, 81, 82, 82, 82, 82, 82, 82, 82, 81, 81, 81, 81, 81,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 83, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84,  0, 84, 84,
 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83,
  0, 83, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84,  0, 84, 84,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85,
 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 86,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 86,  0,  0,  0, 86,
  0, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,  0,  0,  0,  0,  0,
 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86,
 86, 86, 86,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87,
 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87,
 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87,
 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87,  0,  0,  0,  0, 87,
 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87,
 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 72, 72,  0,  0,  0,  0,  0,  0, 72, 72,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 72, 72,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 72, 72,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 72, 72,  0,  0,  0,  0,  0,  0,  0,  0,
 72, 72,  0,  0,  0,  0,  0,  0,  0,  0, 72, 72,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 72, 72, 72, 72, 72, 72,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 72, 72,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 88,  0,  0,  0,  0, 89, 90, 85, 82, 91,  0,  0, 92, 92, 93,  0,
 94, 94,  0,  0,  0, 94, 95,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 95,  0, 95, 95,  0,  0,  0,  0,  0,  0,  0, 95,  0,  0, 85,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 65,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 65,
  0, 65, 65, 65, 65,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 96,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 95,  0,  0,  0,  0,  0, 65,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 65,  0,  0, 97,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 65, 65,  0,  0,  0, 65,  0,  0,  0,  0, 94,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 65, 65,  0,  0,  0,  0,  0,  0, 65, 65, 65, 65,  0,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 75, 75,  0,  0,  0,  0,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 95, 95, 95, 95, 65, 65, 65, 65, 65, 65,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 94,  0, 94,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 94,  0, 94, 94,  0,  0,  0, 94, 95,  0,  0, 94,  0,  0,  0, 98,
  0, 98, 88,  0,  0,  0,  0,  0,  0, 99, 100,  0,  0, 95, 95,  0,
 95,  0,  0,  0,  0, 98,  0, 95, 95, 95, 95, 95, 94,  0, 98,  0,
  0,  0,  0,  0, 95, 95, 75, 75,  0,  0,  0,  0, 65, 95,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 101,  0,  0,  0, 75,  0,  0,  0,
  0,  0, 94,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 95, 95,  0,  0, 102, 102, 88, 88,  0,  0, 94, 94,  0,  0, 75, 75,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 94, 94,  0,  0, 94, 94,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 95,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 95,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 99, 99,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 65, 65, 65, 65, 65,  0,
  0,  0,  0,  0, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,
 98, 98, 98, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 100, 95, 100, 95, 75, 75, 75, 75, 75, 75, 75, 75, 100, 98, 98, 95,
 100, 98, 98, 95, 100, 98, 98, 95, 100, 98, 98, 95, 100, 95, 98, 98,
 95, 98, 98, 95, 100, 95, 98, 98, 95, 98, 98, 95, 100, 98, 98, 95,
 95, 98, 98, 95, 100, 98, 98, 95, 95, 98, 98, 95, 100, 98, 98, 95,
 98, 98, 95, 98, 98, 98, 98, 98, 98, 98, 98, 95,  0,  0,  0,  0,
 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,
 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 99,  0,  0,  0, 99,  0,  0,  0, 99,  0,  0,  0, 99,  0,  0,  0,
 99, 99, 103, 99,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 100, 95,  0, 65, 65, 65, 65, 65, 65, 65,  0,  0,  0,  0,  0,  0,
  0,  0, 95, 95,  0,  0, 65, 65,  0,  0,  0,  0, 94, 94,  0,  0,
 65, 65,  0,  0,  0,  0, 95, 95, 65,  0,  0, 95,  0,  0, 95, 95,
 65, 65,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 88,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 95, 95,  0,  0,  0,  0,  0,  0,  0, 65, 65,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 65,  0, 65,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 95,  0, 95,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 65, 65,  0, 65, 65, 65,  0, 65, 65, 65, 94,  0, 65, 94,  0, 88,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 95, 95, 95, 95,  0, 90, 88, 88, 95, 95, 95, 95, 95, 95, 95, 95,
 95, 95, 88, 95, 95, 95, 75, 75,  0,  0,  0,  0, 88,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
 95, 95, 95, 95,  0,  0,  0,  0,  0,  0,  0, 88, 88, 88, 88,  0,
  0, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
 95, 95, 95, 95, 95, 95, 95,  0,  0,  0,  0, 90, 88, 88, 88,  0,
  0,  0,  0,  0,  0, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,  0,  0,  0,  0,  0,  0,
  0, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,  0,  0,  0,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,  0,  0,  0, 65,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 65, 65, 65, 65, 65,  0,  0,  0, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,  0,  0,  0,  0, 65,
 65,  0,  0, 65,  0,  0, 65,  0, 65,  0,  0, 65, 65, 65,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 95, 95,  0, 95,  0,  0,  0, 95, 95, 95, 95, 95, 75, 95, 90,  0,
 90, 95,  0, 75, 95, 95, 95, 88, 95, 95, 75, 75, 75, 75, 95,  0,
  0, 88, 75,  0, 75, 75, 88, 75, 75,  0, 90, 75, 75, 95,  0,  0,
 75, 88, 95,  0, 75,  0, 90,  0, 95, 95, 75, 95, 88, 75, 75, 90,
  0,  0, 94, 95,  0, 95,  0, 75, 75, 75,  0, 95, 75, 95, 95, 95,
 75,  0, 75, 75, 75, 88, 95, 88, 95, 95,  0,  0, 75, 95, 95, 95,
 75, 75, 88,  0,  0,  0, 75,  0,  0, 75,  0, 65,  0, 65,  0,  0,
 75, 90,  0, 95,  0,  0, 65, 65,  0,  0,  0,  0,  0,  0, 95,  0,
 88,  0, 94,  0,  0, 88, 95,  0, 95, 90, 88, 95, 95, 75, 95, 75,
 65, 95, 95, 75, 95, 95,  0,  0, 95, 88, 75, 95, 88,  0, 94, 90,
 90, 95, 95,  0, 95, 95, 95, 75, 95, 75,  0, 95, 95, 95, 95,  0,
 88,  0, 75, 90,  0, 75, 94,  0,  0,  0, 95, 75,  0,  0,  0, 75,
 95, 95, 90, 75, 95, 75, 90, 95,  0, 75, 95, 95,  0, 95, 90, 88,
  0, 75,  0, 75, 95, 95, 95, 95, 95, 95,  0,  0,  0, 95, 90, 95,
  0, 75,  0, 95, 95, 95,  0,  0, 75,  0, 75, 75, 75, 88, 88,  0,
 95,  0, 95, 75,  0, 75, 95, 95,  0,  0,  0, 95,  0, 75,  0, 75,
  0, 95,  0,  0,  0,  0,  0,  0,  0, 95, 95, 65,  0, 95, 95, 95,
 95, 95,  0,  0,  0,  0,  0, 75, 75, 75, 90, 75, 88, 88, 75, 75,
 75,  0, 75,  0, 75, 75, 75, 75,  0,  0, 75, 75,  0,  0,  0, 95,
 90,  0, 75,  0, 95,  0, 95,  0, 95,  0, 95,  0, 95, 95,  0,  0,
  0,  0,  0, 95,  0,  0, 95, 94, 65,  0,  0,  0,  0, 95, 95, 95,
 95, 95,  0, 90,  0, 95,  0, 90, 75, 95, 95, 95, 95, 90, 90, 75,
 75,  0,  0, 75, 75, 75,  0, 75,  0, 95,  0,  0, 75,  0,  0, 95,
 95,  0,  0, 95, 75, 88, 95,  0,  0,  0, 65, 90, 90,  0, 98, 95,
  0, 65,  0, 95, 98,  0, 94,  0, 95, 75, 65, 95,  0, 95,  0, 95,
  0, 95,  0,  0, 75,  0, 94, 75, 94,  0,  0, 95,  0, 95,  0,  0,
 90, 88,  0, 75,  0, 75, 75, 75, 75, 75, 75, 88, 75, 88, 95, 95,
  0,  0,  0,  0,  0, 95, 94,  0,  0,  0,  0,  0,  0,  0,  0, 95,
  0,  0, 94, 95, 95, 75,  0,  0,  0, 65, 95,  0,  0,  0, 95, 75,
 90, 95,  0, 65, 94,  0,  0, 95, 90,  0, 95, 88, 75, 95, 75, 95,
 65, 95,  0, 90, 88, 88, 75,  0, 75, 75, 75,  0,  0, 75, 95, 95,
  0, 98,  0, 95,  0, 94, 88,  0, 95,  0, 95,  0,  0,  0, 90,  0,
  0,  0, 65,  0,  0, 88, 94,  0,  0, 94,  0, 94, 75, 95,  0, 90,
  0, 94, 95,  0, 90,  0, 94,  0, 75, 95, 95,  0, 98,  0, 65, 95,
  0, 95,  0, 94, 94, 90, 95, 65, 95, 90, 95, 94, 95, 95, 75,  0,
  0,  0,  0,  0,  0,  0, 88,  0,  0, 88, 75, 65, 75,  0, 75,  0,
  0,  0,  0, 95,  0,  0,  0, 95, 95, 94,  0,  0, 75,  0, 75, 95,
 88,  0,  0,  0,  0, 95, 88,  0,  0,  0, 95,  0, 95,  0,  0,  0,
  0,  0,  0,  0,  0, 95,  0,  0,  0,  0,  0,  0, 90,  0,  0,  0,
  0,  0, 88,  0, 94, 94, 95, 75, 94,  0,  0, 75,  0, 88, 75, 75,
 95,  0,  0,  0,  0, 95,  0,  0, 75,  0,  0,  0,  0, 95,  0,  0,
  0, 94,  0,  0,  0,  0,  0,  0, 94, 94, 88,  0,  0,  0,  0,  0,
  0,  0,  0, 75,  0, 75,  0, 75, 75, 75,  0,  0, 95, 94,  0,  0,
  0,  0, 95, 94, 88, 94,  0, 94,  0,  0, 75, 75,  0,  0, 94,  0,
  0,  0, 88,  0,  0, 94,  0,  0,  0, 94, 94,  0,  0, 88,  0, 95,
  0, 94,  0,  0,  0, 94, 95,  0,  0,  0, 95,  0,  0,  0, 94,  0,
  0,  0,  0, 88,  0, 94, 75, 95,  0,  0,  0,  0, 75, 95, 90,  0,
  0,  0,  0, 75,  0, 90,  0,  0,  0, 94,  0, 95,  0,  0,  0, 65,
 94, 94, 88,  0, 94,  0, 98, 75,  0, 94,  0, 75,  0,  0,  0,  0,
  0,  0, 95,  0, 88, 88, 88,  0, 88,  0, 88,  0,  0,  0,  0, 94,
  0, 95,  0,  0,  0,  0,  0,  0,  0,  0, 94,  0,  0,  0,  0,  0,
  0,  0, 94,  0,  0,  0,  0, 94,  0,  0, 94, 88, 94,  0,  0, 90,
 95, 95,  0, 95, 95, 95, 95, 94, 95, 95,  0, 95, 94, 95, 94,  0,
 88, 75, 94,  0, 90, 75, 75,  0,  0,  0, 90,  0, 95,  0,  0,  0,
  0,  0, 95,  0,  0, 95,  0, 65, 95, 94, 94, 95, 95, 95, 95,  0,
 75, 95,  0, 75, 75, 95, 95, 95, 95, 75,  0, 75, 95, 75,  0,  0,
 95, 75, 90,  0,  0, 90, 94,  0, 75, 90, 94,  0, 90, 95,  0, 88,
 88, 88, 95, 88,  0, 95, 90, 95,  0, 90,  0, 75, 75,  0,  0,  0,
 95,  0, 90,  0, 90, 95, 88,  0, 88, 88, 94, 90, 95,  0,  0, 75,
 90, 90, 90, 90, 88, 90, 95, 95,  0,  0,  0, 75, 75, 95,  0,  0,
 75,  0,  0,  0, 95, 88, 95, 75,  0, 95,  0, 95, 95, 94,  0, 75,
  0, 75,  0,  0,  0,  0, 88,  0,  0,  0,  0, 90, 94, 95, 65,  0,
 90, 95,  0,  0, 75,  0, 88, 88,  0, 88, 88, 75,  0, 90,  0, 75,
 95, 94,  0, 75,  0, 90, 95,  0, 95, 95, 95, 75, 75, 95, 88, 75,
 95, 75, 75, 95, 88,  0, 95, 95, 95,  0, 95, 88,  0, 75, 95,  0,
  0, 95, 75,  0, 88,  0, 75, 95, 75, 75, 75, 75,  0, 95,  0,  0,
 75,  0,  0,  0, 95, 94,  0, 88, 75, 95, 94, 75,  0, 75, 95,  0,
 95,  0,  0, 90,  0,  0, 95, 95, 95, 95, 95, 95,  0, 75,  0, 75,
 75, 75, 75, 95, 88,  0,  0, 94,  0,  0, 95, 94, 95, 95,  0, 88,
 75, 75,  0,  0, 95,  0, 95,  0,  0,  0,  0, 94, 75, 65, 90,  0,
  0, 98,  0, 88, 88, 90,  0, 75,  0, 95, 95,  0,  0,  0,  0, 95,
 88, 88, 95, 88, 88, 94,  0,  0,  0,  0,  0,  0,  0, 95,  0, 95,
  0, 75, 75, 94,  0,  0,  0, 94, 95, 94,  0,  0,  0, 94,  0,  0,
 75, 94, 94, 75, 88,  0,  0,  0,  0,  0,  0, 95,  0, 75, 75, 95,
 95, 75, 75, 95, 65,  0,  0,  0, 75, 95, 95, 95, 90, 90,  0,  0,
  0, 90, 75, 75, 88, 88,  0,  0,  0, 88,  0,  0, 88,  0, 95, 75,
  0, 94,  0, 95,  0, 94,  0, 95,  0, 95,  0, 75,  0, 94,  0,  0,
 75,  0, 95,  0,  0, 94, 98, 88, 95, 94,  0, 65,  0, 94, 94, 95,
 88,  0, 94, 94, 95,  0, 88, 88,  0,  0,  0,  0,  0,  0,  0,  0,
 75,  0, 88, 94,  0, 94,  0,  0, 94, 90, 95, 65,  0,  0, 95, 95,
 75, 88, 88,  0,  0, 95, 90,  0, 95,  0,  0,  0,  0, 95,  0, 95,
 95,  0,  0,  0,  0, 95, 95, 95,  0, 95, 90,  0,  0, 90,  0,  0,
 95, 95,  0, 95,  0,  0, 75,  0,  0,  0, 95,  0,  0,  0, 75, 94,
  0, 88,  0, 88,  0,  0,  0,  0, 88, 95, 90, 90,  0,  0, 75, 95,
 94, 95,  0, 95, 65, 90, 88, 95, 95, 95, 95,  0,  0, 94, 75, 75,
  0, 95, 95, 95, 94, 75, 75, 95, 88,  0, 95,  0, 95,  0, 95, 75,
 95, 75, 75, 75, 75,  0, 95, 75, 65, 90,  0, 75,  0,  0, 90, 95,
 95, 95,  0, 90, 95, 95,  0, 95, 90,  0, 75, 88,  0, 65,  0, 95,
  0,  0, 90,  0, 95, 75, 75,  0,  0, 75,  0, 75, 75, 75,  0,  0,
  0,  0,  0, 65,  0, 75, 88,  0, 95,  0, 95,  0,  0, 75,  0, 95,
 94,  0, 75, 75,  0, 95, 95,  0, 90, 90,  0,  0,  0, 94, 90,  0,
 88,  0,  0, 88,  0,  0, 90,  0,  0,  0,  0, 95,  0,  0,  0, 75,
  0, 75, 90, 94,  0,  0,  0,  0, 95, 95, 95, 95, 90, 95, 88,  0,
  0, 75,  0,  0, 95,  0, 95, 95, 75, 90,  0, 95,  0,  0,  0, 90,
 75, 94, 94, 95, 95, 95, 75,  0, 90, 95, 95, 95, 95, 95, 90, 95,
 95, 95, 95, 95,  0, 75, 90, 90, 95, 75, 88, 75, 75, 75,  0,  0,
  0, 90,  0, 95, 95,  0, 75,  0, 95, 95, 95, 88, 95, 95, 95, 95,
 95, 95, 75, 75,  0, 75, 75, 75,  0,  0,  0, 95,  0, 95, 75, 95,
 95, 75,  0, 75,  0,  0, 95, 75, 75, 95,  0, 95, 90, 90, 90, 75,
  0, 75, 75, 65, 75, 75, 88,  0, 95, 95,  0, 95, 95, 88, 95,  0,
 90,  0, 94, 75,  0,  0, 90,  0, 95, 88, 95, 75,  0,  0, 88,  0,
 75, 94, 75, 75, 75, 75, 75, 75, 75, 75,  0, 75, 75,  0,  0, 88,
  0,  0, 75,  0, 75,  0, 75,  0, 95,  0, 94,  0,  0,  0,  0,  0,
 88, 95, 75, 95,  0, 95, 90, 90, 75,  0,  0, 95, 95, 95,  0,  0,
 95,  0, 75,  0, 90,  0, 95,  0,  0,  0,  0, 90, 95,  0, 95, 90,
 95,  0, 90,  0, 75, 75, 75,  0,  0, 75, 75, 75,  0, 75,  0,  0,
  0,  0, 88, 75, 95, 88, 75, 75, 95, 75, 75, 95, 95, 75,  0, 90,
  0, 75, 88, 95, 75,  0,  0,  0, 95,  0,  0, 75, 88, 95, 88, 75,
 95, 95, 90,  0, 95,  0, 75, 90, 95, 95,  0,  0, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75,  0, 75, 88, 75, 75,  0, 75, 75, 75, 75,
  0, 94, 88,  0,  0, 95, 90, 75, 95, 90, 75,  0,  0, 95, 95,  0,
  0,  0, 95, 75,  0,  0,  0,  0,  0,  0, 95,  0, 75, 90,  0, 75,
  0, 75,  0,  0, 94,  0, 95, 95,  0, 75,  0,  0,  0,  0, 65, 90,
 95, 75,  0,  0, 90,  0, 88,  0,  0,  0,  0, 75, 65,  0,  0,  0,
 75,  0, 75, 75, 75,  0,  0, 75,  0,  0, 75,  0, 75,  0, 90, 95,
 75, 95,  0, 90,  0, 65,  0, 75, 88, 88,  0,  0, 75,  0, 95, 75,
 88, 75,  0, 75, 95, 88, 95,  0,  0, 75, 75,  0, 88,  0,  0, 94,
 75,  0,  0, 94,  0, 75, 95, 88,  0,  0,  0,  0, 90, 88, 65,  0,
  0, 75,  0, 94, 75, 75, 75, 75,  0,  0, 75,  0, 75, 75, 75,  0,
  0,  0,  0,  0,  0, 75, 75, 75, 75,  0,  0, 90, 95,  0, 90,  0,
 95, 75, 75, 90, 95,  0, 65, 95, 75, 95, 95, 90,  0,  0,  0, 75,
  0, 75,  0,  0, 75,  0,  0,  0, 95, 95, 94,  0, 95, 95, 88, 90,
  0,  0,  0,  0,  0,  0,  0, 95, 88, 94, 94, 94, 94,  0, 94,  0,
 88, 75,  0, 75,  0, 75, 88, 75,  0, 75,  0, 75,  0, 75, 75,  0,
  0,  0,  0,  0, 90, 95,  0, 94,  0, 75,  0,  0, 75, 75,  0,  0,
  0, 75, 75, 75, 95,  0, 75,  0,  0,  0, 94,  0, 95, 75,  0, 95,
  0, 75,  0, 95, 95, 75, 75,  0, 75,  0, 75, 75, 75,  0,  0, 75,
  0,  0, 75, 75,  0, 75,  0, 90,  0, 88,  0,  0,  0, 95, 95,  0,
 75, 75,  0,  0,  0,  0, 94,  0, 75, 95,  0,  0, 75,  0, 75, 75,
  0,  0,  0,  0, 94,  0, 88, 94, 90,  0,  0, 90,  0,  0, 75, 75,
  0,  0,  0, 75, 75,  0,  0, 75,  0, 88,  0,  0, 75, 75,  0, 94,
  0, 90, 95,  0, 95,  0, 95,  0, 88, 75,  0, 75,  0,  0,  0, 75,
  0,  0, 88,  0,  0,  0,  0,  0,  0,  0,  0,  0, 90, 75, 90,  0,
 88,  0,  0, 65, 75,  0,  0, 75, 75, 75,  0, 88, 75,  0,  0,  0,
  0,  0, 75,  0, 90,  0,  0,  0, 95, 75, 90, 95, 90,  0,  0,  0,
  0, 75,  0,  0, 94,  0, 75,  0, 88,  0, 88, 75, 75,  0,  0,  0,
 88,  0,  0,  0,  0, 75, 95, 88,  0,  0, 88,  0,  0,  0, 75, 90,
  0,  0,  0, 75, 88,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 88,  0, 88, 75,  0, 94,  0,  0,  0,  0,  0,  0, 65,  0, 94, 75,
  0,  0,  0,  0, 94,  0, 88, 75,  0,  0,  0,  0, 95,  0,  0,  0,
 88, 88, 88, 88,  0,  0,  0,  0, 88,  0, 98,  0,  0, 65, 88,  0,
  0, 94,  0, 88, 75,  0,  0, 90, 88,  0, 95, 95,  0, 75, 95, 75,
 95, 75, 75, 88, 75,  0,  0,  0,  0,  0,  0, 75,  0, 75, 88,  0,
 95, 75, 88, 88, 75, 75,  0,  0,  0, 95, 95,  0,  0, 90, 75, 90,
 88,  0,  0, 95, 95,  0, 75,  0, 95, 90, 75, 94,  0, 94,  0, 88,
  0,  0, 94, 94,  0,  0, 94,  0, 94,  0,  0,  0, 90,  0,  0, 95,
  0,  0,  0, 75,  0,  0, 88, 88, 95, 75, 75,  0, 75, 95, 75, 75,
 95,  0,  0, 75,  0,  0,  0, 88, 88, 75, 75, 95,  0,  0, 75,  0,
 95,  0, 95,  0,  0,  0,  0, 95,  0,  0, 95,  0, 75, 98, 95, 90,
 95, 95,  0,  0,  0,  0,  0, 75,  0,  0, 75, 75, 75, 75, 75, 75,
 75, 95,  0,  0, 95,  0, 95,  0, 75, 90, 95, 75,  0, 75, 65, 75,
 65,  0,  0, 75,  0, 65, 75, 75,  0,  0,  0, 75, 98,  0,  0, 88,
  0,  0, 95, 75, 75, 75, 75,  0, 94, 88,  0, 95, 75,  0,  0,  0,
  0,  0, 75, 95,  0,  0,  0,  0,  0,  0,  0, 75,  0,  0,  0,  0,
 95, 75, 95, 95, 90,  0, 75, 75,  0, 75, 88, 75,  0, 75, 75,  0,
 88,  0, 75, 88, 75,  0,  0,  0, 75,  0,  0,  0,  0,  0,  0,  0,
 88,  0, 75, 95,  0,  0, 88, 65, 65,  0,  0, 95,  0,  0, 95, 75,
  0,  0, 90, 88, 90, 75, 88,  0, 75, 75, 75,  0, 88, 75,  0, 95,
 95,  0,  0, 88, 75,  0,  0,  0,  0,  0,  0,  0,  0, 75,  0, 75,
 65,  0,  0,  0, 95,  0,  0, 94, 75, 95, 95,  0, 94, 75,  0,  0,
 95,  0, 95,  0,  0, 94, 95, 75, 65, 65, 94, 90,  0, 75,  0,  0,
  0, 75,  0,  0,  0, 90,  0,  0,  0, 90,  0,  0,  0, 88, 98,  0,
 75, 95,  0,  0, 95,  0,  0, 65,  0,  0, 95,  0,  0,  0,  0, 94,
 95, 94,  0,  0, 94, 95,  0,  0,  0,  0, 94,  0,  0, 88,  0,  0,
 88, 88,  0,  0, 75,  0,  0,  0,  0,  0, 94, 94, 75, 75,  0, 65,
  0, 95, 88,  0, 95,  0,  0, 94, 95, 88, 94,  0,  0,  0, 95,  0,
  0, 65, 94,  0, 65, 75,  0,  0,  0, 88,  0, 90, 75,  0,  0,  0,
 88,  0, 88,  0,  0, 94,  0,  0,  0, 94,  0,  0, 65,  0, 95,  0,
 75, 75,  0, 95,  0, 95,  0,  0,  0, 98,  0,  0,  0,  0,  0,  0,
  0,  0, 75, 95,  0,  0,  0, 88,  0, 75, 75,  0, 94,  0, 98, 95,
  0,  0,  0,  0,  0,  0,  0,  0, 95, 98,  0, 88,  0,  0, 94,  0,
  0,  0,  0, 94,  0,  0,  0,  0, 88, 88, 94, 94, 75,  0, 94,  0,
  0, 95,  0,  0,  0, 95,  0, 94,  0,  0, 88,  0, 88,  0, 65,  0,
  0, 95,  0, 94,  0, 95,  0, 88, 94, 94,  0,  0, 88,  0, 94, 94,
  0,  0,  0,  0, 95, 88,  0,  0,  0,  0,  0, 95, 95,  0, 90, 94,
 90, 88, 88, 75,  0,  0, 75, 88,  0, 95, 94, 94, 88, 94,  0,  0,
  0,  0, 90,  0, 75,  0,  0, 75,  0, 88, 88,  0,  0, 75,  0, 95,
 88,  0,  0,  0, 98, 95, 95,  0, 88, 95, 95, 88, 95,  0,  0, 75,
  0,  0, 94,  0, 75, 90,  0, 95,  0, 95, 95, 95, 88, 95, 95, 75,
  0, 95, 88,  0, 75,  0,  0, 95, 90, 75, 75,  0, 75,  0, 94,  0,
  0, 75, 75,  0, 95,  0,  0, 95, 95, 95,  0, 75,  0,  0, 95, 95,
 94, 95,  0,  0, 95, 95, 75, 95, 90,  0, 95,  0,  0,  0,  0,  0,
 95,  0, 95,  0,  0, 90,  0, 94, 88, 88, 94, 65, 94, 65, 94,  0,
  0,  0,  0, 95, 95,  0, 75,  0, 95, 75,  0,  0,  0, 95,  0,  0,
  0, 90, 95, 95, 95,  0, 75, 75, 75,  0, 95,  0,  0, 90,  0,  0,
  0,  0, 75, 95,  0,  0, 95, 98,  0, 95,  0, 88,  0, 88, 75,  0,
  0,  0,  0, 90, 75, 95,  0,  0, 95, 75, 75, 75, 94,  0, 75, 75,
  0,  0, 90,  0,  0,  0,  0,  0,  0, 95,  0, 95,  0,  0, 95,  0,
  0,  0,  0, 65,  0,  0, 95,  0,  0, 94, 75, 95,  0,  0,  0,  0,
 95, 95, 75, 95, 95,  0,  0, 75, 75, 94, 95,  0, 95, 98,  0,  0,
  0,  0,  0, 75,  0, 90, 94,  0, 95,  0, 94, 88, 98,  0, 65,  0,
  0,  0,  0,  0,  0,  0, 88,  0, 65, 75,  0, 95,  0,  0,  0, 95,
  0, 95,  0, 95, 75, 75, 75, 75, 75, 90,  0,  0, 75,  0,  0,  0,
  0, 95,  0, 75,  0,  0,  0,  0, 95,  0, 88, 65, 95,  0,  0, 95,
 95,  0,  0, 75,  0, 95,  0,  0,  0, 95,  0,  0,  0,  0,  0, 88,
  0, 75, 75,  0, 75, 88, 95,  0,  0,  0,  0,  0, 95,  0,  0,  0,
 90, 94,  0,  0,  0,  0, 95,  0,  0, 95, 75,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 75,  0,  0,  0,  0, 95,  0,  0,  0,  0,  0,
  0,  0, 95,  0,  0,  0, 94, 75,  0,  0, 90,  0, 88,  0,  0,  0,
  0,  0,  0,  0, 75, 75, 75, 75,  0,  0, 75,  0,  0,  0,  0, 90,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 95,  0,  0,  0,  0,  0,  0,  0, 95, 95,  0,  0,  0,  0,
  0,  0,  0,  0, 65,  0,  0,  0,  0,  0, 75,  0,  0,  0,  0,  0,
  0,  0, 75, 75,  0, 75,  0,  0, 75,  0,  0,  0, 88, 88, 90,  0,
  0, 95, 95,  0, 65,  0,  0,  0,  0, 95,  0, 88, 95,  0,  0,  0,
 88,  0, 75,  0, 75,  0, 90, 88, 75,  0,  0,  0, 75,  0,  0,  0,
 75, 95,  0, 90,  0,  0, 95,  0,  0, 95,  0, 75,  0,  0,  0,  0,
  0, 75,  0,  0,  0,  0,  0,  0,  0,  0, 88, 88,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 65,  0,  0,  0, 95,  0, 94, 94,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 95, 75,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 88,  0,  0,  0,  0,  0,  0,  0, 94,  0, 88,  0,  0,  0,
 88,  0, 90,  0, 75,  0, 88, 75,  0,  0,  0,  0,  0,  0, 88,  0,
 95,  0,  0, 94,  0, 88,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 95, 95,  0, 75, 95, 95,  0, 95, 95, 75, 95, 90, 95, 95,  0, 95,
  0,  0, 75, 95, 95, 90, 90,  0,  0, 95, 75, 94, 75,  0,  0,  0,
 95, 95,  0, 90,  0, 95,  0,  0, 94,  0, 95,  0, 65, 75,  0,  0,
 90, 75,  0, 90, 75, 95,  0, 95, 95, 95,  0, 95, 95, 88,  0, 95,
  0,  0,  0, 98,  0, 95, 65, 95, 95, 95, 95, 95, 95, 90, 75, 88,
 75, 75, 95, 95, 95, 95, 95,  0,  0,  0, 75, 75, 65,  0, 94,  0,
 95,  0,  0, 95, 95, 95, 95,  0, 95, 95,  0,  0,  0, 75, 75, 95,
 65,  0, 95, 94, 95, 95, 95, 95,  0, 88,  0,  0, 95,  0,  0,  0,
 95,  0, 95, 95, 94,  0,  0, 65,  0,  0,  0, 88,  0, 90, 95, 95,
  0, 95, 94,  0, 95, 95, 94, 94, 95, 94,  0, 94, 65,  0, 95, 65,
 90,  0,  0, 88,  0, 94, 94,  0, 95, 75, 95, 75, 75,  0, 88, 90,
  0, 95, 88,  0, 95, 88, 90, 94, 94, 95, 95, 94,  0, 94, 94, 95,
  0, 95,  0, 88, 75, 75, 95,  0, 75, 65, 90,  0, 75, 75,  0,  0,
 88,  0, 90,  0, 95, 75,  0, 75, 94,  0,  0,  0, 75, 88,  0,  0,
  0, 95,  0,  0, 75,  0,  0,  0, 95, 95, 95, 95, 95, 90, 95, 95,
 95, 90, 75,  0,  0, 95, 94,  0, 95, 75, 90, 95,  0, 94, 95, 90,
 90, 95,  0, 88,  0, 95,  0,  0,  0, 75,  0, 65,  0,  0, 90,  0,
 95, 90, 65, 75, 94, 95, 75,  0,  0,  0,  0,  0, 94,  0, 90, 95,
  0, 95,  0,  0,  0,  0, 88,  0,  0, 95, 75,  0,  0,  0,  0, 75,
  0, 75, 75,  0,  0,  0,  0,  0, 75,  0,  0,  0, 90, 75,  0,  0,
 95, 95,  0,  0, 90,  0, 75, 75, 75, 75, 75, 75, 75,  0,  0,  0,
  0, 94, 75, 75,  0,  0,  0,  0, 88, 95,  0, 95, 95, 75,  0,  0,
  0, 95,  0, 95,  0, 98, 88, 95, 95,  0, 65, 88, 88, 75, 94, 75,
 65, 75,  0,  0, 75, 88,  0, 88,  0,  0,  0, 75,  0,  0,  0,  0,
  0,  0, 75,  0,  0,  0,  0,  0,  0, 95,  0,  0,  0,  0,  0,  0,
 94, 90,  0,  0, 75, 75, 75,  0, 95, 88, 90,  0,  0, 90,  0, 94,
 95,  0,  0,  0, 65,  0, 94,  0,  0,  0, 88, 95,  0, 94,  0,  0,
  0,  0, 75, 75,  0,  0, 75, 95,  0,  0,  0, 88,  0, 65, 95,  0,
  0, 94,  0,  0, 95, 88, 95, 94, 88, 94, 88, 90,  0,  0, 75, 88,
  0,  0, 88,  0, 75,  0, 75, 98,  0, 95,  0,  0,  0, 75, 75,  0,
  0,  0,  0,  0, 75,  0,  0,  0,  0,  0,  0,  0,  0, 75, 75,  0,
  0,  0,  0,  0,  0,  0,  0, 75,  0,  0, 75, 95, 95,  0, 88,  0,
 94,  0, 88,  0,  0,  0,  0,  0, 75,  0,  0, 75, 88, 75,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 95,  0, 75, 95,  0,  0, 95,
  0,  0,  0, 88, 75,  0, 88,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 90,  0, 88,  0,  0, 94,  0,  0,  0, 94, 88,  0,  0,  0,
 88,  0,  0,  0,  0,  0,  0,  0,  0, 75,  0,  0,  0, 95,  0,  0,
 65,  0, 94,  0,  0,  0,  0,  0,  0,  0, 65,  0, 88,  0, 88,  0,
  0,  0,  0,  0,  0,  0,  0, 90, 65,  0, 94,  0, 94, 94,  0,  0,
  0,  0,  0,  0,  0, 75,  0,  0,  0, 88,  0,  0, 88, 95,  0,  0,
  0,  0, 94, 88,  0,  0, 94,  0,  0,  0,  0, 90,  0, 95, 95,  0,
  0, 95, 98, 88,  0, 95, 95, 95, 95, 75,  0, 95,  0,  0, 95, 75,
  0, 95, 95, 95, 95, 88,  0, 95,  0,  0,  0, 88,  0, 95, 95,  0,
  0, 75, 95, 95,  0, 75, 95,  0, 75,  0,  0, 88, 95,  0,  0, 75,
 75, 95,  0,  0, 75, 75, 95,  0, 75, 95, 90, 95, 75, 95,  0,  0,
  0,  0,  0,  0,  0, 94, 75, 75,  0,  0,  0, 94,  0, 95, 75, 88,
 88, 75,  0, 94,  0,  0, 94, 90, 95,  0,  0, 75, 75, 95,  0, 65,
 94,  0, 75, 88, 95, 95,  0, 94,  0,  0,  0,  0, 95,  0, 88,  0,
  0,  0,  0,  0, 90, 95,  0, 88,  0,  0,  0, 75,  0,  0, 75, 94,
  0, 95, 95, 94, 88,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 95, 95, 95, 88, 90, 65, 95, 94, 90, 95, 95, 95, 94, 90,
 75, 88,  0, 88, 95,  0, 75, 95,  0,  0, 95, 75,  0,  0,  0, 95,
 75, 75,  0, 75, 75, 95, 90, 95,  0, 75, 95,  0, 95,  0, 75, 75,
 95,  0,  0,  0,  0, 75, 95, 95,  0,  0,  0, 94,  0, 95,  0,  0,
  0,  0,  0, 75,  0, 95, 95, 95, 95, 75,  0,  0,  0,  0, 98,  0,
  0, 88, 94, 88,  0,  0,  0,  0, 94, 95, 95,  0,  0,  0,  0, 88,
 94, 75, 75, 95,  0,  0, 95,  0,  0,  0, 94, 95,  0, 88,  0, 94,
 94, 88, 94, 94,  0,  0,  0,  0, 90, 88, 75,  0, 94,  0,  0,  0,
 88, 88,  0, 94, 90,  0, 95, 95, 88,  0, 95, 94, 88,  0, 90, 90,
 75, 95, 75, 90, 95,  0,  0,  0, 75, 88, 95, 90, 88, 88,  0, 95,
 88, 95,  0, 95, 94, 95, 88, 95, 95,  0,  0, 95,  0,  0,  0, 95,
 75,  0,  0,  0,  0, 90, 95, 95,  0, 95, 75,  0,  0, 90,  0, 90,
  0, 95,  0,  0,  0, 94,  0, 88, 88, 75, 98,  0, 95,  0, 88,  0,
 75, 88,  0,  0,  0,  0,  0,  0, 94,  0, 94,  0, 94,  0, 94,  0,
 75, 88, 75, 90,  0, 75, 95, 95, 75, 94,  0, 65, 88, 90,  0,  0,
  0, 90, 95,  0, 75,  0, 95, 65,  0, 95, 95, 94, 95, 95,  0,  0,
 95, 95,  0, 90,  0,  0,  0, 95,  0, 95,  0, 75, 95,  0,  0, 94,
 95, 95, 90, 88, 90, 95,  0, 95, 90, 75, 95, 95, 95,  0,  0,  0,
 95, 94, 95, 88,  0, 75,  0, 95, 95, 95,  0,  0, 75,  0, 94,  0,
 94, 95,  0,  0,  0,  0,  0,  0, 95, 94, 95,  0,  0, 90, 95,  0,
  0,  0,  0, 88, 88, 98,  0, 98,  0, 94,  0,  0, 90, 95,  0,  0,
  0,  0,  0, 95, 75, 95, 75,  0,  0, 75,  0,  0, 95, 95,  0, 75,
 75, 75, 75,  0,  0,  0, 95, 95, 95, 95,  0,  0, 88, 90,  0,  0,
 95, 75,  0,  0, 90,  0,  0, 75,  0,  0, 75, 95,  0, 75, 75,  0,
 88, 90,  0,  0,  0, 95,  0,  0, 90,  0,  0, 90,  0, 95, 75, 95,
 75, 75, 75, 75, 75, 75, 75,  0,  0,  0, 75,  0,  0, 75, 90, 95,
 88,  0, 95,  0, 75, 90, 95,  0,  0, 90,  0, 90, 95, 95,  0,  0,
 95, 95,  0,  0,  0, 95, 90, 95, 95, 90, 95, 90,  0,  0,  0, 95,
  0, 88,  0,  0,  0, 75,  0,  0,  0,  0, 88, 75, 75,  0,  0, 75,
  0, 95, 95, 95,  0,  0, 88,  0,  0,  0, 88, 90,  0, 95,  0,  0,
 95,  0, 95,  0,  0, 95,  0,  0,  0, 95, 90,  0,  0, 98,  0, 88,
 88,  0, 95, 95, 95, 94,  0, 75, 95, 95, 95, 90, 95, 95,  0, 95,
 95,  0,  0, 75,  0, 88, 75, 88, 75, 75, 75, 75, 75, 75,  0, 75,
  0, 88,  0, 90, 90, 65,  0,  0,  0, 95,  0, 88, 95, 95,  0,  0,
  0,  0, 90,  0, 95,  0, 95, 88,  0,  0, 95, 95,  0, 75,  0, 95,
 95,  0,  0, 95, 65,  0, 90, 94, 75, 88, 88, 75, 75, 75,  0, 75,
 65, 75, 95, 94, 95, 88, 94,  0, 95,  0,  0, 75, 95, 94,  0,  0,
  0,  0,  0,  0,  0, 95, 90, 94,  0,  0, 75, 75,  0,  0,  0,  0,
  0, 95,  0, 88,  0, 75,  0,  0, 90,  0, 95,  0, 95, 75,  0, 95,
 95, 94,  0, 88,  0,  0, 75, 90, 90, 75,  0, 75, 75, 75, 75, 75,
 95, 94,  0, 95, 90,  0, 95, 88,  0, 95, 95, 94,  0,  0,  0,  0,
 90, 95,  0, 88,  0,  0, 95,  0, 95, 95,  0,  0,  0, 95, 95, 95,
  0,  0,  0,  0,  0, 95,  0,  0,  0,  0, 95, 94,  0,  0,  0, 95,
 75, 88,  0, 75, 75,  0, 75, 95, 88,  0,  0, 75, 88,  0,  0,  0,
 65,  0,  0,  0, 94,  0,  0, 65,  0,  0,  0,  0, 94, 88, 94, 95,
  0,  0, 94,  0, 94,  0,  0, 94, 95,  0, 95, 94, 95, 88, 90,  0,
  0, 75,  0, 94,  0, 95,  0,  0, 94, 94, 88,  0,  0, 95,  0, 94,
  0,  0, 95, 94, 65, 88,  0, 95, 95,  0,  0, 94,  0,  0, 94, 88,
 95, 88,  0, 88, 88, 90, 94, 95,  0,  0,  0,  0,  0, 65, 94,  0,
  0, 65, 94,  0,  0,  0,  0, 88,  0,  0, 94, 75,  0,  0, 95,  0,
 94, 94,  0,  0, 95,  0, 88,  0, 65, 94, 94,  0,  0, 75,  0,  0,
  0,  0,  0,  0, 94,  0,  0, 95, 75, 95,  0, 94, 95,  0, 94,  0,
  0,  0, 94,  0,  0,  0, 94, 75,  0,  0, 94,  0,  0,  0, 95,  0,
  0,  0, 75, 94,  0,  0, 88, 94, 95, 94, 95, 95, 88, 88,  0,  0,
 88, 75, 75,  0, 75,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 88,  0,  0, 95,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 94,  0, 88, 75, 94, 94, 94,  0, 94,  0, 94, 88, 88, 95,
 94,  0,  0,  0,  0,  0, 75, 65, 95, 88, 95, 75, 95, 95, 95, 75,
 95, 95, 95,  0, 88, 75, 95, 75, 75,  0, 95, 90,  0, 88, 88, 95,
  0, 95, 75,  0, 75, 75, 88,  0,  0,  0, 95,  0, 75,  0, 95, 88,
 94, 65, 88, 90, 95,  0, 65, 75, 88,  0,  0, 88,  0, 75, 98, 95,
 95, 95,  0, 75,  0,  0,  0, 95, 95, 95,  0, 95, 75, 95, 90,  0,
  0, 75, 75, 95, 75, 88,  0,  0, 95,  0,  0, 90,  0,  0, 88,  0,
 88,  0,  0, 90,  0,  0, 75, 75, 88, 75, 75, 75, 75, 75, 95, 75,
 75, 94,  0, 75,  0,  0, 95,  0,  0, 95,  0,  0, 95,  0, 90, 95,
 95,  0, 88, 88, 95,  0,  0,  0,  0, 95, 95,  0,  0,  0,  0,  0,
  0, 95, 95, 90, 88, 95, 90, 95, 95,  0, 75, 95, 88,  0, 88, 75,
 75, 75, 75,  0, 75, 75,  0,  0, 75,  0,  0, 95, 90,  0,  0,  0,
  0, 95,  0,  0,  0, 95,  0,  0,  0, 95,  0, 90, 95, 95,  0, 75,
  0,  0, 95,  0, 75, 90, 90, 95, 95, 95, 90,  0, 95, 95, 75, 94,
 95, 88, 95, 95, 95,  0, 98, 95, 95, 95, 75, 95, 95, 88,  0, 75,
 88, 88, 75, 75,  0, 75, 75, 75, 75, 75,  0,  0, 95, 95, 95, 95,
  0, 95,  0, 95, 75, 88, 90, 95,  0,  0,  0,  0, 75, 75, 95, 95,
  0, 95, 90,  0,  0,  0,  0, 95, 90, 95,  0,  0, 88,  0, 75,  0,
  0, 95,  0,  0,  0,  0, 75,  0,  0, 88, 75, 75,  0, 75, 75, 90,
 75, 75, 75, 75, 75, 75,  0, 88, 90,  0, 75, 95,  0,  0,  0, 95,
  0,  0, 75,  0,  0,  0,  0,  0,  0, 75, 95, 65,  0, 95, 94, 88,
  0,  0, 75, 75,  0, 75, 75,  0,  0, 95,  0, 75, 95, 90, 75, 95,
 95,  0,  0,  0,  0, 95,  0, 88,  0,  0,  0,  0, 88,  0, 75, 75,
  0, 75, 75, 75,  0,  0,  0, 95, 94, 90,  0, 88,  0, 75, 95,  0,
  0, 75, 94,  0,  0,  0, 90, 95,  0,  0, 95, 95,  0,  0,  0, 65,
 90,  0, 75, 94,  0,  0,  0, 75, 95, 95, 75,  0, 95,  0, 90, 90,
 75,  0, 95,  0,  0,  0, 95,  0, 95,  0,  0, 94,  0,  0,  0, 88,
 95, 94, 95, 90,  0, 95,  0, 95, 95, 95, 95, 88, 90, 75, 75,  0,
 75,  0, 88, 75, 90, 88,  0, 75, 75,  0, 75, 88, 75,  0, 90,  0,
 94,  0,  0, 88, 95,  0, 95,  0,  0, 90,  0,  0,  0, 75, 75, 95,
 95,  0, 90,  0,  0,  0, 95,  0,  0,  0, 94, 94,  0,  0, 75,  0,
 75, 95,  0, 90,  0,  0,  0,  0,  0, 90, 75,  0,  0, 98, 94,  0,
  0,  0, 75,  0, 95,  0, 95, 65, 75,  0, 88,  0,  0, 75,  0, 75,
 75, 75, 75,  0,  0, 75, 88,  0,  0,  0,  0, 75, 75, 94,  0, 95,
 75,  0,  0, 90, 98,  0, 94, 94,  0,  0,  0, 75, 95,  0, 75,  0,
 75, 75, 65,  0,  0,  0, 90,  0, 88,  0, 75,  0, 95, 95,  0,  0,
  0,  0,  0,  0, 90,  0, 88,  0,  0,  0, 95,  0,  0, 75, 94, 75,
  0, 75, 88,  0, 75, 75, 75, 75, 75,  0, 75,  0,  0,  0, 88,  0,
  0,  0, 75,  0, 75,  0,  0,  0, 95,  0,  0,  0,  0,  0, 75,  0,
 65,  0,  0,  0,  0,  0,  0, 90,  0, 95,  0,  0,  0, 75,  0, 94,
  0,  0,  0,  0,  0,  0, 88,  0, 95, 98, 95,  0,  0,  0,  0,  0,
  0,  0, 75, 88, 75, 75,  0, 75, 94,  0,  0,  0,  0,  0,  0,  0,
  0, 98, 95, 94,  0, 90, 75,  0,  0, 75, 94,  0,  0,  0, 95,  0,
  0,  0,  0,  0, 95, 94,  0,  0,  0, 90,  0, 94, 75, 95, 95,  0,
 95,  0, 94,  0,  0, 75,  0, 75, 75, 88, 75, 94, 90,  0,  0,  0,
 75, 94, 90,  0, 65, 95,  0, 94,  0,  0, 65,  0,  0, 95, 98,  0,
 75,  0, 95,  0, 94,  0,  0, 75, 95,  0, 94,  0,  0,  0, 75,  0,
 88, 94, 95, 88, 75, 65, 95, 94,  0,  0,  0,  0, 94,  0,  0, 88,
  0, 88, 94,  0, 94,  0, 88,  0,  0,  0, 94,  0,  0, 88, 94,  0,
 95,  0,  0,  0, 65, 88,  0,  0,  0, 75,  0,  0,  0,  0,  0,  0,
  0,  0, 75,  0,  0,  0,  0,  0, 95,  0,  0,  0, 88, 94,  0,  0,
  0,  0,  0, 94, 88, 75,  0,  0,  0,  0, 94, 95, 94,  0, 75, 95,
  0,  0,  0,  0, 90, 90, 95, 94, 95, 95,  0, 95,  0,  0, 95, 95,
  0,  0,  0,  0,  0, 95,  0,  0, 95, 75,  0,  0, 75, 94, 65, 95,
  0, 95,  0,  0,  0, 90, 95, 94, 88, 90,  0, 75,  0, 90, 95,  0,
  0,  0, 95, 95,  0,  0, 95,  0,  0,  0,  0, 75, 95, 65,  0,  0,
 90,  0, 95,  0, 95, 94,  0, 95, 94,  0,  0,  0,  0,  0, 65,  0,
  0,  0, 94, 94,  0, 65,  0, 95, 88, 88,  0, 75, 95,  0, 88,  0,
 95, 95,  0, 75,  0,  0,  0, 95,  0, 95,  0, 95, 95,  0,  0, 95,
  0, 95,  0,  0, 95, 95,  0, 95,  0, 75,  0, 95, 94, 90,  0, 95,
 95,  0,  0,  0,  0,  0,  0, 94,  0, 95,  0,  0, 95, 95,  0,  0,
  0, 95,  0, 90, 90, 95, 90,  0,  0,  0,  0, 95, 95,  0, 75, 95,
  0,  0, 95,  0,  0,  0, 75, 95,  0, 88,  0, 88,  0,  0,  0,  0,
 95, 88, 90, 65,  0, 95, 95, 90, 95, 95,  0,  0, 95, 95, 75, 75,
 75, 95,  0,  0, 65,  0, 75, 75,  0,  0, 95, 94, 65, 65,  0, 65,
 75,  0, 90, 90,  0,  0, 95, 94,  0, 65, 95,  0, 95,  0, 95, 95,
 65, 65,  0, 95, 95, 98,  0,  0,  0, 75,  0,  0, 88, 75, 65, 95,
 95,  0,  0,  0,  0, 95,  0, 95, 95,  0,  0,  0,  0, 95,  0, 95,
 65, 98,  0,  0, 95, 90, 95,  0,  0,  0, 65, 65, 90,  0, 75, 88,
  0, 95, 94, 95, 94,  0,  0,  0,  0, 94,  0, 95, 75,  0,  0, 95,
  0,  0, 90, 75, 75, 75, 75, 75,  0, 65, 75, 65,  0, 94, 94, 95,
  0, 75, 88,  0, 95, 65, 95, 94, 95, 94,  0, 65,  0,  0, 95, 95,
 90,  0,  0, 65, 95,  0, 95, 98, 65,  0, 95,  0,  0,  0, 75,  0,
  0, 88, 75, 88, 95,  0,  0, 95, 94, 94,  0,  0, 75,  0, 94,  0,
 65, 95,  0,  0,  0,  0, 95, 95, 94,  0,  0,  0,  0, 95,  0,  0,
 65,  0, 94,  0,  0,  0, 88, 75, 75,  0,  0, 94,  0,  0, 95,  0,
  0,  0, 65, 65, 95,  0,  0,  0, 88, 95,  0, 65, 88,  0, 95,  0,
  0, 88,  0,  0, 94,  0, 65, 94,  0, 94,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 94,  0,  0, 95, 88, 75, 95, 95,  0,  0,
 94,  0,  0,  0,  0,  0, 95,  0,  0, 90,  0,  0,  0,  0,  0,  0,
 95,  0, 95, 95, 95, 88,  0, 95, 94, 95, 65,  0, 95, 88, 95, 95,
 95,  0,  0, 94,  0,  0,  0,  0, 95, 95, 75, 95,  0, 95,  0, 88,
 75,  0,  0,  0, 95, 95, 88, 95,  0,  0,  0, 95,  0, 95, 94, 95,
  0,  0,  0,  0,  0,  0, 95, 94, 95,  0, 95, 95, 95, 95, 94, 75,
  0, 95,  0,  0, 95, 75, 94, 88, 88,  0, 95,  0,  0, 95,  0, 88,
 75, 88, 75, 75,  0,  0, 95,  0, 75, 95,  0,  0, 75,  0, 95, 95,
 95, 95,  0, 95,  0,  0, 95,  0,  0, 88,  0,  0, 95,  0, 95, 95,
 90, 90, 88, 88, 88, 90,  0,  0, 75, 75, 90,  0,  0, 95,  0, 95,
 95, 94, 90, 95,  0, 95,  0, 95,  0,  0,  0, 65, 90,  0, 95, 95,
  0, 75,  0,  0, 75, 88,  0, 95,  0, 95,  0, 95, 88,  0,  0, 65,
 95,  0,  0, 65,  0, 95,  0, 95, 75,  0, 95,  0, 95, 95, 75,  0,
 88, 88, 90, 75,  0, 75, 88, 75, 75, 88, 75, 75,  0, 75,  0, 95,
 98,  0,  0, 95, 88, 75, 95, 95, 95, 88,  0,  0,  0,  0, 65,  0,
  0, 90,  0, 75, 95,  0, 88,  0,  0,  0, 88,  0,  0,  0, 88, 95,
 95, 95, 98, 95, 95,  0,  0,  0, 90, 75, 95,  0, 75, 95, 90,  0,
 75,  0, 90,  0, 88, 75,  0, 88,  0, 95,  0,  0, 95,  0, 88, 95,
 98, 95,  0, 95, 95, 94, 65,  0,  0,  0,  0, 94,  0, 75, 94, 90,
 75,  0, 88, 88, 88, 75,  0, 75, 75, 75, 75, 75, 75,  0, 75, 75,
  0, 75, 65, 95,  0,  0, 95, 95,  0,  0,  0,  0,  0, 75, 88,  0,
  0, 95, 94,  0,  0,  0,  0,  0,  0, 90, 95, 88,  0,  0,  0, 65,
  0,  0, 90, 75, 88,  0,  0, 75, 95, 95,  0,  0, 95, 95, 75,  0,
 95, 95, 95, 95, 75, 75, 90,  0, 95, 75, 75,  0, 75, 88, 95,  0,
 95, 95,  0, 95, 95, 75,  0,  0,  0, 88,  0,  0, 88, 88,  0, 88,
 75, 75, 75, 90, 75, 75, 75, 90, 75, 75,  0, 75,  0, 65,  0,  0,
  0,  0,  0,  0, 90,  0, 95, 90,  0,  0,  0,  0,  0,  0, 88, 94,
  0, 95,  0, 90,  0, 95, 75,  0,  0,  0,  0,  0,  0, 88,  0, 95,
  0,  0,  0, 95, 94,  0,  0, 95,  0,  0,  0, 88,  0, 94,  0, 94,
 88, 65, 95,  0,  0,  0, 90, 95, 95,  0,  0,  0,  0, 95,  0, 95,
 95, 94,  0, 95,  0, 95, 94,  0,  0, 88, 88,  0, 88,  0,  0,  0,
 75,  0, 75,  0, 94, 65, 88,  0,  0, 95, 88, 95,  0, 95,  0,  0,
  0,  0, 95,  0, 88, 95,  0, 94, 95,  0, 95,  0,  0,  0,  0, 94,
 95, 88,  0, 90,  0,  0,  0, 94, 65,  0,  0,  0,  0,  0, 95, 88,
 75, 75, 94,  0,  0, 75,  0,  0,  0, 95, 95,  0, 75,  0,  0,  0,
 94, 90,  0,  0, 88, 95,  0,  0, 88,  0,  0, 90, 88, 95, 95, 88,
 75,  0, 95,  0,  0,  0,  0,  0,  0, 88, 88, 88, 88,  0,  0, 75,
 75, 88, 88, 88, 75, 88, 88, 65, 88,  0, 88,  0,  0, 75,  0,  0,
 95,  0,  0,  0, 90,  0, 88,  0,  0, 90,  0,  0,  0, 95,  0, 95,
  0,  0, 75,  0,  0,  0,  0,  0,  0,  0, 94,  0,  0,  0,  0,  0,
  0,  0,  0, 94, 95, 94,  0, 98,  0, 94, 95,  0, 88, 90, 95,  0,
 95, 94, 94, 98,  0,  0, 75,  0, 65,  0, 88, 95,  0, 94, 95, 94,
  0, 75,  0, 88, 88, 94,  0, 95, 95, 95,  0,  0, 90, 88, 88,  0,
 75, 88, 90,  0, 75,  0, 75, 75, 75, 75, 88,  0,  0, 75, 88,  0,
  0, 88,  0,  0, 90, 95,  0,  0, 75,  0,  0, 95, 95,  0,  0,  0,
 88,  0,  0,  0,  0, 65,  0, 95, 75,  0,  0, 75,  0, 75, 94,  0,
  0, 90, 88,  0, 95,  0,  0, 75,  0,  0,  0, 95,  0,  0, 88, 88,
  0, 95,  0, 94,  0,  0,  0, 88,  0,  0, 90, 94, 95, 94, 90,  0,
 95,  0,  0, 88, 75,  0,  0,  0, 88, 88,  0, 75,  0, 88, 88, 75,
 75,  0,  0,  0,  0,  0,  0, 88, 94,  0, 65, 88,  0, 90,  0,  0,
  0,  0, 90,  0,  0,  0,  0,  0,  0, 88,  0, 94,  0, 95,  0, 95,
  0,  0, 94,  0,  0, 88,  0,  0,  0,  0, 95, 88, 88,  0,  0,  0,
  0, 65, 88, 94, 88,  0,  0, 95, 75, 94,  0, 88,  0,  0, 94, 95,
  0, 95, 88, 94,  0,  0,  0,  0, 75, 88, 90, 88,  0,  0, 88, 75,
  0, 75,  0,  0,  0, 95, 88,  0, 94, 94, 94,  0,  0, 95, 75,  0,
  0,  0,  0,  0, 95,  0,  0, 90, 94,  0,  0, 94,  0,  0,  0,  0,
 75,  0, 65, 65,  0,  0,  0,  0, 95, 95,  0, 75,  0,  0,  0, 94,
  0, 95, 88,  0,  0, 75, 88,  0,  0,  0,  0, 65,  0,  0,  0,  0,
  0, 75, 88,  0,  0,  0,  0,  0, 88, 75,  0,  0, 75,  0,  0, 88,
 95,  0,  0,  0, 95,  0,  0,  0,  0, 65,  0,  0,  0, 94, 95,  0,
 90, 75,  0,  0,  0,  0,  0, 95,  0,  0,  0,  0, 94,  0,  0,  0,
 90,  0, 94, 94,  0,  0,  0,  0,  0, 75, 88, 75, 90,  0, 88,  0,
  0,  0,  0, 94,  0,  0,  0,  0, 88,  0,  0, 94,  0,  0,  0,  0,
  0, 88, 94, 94,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 88,  0, 94,  0,  0,  0,  0,  0,  0, 94, 94,  0,  0, 88, 88,
  0,  0,  0,  0,  0,  0,  0,  0, 88,  0, 88,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 65,  0,  0,  0, 88, 94,  0,  0,  0,  0,
  0,  0,  0,  0, 94, 88,  0,  0,  0,  0, 94,  0, 65,  0,  0,  0,
  0,  0, 94,  0,  0,  0, 94,  0,  0,  0,  0,  0,  0, 88,  0, 88,
 95, 95, 75, 95, 75,  0,  0, 90,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 95,  0,  0,  0,  0, 90, 88, 90, 95,  0,  0, 94, 95,  0,
  0,  0,  0, 90,  0,  0, 98, 95,  0, 90,  0,  0, 95,  0, 94,  0,
 94,  0,  0, 88, 88,  0,  0,  0,  0, 90,  0, 88,  0,  0,  0, 94,
  0, 94, 95, 95, 95, 98, 95, 75,  0, 88, 95,  0,  0,  0,  0, 88,
  0,  0, 65, 88, 88,  0,  0, 65, 94, 90,  0, 95, 75,  0,  0, 94,
 88, 75, 75, 95, 95,  0, 95, 75,  0, 95, 95, 90,  0, 90,  0,  0,
  0,  0, 75, 75,  0, 88, 95,  0, 94,  0, 75, 75,  0,  0, 94,  0,
  0, 75,  0,  0, 88,  0,  0,  0,  0,  0, 90, 88,  0,  0, 65, 94,
  0, 88, 94, 90, 90, 95,  0, 95,  0,  0, 94, 88, 94,  0,  0, 95,
 88, 98, 75,  0,  0, 95, 94,  0,  0,  0,  0, 95,  0, 95, 88, 98,
  0,  0, 95, 95, 95, 75, 98, 98, 94, 75,  0, 95,  0,  0,  0, 88,
  0, 75,  0,  0,  0,  0,  0,  0,  0,  0, 75, 95, 94,  0,  0, 90,
  0,  0,  0, 90,  0, 75,  0,  0,  0, 75,  0,  0,  0, 75,  0,  0,
  0,  0,  0,  0,  0, 75, 75, 75, 94,  0,  0,  0,  0, 75,  0, 95,
 75, 95,  0, 95, 90, 75, 75, 88, 75, 75, 75, 90,  0,  0,  0, 75,
  0, 75, 75, 94, 90,  0, 75, 75, 75, 75, 75,  0,  0,  0, 75, 75,
 75,  0, 75,  0, 95, 75,  0, 94, 95,  0,  0,  0,  0, 75, 94,  0,
 95, 95, 95,  0,  0,  0, 75, 75,  0, 75, 75,  0,  0,  0, 94,  0,
 95,  0,  0,  0, 75, 95,  0, 95,  0,  0, 94, 75, 75, 95, 95, 95,
 95, 75, 88,  0, 75,  0,  0,  0, 95, 75, 95,  0,  0, 65,  0,  0,
 95,  0, 95, 88, 75,  0, 98,  0,  0, 75, 94,  0,  0, 95, 95,  0,
  0, 95, 95, 95,  0, 98, 98, 65, 95, 75,  0,  0, 95, 88,  0, 75,
 95,  0, 94, 95, 98, 65, 94,  0,  0, 95, 94, 95,  0,  0,  0, 75,
  0, 90, 88, 75, 75, 75, 75, 75,  0, 75, 75, 95,  0, 75, 95,  0,
  0, 90, 75, 95,  0,  0,  0,  0, 95, 95, 88, 95, 95, 95, 95, 95,
  0, 94, 65,  0, 95, 90,  0,  0,  0, 95, 95,  0, 95,  0,  0,  0,
 75,  0,  0, 95, 75, 95, 75, 95,  0, 88,  0, 95,  0, 88, 75,  0,
 75, 95, 95, 95,  0, 95,  0,  0, 95,  0, 90, 98,  0,  0, 98, 95,
 95, 90,  0, 95,  0, 75, 75, 75, 75,  0, 75, 75, 75, 75, 75,  0,
  0, 75,  0,  0, 75,  0,  0, 75,  0,  0,  0, 95, 95,  0, 75,  0,
  0, 65, 90,  0,  0,  0,  0, 95,  0, 95, 75, 95,  0,  0, 95, 88,
  0,  0,  0,  0,  0, 95,  0, 98,  0, 94, 95, 90,  0,  0, 75,  0,
  0, 75, 95, 90,  0, 95, 94,  0, 94, 98,  0, 95, 75, 95, 95,  0,
  0, 95,  0, 75, 88, 90, 75, 75, 75,  0, 75, 75,  0, 75, 75, 75,
  0, 75, 75, 75, 75,  0,  0,  0,  0, 95, 95,  0, 95,  0, 75,  0,
 75,  0,  0, 95, 88,  0, 95,  0,  0, 95, 95,  0, 94,  0, 95, 75,
  0,  0,  0,  0, 95,  0,  0, 95, 95, 94,  0,  0, 75,  0,  0, 65,
  0,  0, 75,  0,  0, 95,  0, 65, 95, 98,  0,  0, 95, 65, 95,  0,
  0, 98,  0, 95, 75, 95,  0,  0,  0, 88,  0, 90, 88, 75, 75, 75,
 75, 75,  0, 75, 75,  0, 75, 75, 75, 75, 75, 75,  0,  0, 75, 95,
  0,  0, 95,  0,  0, 95,  0,  0, 90,  0,  0,  0, 88,  0,  0, 75,
 95,  0,  0, 65, 98, 95, 95, 95,  0,  0,  0, 95, 90,  0,  0, 65,
  0, 95, 88,  0,  0, 88, 75,  0, 95, 95, 65,  0,  0, 75, 95,  0,
 75, 95,  0,  0, 90,  0, 90,  0, 94,  0, 94, 95, 90,  0, 95,  0,
  0, 95,  0, 95,  0, 94,  0, 95, 65, 95, 94, 95, 75,  0,  0,  0,
  0,  0,  0,  0,  0, 90,  0, 88, 88, 88, 90, 88, 75, 75, 75,  0,
 75, 75,  0, 88, 75, 88, 75, 98,  0, 94, 95, 94,  0, 90,  0, 94,
 95, 95,  0, 95, 95, 95, 94,  0,  0, 90,  0, 95, 94, 95, 88, 95,
  0,  0, 98,  0, 98,  0, 65,  0, 95,  0, 95,  0, 65, 65, 94,  0,
  0,  0,  0, 95, 98,  0,  0,  0,  0,  0, 94,  0,  0, 95, 90,  0,
  0,  0,  0, 75, 75,  0, 95,  0, 95,  0,  0, 95, 65,  0, 65, 95,
  0,  0,  0,  0,  0,  0,  0, 94,  0,  0,  0, 95,  0,  0, 95, 94,
  0,  0, 94, 65,  0,  0, 88,  0,  0,  0, 65,  0,  0,  0, 90, 90,
 88,  0, 88, 75,  0, 75, 75,  0,  0, 75,  0,  0, 88,  0,  0, 90,
 95,  0,  0,  0,  0,  0, 94,  0, 90,  0,  0,  0, 95, 94,  0, 95,
  0,  0, 95,  0,  0, 95,  0, 75,  0,  0, 95, 65,  0,  0,  0, 95,
  0, 98, 90,  0, 75,  0, 95, 90,  0,  0, 95, 75,  0, 90,  0,  0,
  0, 75, 95,  0, 94, 94,  0, 75,  0, 94,  0, 95, 94,  0, 65, 75,
  0, 95,  0, 95, 95, 90,  0, 75,  0,  0, 75,  0,  0, 88, 90, 75,
 75, 75, 75,  0, 75, 75, 75,  0, 75, 75,  0,  0, 88,  0,  0, 94,
  0,  0, 88,  0, 95,  0,  0, 88, 94, 75,  0,  0,  0,  0, 94, 94,
  0, 94, 95,  0,  0,  0, 95,  0,  0, 90,  0,  0,  0,  0,  0, 95,
  0, 94,  0, 90, 95, 95,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 95,  0, 94, 94, 75,  0,  0,  0,  0, 75, 75, 95, 94, 75,  0, 75,
  0, 95, 94, 75,  0,  0, 75,  0, 94,  0,  0,  0,  0,  0, 90, 94,
  0, 94,  0,  0,  0, 88, 75, 75,  0,  0,  0, 75,  0, 75,  0,  0,
  0, 65,  0,  0, 94,  0,  0, 65, 95,  0, 65, 94, 90,  0, 98, 94,
  0,  0, 98,  0, 94,  0, 90,  0,  0,  0,  0,  0,  0, 95, 95, 88,
 94,  0, 75,  0, 90,  0,  0,  0, 90,  0, 95,  0, 95, 65, 65,  0,
 88, 94, 88,  0, 95,  0, 88,  0, 98, 75,  0,  0, 75, 98, 95,  0,
 65, 88,  0,  0, 65,  0,  0, 94,  0,  0,  0,  0, 75,  0,  0,  0,
  0, 90,  0, 94, 94,  0,  0, 98,  0,  0, 88,  0,  0,  0, 65, 65,
  0, 94,  0, 95,  0,  0, 75,  0,  0, 95,  0,  0,  0,  0, 65,  0,
 95, 94, 95, 94,  0,  0, 88,  0,  0, 75, 65,  0,  0,  0,  0,  0,
  0, 75, 75,  0, 88, 94,  0,  0, 88,  0, 65, 88,  0,  0, 75, 94,
 95, 95,  0,  0, 94,  0,  0,  0,  0, 65,  0, 94, 94,  0, 90, 95,
  0, 94,  0, 88,  0,  0, 88,  0,  0,  0, 88,  0,  0,  0, 94,  0,
  0, 94,  0,  0,  0, 65, 65,  0,  0, 94,  0, 94,  0,  0,  0, 94,
  0, 95,  0,  0,  0, 94,  0,  0, 94,  0, 95, 95, 65, 94, 94, 94,
  0,  0,  0, 98,  0,  0, 88, 94, 65,  0,  0,  0, 88,  0,  0, 65,
 88,  0, 88,  0,  0, 75,  0, 65,  0, 75,  0,  0,  0,  0, 94,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 95,  0,  0, 75,
 65, 94,  0,  0,  0,  0,  0,  0, 94,  0,  0,  0,  0, 65, 75,  0,
  0,  0,  0, 94,  0,  0,  0,  0,  0,  0,  0, 95, 75, 75,  0, 90,
 95,  0,  0,  0,  0, 75, 75,  0, 95,  0,  0,  0, 95, 94, 75, 75,
 75,  0,  0,  0,  0, 98,  0,  0,  0, 90, 95,  0,  0,  0, 95,  0,
  0,  0, 95,  0, 75, 75, 75,  0, 65, 95, 65,  0, 75, 75,  0,  0,
  0, 65,  0,  0, 65,  0,  0,  0,  0,  0,  0, 98, 95, 95, 90, 95,
  0, 75,  0, 95,  0,  0,  0, 98, 95, 95, 88, 75, 75, 75,  0,  0,
 75, 75, 75, 75,  0,  0,  0,  0, 95,  0, 75, 94,  0,  0,  0, 94,
  0,  0,  0,  0,  0,  0,  0,  0, 98, 95,  0, 75,  0, 94,  0, 95,
  0,  0,  0,  0, 75,  0, 75, 75, 75, 75,  0, 75, 75, 75,  0, 75,
  0, 94,  0,  0,  0,  0,  0, 75,  0, 95,  0,  0,  0, 95,  0,  0,
  0,  0,  0,  0, 65,  0,  0,  0,  0, 95, 75,  0, 65,  0,  0,  0,
 75,  0,  0, 75, 88, 75, 75,  0, 75, 95, 95,  0, 88,  0, 65,  0,
  0, 94,  0,  0,  0,  0, 95,  0,  0,  0,  0,  0,  0,  0,  0, 75,
 98, 75,  0,  0,  0,  0, 95,  0,  0,  0,  0,  0, 88,  0,  0,  0,
  0,  0,  0,  0,  0, 75,  0, 65,  0, 94, 98,  0, 95,  0, 95,  0,
 65,  0,  0,  0,  0, 88, 94,  0,  0, 94,  0,  0, 98,  0, 98,  0,
  0,  0, 88,  0, 95, 94, 95, 95, 75, 94,  0,  0, 94,  0, 95,  0,
  0,  0, 75, 75,  0,  0,  0,  0, 75,  0, 75,  0,  0, 95,  0,  0,
  0,  0,  0,  0, 95,  0,  0,  0, 88, 65, 95,  0,  0,  0,  0, 95,
  0,  0, 65,  0, 95, 88,  0,  0, 75, 95,  0,  0,  0,  0,  0, 95,
 75,  0, 65,  0,  0,  0,  0,  0, 90,  0,  0,  0, 95,  0,  0,  0,
  0, 94,  0, 75,  0, 75,  0,  0,  0, 95, 65,  0,  0,  0, 94,  0,
  0, 65,  0, 95,  0,  0,  0,  0, 94, 94,  0,  0,  0,  0, 95,  0,
 94,  0, 94,  0, 95, 95,  0, 88,  0,  0,  0,  0,  0,  0,  0, 94,
 90,  0,  0,  0,  0, 95, 94, 95,  0,  0,  0,  0, 88, 94, 95,  0,
  0,  0,  0,  0,  0, 88,  0,  0,  0, 90,  0, 94, 94,  0, 65, 94,
 65,  0,  0,  0,  0,  0, 95,  0,  0,  0,  0,  0,  0, 88,  0,  0,
 94,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 94,  0, 75,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 90,  0, 95,  0, 95, 94,  0,  0,
 95, 75, 94,  0,  0, 95, 95, 75, 75, 75, 94, 95, 88, 95, 94, 90,
 94,  0,  0,  0,  0,  0, 94, 95, 95,  0,  0, 88, 95, 75,  0,  0,
  0,  0, 95,  0,  0,  0, 75,  0, 94, 95,  0, 95,  0, 95,  0, 95,
  0, 95, 95,  0,  0,  0, 75, 95,  0, 95,  0,  0,  0,  0, 75, 75,
  0,  0, 95,  0, 88, 75,  0,  0,  0, 95, 75,  0,  0, 94, 90, 75,
 95, 95, 88,  0, 75,  0,  0, 88,  0,  0, 75, 75,  0, 75,  0, 75,
  0,  0, 90,  0,  0,  0, 88,  0,  0,  0,  0,  0,  0,  0,  0, 75,
 88,  0, 94,  0,  0,  0,  0, 94,  0,  0,  0,  0, 95, 75,  0, 95,
 75,  0, 88,  0, 75,  0, 90, 75, 75, 90,  0,  0,  0,  0,  0,  0,
 65, 75, 95, 90, 95,  0, 88,  0, 75,  0,  0,  0,  0, 75, 95,  0,
 95,  0, 90,  0,  0,  0,  0, 95,  0, 95,  0, 88,  0,  0, 75,  0,
 90, 95, 88,  0,  0,  0,  0,  0, 75, 95,  0,  0, 90, 90, 75, 75,
 75, 75, 75, 75, 75,  0,  0, 90, 95, 94, 75, 75, 95, 94,  0,  0,
  0, 75,  0, 75,  0,  0,  0,  0,  0,  0, 95,  0,  0,  0, 75,  0,
  0,  0,  0, 75,  0, 75, 95, 90,  0,  0,  0, 95, 95, 95, 75, 88,
  0, 75, 75,  0,  0, 95,  0,  0,  0, 95, 95, 95, 75,  0, 90, 88,
  0, 75,  0,  0, 90,  0, 94, 95, 75, 75,  0,  0,  0,  0, 95, 95,
  0,  0,  0,  0, 94, 94,  0,  0,  0,  0,  0,  0,  0, 75, 88, 88,
 98,  0, 98,  0,  0,  0,  0, 95,  0,  0,  0,  0,  0,  0,  0,  0,
 75,  0,  0, 88,  0,  0,  0,  0, 94,  0, 94,  0, 75, 75,  0, 75,
 94,  0, 94,  0,  0, 94,  0,  0, 94,  0, 94, 94,  0,  0, 75,  0,
  0,  0,  0,  0, 95,  0, 65, 95,  0, 95,  0, 95,  0,  0, 98,  0,
  0, 75,  0,  0, 65,  0, 95, 65, 65,  0,  0, 75,  0,  0,  0, 98,
  0,  0, 75,  0,  0,  0,  0, 65,  0, 95,  0, 75,  0, 65, 75, 75,
 75,  0, 95, 95,  0,  0,  0, 75,  0, 65, 75, 90,  0,  0,  0,  0,
 95,  0, 95,  0,  0,  0,  0,  0, 90, 98, 95,  0, 65, 95, 88, 98,
 75, 75,  0,  0,  0,  0, 65,  0,  0, 98,  0,  0,  0, 65, 95,  0,
 95,  0,  0, 65, 65, 95, 65, 75,  0, 98, 94,  0,  0, 95, 88,  0,
  0, 88, 75,  0,  0,  0,  0, 65, 88, 65,  0,  0,  0, 65, 94,  0,
  0, 65,  0, 95,  0, 95, 95, 65,  0, 95, 75,  0,  0,  0,  0, 75,
 75,  0,  0, 65,  0,  0,  0,  0,  0,  0, 75, 98,  0,  0,  0,  0,
 65, 65, 95,  0,  0, 95, 98,  0, 98,  0, 98, 65, 98,  0, 98, 65,
 98,  0, 88, 95, 95, 95, 95,  0, 65,  0, 94,  0, 75,  0,  0, 94,
 65, 95,  0, 65, 65,  0,  0,  0,  0,  0,  0, 65,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 95,  0, 98,  0, 95, 95, 95, 95,  0, 95, 95,
 94,  0, 65, 88, 94, 65,  0,  0, 65, 94, 94,  0,  0, 75,  0, 94,
 90,  0,  0, 88,  0,  0, 90, 75,  0,  0,  0,  0,  0,  0, 95,  0,
 75, 75, 65, 95,  0,  0,  0, 98,  0, 65,  0, 95,  0,  0, 75,  0,
 75,  0,  0,  0,  0,  0,  0,  0, 65,  0,  0,  0, 98,  0, 95, 65,
  0, 65, 88, 65,  0, 65,  0, 95, 98, 75, 65,  0,  0,  0,  0,  0,
 94,  0, 65,  0,  0, 65,  0,  0,  0, 65, 75,  0,  0, 94,  0, 65,
  0,  0,  0,  0,  0,  0, 65,  0,  0,  0, 94,  0,  0,  0,  0, 94,
  0,  0, 75,  0, 94,  0,  0,  0, 65,  0, 65,  0, 95,  0, 75,  0,
 95,  0, 95, 95, 75,  0, 95, 88,  0, 88,  0,  0,  0,  0, 95, 75,
 88, 88, 88,  0, 75,  0, 90, 95, 88,  0,  0,  0,  0,  0,  0, 75,
  0, 65,  0, 88, 95, 88,  0,  0,  0,  0,  0,  0, 88, 90, 88, 75,
  0, 95,  0, 90,  0, 94,  0,  0, 95, 75, 95, 65, 90,  0, 88, 95,
  0,  0,  0, 94,  0, 95, 94,  0, 95, 75,  0, 95, 95, 75,  0, 75,
 95, 95, 95, 95,  0, 75,  0, 95, 95,  0, 95, 90, 88,  0, 75,  0,
 75,  0,  0,  0, 88, 75, 88, 65, 75, 88, 88, 90, 95, 88, 75, 95,
  0, 94,  0, 65, 95,  0,  0,  0,  0, 95, 90, 95, 95, 94,  0,  0,
 88,  0, 94,  0, 88, 95, 95, 88,  0, 88, 95, 88,  0, 88,  0, 65,
 94,  0, 75, 88, 90, 65, 94, 88, 95, 75, 65,  0,  0,  0,  0, 95,
  0,  0, 88, 75,  0,  0, 95, 94,  0, 88, 94, 95,  0,  0, 94, 95,
  0, 95, 75,  0, 90,  0, 75, 75,  0, 75, 90,  0,  0, 95,  0, 75,
 75, 75,  0, 90, 75, 95,  0,  0,  0,  0,  0, 95, 75,  0, 75, 75,
 75, 95, 95, 95, 75, 95,  0,  0, 95, 95,  0,  0, 95, 95, 95,  0,
  0,  0, 95, 90, 75, 95,  0, 95, 75, 75, 90,  0,  0, 95,  0,  0,
  0,  0, 95,  0, 95, 95, 75,  0, 95, 94,  0, 95,  0,  0, 90,  0,
  0,  0, 95, 90, 75,  0, 75, 75, 75, 88, 75, 75,  0,  0,  0,  0,
 95, 75, 94, 88, 95,  0,  0,  0,  0, 75, 94,  0, 95,  0, 88, 90,
 98, 90,  0, 75,  0, 75,  0,  0,  0, 88, 75, 88, 75, 94,  0,  0,
 75,  0,  0,  0,  0, 75,  0, 75, 75, 98,  0, 75,  0,  0,  0, 95,
 95, 94, 95,  0, 95, 75, 98, 88,  0, 75, 75, 75,  0, 75,  0,  0,
 90,  0,  0, 75, 90, 75,  0,  0, 75,  0,  0, 94, 75,  0, 75, 75,
 75,  0, 94, 75,  0,  0, 88, 88, 88,  0,  0,  0, 95, 75, 65,  0,
  0,  0, 94,  0, 75,  0, 95,  0, 88,  0,  0,  0, 90,  0, 75,  0,
  0, 94, 88, 75, 65,  0,  0, 88, 88, 94, 88, 75, 94,  0,  0, 75,
 94,  0, 94,  0,  0,  0, 88,  0, 95,  0, 88, 95, 94, 95, 95,  0,
 88,  0, 75, 88, 95,  0, 95, 95, 90,  0,  0, 90,  0,  0, 95,  0,
 94, 75,  0, 95,  0,  0, 90,  0,  0, 90, 88,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 75,  0,  0,  0,  0,  0,  0,  0,  0,  0, 95,  0,
 88, 75, 75,  0, 90,  0,  0, 88, 88, 88, 94,  0,  0,  0,  0, 95,
  0,  0, 95, 94,  0, 75, 95,  0, 95,  0, 95,  0,  0, 90, 75, 75,
 75, 75, 95,  0, 75,  0, 95, 90, 75,  0,  0, 95, 94,  0, 94, 95,
  0, 94,  0, 94, 94, 90,  0, 94,  0,  0, 88,  0,  0,  0, 95, 75,
  0, 75, 95,  0, 95,  0,  0,  0, 95, 75,  0, 88, 98,  0, 95,  0,
  0, 95,  0,  0, 95,  0,  0, 90, 95, 95,  0, 95, 88, 75,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 75, 75, 88,  0,  0, 94, 90,
 95,  0, 75,  0, 88, 88, 90,  0, 75, 95,  0,  0,  0, 75,  0, 75,
  0,  0,  0,  0,  0, 75, 75, 95, 95,  0, 95,  0, 95,  0,  0,  0,
 95, 75,  0, 75,  0,  0,  0, 90,  0,  0,  0,  0,  0, 65,  0,  0,
 75, 75,  0,  0,  0,  0,  0,  0,  0,  0, 90, 95,  0,  0,  0,  0,
  0, 95, 75, 95,  0, 90, 95,  0, 90,  0,  0, 95, 75,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 95,  0,  0,  0, 75, 95, 95,
 75,  0,  0,  0, 75, 75,  0,  0,  0,  0,  0, 94, 75, 75, 90,  0,
  0, 95, 75,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 94, 75,
 90,  0, 75,  0,  0, 95,  0, 75,  0, 75, 75,  0, 95, 94,  0,  0,
 95,  0,  0, 95,  0, 75, 88,  0,  0, 88,  0, 95, 94, 90,  0, 95,
  0,  0,  0,  0,  0,  0,  0, 88,  0,  0,  0,  0,  0, 90,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 95,  0,  0, 88, 95, 95,  0,  0,  0,
  0,  0, 95, 95,  0, 95,  0, 90,  0, 95,  0, 75, 75, 95, 95, 94,
  0,  0,  0, 95,  0,  0, 75,  0, 75,  0,  0,  0, 88, 75, 75, 75,
 75, 75, 95,  0,  0,  0,  0,  0,  0, 75,  0,  0, 90, 75,  0,  0,
  0, 75, 95,  0, 90, 88, 75, 75, 75,  0, 75,  0, 75, 75,  0, 75,
 88,  0,  0, 75,  0, 95, 95, 95,  0, 75,  0,  0, 98, 75,  0,  0,
 75,  0, 94,  0, 95,  0,  0, 75, 75, 75, 90, 75, 75,  0, 75, 88,
 75,  0,  0,  0,  0, 95,  0, 75,  0,  0,  0,  0, 75,  0, 75, 65,
 75,  0, 75,  0,  0, 75, 75, 75,  0,  0,  0,  0,  0, 95,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 75, 95, 95, 75, 75, 94,
  0,  0, 88,  0, 88,  0,  0, 75,  0,  0,  0,  0, 95,  0,  0,  0,
  0, 94,  0,  0,  0,  0, 88, 95,  0, 75,  0,  0, 95, 95, 95,  0,
  0, 95,  0, 90,  0, 88,  0, 95, 75,  0, 90, 75, 75,  0,  0, 75,
  0, 75,  0, 95,  0, 75,  0, 95,  0, 94, 88,  0,  0,  0,  0, 88,
 75, 75, 75, 75, 75, 88,  0,  0,  0, 75, 94, 65, 94,  0, 90,  0,
  0, 95,  0,  0,  0, 95, 88,  0,  0, 75, 95, 95,  0,  0, 65,  0,
 95, 88,  0,  0, 90, 75,  0,  0,  0, 75, 88,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 88, 95,  0,  0,  0, 95,  0,  0, 94,
  0,  0, 75,  0, 90, 65,  0, 75,  0,  0, 75, 65,  0, 88,  0,  0,
  0, 95,  0,  0,  0, 75,  0, 88,  0,  0,  0,  0,  0,  0, 94,  0,
  0, 88, 88, 75,  0,  0, 65,  0,  0, 88,  0,  0,  0,  0, 75,  0,
  0,  0,  0,  0, 75,  0, 88,  0,  0,  0, 94, 94, 94,  0,  0,  0,
  0,  0,  0,  0, 75,  0,  0,  0,  0,  0, 95, 75, 90,  0, 95,  0,
 95, 95,  0,  0,  0,  0, 75, 94, 95, 95,  0,  0,  0,  0,  0,  0,
 94,  0,  0, 90,  0, 88, 95, 95,  0,  0, 95, 98, 98, 95, 95, 90,
 95,  0, 90,  0,  0, 95,  0, 75, 95,  0,  0,  0,  0, 95,  0, 75,
  0,  0,  0,  0,  0,  0,  0, 90, 75,  0, 95,  0,  0,  0,  0, 94,
 90, 95,  0,  0, 90, 90,  0,  0,  0,  0, 90,  0,  0, 94, 94, 95,
  0, 65,  0,  0,  0,  0,  0,  0,  0,  0, 75,  0,  0, 88,  0,  0,
  0,  0,  0,  0,  0,  0, 94, 95,  0,  0, 94,  0,  0,  0, 94,  0,
 88, 65,  0, 95,  0,  0,  0,  0,  0, 95, 90, 75,  0, 95, 95, 94,
 95, 95,  0, 75,  0,  0, 75,  0,  0, 95, 65, 95,  0, 75,  0,  0,
  0, 95, 95,  0,  0, 95,  0,  0, 95,  0,  0,  0,  0,  0,  0, 95,
  0, 88,  0, 90, 95,  0, 95, 95,  0, 95,  0, 75, 88, 75,  0, 75,
 90,  0,  0,  0,  0,  0,  0,  0, 75,  0,  0, 95,  0, 75,  0,  0,
 95,  0, 75, 75,  0, 65, 75,  0, 94,  0,  0, 95,  0, 95, 90,  0,
  0,  0,  0,  0, 95,  0,  0, 95, 88, 94, 95,  0, 94,  0, 75, 94,
 95,  0,  0, 75,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 94,  0,
  0, 94, 88, 75,  0,  0, 65, 95,  0, 75,  0, 95, 95, 95, 88, 95,
 94,  0, 88, 88,  0,  0, 95,  0,  0, 94,  0,  0,  0, 94, 94, 88,
 88, 75,  0,  0,  0,  0,  0, 95,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 94, 94, 88,  0,  0,  0,  0,  0, 94,  0, 94,  0,  0,  0,  0,
 95,  0,  0,  0, 95,  0, 95, 75, 75, 95, 95,  0,  0, 94,  0, 95,
 75, 95,  0, 90, 95,  0, 75,  0, 95,  0,  0,  0,  0, 75,  0,  0,
  0, 75, 95, 94,  0, 95, 90, 90, 95,  0,  0,  0, 75, 75,  0, 95,
 75,  0,  0,  0,  0, 75, 75,  0, 75, 94, 94,  0, 75, 75, 94, 94,
 88,  0,  0, 75,  0,  0, 88,  0,  0,  0, 94,  0,  0,  0,  0, 90,
  0,  0,  0, 88, 94, 94,  0, 94, 88,  0, 94, 95,  0, 88,  0, 88,
  0,  0, 88, 88,  0, 88, 75, 65,  0, 95, 88,  0, 88, 94, 75, 95,
 95, 88, 88, 95,  0, 95, 90,  0,  0,  0, 94,  0,  0, 95,  0, 95,
 88,  0,  0,  0,  0,  0, 94,  0, 88, 95, 95,  0,  0, 75,  0, 95,
  0,  0, 88, 75, 90,  0, 90,  0, 90,  0, 90, 90,  0,  0,  0, 95,
  0, 95,  0,  0, 75, 75,  0,  0, 88, 95,  0, 95,  0,  0, 95,  0,
 95,  0,  0,  0, 75, 90, 95,  0, 90,  0, 75, 75, 95, 65, 75,  0,
  0, 75,  0, 90,  0, 88, 88,  0, 75, 94, 75,  0, 75,  0, 75,  0,
  0,  0,  0,  0,  0, 90, 94, 75, 88, 95,  0, 95, 95, 94,  0, 95,
 95, 95, 95,  0, 95,  0, 95,  0, 75,  0, 75, 75,  0, 90,  0,  0,
 98,  0, 75,  0,  0, 88,  0, 88,  0,  0,  0,  0, 94,  0, 95,  0,
 88, 90, 75,  0, 88, 95,  0, 75,  0, 75, 88, 75,  0, 65, 75,  0,
 75,  0,  0,  0,  0, 75, 88, 94,  0,  0,  0, 94,  0, 90,  0, 94,
 75,  0, 88,  0, 95, 95,  0, 95, 88, 88, 94,  0, 90, 95,  0, 88,
  0, 95, 75,  0,  0,  0, 75, 75, 75, 75, 90, 75, 75, 95,  0,  0,
  0, 95,  0,  0, 95,  0,  0,  0, 95,  0,  0,  0,  0,  0,  0,  0,
 94, 95,  0,  0, 94,  0, 95, 95,  0, 94,  0, 88, 90,  0,  0, 88,
  0, 75, 65, 75,  0,  0,  0,  0,  0, 75, 75,  0,  0, 90,  0,  0,
 94, 75,  0,  0, 94, 90, 90,  0,  0, 94, 75,  0,  0, 88, 75,  0,
  0, 75,  0, 88,  0,  0, 88, 90,  0,  0,  0,  0, 75,  0, 75,  0,
 88,  0,  0,  0,  0,  0,  0, 95,  0,  0,  0, 75, 75, 88,  0, 75,
  0, 88, 94, 88, 88,  0, 75, 88,  0,  0,  0,  0,  0,  0, 65, 90,
  0, 94,  0, 88,  0,  0, 75, 95,  0,  0, 95, 94,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 88, 90,  0,  0,  0,  0, 94, 94, 95,
 90, 75,  0, 94,  0,  0,  0,  0,  0,  0,  0,  0, 94, 95,  0, 88,
 88,  0,  0,  0, 88,  0, 88,  0, 88,  0,  0,  0,  0,  0,  0, 88,
 94,  0,  0,  0, 94, 88,  0,  0,  0,  0,  0,  0, 94,  0,  0,  0,
  0,  0,  0, 95, 75, 88,  0,  0,  0,  0,  0, 75, 75, 75, 88,  0,
  0, 88, 88, 94,  0,  0,  0,  0,  0, 95,  0, 88,  0, 88,  0,  0,
 88, 75, 95,  0,  0, 95,  0, 95, 95,  0,  0, 88, 75, 75, 75, 95,
  0, 88, 90,  0, 90, 95,  0, 94, 88,  0, 75, 88,  0, 88, 95,  0,
  0, 95, 95, 95,  0,  0,  0,  0,  0, 95,  0,  0, 75, 90, 95,  0,
 88, 75, 88,  0,  0, 90,  0, 75, 75,  0, 95,  0, 75, 75, 88,  0,
  0,  0, 88,  0,  0, 75, 95, 75, 88, 75,  0,  0, 90,  0, 94, 95,
 95,  0, 88,  0,  0,  0,  0, 94, 75,  0,  0,  0,  0,  0,  0, 90,
  0,  0, 88,  0, 88,  0, 88,  0, 90,  0, 88, 95,  0,  0, 94,  0,
 94,  0, 94,  0, 94, 94, 94, 65, 65,  0, 95, 94,  0, 94,  0,  0,
 94,  0,  0,  0, 94, 88,  0, 94, 94, 94, 94, 94, 88,  0,  0,  0,
 95, 94, 95,  0,  0,  0,  0, 75,  0,  0,  0, 95, 94,  0, 94, 95,
 94,  0, 88, 94,  0, 94,  0,  0,  0, 94, 94,  0,  0,  0,  0, 88,
  0,  0, 94, 94, 94, 94, 94,  0,  0,  0,  0, 88, 88,  0, 88, 88,
 94,  0,  0,  0,  0,  0, 88,  0,  0,  0,  0, 88,  0,  0, 94,  0,
  0, 94, 94, 88,  0,  0, 94,  0, 94,  0, 65,  0,  0,  0, 95,  0,
  0, 94, 94, 94,  0, 88, 94, 75,  0, 94,  0,  0,  0, 88,  0, 65,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 88,  0,  0,  0,  0, 65, 94,
  0,  0,  0, 94,  0,  0,  0,  0,  0, 88, 88, 88, 94,  0,  0, 88,
 65,  0, 94, 88,  0,  0, 75,  0,  0,  0,  0, 88, 94, 94, 90, 88,
 88, 94, 94,  0, 94, 94,  0,  0, 94,  0, 94, 94,  0, 94, 94, 94,
  0,  0,  0,  0,  0,  0,  0, 94,  0,  0, 94, 94,  0,  0,  0, 88,
  0, 88, 88,  0,  0, 88, 65,  0, 94,  0, 94,  0, 88, 94, 94,  0,
 94, 94,  0, 65, 88,  0,  0,  0, 94, 94,  0,  0, 94,  0,  0, 94,
  0,  0, 88,  0, 94,  0,  0,  0,  0,  0,  0, 94,  0,  0,  0,  0,
  0, 88,  0,  0, 88, 88,  0,  0,  0, 94, 94, 88,  0,  0,  0,  0,
  0,  0, 88,  0,  0, 65,  0,  0,  0,  0,  0, 94,  0, 65, 94, 94,
  0, 94, 88, 94,  0,  0, 88,  0,  0,  0,  0, 94,  0,  0, 94, 65,
  0, 94, 88,  0,  0, 88,  0, 94,  0, 88, 88, 90,  0, 94, 94,  0,
  0, 95,  0, 94,  0,  0, 94, 98,  0,  0, 88, 88,  0, 88,  0,  0,
  0,  0, 65,  0, 94, 94, 88,  0,  0, 88, 88,  0,  0, 88, 94,  0,
  0, 65,  0,  0,  0,  0, 88, 88,  0, 94, 94, 65,  0, 94,  0,  0,
 94,  0,  0,  0,  0,  0,  0,  0,  0, 94,  0, 88, 94, 88,  0, 88,
  0,  0, 95, 88,  0,  0,  0,  0, 88, 88,  0,  0, 94,  0, 88, 94,
 88,  0, 88, 94, 88,  0, 94,  0, 65,  0,  0, 95, 94,  0,  0, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,  0, 75,
 75, 75, 75, 75,  0, 75, 75, 75, 75, 75, 75,  0,  0, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75,  0, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75,  0, 75, 75, 75, 75, 75, 75, 75,  0, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75,  0, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,  0, 75, 75, 75, 75, 75,
  0, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,  0, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 95,  0, 95,  0, 95,  0,  0,  0,  0,  0,
  0,  0, 75,  0, 75, 90,  0,  0,  0,  0,  0,  0, 94, 88, 88,  0,
 95, 90,  0,  0, 95, 95,  0, 75, 90,  0, 75,  0,  0,  0,  0, 90,
 88, 75, 75,  0,  0,  0,  0, 88, 90, 90, 95, 94,  0,  0, 95,  0,
 94, 75, 95,  0, 75, 94,  0, 94, 88, 95,  0,  0,  0,  0, 75,  0,
  0, 75, 88, 88,  0, 94, 88, 88, 94,  0, 95,  0, 95,  0, 95,  0,
  0,  0,  0,  0, 95,  0,  0,  0,  0,  0, 95,  0,  0, 90, 95, 75,
  0, 75,  0, 88, 95,  0,  0, 75, 94, 94,  0,  0,  0,  0, 88, 90,
 75,  0, 95,  0,  0,  0, 88,  0, 95, 95,  0,  0, 75, 95,  0, 75,
  0, 95,  0,  0,  0, 95, 88,  0,  0,  0, 95,  0, 95,  0, 98,  0,
  0,  0, 94,  0, 95, 95,  0,  0, 75,  0,  0,  0,  0,  0,  0, 98,
 95, 95,  0,  0,  0, 75, 90,  0,  0, 95,  0, 94,  0,  0, 75,  0,
 95, 75,  0, 90,  0,  0,  0,  0,  0, 94,  0, 90, 95,  0,  0,  0,
 95, 95,  0, 95, 90, 95, 95,  0,  0, 65,  0, 90, 95, 75,  0,  0,
 95,  0, 90,  0, 75, 95, 75, 95, 95, 90,  0,  0, 90,  0,  0,  0,
 75, 88, 75,  0,  0, 75, 75, 75, 90, 75, 75,  0,  0, 65,  0,  0,
  0, 75,  0, 95,  0, 75, 95, 75, 75,  0,  0, 90,  0, 95,  0, 95,
  0,  0, 75, 98,  0,  0, 95,  0,  0,  0, 95, 75, 75, 75,  0,  0,
  0,  0, 90,  0, 75,  0, 94,  0, 95,  0, 95,  0,  0,  0, 94, 88,
  0, 88, 88,  0,  0,  0,  0,  0, 88, 75, 75,  0,  0,  0,  0, 94,
 94, 75, 94, 94, 88,  0, 88, 94,  0, 88,  0,  0,  0, 94, 94, 95,
 75,  0,  0, 75, 95, 94, 95, 95,  0, 95,  0, 95, 95,  0,  0,  0,
  0,  0,  0, 90,  0,  0, 95,  0, 90,  0, 90, 95, 75, 95,  0, 75,
 75, 95, 95,  0, 75, 95,  0,  0,  0, 95, 95, 75, 88, 90, 75, 95,
  0, 95, 95,  0, 95,  0,  0, 75,  0,  0, 95,  0, 75, 75, 75, 75,
 75, 75, 75, 95, 95,  0, 90,  0,  0,  0,  0,  0, 95, 75, 95,  0,
  0,  0,  0,  0,  0,  0, 90, 75,  0, 90, 95, 95, 75, 90, 95,  0,
  0, 95,  0,  0, 95, 95,  0, 75, 75, 75, 75, 75, 75, 75,  0, 90,
 75, 95, 75, 75, 95,  0, 75,  0, 95,  0, 75,  0, 90, 95,  0,  0,
  0,  0, 95,  0,  0, 94, 95, 94, 94, 90, 95,  0,  0, 75, 75, 75,
 75, 75, 75, 75, 75,  0, 75,  0, 98,  0, 95, 94,  0,  0, 75,  0,
  0,  0,  0, 94,  0,  0,  0,  0,  0, 94,  0, 65, 75,  0,  0, 95,
  0, 90, 75, 88,  0,  0, 75,  0, 75, 94,  0,  0,  0,  0, 95,  0,
  0,  0,  0,  0,  0,  0, 90,  0, 75,  0, 75, 95, 75,  0, 94,  0,
 95, 95,  0, 90, 95, 95,  0,  0,  0, 75, 75,  0,  0,  0,  0, 88,
 75,  0,  0,  0,  0, 95, 94, 75,  0, 75,  0, 94,  0, 75, 90,  0,
 95, 95,  0,  0, 90,  0,  0,  0, 94, 95, 95, 75, 75, 75, 75, 95,
 95,  0, 90, 88,  0,  0,  0,  0, 95,  0, 95,  0,  0,  0,  0, 95,
  0, 75,  0, 88,  0, 88,  0,  0, 75,  0, 94, 75, 95, 95,  0,  0,
 94,  0,  0, 95, 88,  0, 75,  0, 95, 88, 75,  0,  0,  0,  0,  0,
 88,  0,  0, 95,  0, 94,  0,  0, 88,  0, 95, 75,  0, 94, 94, 94,
 95, 75, 95, 75,  0,  0, 95,  0, 88, 88, 75,  0, 75, 94,  0,  0,
  0, 88,  0, 88,  0,  0,  0,  0, 94, 88, 88,  0,  0,  0,  0, 94,
 88,  0,  0, 95,  0, 94,  0, 95, 94,  0, 95,  0, 75, 95,  0,  0,
  0,  0,  0, 95, 95,  0,  0,  0,  0,  0, 94, 95, 95,  0, 95,  0,
 75, 90, 90,  0, 75, 95, 75, 94, 94, 88, 94,  0, 95, 95, 88,  0,
 90,  0, 95,  0, 75,  0, 88, 88, 88,  0,  0, 95, 95,  0, 95, 95,
  0, 98, 75, 75,  0,  0,  0,  0, 75, 88, 95, 95, 95, 75, 88, 75,
 75, 75,  0, 90, 75, 95, 95, 95, 90, 95,  0, 75,  0,  0, 75,  0,
 94,  0,  0,  0, 75, 65,  0, 95,  0, 75,  0, 75,  0,  0,  0, 75,
  0,  0,  0,  0,  0,  0,  0,  0, 90, 94, 90,  0,  0, 88,  0, 90,
  0,  0, 88,  0, 94,  0, 94,  0, 90,  0, 88, 88,  0,  0, 95, 95,
 75, 94, 95, 75, 75,  0, 94, 88, 94, 75, 75,  0,  0, 75, 95, 75,
  0,  0, 75,  0, 75,  0,  0,  0, 75,  0, 75, 95,  0, 95, 98, 75,
  0, 75, 95,  0,  0,  0,  0, 75, 75, 95, 65,  0, 75, 95,  0, 95,
  0, 75,  0,  0, 75, 95, 95,  0, 75, 98, 75, 90, 95, 95, 98, 95,
 75, 95,  0, 95, 75,  0,  0, 98, 95, 95,  0, 94, 65, 95, 75, 65,
  0, 75,  0,  0, 75, 88,  0, 75, 75,  0, 75, 75, 75, 75, 75, 75,
  0, 95, 95, 90, 95, 98,  0, 95, 75, 88,  0, 95, 90,  0, 95, 95,
 75, 95,  0, 90, 75, 95, 95, 94,  0,  0,  0, 90,  0,  0,  0, 75,
  0, 95,  0, 88, 90,  0,  0, 75,  0, 90, 88, 90,  0, 65, 65,  0,
  0, 98, 95, 95, 95, 95, 90, 75, 75, 95,  0,  0, 75,  0, 90, 75,
  0, 75,  0,  0, 75, 75, 88, 95, 88,  0, 75, 75, 90,  0,  0,  0,
  0,  0,  0, 88,  0,  0,  0, 75, 95,  0,  0, 95, 75, 75,  0, 95,
  0, 95, 88, 75, 95, 95, 95,  0, 95, 95, 75,  0, 75,  0,  0,  0,
 95,  0,  0, 75,  0, 88, 75, 98,  0, 95, 94,  0,  0,  0,  0, 95,
 90, 98, 95,  0, 75,  0,  0,  0, 88,  0, 75, 75, 75,  0, 75, 75,
 75, 75,  0, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
  0,  0,  0, 94,  0, 88,  0, 95, 75,  0,  0, 95, 90, 75,  0,  0,
  0,  0,  0,  0,  0, 90, 75, 88,  0, 95, 94,  0,  0,  0, 95,  0,
  0,  0, 75, 90,  0,  0, 94,  0, 98,  0, 88, 75, 75,  0, 95, 88,
 90,  0, 94,  0,  0,  0,  0,  0, 90, 98, 95, 95,  0,  0,  0,  0,
 75, 90, 75, 75, 75, 88, 75, 75, 75, 75, 75,  0, 75, 95,  0,  0,
 75, 95,  0,  0,  0, 95,  0, 75,  0, 65, 95,  0, 95,  0, 88, 75,
  0,  0,  0, 94, 75,  0, 95,  0, 90,  0,  0,  0, 95, 75,  0, 90,
 90, 75,  0,  0,  0, 75,  0,  0,  0, 95, 75, 94,  0,  0,  0, 94,
 95, 95, 95,  0, 94,  0,  0, 88, 75, 98,  0, 88,  0, 95,  0,  0,
  0, 75,  0, 95, 95,  0, 75, 88,  0,  0, 65, 90, 95, 95, 95, 75,
  0, 75,  0, 88,  0,  0,  0,  0, 75,  0,  0,  0, 75, 75,  0,  0,
 88,  0, 88,  0, 75, 75, 75, 75, 75, 94, 88,  0, 94,  0,  0,  0,
  0, 95,  0,  0,  0, 88,  0,  0, 95,  0,  0,  0, 90, 95,  0,  0,
  0,  0,  0,  0,  0,  0, 90,  0,  0, 94,  0,  0,  0,  0, 88,  0,
  0, 75,  0,  0,  0,  0,  0, 95,  0, 75, 75, 95, 75,  0,  0,  0,
  0, 95, 88, 95,  0,  0, 94,  0,  0, 90,  0, 95, 95, 90, 88, 94,
  0, 90,  0, 75,  0, 95, 75, 88, 75, 88, 95,  0,  0,  0,  0,  0,
  0,  0, 90,  0, 88,  0,  0, 75, 75, 75,  0, 90, 75,  0, 75,  0,
 94,  0,  0,  0, 94,  0,  0, 75,  0, 95,  0,  0, 95,  0,  0, 88,
  0, 95,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 88,  0, 75,
  0,  0, 95,  0, 75,  0,  0,  0, 95, 90, 75, 94, 94, 75,  0, 95,
 65, 90, 65,  0, 95,  0, 94,  0,  0, 95, 90, 94,  0, 95,  0,  0,
 90, 95,  0, 75,  0,  0, 90,  0,  0, 88, 94,  0,  0, 75,  0, 75,
 75,  0,  0, 75,  0, 75, 75,  0,  0,  0,  0,  0, 95,  0, 94,  0,
 75,  0,  0,  0, 94,  0,  0,  0,  0,  0,  0,  0, 95,  0,  0, 90,
 88,  0,  0,  0,  0,  0, 88,  0,  0,  0,  0,  0, 75,  0,  0,  0,
  0, 95,  0, 95, 94, 88,  0, 95, 94,  0, 95,  0,  0,  0, 65, 90,
  0, 95,  0, 65,  0, 65, 88,  0,  0,  0,  0, 75, 95, 94,  0, 65,
  0,  0,  0,  0,  0, 88,  0, 75, 75, 75, 75, 75, 75, 95,  0, 65,
 88, 94,  0, 95,  0,  0,  0,  0, 90, 95, 90, 88,  0,  0, 94,  0,
  0,  0,  0, 65,  0, 88, 75, 88, 88, 98, 88,  0,  0,  0, 75,  0,
  0,  0,  0, 94, 75,  0,  0,  0, 95, 94, 94,  0,  0, 94,  0,  0,
  0,  0, 75,  0, 75,  0,  0, 88,  0, 75, 75, 75,  0,  0, 90,  0,
 88,  0,  0,  0, 95, 75,  0, 95, 88,  0, 88,  0,  0,  0,  0, 98,
 88, 94,  0,  0, 94,  0,  0, 88,  0, 88,  0, 95, 90,  0,  0,  0,
  0,  0,  0,  0, 90,  0, 94,  0, 95, 94, 95, 88, 88,  0, 90, 95,
 98,  0,  0,  0,  0,  0,  0, 75,  0, 90, 94,  0,  0,  0,  0,  0,
  0, 95,  0,  0,  0,  0,  0,  0,  0, 95,  0,  0,  0, 94, 65, 95,
 90,  0,  0, 75,  0, 95,  0,  0,  0,  0,  0,  0, 95, 94,  0,  0,
  0,  0,  0,  0, 95, 94,  0,  0,  0, 95, 94,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 94,  0, 88, 94, 95,  0,  0, 88, 98,
  0,  0, 94,  0,  0, 75, 94, 94,  0,  0, 94, 88,  0,  0,  0,  0,
  0, 75,  0, 88,  0,  0, 95, 94,  0,  0, 94,  0,  0,  0,  0,  0,
  0,  0, 88,  0,  0,  0,  0, 75,  0, 75,  0,  0,  0, 94,  0, 88,
 88,  0,  0,  0,  0,  0,  0,  0, 75,  0,  0,  0, 75,  0,  0, 94,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 90, 95, 75,
 95, 75,  0,  0, 95, 94,  0,  0,  0,  0, 90, 65, 94,  0, 95, 94,
  0,  0, 75,  0,  0,  0,  0, 94,  0,  0,  0, 90, 75,  0, 75,  0,
  0, 90,  0,  0,  0,  0,  0,  0,  0, 95, 75, 90, 75, 75, 75, 75,
 75, 75, 75,  0,  0,  0,  0,  0,  0,  0, 95, 90, 95, 75,  0,  0,
  0,  0,  0, 95,  0, 90,  0,  0,  0,  0,  0,  0, 75, 75,  0,  0,
  0,  0,  0, 95, 95,  0,  0, 75, 75, 95, 90, 88, 75,  0,  0, 90,
 90, 75,  0,  0, 75, 75, 90,  0,  0,  0, 75,  0,  0,  0,  0,  0,
 75,  0,  0,  0, 90,  0, 90, 95,  0, 90, 75, 95,  0, 88, 90, 75,
 75, 75,  0,  0, 95,  0,  0,  0, 75, 95,  0, 95,  0,  0, 90, 95,
  0,  0,  0,  0, 95,  0,  0,  0,  0, 90,  0,  0, 88, 95, 90, 88,
 75, 75, 75, 75, 75,  0,  0,  0, 90, 90,  0, 88,  0,  0, 95,  0,
 95,  0, 95, 95,  0,  0, 88, 75, 95, 90, 90,  0,  0, 90,  0,  0,
  0, 88, 90, 75,  0, 75,  0, 75, 95,  0, 95,  0, 95,  0, 75,  0,
  0, 75, 75, 75,  0, 90,  0,  0,  0, 90,  0,  0,  0,  0, 75,  0,
  0, 75,  0,  0, 90,  0,  0, 90,  0,  0,  0, 90,  0,  0, 75, 90,
  0,  0,  0,  0,  0,  0,  0, 75, 75, 90,  0, 88, 90,  0, 95,  0,
  0,  0,  0, 90,  0, 94,  0, 95,  0, 90,  0,  0,  0,  0,  0, 94,
 90,  0,  0, 90, 75, 75, 94,  0, 94,  0, 88,  0,  0,  0, 90,  0,
 75,  0,  0,  0, 95,  0, 95,  0, 94,  0,  0, 75, 75, 75, 75, 88,
  0,  0, 95, 75,  0, 75,  0,  0, 75,  0,  0, 75,  0, 95,  0,  0,
  0,  0,  0, 75,  0,  0,  0, 75,  0,  0,  0,  0,  0,  0,  0, 95,
  0,  0, 94,  0,  0,  0,  0,  0, 75,  0,  0, 90, 75, 75,  0, 90,
  0,  0,  0, 95,  0, 75,  0,  0,  0,  0, 95, 88,  0, 90,  0,  0,
 90,  0,  0,  0, 94,  0, 90, 88,  0,  0, 75, 90,  0,  0,  0,  0,
 88, 75, 90, 75,  0,  0,  0,  0,  0,  0,  0, 75,  0,  0,  0,  0,
 95,  0,  0,  0,  0, 75,  0,  0,  0,  0, 75,  0, 65,  0, 75, 94,
  0,  0, 94,  0,  0,  0, 88, 88,  0, 95,  0, 94,  0,  0, 95,  0,
  0,  0,  0, 75,  0, 94,  0,  0,  0,  0, 75,  0,  0, 88, 88, 88,
  0, 88,  0, 75,  0, 90, 90,  0,  0,  0,  0, 75,  0,  0,  0, 65,
  0, 90, 95, 94,  0,  0,  0, 88,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 94, 75,  0,  0,  0, 94,  0,  0, 90,  0, 94, 75,  0,  0,  0,
 95,  0, 88,  0, 90, 75, 94,  0,  0,  0,  0,  0, 95, 95,  0,  0,
  0,  0, 94, 94, 75,  0,  0, 95,  0, 95,  0, 94,  0, 94, 88,  0,
  0, 95, 95, 95, 75, 75,  0,  0, 95, 75,  0, 95, 75,  0, 75,  0,
 95,  0, 95,  0,  0, 88,  0, 95,  0,  0,  0,  0,  0, 90, 95, 95,
  0, 95, 95,  0, 75, 75,  0,  0, 95,  0,  0, 95,  0, 95,  0,  0,
  0,  0, 95,  0,  0,  0, 95, 94,  0, 88,  0,  0, 75,  0, 94,  0,
  0,  0, 90,  0, 90,  0,  0,  0,  0,  0,  0, 95,  0, 75, 88,  0,
 88, 90,  0,  0, 94, 88,  0, 90,  0,  0,  0,  0, 75,  0,  0, 88,
  0, 95, 95, 88, 88, 90, 75,  0,  0, 75,  0,  0,  0,  0, 75, 94,
  0,  0, 75,  0, 95, 95,  0,  0, 90, 95,  0,  0, 94, 94,  0, 95,
  0, 94, 75, 75, 75, 75,  0,  0, 95,  0,  0,  0,  0,  0,  0,  0,
 75, 75, 88, 95, 95, 65,  0,  0, 95, 90,  0,  0, 90, 94, 90,  0,
  0,  0, 90,  0, 88,  0,  0, 94,  0,  0, 90,  0, 88,  0,  0,  0,
 95,  0, 95, 95,  0,  0,  0,  0, 65, 98, 75, 75,  0, 88, 88,  0,
  0, 75,  0,  0,  0, 95,  0,  0,  0,  0, 95, 90,  0,  0,  0,  0,
 75,  0,  0,  0, 75,  0, 95,  0, 94,  0,  0, 94,  0,  0,  0,  0,
  0, 95,  0, 88, 95,  0,  0,  0,  0,  0,  0,  0, 88, 88,  0,  0,
  0,  0,  0,  0,  0,  0, 88,  0,  0,  0,  0,  0,  0,  0, 90, 95,
 88,  0,  0,  0, 94,  0, 90,  0,  0,  0, 94,  0,  0, 88,  0, 88,
  0,  0, 94,  0, 88,  0,  0, 88,  0,  0,  0, 75,  0,  0, 88, 95,
  0, 95,  0, 95,  0,  0, 95, 94, 88,  0, 88, 94,  0,  0,  0, 94,
  0,  0,  0, 94,  0,  0, 94, 88, 88,  0, 88,  0,  0,  0,  0,  0,
  0, 94,  0,  0,  0,  0, 88, 88,  0, 94, 94,  0, 88,  0,  0, 88,
  0,  0, 94, 88,  0,  0,  0,  0,  0,  0, 94,  0,  0, 94,  0, 88,
 94, 75, 75,  0, 75, 75, 75, 75, 75, 75, 75, 75, 75,  0, 75, 75,
 75, 75, 95,  0,  0,  0, 75,  0,  0,  0, 90,  0, 90, 88, 75,  0,
  0,  0,  0, 95,  0, 75, 90, 88,  0,  0,  0, 75,  0,  0,  0, 75,
  0,  0,  0, 75, 94,  0,  0,  0, 94,  0,  0,  0,  0,  0,  0,  0,
 95,  0, 94, 94,  0,  0,  0, 75, 94,  0, 94,  0, 94,  0, 94,  0,
 88,  0,  0, 94,  0,  0, 94, 94, 94,  0,  0, 94,  0, 94,  0, 94,
  0,  0,  0, 94,  0, 94,  0,  0,  0,  0, 94,  0,  0, 94,  0,  0,
  0, 94,  0, 88, 94,  0, 94,  0,  0,  0, 94, 94, 88,  0, 75,  0,
  0, 88,  0,  0,  0,  0, 88,  0, 90,  0,  0,  0,  0,  0,  0,  0,
 94, 88, 88,  0, 94, 94,  0,  0,  0,  0,  0, 94,  0,  0, 94,  0,
 94,  0, 94, 94,  0,  0, 94,  0,  0, 94,  0, 88, 88, 94, 94,  0,
 94, 94, 94, 94,  0, 65,  0,  0,  0, 98,  0,  0, 88,  0,  0,  0,
  0,  0, 88,  0, 88, 94,  0, 94,  0, 90, 75,  0, 94, 94,  0,  0,
  0, 88,  0, 95,  0, 94,  0,  0, 94,  0, 88,  0,  0,  0, 94,  0,
 94, 94,  0, 94, 94, 94, 94,  0, 94,  0, 65,  0, 88, 88,  0,  0,
 94,  0, 94,  0,  0,  0,  0,  0,  0, 94,  0,  0, 94,  0, 65, 94,
  0,  0, 94,  0, 94,  0,  0, 94,  0,  0,  0, 94, 88, 94,  0, 94,
  0,  0, 94,  0,  0,  0, 94,  0,  0,  0, 88, 94, 94,  0, 88,  0,
 88, 94, 88,  0, 88,  0, 94, 94,  0,  0, 65, 94,  0, 94, 94,  0,
  0, 94,  0, 88,  0,  0, 65, 94, 94,  0, 94,  0,  0,  0, 94,  0,
 94, 94, 94,  0, 94,  0,  0, 90,  0,  0,  0,  0, 88,  0, 94,  0,
 94,  0,  0,  0, 94,  0, 94, 94,  0, 94, 94, 94,  0, 94,  0,  0,
 94, 88,  0,  0,  0,  0, 90,  0, 94,  0,  0, 94, 94,  0,  0,  0,
  0,  0,  0, 94,  0,  0,  0,  0,  0, 94,  0,  0,  0,  0, 88,  0,
  0, 94,  0,  0,  0,  0,  0,  0,  0, 94,  0,  0, 88,  0, 94, 94,
  0,  0,  0,  0,  0,  0, 88,  0, 94,  0, 94, 88, 94,  0,  0, 88,
  0,  0,  0,  0,  0,  0, 95,  0,  0,  0,  0, 88, 95,  0,  0, 94,
 94, 88, 88,  0, 94,  0,  0, 94,  0,  0,  0,  0,  0, 94,  0,  0,
 94,  0,  0, 88,  0,  0,  0,  0,  0,  0, 94,  0, 88,  0, 88,  0,
 94,  0, 94, 94,  0,  0, 94,  0,  0, 88, 94,  0,  0,  0,  0,  0,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,  0, 75, 75, 75,
 75,  0, 75, 75, 75, 75, 75, 75, 75, 75, 75,  0, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75,  0, 75, 75, 75, 75, 75, 75, 75, 75,
  0, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,  0, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75,  0, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,  0, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 95,  0,  0, 88,  0,  0,  0,  0, 94,
  0, 95,  0,  0,  0,  0, 95, 75, 94, 75, 94,  0, 95,  0, 88,  0,
 88,  0,  0,  0,  0, 95,  0,  0,  0,  0, 95,  0,  0,  0,  0,  0,
  0, 95, 90,  0,  0,  0,  0,  0,  0,  0, 95, 95, 88,  0,  0,  0,
  0,  0,  0, 75,  0,  0,  0,  0, 90, 95, 95,  0, 88,  0,  0,  0,
  0,  0, 95,  0,  0, 90,  0,  0,  0, 90, 95,  0, 95, 88, 88,  0,
  0,  0,  0,  0, 90,  0,  0,  0, 90,  0,  0,  0,  0, 94, 94,  0,
 94, 94, 94,  0,  0,  0,  0, 94, 94, 94, 94, 94, 94, 88, 88, 94,
 94,  0, 88, 94, 94,  0, 94, 94, 94,  0,  0, 94, 94, 94,  0, 94,
 94, 94, 94, 94, 94,  0,  0, 94, 94,  0, 94,  0,  0, 88, 88,  0,
  0, 94,  0, 94,  0,  0,  0,  0,  0,  0, 94, 88, 94,  0, 94,  0,
 94,  0, 94, 94, 94,  0, 94,  0,  0,  0, 94,  0,  0, 94,  0,  0,
  0,  0,  0,  0, 65,  0,  0,  0,  0,  0, 88, 94, 94, 94,  0,  0,
  0,  0,  0,  0, 94, 94,  0, 94, 94,  0, 94, 88,  0, 94,  0, 88,
 88,  0,  0, 94, 88,  0, 94,  0,  0,  0,  0,  0,  0, 75, 75, 75,
  0, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75,  0,  0, 75, 75, 75, 75,  0, 75, 75, 75, 75, 75, 75, 75,  0,
 75, 75, 75, 75, 95,  0, 95, 90,  0,  0,  0, 95,  0, 90,  0,  0,
 95, 88,  0, 95, 95, 75, 75, 95,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 90,  0,  0, 75, 95,  0,  0,  0,  0, 95, 75,  0,  0,  0,  0,
  0, 75,  0,  0, 75,  0,  0,  0,  0, 94,  0,  0,  0,  0,  0, 75,
  0,  0,  0, 95,  0,  0,  0,  0, 94,  0,  0,  0,  0,  0,  0,  0,
  0, 75,  0, 95, 75, 75,  0,  0, 75,  0, 95,  0, 75,  0, 95, 75,
  0,  0, 88, 75, 75,  0, 98,  0,  0,  0,  0, 95, 95,  0, 75, 95,
  0, 75,  0,  0,  0,  0, 90, 75,  0,  0, 90, 95,  0, 95, 75, 90,
  0, 94,  0, 95, 75,  0,  0,  0, 95,  0, 90, 90, 75,  0,  0, 95,
  0,  0,  0, 95,  0, 90,  0, 75, 75, 75, 75, 75, 88, 75,  0, 88,
  0,  0,  0,  0,  0, 75,  0,  0, 88, 90, 95,  0, 75,  0,  0, 95,
 94,  0,  0,  0, 75,  0,  0,  0,  0,  0,  0,  0,  0, 90, 95, 90,
  0,  0, 75, 75,  0,  0,  0,  0,  0, 75, 95,  0, 75,  0, 75, 75,
 94, 75,  0,  0, 88, 95,  0,  0,  0, 75, 75,  0,  0, 75,  0,  0,
 75, 75, 95,  0, 95,  0,  0, 95, 95, 95, 95, 75, 88,  0,  0,  0,
 88, 75, 75,  0,  0, 88,  0,  0,  0, 95,  0,  0,  0,  0,  0, 94,
 94,  0,  0, 88, 88,  0, 75,  0,  0, 75,  0,  0, 75, 75,  0, 75,
 75,  0, 90,  0, 95,  0, 95,  0,  0,  0,  0,  0, 90,  0,  0, 75,
  0, 95,  0,  0, 88, 90,  0, 95,  0,  0, 94, 88,  0, 94,  0, 75,
 75, 88,  0, 88, 90,  0,  0,  0,  0, 88,  0,  0, 75,  0, 75,  0,
  0, 88,  0,  0,  0,  0,  0,  0,  0,  0, 94, 95, 95,  0,  0, 90,
 88, 88, 75,  0,  0,  0,  0,  0,  0,  0, 75,  0,  0,  0, 88,  0,
 65,  0,  0,  0,  0, 88, 88,  0, 88,  0, 94, 94, 94, 94, 75,  0,
  0,  0, 94,  0,  0,  0,  0,  0,  0,  0,  0, 88,  0,  0,  0, 94,
  0,  0, 88, 88,  0,  0,  0,  0,  0,  0,  0, 94,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 94,  0,  0, 94, 88, 88, 94,  0,
  0,  0,  0, 94,  0, 94,  0,  0,  0, 94, 88,  0, 88,  0,  0,  0,
  0,  0, 94, 94, 94, 94,  0,  0,  0, 88,  0, 94, 94, 94, 65, 94,
  0,  0,  0,  0,  0,  0, 94, 65,  0, 94, 94,  0,  0,  0,  0, 94,
  0,  0,  0, 94,  0,  0,  0,  0, 94, 94,  0, 94,  0,  0, 94, 94,
  0,  0, 88,  0, 94, 94, 88,  0,  0, 94,  0,  0, 88, 94, 94,  0,
  0,  0,  0,  0,  0,  0,  0, 88,  0,  0,  0,  0, 88, 65,  0, 94,
  0, 88, 94, 88, 88,  0, 75, 75, 75, 75,  0, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
  0, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,  0, 75, 75, 75,
 75, 75,  0, 75, 75, 75, 75, 75, 75, 75, 75, 95, 95,  0, 90, 90,
  0,  0,  0, 95,  0,  0, 65, 88, 95, 75,  0, 75,  0, 94, 88, 94,
 95, 95, 94,  0,  0,  0, 75, 88,  0, 75, 88, 88, 88, 75, 75, 88,
  0, 75, 95,  0, 90, 95,  0, 75, 75,  0,  0,  0,  0,  0, 95,  0,
 75, 95,  0, 75, 95, 75,  0,  0, 75, 75, 88, 75, 75, 75, 75, 75,
  0,  0, 90,  0, 75, 90, 95,  0, 75, 90, 95, 95,  0, 95, 75, 88,
 95,  0, 65, 75, 88,  0,  0, 95, 90, 95, 88,  0,  0, 95,  0,  0,
 95, 95, 98, 95, 75, 95, 95,  0, 65, 75, 75, 95,  0, 95, 88, 95,
 95, 95, 75, 88, 95, 94, 90, 95,  0, 94, 95, 75,  0, 95, 95, 95,
 95, 95, 95, 94,  0,  0, 75, 88,  0,  0,  0,  0,  0, 75, 95, 75,
  0, 94, 94,  0,  0, 95, 90,  0, 95, 88,  0, 75, 95,  0, 95,  0,
  0, 95, 95,  0, 75, 88,  0, 95,  0, 88, 94, 94,  0, 95, 94, 90,
 95, 95, 90, 95, 94, 94, 88, 75, 90, 94,  0, 75, 94, 65, 94,  0,
 94, 94, 75, 95,  0, 90,  0,  0, 90, 94,  0,  0,  0, 95, 95, 94,
  0,  0, 94,  0, 75, 95, 88, 94, 94,  0, 94,  0, 94, 95,  0, 95,
 95, 94, 95, 95, 94,  0,  0, 94, 98, 88, 94, 75,  0,  0,  0, 94,
  0, 95,  0, 75,  0, 98,  0, 75,  0, 98,  0, 75,  0, 75,  0,  0,
  0, 75, 98, 95,  0,  0, 95,  0, 94,  0, 95,  0, 75,  0, 75, 95,
 98, 95,  0, 75, 75, 95, 75,  0, 95, 75, 75, 75,  0,  0, 75,  0,
  0, 95,  0,  0, 75, 75,  0, 75,  0,  0, 95,  0,  0,  0, 90, 75,
 75, 75,  0, 75,  0,  0,  0, 75,  0,  0,  0, 90, 75, 75, 65,  0,
  0, 95, 90,  0, 88,  0, 75, 75, 95,  0,  0, 75,  0, 95,  0, 75,
  0,  0,  0,  0, 75, 94,  0, 88, 75,  0,  0,  0,  0, 95, 75,  0,
  0,  0, 95,  0, 75,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0, 94,  0,  0, 65,  0,  0,  0, 95,  0,  0,  0,  0, 75,  0,
  0,  0, 75, 75,  0,  0,  0, 65,  0,  0,  0,  0,  0, 94,  0, 75,
 88, 75, 94,  0,  0,  0,  0,  0,  0, 75,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 75,  0,  0, 75,  0,  0, 95, 95, 95, 95, 95, 95, 75,
 75,  0, 95,  0, 88,  0, 88, 75, 88,  0, 75,  0,  0, 75, 75,  0,
  0, 75, 95, 90, 75, 90,  0,  0,  0, 95, 95,  0, 95,  0, 75, 75,
 75, 75, 90, 88, 75, 95, 75, 95, 95, 75,  0,  0,  0, 75, 75, 75,
  0,  0, 88,  0,  0, 75,  0, 95,  0, 95,  0, 95, 75, 95,  0,  0,
 90, 75, 95,  0,  0,  0,  0, 88,  0,  0, 75, 75, 94,  0,  0,  0,
  0,  0, 90, 75, 88,  0,  0,  0,  0,  0, 90, 94, 65, 75, 98, 95,
  0, 65,  0,  0, 95, 95,  0,  0, 88,  0, 90,  0,  0,  0,  0,  0,
 94, 88,  0,  0,  0,  0, 88, 95, 88, 95, 75, 94, 95, 95, 95, 95,
 94, 95,  0,  0,  0,  0, 88, 65, 94,  0,  0, 88, 95, 94,  0, 88,
  0, 88,  0, 94,  0,  0, 88, 94,  0,  0, 65,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 94, 88,  0,  0,  0,  0,  0, 88,  0,  0, 88,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 94, 88,  0,
 65, 94, 65,  0, 88, 88,  0, 65,  0,  0,  0,  0,  0,  0, 94,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0, 88,  0,  0, 88,  0,  0,  0,
  0,  0,  0,  0, 94,  0,  0, 88,  0,  0, 65,  0,  0,  0,  0, 94,
 65,  0,  0,  0, 88, 94,  0,  0, 88, 94,  0, 88,  0,  0,  0,  0,
 88,  0,  0,  0,  0,  0,  0, 94,  0,  0, 88, 94,  0,  0, 94,  0,
  0,  0, 94,  0, 94, 65, 94,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 88,  0,  0, 75,  0,  0,  0,  0,  0,  0,  0,  0,  0, 88,  0,
 94,  0,  0, 94,  0, 94,  0,  0,  0,  0,  0,  0,  0,  0, 75,  0,
  0, 94,  0, 94,  0, 88, 94,  0, 94,  0, 88, 88, 94,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 88, 75,  0,
  0,  0,  0, 65,  0,  0, 65, 94,  0, 94,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 75,  0,  0,  0, 65,  0,  0, 94,
  0,  0, 94,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 94,  0,  0,  0,  0, 88, 94,  0,  0, 88,  0,  0,
  0,  0, 88, 88,  0,  0,  0,  0, 94,  0, 88,  0, 94,  0,  0,  0,
  0,  0,  0,  0, 65,  0, 88,  0,  0,  0,  0,  0,  0,  0,  0, 88,
 94,  0,  0,  0,  0,  0,  0,  0, 94, 88, 94,  0,  0,  0, 65, 65,
 94, 65, 94, 88, 65,  0, 94,  0, 94,  0,  0, 94, 88,  0, 94, 94,
  0,  0, 88,  0,  0, 88,  0,  0,  0,  0, 88, 88,  0,  0, 75,  0,
  0,  0,  0,  0, 88,  0,  0,  0, 65,  0, 65, 94,  0, 94,  0,  0,
  0,  0,  0,  0, 94,  0, 88,  0,  0,  0,  0, 94, 88,  0,  0,  0,
 88,  0,  0,  0,  0,  0,  0,  0,  0,  0, 75,  0, 88,  0, 94,  0,
  0,  0,  0,  0,  0, 94,  0,  0,  0,  0,  0,  0, 94,  0, 94,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 94,  0,  0, 75,
  0,  0,  0,  0, 94,  0, 94, 88,  0,  0, 94,  0,  0,  0,  0,  0,
  0,  0,  0, 65,  0,  0,  0, 94,  0,  0,  0,  0, 94, 94, 88,  0,
 94,  0,  0,  0,  0,  0,  0,  0,  0, 88,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 94,  0,  0,  0,  0, 88,  0, 75,  0,  0,  0,  0,  0,
 88, 94,  0,  0,  0,  0, 90, 88, 88,  0,  0,  0,  0, 88, 65,  0,
  0, 94,  0,  0, 94, 88,  0,  0, 88,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 65,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 88, 65,  0,  0, 88,  0,  0,  0,  0,  0,  0,  0,  0,
 88,  0,  0, 88, 88,  0,  0,  0, 94, 88, 88,  0,  0,  0,  0,  0,
  0, 88,  0,  0,  0, 65,  0,  0,  0,  0,  0, 94,  0,  0,  0,  0,
  0,  0,  0,  0,  0, 94, 88,  0, 94,  0, 88,  0,  0,  0, 75,  0,
  0, 88,  0,  0, 94,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 94, 94, 88,  0,  0,  0,  0,  0,  0, 88, 94,  0,  0, 88,  0,
 88,  0, 88,  0,  0,  0,  0,  0,  0,  0, 88, 75,  0,  0,  0,  0,
 88,  0,  0,  0,  0, 88,  0, 88,  0,  0,  0,  0, 88, 94, 88, 94,
  0, 88,  0,  0,  0, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75,  0, 75, 75, 75, 75,  0, 75,  0, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75,  0, 75, 75, 75, 75, 75, 75, 75,  0,
 75, 75, 75,  0,  0, 75, 75, 75, 75, 75,  0, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75,  0, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,  0, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,  0, 75, 75, 75,
  0, 75, 75, 75, 75, 75, 75,  0, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75,  0, 75, 75, 75, 75, 75, 75, 75, 75, 75,  0, 75, 75,
 75, 75, 75,  0, 75, 75, 75, 75,  0, 75, 75,  0, 75, 75, 75, 75,
 75, 75, 75, 75, 75,  0, 75, 75, 75, 75,  0, 75, 75, 75, 75, 75,
  0, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,  0, 75,
 75, 75, 75, 75,  0,  0, 75, 94,  0,  0,  0,  0,  0,  0,  0, 75,
 94,  0, 88, 94,  0,  0,  0, 88,  0, 94, 88, 94,  0,  0,  0, 94,
  0, 94, 65, 94, 94,  0, 88,  0, 94, 88,  0,  0,  0,  0,  0,  0,
 88,  0, 88, 94, 94, 94,  0, 88, 94,  0,  0,  0,  0, 94,  0,  0,
  0, 65, 88,  0,  0,  0,  0,  0,  0, 88,  0, 94, 94,  0, 88,  0,
  0,  0,  0, 88,  0,  0,  0, 94,  0,  0, 94,  0, 88, 88,  0,  0,
  0,  0,  0,  0, 94, 94, 94,  0, 88,  0,  0,  0, 94,  0,  0,  0,
  0, 94, 94,  0,  0, 88,  0,  0, 75, 75, 75, 75,  0, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,  0,
 75, 75, 75, 75, 75, 75, 75,  0, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75,  0, 75, 75, 75, 75,  0, 75, 75,  0, 95, 75,  0, 75,
  0, 95, 75,  0,  0,  0,  0,  0, 88,  0, 95,  0,  0,  0, 95, 88,
  0, 75, 95, 75, 75, 75, 75,  0,  0,  0,  0, 95, 75, 75,  0, 95,
 95,  0, 95,  0, 95, 75, 75, 75, 75, 75,  0, 95, 95, 95,  0, 88,
 95,  0,  0,  0, 75, 75,  0,  0,  0,  0,  0, 95, 94, 94, 94, 95,
  0, 75, 95, 94, 95, 88, 88, 75, 75, 75, 95,  0, 90,  0,  0,  0,
 94,  0, 90, 94, 75, 95, 95, 95, 94,  0, 88,  0,  0, 94,  0,  0,
  0,  0,  0,  0,  0, 95, 95,  0, 90,  0, 94, 95,  0, 95, 94, 90,
 75,  0,  0,  0, 95, 94,  0, 90, 95, 95,  0, 94, 95,  0,  0,  0,
 88,  0,  0, 94,  0,  0,  0, 95, 94,  0, 94,  0,  0,  0,  0,  0,
 90, 94, 88, 75, 88,  0, 90, 94, 88, 90,  0, 94, 90, 75, 75,  0,
 95, 95,  0,  0, 95, 95, 95, 95,  0, 95,  0, 94, 95, 95, 95, 75,
  0, 88, 75,  0,  0, 95, 94,  0,  0, 94,  0, 94, 94,  0,  0,  0,
 75,  0, 94, 94,  0,  0,  0,  0, 95, 98, 95, 88,  0,  0,  0, 98,
 94,  0, 94, 75,  0,  0, 95, 95,  0, 95,  0, 94,  0,  0, 75,  0,
 95, 75,  0,  0, 90,  0, 95, 95, 90, 75, 88,  0,  0, 90, 90, 90,
  0, 94,  0, 95,  0,  0, 95,  0,  0, 94,  0,  0, 95,  0, 95,  0,
  0,  0,  0,  0, 88,  0,  0, 94,  0,  0, 90,  0,  0, 75,  0,  0,
 95,  0, 95,  0,  0,  0,  0,  0, 90, 95,  0,  0,  0, 94, 90,  0,
  0,  0, 94,  0, 94,  0, 88,  0, 94, 88,  0,  0,  0,  0,  0,  0,
  0, 65, 90, 75,  0,  0, 95,  0,  0, 90,  0, 75, 94,  0, 95,  0,
 90, 95, 95,  0, 88, 75, 88,  0, 88, 95,  0, 88,  0, 94,  0,  0,
  0, 88,  0, 75, 95,  0, 75, 65,  0, 88, 94,  0, 90,  0,  0,  0,
  0, 88,  0,  0, 88, 90, 88,  0,  0,  0,  0, 95,  0, 95,  0, 94,
 88, 75, 75,  0, 75,  0,  0,  0, 90,  0,  0,  0, 88,  0,  0,  0,
 95,  0,  0, 90,  0,  0, 88,  0, 94,  0,  0, 95,  0, 95,  0, 75,
  0,  0, 75, 88, 90,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 88,  0,  0, 94,  0, 88,  0,  0, 94,  0,  0,  0,  0,
  0,  0,  0, 94,  0,  0,  0,  0,  0,  0,  0,  0, 94,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 75, 75,  0, 75, 75, 75, 75, 90, 88,  0,
  0,  0, 88, 95,  0, 90, 95,  0,  0,  0,  0, 94,  0,  0,  0, 94,
 65, 94, 94, 94,  0, 94, 94,  0, 94,  0, 65,  0, 94,  0,  0, 88,
 94, 94, 94, 94,  0,  0,  0, 94, 94,  0, 88,  0,  0,  0,  0,  0,
  0, 88,  0,  0, 88,  0,  0,  0,  0,  0,  0,  0, 88, 94,  0,  0,
 65,  0,  0,  0, 88,  0,  0, 88, 94, 65,  0, 94, 88, 88,  0,  0,
  0,  0,  0,  0,  0,  0, 94,  0,  0,  0,  0, 88, 94, 94, 94, 88,
  0,  0,  0,  0, 94, 88,  0,  0, 94,  0, 65, 88,  0,  0, 94,  0,
  0,  0,  0,  0,  0, 65,  0, 94,  0,  0,  0, 94,  0,  0,  0, 94,
 88, 88,  0, 88, 88, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,  0, 75, 75,  0, 75,
 75, 75,  0, 75, 75,  0, 75, 75, 75,  0, 75, 75, 75, 75, 75, 75,
 75, 75, 75,  0, 75, 75, 75, 75, 94,  0, 88,  0,  0,  0,  0, 94,
  0, 94,  0,  0,  0,  0, 88,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 88, 94,  0, 88, 65,  0,  0,  0,  0,  0,  0, 75,  0,
  0, 75, 75, 75,  0, 75,  0,  0, 75, 75, 75, 94, 94,  0, 75, 95,
  0, 65, 94,  0,  0,  0,  0, 75, 75, 88,  0, 88,  0, 94, 94, 94,
  0,  0, 88,  0, 94,  0,  0,  0,  0,  0,  0,  0, 94, 94, 94,  0,
  0,  0,  0, 94,  0, 88,  0,  0,  0, 94, 94,  0, 94, 75,  0,  0,
 95,  0, 88, 94, 88,  0,  0,  0, 94,  0,  0,  0,  0, 88, 94,  0,
 94, 88,  0,  0, 88,  0,  0,  0, 94,  0,  0,  0, 88,  0, 90,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 88, 88,  0,
  0,  0, 88,  0,  0, 94,  0,  0,  0, 94,  0, 94, 94, 65,  0,  0,
 88, 94, 94,  0, 98, 90,  0, 94,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 75,  0, 75,  0, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75,  0, 75, 75, 75, 75,  0,  0, 75,  0, 75, 75,  0, 75,
 75, 75,  0,  0, 75, 75, 75, 75, 75,  0, 75, 75,  0, 75,  0, 75,
 75, 75, 75, 75, 75, 75, 95, 90, 90, 95,  0,  0,  0, 65,  0,  0,
  0,  0,  0,  0,  0, 95,  0,  0, 95,  0,  0,  0, 94, 94, 94,  0,
  0, 65,  0, 94, 94,  0,  0,  0,  0, 65,  0,  0, 88,  0,  0,  0,
  0, 94,  0,  0, 88, 88, 88,  0, 88,  0,  0,  0,  0,  0,  0,  0,
 94, 94, 94,  0,  0, 94,  0,  0, 88, 65,  0, 88,  0, 94,  0, 94,
  0,  0, 88,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 94, 88,  0,
  0, 94, 88,  0,  0,  0,  0,  0, 88,  0,  0, 88,  0,  0,  0, 94,
  0, 94,  0,  0,  0, 88,  0,  0, 65,  0,  0,  0,  0,  0, 94, 94,
  0,  0, 88, 88,  0,  0,  0,  0,  0, 94,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0, 88,  0,  0, 94,  0,  0,  0,  0,
 94,  0,  0,  0,  0,  0, 65, 94,  0,  0,  0,  0,  0,  0, 88,  0,
 94,  0, 88, 94,  0, 94,  0,  0,  0,  0,  0,  0,  0, 94,  0,  0,
  0,  0,  0,  0,  0, 94,  0, 94,  0,  0, 94, 94,  0,  0,  0, 94,
  0,  0, 94,  0, 88, 94,  0,  0,  0, 94, 94, 88, 75, 75, 75, 75,
 75, 75,  0, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,
 75, 75, 75,  0, 75, 75, 75, 75, 75,  0, 75, 75, 75,  0,  0, 75,
 75, 75, 75, 75,  0,  0, 75, 75, 75,  0, 75, 75, 75, 75, 75, 75,
 75, 75, 75, 75, 75, 75,  0, 75, 95,  0,  0,  0,  0, 88,  0,  0,
 90, 75,  0,  0,  0,  0, 75, 75, 95,  0, 75,  0, 90,  0,  0,  0,
 90, 75, 75,  0, 88, 75,  0,  0,  0,  0,  0, 75, 75,  0,  0, 88,
  0, 90,  0, 95, 94,  0,  0,  0, 95,  0,  0,  0,  0,  0, 88, 90,
  0, 75, 88, 88,  0, 65, 90,  0,  0,  0, 88, 90,  0, 90, 94, 90,
  0, 88,  0,  0, 88,  0,  0, 88,  0, 75,  0, 90,  0,  0,  0,  0,
  0,  0,  0, 75,  0,  0, 88,  0, 75,  0,  0,  0,  0,  0,  0, 75,
  0,  0,  0, 75,  0,  0,  0,  0, 88,  0, 94,  0,  0,  0,  0, 90,
  0,  0, 88, 90,  0, 88,  0, 94, 88, 88, 94,  0,  0,  0, 88, 90,
  0, 94, 90,  0,  0,  0,  0,  0,  0,  0,  0, 90, 95,  0,  0,  0,
  0, 95, 95, 95, 95, 95,  0, 75, 75, 75,  0,  0,  0, 90, 88, 95,
  0, 90,  0,  0, 95,  0,  0,  0, 88,  0, 94,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 94,
  0,  0,  0,  0, 88,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 88,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 94,  0,
  0, 94, 88, 88,  0,  0, 88, 88,  0,  0,  0,  0,  0,  0,  0, 94,
 88,  0,  0,  0,  0,  0,  0,  0, 88,  0, 88, 94,  0, 88, 94,  0,
  0,  0,  0,  0, 88,  0,  0,  0,  0, 88,  0,  0,  0,  0,  0,  0,
 88,  0,  0,  0,  0,  0, 88,  0,  0, 94, 88,  0,  0,  0,  0, 88,
  0, 88, 88,  0, 88,  0, 94,  0,  0,  0,  0, 88,  0,  0,  0,  0,
  0, 88, 88, 88, 94,  0,  0,  0, 94,  0,  0,  0,  0,  0,  0,  0,
 88, 88, 88,  0,  0, 88,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 88,  0, 88,  0, 88, 88, 88,  0, 88, 94,  0,  0,
 94,  0, 94, 88, 88, 94,  0,  0,  0,  0,  0, 88,  0,  0,  0,  0,
  0, 88,  0,  0, 88, 94,  0,  0,  0,  0,  0,  0,  0, 88, 88, 88,
 88,  0, 94,  0,  0,  0,  0,  0,  0, 88, 88, 94,  0,  0, 88,  0,
  0,  0,  0,  0,  0,  0, 88, 94, 88, 65,  0,  0,  0,  0,  0,  0,
  0,  0, 88,  0,  0,  0,  0, 94,  0,  0, 88,  0,  0,  0,  0,  0,
 88,  0,  0,  0,  0,  0,  0, 88,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 88,  0, 88,  0,  0,  0, 75,  0,  0, 75,
  0, 75, 75,  0,  0, 75, 75, 75, 75,  0,  0, 75,  0, 75, 75,  0,
 75, 75, 75,  0, 75, 75,  0,  0,  0,  0, 75, 75, 75,  0, 75, 75,
 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,  0, 75,  0, 75, 75,  0,
 75, 75, 75, 75, 75, 75, 75, 75, 75,  0, 75, 75, 75, 75,  0,  0,
  0,  0,  0, 75, 75, 75, 75, 75,  0,  0, 75, 75, 75, 75, 75, 75,
 75,  0,  0, 75, 75, 75, 75, 75, 75, 75,  0,  0, 75, 75, 75, 75,
  0,  0, 75,  0,  0, 94,  0, 94,  0, 94,  0, 88, 88,  0,  0,  0,
 88,  0,  0, 94, 94,  0, 94,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0, 88,  0,  0, 88, 88, 88, 94,  0,  0,  0,  0, 88,  0,
  0,  0, 88,  0,  0, 88,  0,  0,  0,  0,  0, 94,  0,  0,  0, 88,
  0,  0,  0, 88,  0,  0, 94,  0, 94,  0, 88, 88, 88,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 94,  0,  0, 88, 88,
  0, 88,  0,  0, 88,  0, 88,  0, 88,  0,  0,  0,  0,  0,  0,  0,
 88, 94,  0,  0,  0,  0,  0,  0,  0, 88,  0,  0, 88, 94, 88,  0,
 94, 94,  0,  0, 88,  0,  0,  0,  0,  0,  0,  0, 94,  0,  0, 88,
  0,  0, 94,  0,  0,  0,  0,  0,  0,  0, 88,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0, 88,  0, 88,  0,  0,  0,  0,  0, 88,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 88,  0,  0,  0,  0,  0,
  0,  0,  0,  0, 88,  0,  0,  0,  0, 94,  0, 88,  0,  0,  0, 94,
  0,  0, 88,  0, 94,  0,  0,  0, 88,  0, 88, 88,  0,  0,  0,  0,
  0, 88, 88,  0, 94,  0, 88,  0,  0,  0,  0,  0,  0,  0,  0, 88,
  0,  0,  0, 88,  0,  0,  0, 65,  0, 88,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0, 88,  0,  0,  0,  0,  0,  0, 88,  0, 88,
  0,  0, 94,  0,  0,  0,  0,  0, 94, 94, 94,  0,  0, 88,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 94, 88,  0,  0, 94, 75,
 75, 75, 75, 75,  0, 75, 75,  0, 75, 75, 75, 75, 75, 75,  0, 75,
  0, 75, 75, 75,  0, 75, 75, 75, 75, 75, 75,  0,  0, 75, 75, 75,
  0, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75,  0, 75, 75,
  0, 75,  0,  0,  0, 75,  0, 75, 75,  0, 75, 75, 75,  0, 75,  0,
  0,  0,  0, 75, 75,  0, 75, 75, 75, 75, 75, 75, 75, 75,  0,  0,
 75, 75,  0, 75,  0, 94,  0,  0, 88, 94,  0,  0,  0, 94, 75, 95,
  0, 88, 75,  0,  0,  0,  0, 75, 90,  0,  0, 90, 88,  0,  0,  0,
  0, 88, 95, 95,  0, 88,  0, 94,  0,  0,  0,  0,  0, 95,  0, 95,
  0,  0,  0,  0,  0, 94, 90,  0,  0, 88, 88,  0,  0, 88,  0,  0,
  0,  0,  0,  0, 98, 65,  0,  0, 90, 88, 88, 95, 88, 75, 95, 88,
  0,  0,  0, 65, 90,  0,  0,  0,  0, 75,  0,  0, 88, 95, 95, 90,
 88, 98, 88,  0, 95,  0,  0,  0, 95, 88,  0, 95, 95, 90, 94, 75,
 90,  0, 75,  0,  0, 90,  0, 75, 94, 75, 75,  0,  0,  0,  0, 90,
  0,  0,  0,  0, 94,  0, 88, 88,  0, 90,  0, 90, 90, 88, 75,  0,
  0,  0,  0,  0,  0,  0,  0, 94, 94,  0,  0, 75,  0, 75, 95,  0,
 75,  0,  0, 95,  0, 88,  0, 75,  0, 75,  0,  0,  0,  0,  0,  0,
 95, 88, 75,  0,  0,  0,  0,  0,  0,  0,  0,  0, 90,  0,  0, 75,
  0,  0,  0,  0,  0,  0,  0, 75,  0, 75,  0, 95,  0, 75, 90,  0,
  0,  0,  0,  0, 75,  0,  0,  0,  0,  0, 94, 94,  0,  0, 94, 88,
 75, 75, 94,  0, 88,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 94,
 88, 94, 88, 88,  0,  0, 88, 94,  0,  0, 94,  0, 94,  0,  0,  0,
  0,  0, 88,  0,  0,  0, 88, 94,  0,  0,  0,  0,  0,  0,  0, 75,
 75,  0,  0, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 94,  0,  0,
 65,  0,  0,  0,  0, 94,  0,  0,  0, 75, 75, 75, 94, 88,  0, 75,
 90,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,
 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0, 95, 98, 95, 95, 95, 95, 98, 95, 95, 95, 95, 95, 98, 95, 95,
 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 98, 95, 95, 95,
 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95,
 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 98,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 98, 98, 65, 95,  0, 95, 65,
};
