static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" * Copyright 2008 Hubert Figuière <hub@figuiere.net>                         \n"
" * Copyright 2011 Chong Kai Xiong <w_velocity@yahoo.com>                      \n"
" * Copyright 2011 Paul Sbarra <tones111@hotmail.com>                          \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, \"File\", \"\")                                     \n"
"  description (_(\"Path of file to load.\"))                                  \n"
"property_int (image_num, \"Image number\", 0)                                 \n"
"property_int (quality, \"quality\", 10)                                       \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#include \"gegl-plugin.h\"                                                    \n"
"struct _GeglOp                                                                \n"
"{                                                                             \n"
"  GeglOperationSource parent_instance;                                        \n"
"  gpointer            properties;                                             \n"
"};                                                                            \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  GeglOperationSourceClass parent_class;                                      \n"
"} GeglOpClass;                                                                \n"
"                                                                              \n"
"#define GEGL_OP_NAME raw_load                                                 \n"
"#define GEGL_OP_C_SOURCE raw-load.c                                           \n"
"#include \"gegl-op.h\"                                                        \n"
"GEGL_DEFINE_DYNAMIC_OPERATION(GEGL_TYPE_OPERATION_SOURCE)                     \n"
"                                                                              \n"
"#include <stdio.h>                                                            \n"
"#include <libraw.h>                                                           \n"
"                                                                              \n"
"#include <stdio.h>                                                            \n"
"#include <string.h>                                                           \n"
"#include <libraw/libraw.h>                                                    \n"
"                                                                              \n"
"typedef struct {                                                              \n"
"  libraw_data_t            *LibRaw;                                           \n"
"  libraw_processed_image_t *image;                                            \n"
"  gchar                    *cached_path;                                      \n"
"} Private;                                                                    \n"
"                                                                              \n"
"static void                                                                   \n"
"raw_close (GeglProperties *o)                                                 \n"
"{                                                                             \n"
"  Private *p = (Private*)o->user_data;                                        \n"
"                                                                              \n"
"  g_clear_pointer (&p->cached_path, g_free);                                  \n"
"  g_clear_pointer (&p->image, (GDestroyNotify) libraw_dcraw_clear_mem);       \n"
"  g_clear_pointer (&p->LibRaw, (GDestroyNotify) libraw_close);                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Private    *p = (Private*)o->user_data;                                     \n"
"  int         ret;                                                            \n"
"                                                                              \n"
"  if (p == NULL)                                                              \n"
"    {                                                                         \n"
"      p = g_new0(Private, 1);                                                 \n"
"      o->user_data = (gpointer)p;                                             \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (p->cached_path && strcmp (p->cached_path, o->path))                     \n"
"  {                                                                           \n"
"     raw_close (o);                                                           \n"
"  }                                                                           \n"
"                                                                              \n"
"  if (p->LibRaw == NULL)                                                      \n"
"    {                                                                         \n"
"      g_return_if_fail (p->image == NULL);                                    \n"
"                                                                              \n"
"      if ((p->LibRaw = libraw_init(LIBRAW_OPTIONS_NONE)) == NULL)             \n"
"        g_warning (\"raw-load: Error Initializing raw library\");             \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          p->LibRaw->params.shot_select = o->image_num;                       \n"
"                                                                              \n"
"          p->LibRaw->params.aber[0] = 1.0;                                    \n"
"          p->LibRaw->params.aber[2] = 1.0;                                    \n"
"          p->LibRaw->params.gamm[0] = 1.0 / 2.4;                              \n"
"          p->LibRaw->params.gamm[1] = 12.92;                                  \n"
"          p->LibRaw->params.bright = 1.0f;                                    \n"
"          p->LibRaw->params.half_size = FALSE;                                \n"
"          p->LibRaw->params.highlight = 0;                                    \n"
"          p->LibRaw->params.use_auto_wb = TRUE;                               \n"
"          p->LibRaw->params.use_camera_wb = TRUE;                             \n"
"          p->LibRaw->params.use_camera_matrix = 1;                            \n"
"          p->LibRaw->params.output_color = 1;                                 \n"
"          p->LibRaw->params.user_flip = 0;                                    \n"
"          p->LibRaw->params.no_auto_bright = 1;                               \n"
"          p->LibRaw->params.auto_bright_thr = 0.01f;                          \n"
"          p->LibRaw->params.use_fuji_rotate = -1;                             \n"
"                                                                              \n"
"          p->LibRaw->params.output_bps = 16;                                  \n"
"          p->LibRaw->params.user_qual = o->quality;                           \n"
"                                                                              \n"
"          if ((ret = libraw_open_file(p->LibRaw, o->path)) != LIBRAW_SUCCESS) \n"
"          {                                                                   \n"
"                                                                              \n"
"            g_warning (\"raw-load: Unable to open %s: %s\", o->path, libraw_strerror (ret));\n"
"          }                                                                   \n"
"          else                                                                \n"
"          {                                                                   \n"
"            p->cached_path = strdup (o->path);                                \n"
"          }                                                                   \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglProperties *o      = GEGL_PROPERTIES (operation);                       \n"
"  Private        *p      = (Private*)o->user_data;                            \n"
"  GeglRectangle  result = {0,0,0,0};                                          \n"
"                                                                              \n"
"  if (p == NULL)                                                              \n"
"    {                                                                         \n"
"      prepare(operation);                                                     \n"
"      p = (Private*)o->user_data;                                             \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (p->LibRaw != NULL &&                                                    \n"
"      (p->LibRaw->progress_flags & LIBRAW_PROGRESS_IDENTIFY))                 \n"
"    {                                                                         \n"
"      switch (p->LibRaw->sizes.flip)                                          \n"
"      {                                                                       \n"
"        case 5:                                                               \n"
"        case 6:                                                               \n"
"          result.width  = p->LibRaw->sizes.height;                            \n"
"          result.height = p->LibRaw->sizes.width;                             \n"
"          break;                                                              \n"
"        default:                                                              \n"
"          result.width  = p->LibRaw->sizes.width;                             \n"
"          result.height = p->LibRaw->sizes.height;                            \n"
"          break;                                                              \n"
"      }                                                                       \n"
"      gegl_operation_set_format (operation, \"output\", babl_format (\"R'G'B' u16\"));\n"
"    }                                                                         \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         int                  level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Private *p = (Private*)o->user_data;                                        \n"
"  GeglRectangle rect = {0,0,0,0};                                             \n"
"  const Babl *format = NULL;                                                  \n"
"  int ret;                                                                    \n"
"                                                                              \n"
"  g_assert (p);                                                               \n"
"                                                                              \n"
"  if (p->LibRaw != NULL)                                                      \n"
"    {                                                                         \n"
"      if (!(p->LibRaw->progress_flags & LIBRAW_PROGRESS_LOAD_RAW))            \n"
"        {                                                                     \n"
"          if ((ret = libraw_unpack(p->LibRaw)) != LIBRAW_SUCCESS)             \n"
"            g_warning (\"raw-load: Error unpacking data: %s\", libraw_strerror (ret));\n"
"                                                                              \n"
"          if (ret == LIBRAW_SUCCESS && !(p->LibRaw->progress_flags & LIBRAW_PROGRESS_CONVERT_RGB))\n"
"            {                                                                 \n"
"              if ((ret = libraw_dcraw_process(p->LibRaw)) != LIBRAW_SUCCESS)  \n"
"                g_warning (\"raw-load: Error processing data: %s\", libraw_strerror (ret));\n"
"              else if ((p->image = libraw_dcraw_make_mem_image(p->LibRaw, &ret)) == NULL)\n"
"                g_warning (\"raw-load: Error converting image: %s\", libraw_strerror (ret));\n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (p->image != NULL)                                                       \n"
"    {                                                                         \n"
"      g_assert (p->image->type == LIBRAW_IMAGE_BITMAP);                       \n"
"      rect.width  = p->image->width;                                          \n"
"      rect.height = p->image->height;                                         \n"
"                                                                              \n"
"      if (p->image->colors == 1)                                              \n"
"        format = babl_format (\"Y' u16\");                                    \n"
"      else // 3 color channels                                                \n"
"        format = babl_format (\"R'G'B' u16\");                                \n"
"                                                                              \n"
"      gegl_buffer_set (output, &rect, 0, format, p->image->data, GEGL_AUTO_ROWSTRIDE);\n"
"      return TRUE;                                                            \n"
"    }                                                                         \n"
"                                                                              \n"
"  return FALSE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (object);                               \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      raw_close (o);                                                          \n"
"      g_free (o->user_data);                                                  \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize(object);                    \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  static gboolean done = FALSE;                                               \n"
"                                                                              \n"
"  GObjectClass             *object_class;                                     \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationSourceClass *source_class;                                     \n"
"                                                                              \n"
"  object_class    = G_OBJECT_CLASS (klass);                                   \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  source_class = GEGL_OPERATION_SOURCE_CLASS (klass);                         \n"
"                                                                              \n"
"  operation_class->prepare     = prepare;                                     \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  source_class->process = process;                                            \n"
"  object_class->finalize = finalize;                                          \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:raw-load\",                                       \n"
"    \"title\",       _(\"libraw File Loader\"),                               \n"
"    \"categories\",  \"hidden\",                                              \n"
"    \"description\", \"Camera RAW image loader\",                             \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"  if (done)                                                                   \n"
"    return;                                                                   \n"
"                                                                              \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \"image/x-pentax-pef\", \"gegl:raw-load\");                               \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \".pef\", \"gegl:raw-load\");                                             \n"
"                                                                              \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \"image/x-nikon-nef\", \"gegl:raw-load\");                                \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \".nef\", \"gegl:raw-load\");                                             \n"
"                                                                              \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \"image/x-fuji-raf\", \"gegl:raw-load\");                                 \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \".raf\", \"gegl:raw-load\");                                             \n"
"                                                                              \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \"image/x-olympus-orf\", \"gegl:raw-load\");                              \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \".orf\", \"gegl:raw-load\");                                             \n"
"                                                                              \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \"image/x-epson-erf\", \"gegl:raw-load\");                                \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \".erf\", \"gegl:raw-load\");                                             \n"
"                                                                              \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \"image/x-minolta-mrw\", \"gegl:raw-load\");                              \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \".mrw\", \"gegl:raw-load\");                                             \n"
"                                                                              \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \"image/x-canon-crw\", \"gegl:raw-load\");                                \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \".crw\", \"gegl:raw-load\");                                             \n"
"                                                                              \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \"image/x-canon-cr2\", \"gegl:raw-load\");                                \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \".cr2\", \"gegl:raw-load\");                                             \n"
"                                                                              \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \"image/x-sony-arw\", \"gegl:raw-load\");                                 \n"
"  gegl_operation_handlers_register_loader (                                   \n"
"    \".arw\", \"gegl:raw-load\");                                             \n"
"                                                                              \n"
" done = TRUE;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
