static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2014 Michael Natterer <mitch@gimp.org>                           \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_format (input_format, _(\"Input format\"), NULL)                     \n"
"    description(_(\"The babl format of the input\"))                          \n"
"property_format (output_format, _(\"Output format\"), NULL)                   \n"
"    description(_(\"The babl format of the output\"))                         \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_NAME     cast_format                                          \n"
"#define GEGL_OP_C_SOURCE cast-format.c                                        \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  if (o->input_format)                                                        \n"
"    gegl_operation_set_format (operation, \"input\", o->input_format);        \n"
"                                                                              \n"
"  if (o->output_format)                                                       \n"
"    gegl_operation_set_format (operation, \"output\", o->output_format);      \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation        *operation,                                     \n"
"         GeglOperationContext *context,                                       \n"
"         const gchar          *output_prop,                                   \n"
"         const GeglRectangle  *roi,                                           \n"
"         gint                  level)                                         \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglBuffer *input;                                                          \n"
"  GeglBuffer *output;                                                         \n"
"                                                                              \n"
"  if (! o->input_format || ! o->output_format)                                \n"
"    {                                                                         \n"
"      g_warning (\"cast-format: input-format or output-format are not set\"); \n"
"      return FALSE;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (babl_format_get_bytes_per_pixel (o->input_format) !=                    \n"
"      babl_format_get_bytes_per_pixel (o->output_format))                     \n"
"    {                                                                         \n"
"      g_warning (\"cast-format: input-format and output-format have different bpp\");\n"
"      return FALSE;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (strcmp (output_prop, \"output\"))                                       \n"
"    {                                                                         \n"
"      g_warning (\"cast-format: requested processing of %s pad\", output_prop);\n"
"      return FALSE;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  input = gegl_operation_context_get_source (context, \"input\");             \n"
"  if (! input)                                                                \n"
"    {                                                                         \n"
"      g_warning (\"cast: received NULL input\");                              \n"
"      return FALSE;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  output = gegl_buffer_new (roi, o->input_format);                            \n"
"                                                                              \n"
"  gegl_buffer_copy (input,  roi, GEGL_ABYSS_NONE,                             \n"
"                    output, roi);                                             \n"
"  gegl_buffer_set_format (output, o->output_format);                          \n"
"                                                                              \n"
"  g_object_unref (input);                                                     \n"
"                                                                              \n"
"  gegl_operation_context_take_object (context, \"output\", G_OBJECT (output));\n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass *operation_class = GEGL_OPERATION_CLASS (klass);         \n"
"                                                                              \n"
"  operation_class->prepare  = prepare;                                        \n"
"  operation_class->process  = process;                                        \n"
"  operation_class->no_cache = FALSE;                                          \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",       \"gegl:cast-format\",                                     \n"
"    \"title\",      _(\"Cast Format\"),                                       \n"
"    \"categories\", \"core:color\",                                           \n"
"    \"description\", _(\"Cast the data between input_format and output_format, \"\n"
"                     \"both formats must have the same bpp\"),                \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
