static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright (C) 1997 Hirotsuna Mizuno <s1041150@u-aizu.ac.jp>                \n"
" * Copyright (C) 2011 Robert Sasu <sasu.robert@gmail.com>                     \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"enum_start (gegl_fractal_trace_type)                                          \n"
"  enum_value (GEGL_FRACTAL_TRACE_TYPE_MANDELBROT, \"mandelbrot\", N_(\"Mandelbrot\"))\n"
"  enum_value (GEGL_FRACTAL_TRACE_TYPE_JULIA,      \"julia\",      N_(\"Julia\"))\n"
"enum_end (GeglFractalTraceType)                                               \n"
"                                                                              \n"
"property_enum (fractal, _(\"Fractal type\"),                                  \n"
"               GeglFractalTraceType, gegl_fractal_trace_type,                 \n"
"               GEGL_FRACTAL_TRACE_TYPE_MANDELBROT)                            \n"
"                                                                              \n"
"property_double (X1, _(\"X1\"), -1.0)                                         \n"
"  description   (_(\"X1 value, position\"))                                   \n"
"  value_range   (-50.0, 50.0)                                                 \n"
"                                                                              \n"
"property_double (X2, _(\"X2\"), 0.50)                                         \n"
"  description   (_(\"X2 value, position\"))                                   \n"
"  value_range   (-50.0, 50.0)                                                 \n"
"                                                                              \n"
"property_double (Y1, _(\"Y1\"), -1.0)                                         \n"
"  description   (_(\"Y1 value, position\"))                                   \n"
"  value_range   (-50.0, 50.0)                                                 \n"
"                                                                              \n"
"property_double (Y2, _(\"Y2\"), 1.0)                                          \n"
"  description   (_(\"Y2 value, position\"))                                   \n"
"  value_range   (-50.0, 50.0)                                                 \n"
"                                                                              \n"
"property_double (JX, _(\"JX\"), 0.5)                                          \n"
"  description (_(\"Julia seed X value, position\"))                           \n"
"  value_range   (-50.0, 50.0)                                                 \n"
"  ui_meta       (\"visible\", \"fractal {julia}\")                            \n"
"                                                                              \n"
"property_double (JY, _(\"JY\"), 0.5)                                          \n"
"  description (_(\"Julia seed Y value, position\"))                           \n"
"  value_range   (-50.0, 50.0)                                                 \n"
"  ui_meta       (\"visible\", \"$JX.visible\")                                \n"
"                                                                              \n"
"property_int    (depth, _(\"Depth\"), 3)                                      \n"
"  value_range   (1, 65536)                                                    \n"
"                                                                              \n"
"property_double (bailout, _(\"Bailout length\"), G_MAXDOUBLE)                 \n"
"  value_range   (0.0, G_MAXDOUBLE)                                            \n"
"                                                                              \n"
"property_enum   (abyss_policy, _(\"Abyss policy\"),                           \n"
"                   GeglAbyssPolicy, gegl_abyss_policy, GEGL_ABYSS_LOOP)       \n"
"  description   (_(\"How to deal with pixels outside of the input buffer\"))  \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_NAME     fractal_trace                                        \n"
"#define GEGL_OP_C_SOURCE fractal-trace.c                                      \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\",  babl_format (\"RGBA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"julia (gdouble  x,                                                            \n"
"       gdouble  y,                                                            \n"
"       gdouble  jx,                                                           \n"
"       gdouble  jy,                                                           \n"
"       gdouble *u,                                                            \n"
"       gdouble *v,                                                            \n"
"       gint     depth,                                                        \n"
"       gdouble  bailout2)                                                     \n"
"{                                                                             \n"
"  gint    i;                                                                  \n"
"  gdouble xx = x;                                                             \n"
"  gdouble yy = y;                                                             \n"
"                                                                              \n"
"  for (i = 0; i < depth; i++)                                                 \n"
"    {                                                                         \n"
"      gdouble x2, y2, tmp;                                                    \n"
"                                                                              \n"
"      x2 = xx * xx;                                                           \n"
"      y2 = yy * yy;                                                           \n"
"      tmp = x2 - y2 + jx;                                                     \n"
"      yy  = 2 * xx * yy + jy;                                                 \n"
"      xx  = tmp;                                                              \n"
"                                                                              \n"
"      if ((x2 + y2) > bailout2)                                               \n"
"        break;                                                                \n"
"    }                                                                         \n"
"                                                                              \n"
"  *u = xx;                                                                    \n"
"  *v = yy;                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"fractaltrace (GeglBuffer            *input,                                   \n"
"              GeglSampler           *sampler,                                 \n"
"              const GeglRectangle   *picture,                                 \n"
"              gfloat                *dst_buf,                                 \n"
"              const GeglRectangle   *roi,                                     \n"
"              GeglProperties        *o,                                       \n"
"              gint                   y,                                       \n"
"              GeglFractalTraceType   fractal_type,                            \n"
"              const Babl            *format,                                  \n"
"              gint                   level)                                   \n"
"{                                                                             \n"
"  GeglMatrix2  scale;        /* a matrix indicating scaling factors around the\n"
"                                current center pixel.                         \n"
"                              */                                              \n"
"  gint         x, i, offset;                                                  \n"
"  gdouble      scale_x, scale_y;                                              \n"
"  gdouble      bailout2;                                                      \n"
"  gfloat       dest[4];                                                       \n"
"                                                                              \n"
"  scale_x = (o->X2 - o->X1) / picture->width;                                 \n"
"  scale_y = (o->Y2 - o->Y1) / picture->height;                                \n"
"                                                                              \n"
"  bailout2 = o->bailout * o->bailout;                                         \n"
"                                                                              \n"
"  offset = (y - roi->y) * roi->width * 4;                                     \n"
"                                                                              \n"
"  for (x = roi->x; x < roi->x + roi->width; x++)                              \n"
"    {                                                                         \n"
"      gdouble cx, cy;                                                         \n"
"      gdouble px, py;                                                         \n"
"      dest[1] = dest[2] = dest[3] = dest[0] = 0.0;                            \n"
"                                                                              \n"
"      switch (fractal_type)                                                   \n"
"        {                                                                     \n"
"        case GEGL_FRACTAL_TRACE_TYPE_JULIA:                                   \n"
"#define gegl_unmap(u,v,ud,vd) {                                         \\    \n"
"            gdouble rx, ry;                                             \\    \n"
"            cx = o->X1 + ((u) - picture->x) * scale_x;                  \\    \n"
"            cy = o->Y1 + ((v) - picture->y) * scale_y;                  \\    \n"
"            julia (cx, cy, o->JX, o->JY, &rx, &ry, o->depth, bailout2); \\    \n"
"            ud = (rx - o->X1) / scale_x + picture->x;                   \\    \n"
"            vd = (ry - o->Y1) / scale_y + picture->y;                   \\    \n"
"          }                                                                   \n"
"        gegl_sampler_compute_scale (scale, x, y);                             \n"
"        gegl_unmap(x,y,px,py);                                                \n"
"#undef gegl_unmap                                                             \n"
"        break;                                                                \n"
"                                                                              \n"
"        case GEGL_FRACTAL_TRACE_TYPE_MANDELBROT:                              \n"
"#define gegl_unmap(u,v,ud,vd) {                                     \\        \n"
"            gdouble rx, ry;                                         \\        \n"
"            cx = o->X1 + ((u) - picture->x) * scale_x;              \\        \n"
"            cy = o->Y1 + ((v) - picture->y) * scale_y;              \\        \n"
"            julia (cx, cy, cx, cy, &rx, &ry, o->depth, bailout2);   \\        \n"
"            ud = (rx - o->X1) / scale_x + picture->x;               \\        \n"
"            vd = (ry - o->Y1) / scale_y + picture->y;               \\        \n"
"          }                                                                   \n"
"        gegl_sampler_compute_scale (scale, x, y);                             \n"
"        gegl_unmap(x,y,px,py);                                                \n"
"#undef gegl_unmap                                                             \n"
"        break;                                                                \n"
"                                                                              \n"
"        default:                                                              \n"
"          g_error (_(\"Unsupported fractal type\"));                          \n"
"        }                                                                     \n"
"                                                                              \n"
"      gegl_sampler_get (sampler, px, py, &scale, dest, o->abyss_policy);      \n"
"                                                                              \n"
"      for (i = 0; i < 4; i++)                                                 \n"
"        dst_buf[offset++] = dest[i];                                          \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties    *o = GEGL_PROPERTIES (operation);                         \n"
"  GeglRectangle  boundary;                                                    \n"
"  const Babl    *format;                                                      \n"
"  GeglSampler   *sampler;                                                     \n"
"  gfloat        *dst_buf;                                                     \n"
"  gint           y;                                                           \n"
"                                                                              \n"
"  boundary = gegl_operation_get_bounding_box (operation);                     \n"
"                                                                              \n"
"  format = babl_format (\"RGBA float\");                                      \n"
"  dst_buf = g_new0 (gfloat, result->width * result->height * 4);              \n"
"  sampler = gegl_buffer_sampler_new_at_level (input, format, GEGL_SAMPLER_CUBIC, level);\n"
"                                                                              \n"
"  for (y = result->y; y < result->y + result->height; y++)                    \n"
"    fractaltrace (input, sampler, &boundary, dst_buf, result, o, y, o->fractal, format, level);\n"
"                                                                              \n"
"  gegl_buffer_set (output, result, 0, format, dst_buf, GEGL_AUTO_ROWSTRIDE);  \n"
"  g_object_unref (sampler);                                                   \n"
"                                                                              \n"
"  g_free (dst_buf);                                                           \n"
"                                                                              \n"
"  gegl_buffer_sample_cleanup (input);                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle  result = { 0, 0, 0, 0 };                                     \n"
"  GeglRectangle *in_rect;                                                     \n"
"                                                                              \n"
"  in_rect = gegl_operation_source_get_bounding_box (operation, \"input\");    \n"
"  if (!in_rect)                                                               \n"
"    return result;                                                            \n"
"                                                                              \n"
"  return *in_rect;                                                            \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  return get_bounding_box (operation);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  operation_class->prepare                 = prepare;                         \n"
"  operation_class->get_bounding_box        = get_bounding_box;                \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"                                                                              \n"
"  filter_class->process                    = process;                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",               \"gegl:fractal-trace\",                           \n"
"    \"title\",              _(\"Fractal Trace\"),                             \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"categories\",         \"map\",                                          \n"
"    \"license\",            \"GPL3+\",                                        \n"
"    \"reference-hash\",     \"c4cf80fc9db401ebeedb30cabf7b4921\",             \n"
"    \"description\", _(\"Transform the image with the fractals\"),            \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
