/* BSE - Bedevilled Sound Engine
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * bsemem.h: private file to implement helper macros for GMemChunk allocations
 */
#ifndef __BSE_MEM_H__
#define __BSE_MEM_H__


#include	"glib_extra.h"
#include	<bse/bsedefs.h>


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */



/* --- BSE Allocators --- */
#define bse_callback_node_chunk_new()	(GMEMCHUNK_HELPER_ALLOC_1 (BseCallbackNode))
#define bse_callback_node_chunk_new0()	(GMEMCHUNK_HELPER_ALLOC_0 (BseCallbackNode))
#define bse_instrument_chunk_new()	(GMEMCHUNK_HELPER_ALLOC_1 (BseInstrument))
#define bse_instrument_chunk_new0()	(GMEMCHUNK_HELPER_ALLOC_0 (BseInstrument))
#define bse_pattern_chunk_new()		(GMEMCHUNK_HELPER_ALLOC_1 (BsePattern))
#define bse_pattern_chunk_new0()	(GMEMCHUNK_HELPER_ALLOC_0 (BsePattern))
#define bse_sequencer_chunk_new()	(GMEMCHUNK_HELPER_ALLOC_1 (BseSequencer))
#define bse_sequencer_chunk_new0()	(GMEMCHUNK_HELPER_ALLOC_0 (BseSequencer))


/* --- BSE Deallocators --- */
#define bse_callback_node_chunk_free(m)	(GMEMCHUNK_HELPER_FREE (BseCallbackNode, (m)))
#define bse_instrument_chunk_free(m)	(GMEMCHUNK_HELPER_FREE (BseInstrument, (m)))
#define bse_pattern_chunk_free(m)	(GMEMCHUNK_HELPER_FREE (BsePattern, (m)))
#define bse_sequencer_chunk_free(m)	(GMEMCHUNK_HELPER_FREE (BseSequencer, (m)))


/* --- BSE Mem Chunk List --- */
#define BSE_MEM_CHUNK_LIST()	\
  GMEMCHUNK_HELPER_ITERATOR (BseCallbackNode,	64,	ALLOC_AND_FREE); \
  GMEMCHUNK_HELPER_ITERATOR (BseInstrument,	32,	ALLOC_AND_FREE); \
  GMEMCHUNK_HELPER_ITERATOR (BsePattern,	64,	ALLOC_AND_FREE); \
  GMEMCHUNK_HELPER_ITERATOR (BseSequencer,	4,	ALLOC_AND_FREE) \


/* --- Mem Chunk Declarations --- */
#undef	GMEMCHUNK_HELPER_ITERATOR
#define GMEMCHUNK_HELPER_ITERATOR	GMEMCHUNK_HELPER_DECLARE_EXTERN
BSE_MEM_CHUNK_LIST();
#undef	GMEMCHUNK_HELPER_ITERATOR






#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif /* __BSE_MEM_H__ */
