/* BEAST - Bedevilled Audio System
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#include	"bstrcargs.h"
#include	"gtkitemfactory.h"
#include	<stdarg.h>
#include	<fcntl.h>
#include	<stdio.h>
#include	<sys/stat.h>
#include	<unistd.h>

/* --- prototypes --- */
static guint	ifactory_parser	(GScanner		*scanner,
				 BstRcCallback		*cb_arg);
static void	ifactory_dumper	(void			*stream,
				 BstRcCallback		*cb_arg,
				 gchar			*indent);
static guint	scache_parser	(GScanner		*scanner,
				 BstRcCallback		*cb_arg);
static void	scache_dumper	(void			*stream,
				 BstRcCallback		*cb_arg,
				 gchar			*indent);


/* --- variables --- */
static BST_RCARG_DECLARATE (Bool, TRACK_SHELL_MOVEMENTS) =
{
  BST_RC_BOOL, "track-shell-movement",
  0 | BST_RC_FORCE_DUMP | BST_RC_PREFERENCES,
  "Track movement of the BEAST shell window",
  TRUE, 0
};
static BST_RCARG_DECLARATE (Long, SHELL_INIT_X) =
{
  BST_RC_LONG, "shell-init-x",
  0 | BST_RC_FORCE_DUMP,
  "Initial X-position for the BEAST shell window",
  10, 0,
  -2, 4096
};
static BST_RCARG_DECLARATE (Long, SHELL_INIT_Y) =
{
  BST_RC_LONG, "shell-init-y",
  0 | BST_RC_FORCE_DUMP,
  "Initial Y-position for the BEAST shell window",
  10, 0,
  -2, 4096
};
static BST_RCARG_DECLARATE (Bool, AUTO_PATTERN_VIEW) =
{
  BST_RC_BOOL, "auto-popup-pattern-view",
  0 | BST_RC_FORCE_DUMP | BST_RC_PREFERENCES,
  "Automatically popup pattern views?",
  FALSE, 0
};
static BST_RCARG_DECLARATE (Bool, AUTO_INSTRUMENT_LIST) =
{
  BST_RC_BOOL, "auto-popup-instrument-list",
  0 | BST_RC_FORCE_DUMP | BST_RC_PREFERENCES,
  "Automatically popup instrument lists?",
  TRUE, 0
};
static BST_RCARG_DECLARATE (String, KEYTABLE) =
{
  BST_RC_STRING, "pattern-keytable",
  0 | BST_RC_FORCE_DUMP | BST_RC_PREFERENCES,
  "Keytable to be used for the Pattern Editor\n"
  "Possible values are currently 'US' and 'DE'",
  "DE", NULL
};
static BST_RCARG_DECLARATE (StringList, SAMPLE_PATH_LIST) =
{
  BST_RC_STRING_LIST, "sample-path",
  0 | BST_RC_FORCE_DUMP | BST_RC_PREFERENCES,
  "Directory list to search for sample files",
  NULL, NULL
};
BstRcUnion		*bst_rc_args[] =
{
#define	BST_RCARG_ITERATOR	BST_RCARG_ITERATOR_STRUC
  BST_RCARGS_DEFS ()
#undef	BST_RCARG_ITERATOR
};
static guint bst_rc_n_args = sizeof (bst_rc_args) / sizeof (bst_rc_args[0]);
static BstRcCallback	menu_callback_arg =
{
  BST_RC_CALLBACK, "menu-bindings",
  0 | BST_RC_AUTOMATIC,
  "List of menu paths and their corresponding accelerator bindings",
  NULL, NULL,
  ifactory_parser,
  ifactory_dumper,
  NULL,
  NULL, NULL, NULL,
};
static BstRcCallback	sample_cache_arg =
{
  BST_RC_CALLBACK, "sample-cache",
  0 | BST_RC_AUTOMATIC,
  "Associative list of sample-name <-> sample-location pairs",
  NULL, NULL,
  scache_parser,
  scache_dumper,
  NULL,
  NULL, NULL, NULL,
};


/* --- functions --- */
void
bst_rc_args_init (void)
{
  static guint initialized = FALSE;
  
  if (!initialized)
    {
      GtkItemFactoryClass *ifactory_class;
      guint i;
      
      initialized = TRUE;
      
      g_assert (bst_rc_n_args == BST_RCIDX_LAST);
      
      for (i = 0; i < bst_rc_n_args; i++)
	bst_rc_add_arg (bst_rc_args [i]);

      bst_rc_add_arg ((BstRcUnion*) &menu_callback_arg);
      bst_rc_add_arg ((BstRcUnion*) &sample_cache_arg);

      ifactory_class = gtk_type_class (gtk_item_factory_get_type ());
      g_free (ifactory_class->cpair_comment_single);
      ifactory_class->cpair_comment_single = g_strdup (";\n");
    }
}

static guint
ifactory_parser (GScanner		*scanner,
		 BstRcCallback		*cb_arg)
{
  gtk_item_factory_parse_rc_scanner (scanner);

  g_scanner_get_next_token (scanner);

  return scanner->token == ')' ? G_TOKEN_NONE : ')';
}

static guint
scache_parser (GScanner		*scanner,
	       BstRcCallback	*cb_arg)
{
  bse_sample_cache_parse_rc_scanner (scanner);

  g_scanner_get_next_token (scanner);

  return scanner->token == ')' ? G_TOKEN_NONE : ')';
}

static void
arg_print_func (gpointer  user_data,
		gchar	 *str)
{
  gpointer *d = user_data;
  FILE *f_out = d[0];
  gchar *indent = d[1];

  fputs (indent, f_out);
  fputs (str, f_out);
  fputc ('\n', f_out);
}

static void
ifactory_dumper (void			*stream,
		 BstRcCallback		*cb_arg,
		 gchar			*indent)
{
  gpointer d[2];

  d[0] = stream;
  d[1] = indent;
  fputc ('\n', stream);
  gtk_item_factory_dump_rc (NULL, FALSE, arg_print_func, d);
}

static void
scache_dumper (void			*stream,
	       BstRcCallback		*cb_arg,
	       gchar			*indent)
{
  gpointer d[2];

  d[0] = stream;
  d[1] = indent;
  fputc ('\n', stream);
  bse_sample_cache_dump_rc (NULL, FALSE, arg_print_func, d);
}
