/* BEAST - Bedevilled Audio System
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#include	"bstpatterneditor.h"
#include	<gdk/gdkkeysyms.h>



typedef	struct _BstPatternEditorKey	BstPatternEditorKey;
struct _BstPatternEditorKey
{
  guint16 keyval;
  guint16 modifier;
  guint32 pe_action;
};

#define	Z_WRAP		(0)
#define	C_WRAP		(BST_PEA_WRAP_AS_CONFIG)
#define	N_WRAP		(BST_PEA_WRAP_AS_CONFIG)
#define	P_WRAP		(BST_PEA_WRAP_TO_PATTERN)
#define	SET_INSTR	(BST_PEA_SET_INSTRUMENT_0F | Z_WRAP)
#define	SET_BASEO	(BST_PEA_AFFECT_BASE_OCTAVE | Z_WRAP)

/* BST_PEA(note,shift,instrument,zero,movement,flags); */
static BstPatternEditorKey	bst_pea_ktab_de[] = {
  /* set lower octave and default instrument (0F) */
  { '<',		BST_MOD (000),	BST_PEA (C  ,DOWN,0F,0,NEXT,C_WRAP) },
  { 'a',		BST_MOD (000),	BST_PEA (Cis,DOWN,0F,0,NEXT,C_WRAP) },
  { 'y',		BST_MOD (000),	BST_PEA (D  ,DOWN,0F,0,NEXT,C_WRAP) },
  { 's',		BST_MOD (000),	BST_PEA (Dis,DOWN,0F,0,NEXT,C_WRAP) },
  { 'x',		BST_MOD (000),	BST_PEA (E  ,DOWN,0F,0,NEXT,C_WRAP) },
  { 'c',		BST_MOD (000),	BST_PEA (F  ,DOWN,0F,0,NEXT,C_WRAP) },
  { 'f',		BST_MOD (000),	BST_PEA (Fis,DOWN,0F,0,NEXT,C_WRAP) },
  { 'v',		BST_MOD (000),	BST_PEA (G  ,DOWN,0F,0,NEXT,C_WRAP) },
  { 'g',		BST_MOD (000),	BST_PEA (Gis,DOWN,0F,0,NEXT,C_WRAP) },
  { 'b',		BST_MOD (000),	BST_PEA (A  ,DOWN,0F,0,NEXT,C_WRAP) },
  { 'h',		BST_MOD (000),	BST_PEA (Ais,DOWN,0F,0,NEXT,C_WRAP) },
  { 'n',		BST_MOD (000),	BST_PEA (B  ,DOWN,0F,0,NEXT,C_WRAP) },
  { 'm',		BST_MOD (000),	BST_PEA (C  ,0	 ,0F,0,NEXT,C_WRAP) },
  { 'k',		BST_MOD (000),	BST_PEA (Cis,0	 ,0F,0,NEXT,C_WRAP) },
  { ',',		BST_MOD (000),	BST_PEA (D  ,0	 ,0F,0,NEXT,C_WRAP) },
  { 'l',		BST_MOD (000),	BST_PEA (Dis,0	 ,0F,0,NEXT,C_WRAP) },
  { '.',		BST_MOD (000),	BST_PEA (E  ,0	 ,0F,0,NEXT,C_WRAP) },
  /* set lower octave without instrument (with SHIFT) */
  { '>',		BST_MOD (S00),	BST_PEA (C  ,DOWN,00,0,NEXT,C_WRAP) },
  { 'A',		BST_MOD (S00),	BST_PEA (Cis,DOWN,00,0,NEXT,C_WRAP) },
  { 'Y',		BST_MOD (S00),	BST_PEA (D  ,DOWN,00,0,NEXT,C_WRAP) },
  { 'S',		BST_MOD (S00),	BST_PEA (Dis,DOWN,00,0,NEXT,C_WRAP) },
  { 'X',		BST_MOD (S00),	BST_PEA (E  ,DOWN,00,0,NEXT,C_WRAP) },
  { 'C',		BST_MOD (S00),	BST_PEA (F  ,DOWN,00,0,NEXT,C_WRAP) },
  { 'F',		BST_MOD (S00),	BST_PEA (Fis,DOWN,00,0,NEXT,C_WRAP) },
  { 'V',		BST_MOD (S00),	BST_PEA (G  ,DOWN,00,0,NEXT,C_WRAP) },
  { 'G',		BST_MOD (S00),	BST_PEA (Gis,DOWN,00,0,NEXT,C_WRAP) },
  { 'B',		BST_MOD (S00),	BST_PEA (A  ,DOWN,00,0,NEXT,C_WRAP) },
  { 'H',		BST_MOD (S00),	BST_PEA (Ais,DOWN,00,0,NEXT,C_WRAP) },
  { 'N',		BST_MOD (S00),	BST_PEA (B  ,DOWN,00,0,NEXT,C_WRAP) },
  { 'M',		BST_MOD (S00),	BST_PEA (C  ,0	 ,00,0,NEXT,C_WRAP) },
  { 'K',		BST_MOD (S00),	BST_PEA (Cis,0	 ,00,0,NEXT,C_WRAP) },
  { ';',		BST_MOD (S00),	BST_PEA (D  ,0	 ,00,0,NEXT,C_WRAP) },
  { 'L',		BST_MOD (S00),	BST_PEA (Dis,0	 ,00,0,NEXT,C_WRAP) },
  { ':',		BST_MOD (S00),	BST_PEA (E  ,0	 ,00,0,NEXT,C_WRAP) },
  /* set normal octave and default instrument (0F) */
  { 'q',		BST_MOD (000),	BST_PEA (C  ,0	 ,0F,0,NEXT,C_WRAP) },
  { '2',		BST_MOD (000),	BST_PEA (Cis,0	 ,0F,0,NEXT,C_WRAP) },
  { 'w',		BST_MOD (000),	BST_PEA (D  ,0	 ,0F,0,NEXT,C_WRAP) },
  { '3',		BST_MOD (000),	BST_PEA (Dis,0	 ,0F,0,NEXT,C_WRAP) },
  { 'e',		BST_MOD (000),	BST_PEA (E  ,0	 ,0F,0,NEXT,C_WRAP) },
  { 'r',		BST_MOD (000),	BST_PEA (F  ,0	 ,0F,0,NEXT,C_WRAP) },
  { '5',		BST_MOD (000),	BST_PEA (Fis,0	 ,0F,0,NEXT,C_WRAP) },
  { 't',		BST_MOD (000),	BST_PEA (G  ,0	 ,0F,0,NEXT,C_WRAP) },
  { '6',		BST_MOD (000),	BST_PEA (Gis,0	 ,0F,0,NEXT,C_WRAP) },
  { 'z',		BST_MOD (000),	BST_PEA (A  ,0	 ,0F,0,NEXT,C_WRAP) },
  { '7',		BST_MOD (000),	BST_PEA (Ais,0	 ,0F,0,NEXT,C_WRAP) },
  { 'u',		BST_MOD (000),	BST_PEA (B  ,0	 ,0F,0,NEXT,C_WRAP) },
  { 'i',		BST_MOD (000),	BST_PEA (C  ,UP	 ,0F,0,NEXT,C_WRAP) },
  { '9',		BST_MOD (000),	BST_PEA (Cis,UP	 ,0F,0,NEXT,C_WRAP) },
  { 'o',		BST_MOD (000),	BST_PEA (D  ,UP	 ,0F,0,NEXT,C_WRAP) },
  { '0',		BST_MOD (000),	BST_PEA (Dis,UP	 ,0F,0,NEXT,C_WRAP) },
  { 'p',		BST_MOD (000),	BST_PEA (E  ,UP	 ,0F,0,NEXT,C_WRAP) },
  { GDK_Udiaeresis,	BST_MOD (000),	BST_PEA (F  ,UP	 ,0F,0,NEXT,C_WRAP) },
  { GDK_apostrophe,	BST_MOD (000),	BST_PEA (Fis,UP	 ,0F,0,NEXT,C_WRAP) },
  /* set normal octave without instrument (with SHIFT) */
  { 'Q',		BST_MOD (S00),	BST_PEA (C  ,0	 ,00,0,NEXT,C_WRAP) },
  { '"',		BST_MOD (S00),	BST_PEA (Cis,0	 ,00,0,NEXT,C_WRAP) },
  { 'W',		BST_MOD (S00),	BST_PEA (D  ,0	 ,00,0,NEXT,C_WRAP) },
  { GDK_section,	BST_MOD (S00),	BST_PEA (Dis,0	 ,00,0,NEXT,C_WRAP) },
  { 'E',		BST_MOD (S00),	BST_PEA (E  ,0	 ,00,0,NEXT,C_WRAP) },
  { 'R',		BST_MOD (S00),	BST_PEA (F  ,0	 ,00,0,NEXT,C_WRAP) },
  { '%',		BST_MOD (S00),	BST_PEA (Fis,0	 ,00,0,NEXT,C_WRAP) },
  { 'T',		BST_MOD (S00),	BST_PEA (G  ,0	 ,00,0,NEXT,C_WRAP) },
  { '&',		BST_MOD (S00),	BST_PEA (Gis,0	 ,00,0,NEXT,C_WRAP) },
  { 'Z',		BST_MOD (S00),	BST_PEA (A  ,0	 ,00,0,NEXT,C_WRAP) },
  { '/',		BST_MOD (S00),	BST_PEA (Ais,0	 ,00,0,NEXT,C_WRAP) },
  { 'U',		BST_MOD (S00),	BST_PEA (B  ,0	 ,00,0,NEXT,C_WRAP) },
  { 'I',		BST_MOD (S00),	BST_PEA (C  ,UP	 ,00,0,NEXT,C_WRAP) },
  { ')',		BST_MOD (S00),	BST_PEA (Cis,UP	 ,00,0,NEXT,C_WRAP) },
  { 'O',		BST_MOD (S00),	BST_PEA (D  ,UP	 ,00,0,NEXT,C_WRAP) },
  { '=',		BST_MOD (S00),	BST_PEA (Dis,UP	 ,00,0,NEXT,C_WRAP) },
  { 'P',		BST_MOD (S00),	BST_PEA (E  ,UP	 ,00,0,NEXT,C_WRAP) },
  { GDK_Udiaeresis,	BST_MOD (S00),	BST_PEA (F  ,UP	 ,00,0,NEXT,C_WRAP) },
  { GDK_grave,		BST_MOD (S00),	BST_PEA (Fis,UP	 ,00,0,NEXT,C_WRAP) },
  /* octave shifting */
  { '+',		BST_MOD (000),	BST_PEA (0, UP	 ,00,0, 0  ,Z_WRAP) },
  { '-',		BST_MOD (000),	BST_PEA (0, DOWN ,00,0, 0  ,Z_WRAP) },
  { GDK_KP_Add,		BST_MOD (000),	BST_PEA (0, UP	 ,00,0, 0  ,Z_WRAP) },
  { GDK_KP_Subtract,	BST_MOD (000),	BST_PEA (0, DOWN ,00,0, 0  ,Z_WRAP) },
  { '+',		BST_MOD (0C0),	BST_PEA (0, UP	 ,00,0,NEXT,Z_WRAP) },
  { '-',		BST_MOD (0C0),	BST_PEA (0, DOWN ,00,0,NEXT,Z_WRAP) },
  /* base octave shifting */
  { '*',		BST_MOD (S00),	BST_PEA (0, UP	 ,00,0, 0 ,SET_BASEO) },
  { '_',		BST_MOD (S00),	BST_PEA (0, DOWN ,00,0, 0 ,SET_BASEO) },
  { GDK_KP_Add,		BST_MOD (S00),	BST_PEA (0, UP	 ,00,0, 0 ,SET_BASEO) },
  { GDK_KP_Subtract,	BST_MOD (S00),	BST_PEA (0, DOWN ,00,0, 0 ,SET_BASEO) },
  /* movement */
  { GDK_Left,		BST_MOD (000),	BST_PEA (0,0,00,0, LEFT	     ,C_WRAP) },
  { GDK_Right,		BST_MOD (000),	BST_PEA (0,0,00,0, RIGHT     ,C_WRAP) },
  { GDK_Up,		BST_MOD (000),	BST_PEA (0,0,00,0, UP	     ,P_WRAP) },
  { GDK_Down,		BST_MOD (000),	BST_PEA (0,0,00,0, DOWN	     ,P_WRAP) },
  { GDK_Left,		BST_MOD (000),	BST_PEA (0,0,00,0, LEFT	     ,C_WRAP) },
  { GDK_KP_Right,	BST_MOD (000),	BST_PEA (0,0,00,0, RIGHT     ,C_WRAP) },
  { GDK_KP_Up,		BST_MOD (000),	BST_PEA (0,0,00,0, UP	     ,P_WRAP) },
  { GDK_KP_Down,	BST_MOD (000),	BST_PEA (0,0,00,0, DOWN	     ,P_WRAP) },
  { GDK_KP_Begin,	BST_MOD (000),	BST_PEA (0,0,00,0, DOWN	     ,C_WRAP) },
  { GDK_Page_Up,	BST_MOD (000),	BST_PEA (0,0,00,0, PAGE_UP   ,C_WRAP) },
  { GDK_Page_Down,	BST_MOD (000),	BST_PEA (0,0,00,0, PAGE_DOWN ,C_WRAP) },
  { GDK_Page_Up,	BST_MOD (0C0),	BST_PEA (0,0,00,0, JUMP_TOP  ,C_WRAP) },
  { GDK_Page_Down,	BST_MOD (0C0),	BST_PEA (0,0,00,0, JUMP_BOTTOM,C_WRAP) },
  { GDK_Home,		BST_MOD (000),	BST_PEA (0,0,00,0, JUMP_LEFT ,C_WRAP) },
  { GDK_End,		BST_MOD (000),	BST_PEA (0,0,00,0, JUMP_RIGHT,C_WRAP) },
  { GDK_KP_Page_Up,	BST_MOD (000),	BST_PEA (0,0,00,0, PAGE_UP   ,C_WRAP) },
  { GDK_KP_Page_Down,	BST_MOD (000),	BST_PEA (0,0,00,0, PAGE_DOWN ,C_WRAP) },
  { GDK_KP_Page_Up,	BST_MOD (0C0),	BST_PEA (0,0,00,0, JUMP_TOP  ,C_WRAP) },
  { GDK_KP_Page_Down,	BST_MOD (0C0),	BST_PEA (0,0,00,0, JUMP_BOTTOM,C_WRAP) },
  { GDK_KP_Home,	BST_MOD (000),	BST_PEA (0,0,00,0, JUMP_LEFT ,C_WRAP) },
  { GDK_KP_End,		BST_MOD (000),	BST_PEA (0,0,00,0, JUMP_RIGHT,C_WRAP) },
  { GDK_Tab,		BST_MOD (000),	BST_PEA (0,0,00,0, NEXT_PATTERN,Z_WRAP) },
  { GDK_KP_Tab,		BST_MOD (000),	BST_PEA (0,0,00,0, NEXT_PATTERN,Z_WRAP) },
  { GDK_ISO_Left_Tab,	BST_MOD (000),	BST_PEA (0,0,00,0, NEXT_PATTERN,Z_WRAP) },
  { GDK_Tab,		BST_MOD (S00),	BST_PEA (0,0,00,0, PREV_PATTERN,Z_WRAP) },
  { GDK_KP_Tab,		BST_MOD (S00),	BST_PEA (0,0,00,0, PREV_PATTERN,Z_WRAP) },
  { GDK_ISO_Left_Tab,	BST_MOD (S00),	BST_PEA (0,0,00,0, PREV_PATTERN,Z_WRAP) },
  /* instruments */
  { GDK_F1,		BST_MOD (000),	BST_PEA (0,0, 01 ,0,  0	 ,Z_WRAP) },
  { GDK_KP_F1,		BST_MOD (000),	BST_PEA (0,0, 01 ,0,  0	 ,Z_WRAP) },
  { GDK_F2,		BST_MOD (000),	BST_PEA (0,0, 02 ,0,  0	 ,Z_WRAP) },
  { GDK_KP_F2,		BST_MOD (000),	BST_PEA (0,0, 02 ,0,  0	 ,Z_WRAP) },
  { GDK_F3,		BST_MOD (000),	BST_PEA (0,0, 03 ,0,  0	 ,Z_WRAP) },
  { GDK_KP_F3,		BST_MOD (000),	BST_PEA (0,0, 03 ,0,  0	 ,Z_WRAP) },
  { GDK_F4,		BST_MOD (000),	BST_PEA (0,0, 04 ,0,  0	 ,Z_WRAP) },
  { GDK_KP_F4,		BST_MOD (000),	BST_PEA (0,0, 04 ,0,  0	 ,Z_WRAP) },
  { GDK_F5,		BST_MOD (000),	BST_PEA (0,0, 05 ,0,  0	 ,Z_WRAP) },
  { GDK_F6,		BST_MOD (000),	BST_PEA (0,0, 06 ,0,  0	 ,Z_WRAP) },
  { GDK_F7,		BST_MOD (000),	BST_PEA (0,0, 07 ,0,  0	 ,Z_WRAP) },
  { GDK_F8,		BST_MOD (000),	BST_PEA (0,0, 08 ,0,  0	 ,Z_WRAP) },
  { GDK_F9,		BST_MOD (000),	BST_PEA (0,0, 09 ,0,  0	 ,Z_WRAP) },
  { GDK_F10,		BST_MOD (000),	BST_PEA (0,0, 0A ,0,  0	 ,Z_WRAP) },
  { GDK_F11,		BST_MOD (000),	BST_PEA (0,0, 0B ,0,  0	 ,Z_WRAP) },
  { GDK_F12,		BST_MOD (000),	BST_PEA (0,0, 0C ,0,  0	 ,Z_WRAP) },
  /* change default instrument (with SHIFT) */
  { GDK_F1,		BST_MOD (S00),	BST_PEA (0,0, 01 ,0,  0	 ,SET_INSTR) },
  { GDK_KP_F1,		BST_MOD (S00),	BST_PEA (0,0, 01 ,0,  0	 ,SET_INSTR) },
  { GDK_F2,		BST_MOD (S00),	BST_PEA (0,0, 02 ,0,  0	 ,SET_INSTR) },
  { GDK_KP_F2,		BST_MOD (S00),	BST_PEA (0,0, 02 ,0,  0	 ,SET_INSTR) },
  { GDK_F3,		BST_MOD (S00),	BST_PEA (0,0, 03 ,0,  0	 ,SET_INSTR) },
  { GDK_KP_F3,		BST_MOD (S00),	BST_PEA (0,0, 03 ,0,  0	 ,SET_INSTR) },
  { GDK_F4,		BST_MOD (S00),	BST_PEA (0,0, 04 ,0,  0	 ,SET_INSTR) },
  { GDK_KP_F4,		BST_MOD (S00),	BST_PEA (0,0, 04 ,0,  0	 ,SET_INSTR) },
  { GDK_F5,		BST_MOD (S00),	BST_PEA (0,0, 05 ,0,  0	 ,SET_INSTR) },
  { GDK_F6,		BST_MOD (S00),	BST_PEA (0,0, 06 ,0,  0	 ,SET_INSTR) },
  { GDK_F7,		BST_MOD (S00),	BST_PEA (0,0, 07 ,0,  0	 ,SET_INSTR) },
  { GDK_F8,		BST_MOD (S00),	BST_PEA (0,0, 08 ,0,  0	 ,SET_INSTR) },
  { GDK_F9,		BST_MOD (S00),	BST_PEA (0,0, 09 ,0,  0	 ,SET_INSTR) },
  { GDK_F10,		BST_MOD (S00),	BST_PEA (0,0, 0A ,0,  0	 ,SET_INSTR) },
  { GDK_F11,		BST_MOD (S00),	BST_PEA (0,0, 0B ,0,  0	 ,SET_INSTR) },
  { GDK_F12,		BST_MOD (S00),	BST_PEA (0,0, 0C ,0,  0	 ,SET_INSTR) },
  /* reset note */
  { ' ',		BST_MOD (S00),	BST_PEA (RESET,0,00,0,NEXT,C_WRAP) },
  { GDK_KP_Space,	BST_MOD (S00),	BST_PEA (RESET,0,00,0,NEXT,C_WRAP) },
  /* reset instrument */
  { ' ',		BST_MOD (0C0),	BST_PEA (0,0,RESET,0,NEXT,C_WRAP) },
  { GDK_KP_Space,	BST_MOD (0C0),	BST_PEA (0,0,RESET,0,NEXT,C_WRAP) },
  /* reset note and instrument */
  { ' ',		BST_MOD (000),	BST_PEA (RESET,0,RESET,0,NEXT,C_WRAP) },
  { GDK_KP_Space,	BST_MOD (000),	BST_PEA (RESET,0,RESET,0,NEXT,C_WRAP) },
};
static guint	bst_pea_ktab_de_n_entries = (sizeof (bst_pea_ktab_de) /
					     sizeof (bst_pea_ktab_de[0]));
