/*-------------------------------------------------------------------------*
 * GNU Prolog                                                              *
 *                                                                         *
 * Part  : Prolog to WAM compiler                                          *
 * File  : make_bip_list.pl                                                *
 * Descr.: bip file generator                                              *
 * Author: Daniel Diaz                                                     *
 *                                                                         *
 * Copyright (C) 1999-2002 Daniel Diaz                                     *
 *                                                                         *
 * GNU Prolog is free software; you can redistribute it and/or modify it   *
 * under the terms of the GNU General Public License as published by the   *
 * Free Software Foundation; either version 2, or any later version.       *
 *                                                                         *
 * GNU Prolog is distributed in the hope that it will be useful, but       *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        *
 * General Public License for more details.                                *
 *                                                                         *
 * You should have received a copy of the GNU General Public License along *
 * with this program; if not, write to the Free Software Foundation, Inc.  *
 * 59 Temple Place - Suite 330, Boston, MA 02111, USA.                     *
 *-------------------------------------------------------------------------*/

/* $Id: make_bip_list.pl,v 1.8 2002/09/27 15:48:15 diaz Exp $ */

q :-
	set_prolog_flag(strict_iso, off),
	write('/* this file is automatically generated by make_bip_list.pl */'),
	nl,
	set_prolog_flag(strict_iso, off),
	pl_bips,
	fd_bips,
	halt.

pl_bips :-
	findall(F - P, enum(built_in, P, F), L),
	keysort(L, L1),
	display_bips(L1, false).

fd_bips :-
	findall(F - P, enum(built_in_fd, P, F), L),
	keysort(L, L1),
	display_bips(L1, false).

enum(Prop, P, F) :-
	current_predicate(P),
	predicate_property(P, Prop),
	predicate_property(P, prolog_file(F)).




display_bips([], _).

display_bips([F - P|L], F0) :-
	treat_file(F, F0),
	P = Func / Arity,
	format('bip(~q,~d).~n', [Func, Arity]),
	display_bips(L, F).



treat_file(X, X) :-
	!.

treat_file(New, _) :-
	format('~n%% defined in ~a~n~n', [New]).



:-	initialization(q).
