
/*  A Bison parser, made from bpl.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define	TR_BB	257
#define	TR_CHAR	258
#define	TR_DESIGNSIZE	259
#define	TR_FONTBB	260
#define	TR_FONTCOMMENT	261
#define	TR_FONTFILE	262
#define	TR_LINE	263
#define	TR_NCHARS	264
#define	TR_OUTLINE	265
#define	TR_SPLINE	266
#define	TR_WIDTH	267
#define	T_INTEGER	268
#define	T_REAL	269
#define	T_REALSTR	270
#define	T_STRING	271

#line 1 "bpl.y"

/* bpl.y: parse a Bezier property list file and output it in the binary
   BZR format.  We assume `bzr_open_output_file' has been called.

Copyright (C) 1992 Free Software Foundation, Inc.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include "config.h"

#include <ctype.h>
#include "bzr.h"
#include "spline.h"
#include "varstring.h"

#include "main.h"


/* We need to keep track of a current point for building the characters.  */
static real_coordinate_type cur;

static void yyerror (string);
static int yylex (void);

#line 38 "bpl.y"
typedef union
{
  real_bounding_box_type *bbval;
  int intval;
  spline_list_type *outlineval;		/* A single cyclic path.  */
  real realval;
  spline_list_array_type *shapeval;	/* A sequence of outlines.  */
  spline_type splineval;		/* A single line or cubic.  */
  string strval;
} YYSTYPE;
#ifndef YYDEBUG
#define YYDEBUG 1
#endif

#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		58
#define	YYFLAG		-32768
#define	YYNTBASE	18

#define YYTRANSLATE(x) ((unsigned)(x) <= 271 ? yytranslate[x] : 36)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     4,     8,    11,    14,    17,    19,    22,    28,    31,
    37,    38,    40,    42,    45,    46,    52,    54,    57,    61,
    69,    72,    78
};

static const short yyrhs[] = {    19,
    23,    33,     0,    20,    21,    22,     0,     8,    17,     0,
     7,    17,     0,     5,    15,     0,    24,     0,    23,    24,
     0,     4,    14,    25,    26,    27,     0,    13,    16,     0,
     3,    16,    16,    16,    16,     0,     0,    28,     0,    29,
     0,    28,    29,     0,     0,    11,    16,    16,    30,    31,
     0,    32,     0,    31,    32,     0,     9,    16,    16,     0,
    12,    16,    16,    16,    16,    16,    16,     0,    34,    35,
     0,     6,    16,    16,    16,    16,     0,    10,    14,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
    62,    65,    74,    77,    82,    87,    89,    92,   110,   115,
   125,   131,   134,   141,   147,   151,   154,   161,   167,   175,
   186,   191,   194
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","TR_BB",
"TR_CHAR","TR_DESIGNSIZE","TR_FONTBB","TR_FONTCOMMENT","TR_FONTFILE","TR_LINE",
"TR_NCHARS","TR_OUTLINE","TR_SPLINE","TR_WIDTH","T_INTEGER","T_REAL","T_REALSTR",
"T_STRING","bpl_file","preamble","fontfile","fontcomment","designsize","chardefs",
"chardef","setwidth","charbb","shape","outline_list","outline","@1","splines",
"spline","postamble","fontbb","nchars", NULL
};
#endif

static const short yyr1[] = {     0,
    18,    19,    20,    21,    22,    23,    23,    24,    25,    26,
    27,    27,    28,    28,    30,    29,    31,    31,    32,    32,
    33,    34,    35
};

static const short yyr2[] = {     0,
     3,     3,     2,     2,     2,     1,     2,     5,     2,     5,
     0,     1,     1,     2,     0,     5,     1,     2,     3,     7,
     2,     5,     2
};

static const short yydefact[] = {     0,
     0,     0,     0,     3,     0,     0,     6,     0,     0,     0,
     0,     7,     1,     0,     4,     0,     2,     0,     0,     0,
     0,    21,     5,     9,     0,    11,     0,    23,     0,     0,
     8,    12,    13,     0,     0,     0,    14,    22,     0,    15,
    10,     0,     0,     0,    16,    17,     0,     0,    18,    19,
     0,     0,     0,     0,    20,     0,     0,     0
};

static const short yydefgoto[] = {    56,
     2,     3,     9,    17,     6,     7,    19,    26,    31,    32,
    33,    42,    45,    46,    13,    14,    22
};

static const short yypact[] = {    -7,
   -12,     2,     0,-32768,    -6,    -2,-32768,    -8,     5,    -1,
    -5,-32768,-32768,     3,-32768,     1,-32768,     4,    11,     6,
     7,-32768,-32768,-32768,     8,    12,     9,-32768,    10,    13,
-32768,    12,-32768,    14,    15,    16,-32768,-32768,    17,-32768,
-32768,    -9,    18,    19,    -9,-32768,    20,    21,-32768,-32768,
    22,    23,    24,    25,-32768,    27,    28,-32768
};

static const short yypgoto[] = {-32768,
-32768,-32768,-32768,-32768,-32768,    36,-32768,-32768,-32768,-32768,
   -17,-32768,-32768,   -28,-32768,-32768,-32768
};


#define	YYLAST		42


static const short yytable[] = {    43,
     1,     5,    44,    11,     4,     5,     8,    10,    15,    16,
    20,    18,    21,    25,    37,    23,    49,     0,     0,    24,
    28,    27,    30,    29,    34,    35,    57,    58,    36,    38,
    39,    40,    41,    47,    48,    50,    51,    52,    53,    54,
    55,    12
};

static const short yycheck[] = {     9,
     8,     4,    12,     6,    17,     4,     7,    14,    17,     5,
    16,    13,    10,     3,    32,    15,    45,    -1,    -1,    16,
    14,    16,    11,    16,    16,    16,     0,     0,    16,    16,
    16,    16,    16,    16,    16,    16,    16,    16,    16,    16,
    16,     6
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/local/gnu/share/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/local/gnu/share/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 2:
#line 67 "bpl.y"
{ bzr_preamble_type pre;
              BZR_COMMENT (pre) = yyvsp[-1].strval;
              BZR_DESIGN_SIZE (pre) = yyvsp[0].realval;
              bzr_put_preamble (pre);
            ;
    break;}
case 4:
#line 79 "bpl.y"
{ yyval.strval = yyvsp[0].strval; ;
    break;}
case 5:
#line 84 "bpl.y"
{ yyval.realval = yyvsp[0].realval; ;
    break;}
case 8:
#line 94 "bpl.y"
{
              bzr_char_type ch;

              if (yyvsp[-3].intval > MAX_CHARCODE)
                {
                  WARNING1 ("%d: Character code too large", yyvsp[-3].intval);
                  yyvsp[-3].intval %= 256;
                }
              CHARCODE (ch) = yyvsp[-3].intval;
              CHAR_SET_WIDTH (ch) = yyvsp[-2].realval;
              CHAR_BB (ch) = *yyvsp[-1].bbval;
              BZR_SHAPE (ch) = *yyvsp[0].shapeval;
              bzr_put_char (ch);
            ;
    break;}
case 9:
#line 112 "bpl.y"
{ yyval.realval = yyvsp[0].realval; ;
    break;}
case 10:
#line 117 "bpl.y"
{ yyval.bbval = XTALLOC1 (real_bounding_box_type); 
              MIN_COL (*yyval.bbval) = yyvsp[-3].realval;
              MAX_COL (*yyval.bbval) = yyvsp[-2].realval;
              MIN_ROW (*yyval.bbval) = yyvsp[-1].realval;
              MAX_ROW (*yyval.bbval) = yyvsp[0].realval;
            ;
    break;}
case 11:
#line 127 "bpl.y"
{ yyval.shapeval = XTALLOC1 (spline_list_array_type);
              SPLINE_LIST_ARRAY_LENGTH (*yyval.shapeval) = 0;
              SPLINE_LIST_ARRAY_DATA (*yyval.shapeval) = NULL;
            ;
    break;}
case 12:
#line 132 "bpl.y"
{ yyval.shapeval = yyvsp[0].shapeval; ;
    break;}
case 13:
#line 136 "bpl.y"
{ yyval.shapeval = XTALLOC1 (spline_list_array_type);
              SPLINE_LIST_ARRAY_LENGTH (*yyval.shapeval) = 1;
              SPLINE_LIST_ARRAY_DATA (*yyval.shapeval) = XTALLOC (1, spline_list_type);
              SPLINE_LIST_ARRAY_ELT (*yyval.shapeval, 0) = *yyvsp[0].outlineval;
            ;
    break;}
case 14:
#line 142 "bpl.y"
{ append_spline_list (yyvsp[-1].shapeval, *yyvsp[0].outlineval);
              yyval.shapeval = yyvsp[-1].shapeval;
            ;
    break;}
case 15:
#line 149 "bpl.y"
{ cur = (real_coordinate_type) { yyvsp[-1].realval, yyvsp[0].realval }; ;
    break;}
case 16:
#line 151 "bpl.y"
{ yyval.outlineval = yyvsp[0].outlineval; ;
    break;}
case 17:
#line 156 "bpl.y"
{ yyval.outlineval = XTALLOC1 (spline_list_type);
              SPLINE_LIST_LENGTH (*yyval.outlineval) = 1;
              SPLINE_LIST_DATA (*yyval.outlineval) = XTALLOC (1, spline_type);
              SPLINE_LIST_ELT (*yyval.outlineval, 0) = yyvsp[0].splineval;
            ;
    break;}
case 18:
#line 162 "bpl.y"
{ append_spline (yyvsp[-1].outlineval, yyvsp[0].splineval);
              yyval.outlineval = yyvsp[-1].outlineval;
            ;
    break;}
case 19:
#line 169 "bpl.y"
{ yyval.splineval = new_spline ();
              START_POINT (yyval.splineval) = cur; 
              cur = (real_coordinate_type) { yyvsp[-1].realval, yyvsp[0].realval };
              END_POINT (yyval.splineval) = cur;
              SPLINE_DEGREE (yyval.splineval) = LINEAR;
            ;
    break;}
case 20:
#line 176 "bpl.y"
{ yyval.splineval = new_spline ();
              START_POINT (yyval.splineval) = cur;
              CONTROL1 (yyval.splineval) = (real_coordinate_type) { yyvsp[-5].realval, yyvsp[-4].realval };
              CONTROL2 (yyval.splineval) = (real_coordinate_type) { yyvsp[-3].realval, yyvsp[-2].realval };
              cur = (real_coordinate_type) { yyvsp[-1].realval, yyvsp[0].realval };
              END_POINT (yyval.splineval) = cur;
              SPLINE_DEGREE (yyval.splineval) = CUBIC;
            ;
    break;}
case 21:
#line 188 "bpl.y"
{ bzr_put_postamble (); ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/local/gnu/share/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 196 "bpl.y"


/* Let's hope Bison will never use this value as a token code.  */
#define NOT_A_TOKEN (-1)

static int get_numeric_token (FILE *);
static int get_word_token (FILE *);
static int get_string_token (FILE *);
static int token_number (string);


/* Return the next token from `bpl_file'.  */

static int
yylex (void)
{
  int t = NOT_A_TOKEN;
  
  do
    {
      int c = getc (bpl_file);

      /* Although the BPL file has parentheses in it to make it easy for
         Lisp to execute, there's no need to clutter up the grammar with
         parentheses everywhere.  The keywords do well enough to
         separate the various components.  */
      while (c != EOF && (isspace (c) || c == '(' || c == ')'))
        c = getc (bpl_file);
        
      switch (c)
        {
        case EOF: 
          t = 0;
          break;

        case '0': case '1': case '2': case '3': case '4':
        case '5': case '6': case '7': case '8': case '9':
        case '.':
          ungetc (c, bpl_file);
          t = get_numeric_token (bpl_file);
          break;

        case '"':
          t = get_string_token (bpl_file);
          break;

        default:
          if (isalpha (c))
            {
              ungetc (c, bpl_file);
              t = get_word_token (bpl_file);
            }
          else 
            t = c;
          break;
        }
    }
  while (t == NOT_A_TOKEN);

  return t;
}


/* Don't do anything special for errors.  */

static void
yyerror (string s)
{
  fprintf (stderr, "%s\n", s);
}

/* Read a numeric decimal constant from the file F.  If we see just
   <digits>, we return T_INTEGER and set yylval.intval.  If we see
   <digits>.<digits>, we return T_REAL and set yylval.realval.  This
   allows only unsigned numbers.  */

static int
get_numeric_token (FILE *f)
{
  int c;
  int t = T_INTEGER;
  variable_string vs = vs_init ();
  
  /* First collect leading digits.  */
  for (;;)
    {
      c = getc (f);
      if (!isdigit (c))
        break;
      vs_append_char (&vs, c);
    }
  
  /* If we're at a decimal point, this is a real constant.  */
  if (c == '.')
    {
      t = T_REAL;
      
      /* Collect more digits.  Append first, so we grab the `.'.  */
      do
        {
          vs_append_char (&vs, c);
          c = getc (f);
        }
      while (isdigit (c));
      
      /* Don't bother to allow `e<exponent>' at the end, since we never
         need to output in that format.  */
    }
  
  /* Add the terminating null and convert the string to a number.  */
  vs_append_char (&vs, 0);
  
  if (t == T_INTEGER)
    yylval.intval = atoi (VS_CHARS (vs));
  else
    yylval.realval = atof (VS_CHARS (vs));
  
  vs_free (&vs);
  
  return t;
}

/* Read a string constant from the file F. We make no provision for
   quoting " characters; the string just consists of everything from one
   " to the next.  Because Emacs 18 does not support floating-point
   numeric constants, bzrto writes such as a string.  Therefore, when we
   find a string whose contents are entirely such a constant, we return
   T_REALSTR and set yylval.realval.  Otherwise, we return T_STRING and
   set yylval.strval.  */

static int
get_string_token (FILE *f)
{
  int c, t;
  variable_string vs = vs_init ();

  while ((c = getc (f)) != EOF && c != '"')
    vs_append_char (&vs, c);

  if (c == EOF)
    FATAL ("BPL file ended in the midst of a string");

  /* Add the terminating null.  */
  vs_append_char (&vs, 0);

  /* Cheat and use `scanf' to see if this string is really a real.  */
  if (float_ok (VS_CHARS (vs)))
    {
      t = T_REALSTR;
      yylval.realval = atof (VS_CHARS (vs));
    }
  else
    {
      t = T_STRING;
      yylval.strval = VS_CHARS (vs);
    }
  
  return t;
}

/* Return the Bison-defined value for the token equal to the
   next nonalpha-delimited word in the file F, unless the word is
   ``comment''; in that case, ignore everything through the next `)' and
   return NOT_A_TOKEN.  */
   
static int
get_word_token (FILE *f)
{
  int c, t;
  variable_string word = vs_init ();

  while ((c = getc (f)) != EOF && isalpha (c))
    vs_append_char (&word, c);
  
  if (c != EOF)
    ungetc (c, f);

  /* Add the terminating null.  */
  vs_append_char (&word, 0);

  if (STREQ (VS_CHARS (word), "comment"))
    {
      while ((c = getc (f)) != EOF && c != ')')
        ;
      if (c == EOF)
        FATAL ("BPL file ended in the midst of a comment");
      t = NOT_A_TOKEN;
    }
  else
    t = token_number (VS_CHARS (word));
  
  /* We don't need the characters in the identifier again.  */
  vs_free (&word);
  
  return t;
}


/* Return the token code corresponding to the word STR.  If STR is not
   one of the reserved words, give an error message and return NOT_A_TOKEN:
   this is a language which doesn't have arbitrary user identifiers.  */

static int
token_number (string word)
{
  int t = NOT_A_TOKEN;
  
  if (STREQ (word, "bb"))
    return TR_BB;
  else if (STREQ (word, "char"))
    return TR_CHAR;
  else if (STREQ (word, "designsize"))
    return TR_DESIGNSIZE;
  else if (STREQ (word, "fontbb"))
    return TR_FONTBB;
  else if (STREQ (word, "fontcomment"))
    return TR_FONTCOMMENT;
  else if (STREQ (word, "fontfile"))
    return TR_FONTFILE;
  else if (STREQ (word, "line"))
    return TR_LINE;
  else if (STREQ (word, "nchars"))
    return TR_NCHARS;
  else if (STREQ (word, "outline"))
    return TR_OUTLINE;
  else if (STREQ (word, "spline"))
    return TR_SPLINE;
  else if (STREQ (word, "width"))
    return TR_WIDTH;

  return t;
}
