/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util.crypto;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.gnunet.construct.FixedSizeIntegerArray;
import org.gnunet.construct.Message;
import org.gnunet.util.HashCode;
import org.gnunet.util.crypto.DsaPrng;
import org.gnunet.util.crypto.EcdsaPublicKey;
import org.gnunet.util.crypto.EcdsaSignature;
import org.gnunet.util.crypto.Ed25519;

public class EcdsaPrivateKey
implements Message {
    @FixedSizeIntegerArray(bitSize=8, signed=false, length=32)
    public byte[] d;

    public static EcdsaPrivateKey getAnonymous() {
        EcdsaPrivateKey privateKey = new EcdsaPrivateKey();
        privateKey.d = new byte[32];
        privateKey.d[31] = 1;
        return privateKey;
    }

    public EcdsaSignature sign(byte[] data, int purpose) {
        return this.sign(data, purpose, this.getPublicKey());
    }

    public EcdsaSignature sign(byte[] data, int purpose, EcdsaPublicKey publicKey) {
        ByteArrayOutputStream os = new ByteArrayOutputStream(data.length + 8);
        DataOutputStream dos = new DataOutputStream(os);
        try {
            dos.writeInt(data.length);
            dos.writeInt(purpose);
            dos.write(data);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return this.signRaw(publicKey, os.toByteArray());
    }

    public EcdsaSignature signRaw(byte[] data) {
        return this.signRaw(this.getPublicKey(), data);
    }

    public EcdsaSignature signRaw(EcdsaPublicKey publicKey, byte[] data) {
        BigInteger v;
        BigInteger k;
        BigInteger kInv;
        BigInteger s;
        Ed25519 P;
        BigInteger r;
        EcdsaSignature signature = new EcdsaSignature();
        DsaPrng prng = new DsaPrng(this.d, data);
        HashCode h = HashCode.hash(data);
        BigInteger z = new BigInteger(1, h.data);
        BigInteger dCoeff = this.asCoefficient();
        do {
            k = prng.nextK();
            P = Ed25519.B.scalarmult(k);
        } while ((r = P.P0.mod(Ed25519.l)).equals(BigInteger.ZERO) || (s = (kInv = k.modInverse(Ed25519.l)).multiply(v = z.add(r.multiply(dCoeff))).mod(Ed25519.l)).equals(BigInteger.ZERO));
        signature.r = Ed25519.encodeScalar(r);
        signature.s = Ed25519.encodeScalar(s);
        return signature;
    }

    public EcdsaPublicKey getPublicKey() {
        Ed25519 A = Ed25519.B.scalarmult(this.asCoefficient());
        return new EcdsaPublicKey(A);
    }

    public static EcdsaPrivateKey createRandom() {
        SecureRandom sr = new SecureRandom();
        EcdsaPrivateKey privateKey = new EcdsaPrivateKey();
        privateKey.d = new byte[32];
        sr.nextBytes(privateKey.d);
        return privateKey;
    }

    public BigInteger asCoefficient() {
        return new BigInteger(1, this.d);
    }

    public static EcdsaPrivateKey zeroKey() {
        EcdsaPrivateKey pk = new EcdsaPrivateKey();
        pk.d = new byte[32];
        return pk;
    }
}

