escape_char /
comment_char %
repertoiremap mnemonic.ds

% English language locale for Denmark
%
% Written according to POSIX.2
% ISO/IEC 9945-2:1993 specifications
%
% Source: Danish Standards Association
% Address: Baunegaardsvej 73,
%    DK-2900 Hellerup, Danmark
% Contact: Keld Simonsen
% Email: Keld.Simonsen@dkuug.dk
% Tel: +45 - 39770101
% Fax: +45 - 39770202
% Language: en
% Territory: DK
% Revision: 3.3
% Date: 1994-03-22
% Application: general
% Users: general
% Repertoiremap: mnemonic.ds
% Charset: ISO_8859-1:1987
% Distribution and use is free, also for
% commercial purposes.

LC_COLLATE

% Base collation scheme: 1994-03-22

% Ordering algorithm:
%  1. Spaces and hyphen (but not soft
%     hyphen) before punctuation
%     characters, punctuation characters
%     before numbers,
%     numbers before letters.
%  2. Letters with diacritical marks are
%     members of equivalence classes
%  3. A distinction is made with regards
%     to case as noted below.
%  4. Special characters are ignored
%     when comparing letters, but then
%     they are considered
%  5. The alphabets are sorted in order
%     of first appearance in ISO 10646:
%     Latin, Greek, Cyrillic, etc.
%
% According to Greek specifications,
% the steps 2. and 3. above are reversed
% for the Greek script

% collating symbols

% The collating symbol naming is
% mostly taken from ISO 10646-1,
% for example the case and accent
% names are from this standard.

collating-symbol <CAPITAL>
collating-symbol <CAPITAL-SMALL>
collating-symbol <SMALL-CAPITAL>
collating-symbol <SMALL>

% <CAPITAL-SMALL> and <SMALL-CAPITAL>
% are for cases like Danish <A><a>
% and Spanish <C><h> being treated
% as one letter.

% The <a8> ...... <z8> collating
% symbols have defined weights as
% the last character in a group of
% Latin letters. They are used
% to specify deltas by locales using
% a locale as the default ordering
% and by "replace-after" statements
% specifying the changed placement
% in an ordering of a character.

collating-symbol <a8>
collating-symbol <b8>
collating-symbol <c8>
collating-symbol <d8>
collating-symbol <e8>
collating-symbol <f8>
collating-symbol <g8>
collating-symbol <h8>
collating-symbol <i8>
collating-symbol <j8>
collating-symbol <k8>
collating-symbol <l8>
collating-symbol <m8>
collating-symbol <n8>
collating-symbol <o8>
collating-symbol <p8>
collating-symbol <q8>
collating-symbol <r8>
collating-symbol <s8>
collating-symbol <t8>
collating-symbol <u8>
collating-symbol <v8>
collating-symbol <w8>
collating-symbol <x8>
collating-symbol <y8>
collating-symbol <z8>

collating-symbol <NONE>
collating-symbol <ACUTE>
collating-symbol <ACUTE+DOT>
collating-symbol <GRAVE>
collating-symbol <DOUBLE-GRAVE>
collating-symbol <BREVE>
collating-symbol <BREVE+ACUTE>
collating-symbol <BREVE+GRAVE>
collating-symbol <BREVE+MACRON>
collating-symbol <BREVE+HOOK>
collating-symbol <BREVE+TILDE>
collating-symbol <BREVE+DOT-BELOW>
collating-symbol <BREVE-BELOW>
collating-symbol <INVERTED-BREVE>
collating-symbol <CIRCUMFLEX>
collating-symbol <CIRCUMFLEX+ACUTE>
collating-symbol <CIRCUMFLEX+GRAVE>
collating-symbol <CIRCUMFLEX+HOOK>
collating-symbol <CIRCUMFLEX+TILDE>
collating-symbol <CIRCUMFLEX+DOT-BELOW>
collating-symbol <CARON>
collating-symbol <CARON+DIAERESIS>
collating-symbol <CARON+DOT>
collating-symbol <RING>
collating-symbol <RING+ACUTE>
collating-symbol <RING-BELOW>
collating-symbol <DIAERESIS>
collating-symbol <DIAERESIS+MACRON>
collating-symbol <DIAERESIS+ACUTE>
collating-symbol <DIAERESIS+GRAVE>
collating-symbol <DIAERESIS+CARON>
collating-symbol <DOUBLE-ACUTE>
collating-symbol <HOOK>
collating-symbol <TILDE>
collating-symbol <TILDE+ACUTE>
collating-symbol <TILDE+DIAERESIS>
collating-symbol <TILDE-BELOW>
collating-symbol <DOT>
collating-symbol <DOT-BELOW>
collating-symbol <DOT+DOT-BELOW>
collating-symbol <STROKE>
collating-symbol <STROKE+ACUTE>
collating-symbol <CEDILLA>
collating-symbol <CEDILLA+ACUTE>
collating-symbol <CEDILLA+GRAVE>
collating-symbol <CEDILLA+BREVE>
collating-symbol <OGONEK>
collating-symbol <OGONEK+MACRON>
collating-symbol <MACRON>
collating-symbol <MACRON+ACUTE>
collating-symbol <MACRON+GRAVE>
collating-symbol <MACRON+DIAERESIS>
collating-symbol <MACRON+DIAERESIS-BELOW>
collating-symbol <MACRON+DOT>
collating-symbol <MACRON+DOT-BELOW>
collating-symbol <MACRON+CIRCUMFLEX>
collating-symbol <LINE-BELOW>
collating-symbol <HORN>
collating-symbol <HORN+ACUTE>
collating-symbol <HORN+GRAVE>
collating-symbol <HORN+HOOK>
collating-symbol <HORN+TILDE>
collating-symbol <HORN+DOT-BELOW>
collating-symbol <PRECEDED-BY-APOSTROPHE>
collating-symbol <GREEK>
collating-symbol <TONOS>
collating-symbol <DIALYTICA>
collating-symbol <DIALYTICA+TONOS>
collating-symbol <CYRILLIC>
collating-symbol <HIRAGANA>
collating-symbol <KATAKANA>
collating-symbol <SPECIAL>

% letter;accent;case;specials

order_start forward;backward/
            ;forward;position

% <CAPITAL> or <SMALL> letters first:

<CAPITAL>
<CAPITAL-SMALL>
<SMALL-CAPITAL>
<SMALL>

% Accents:

<NONE>
<ACUTE>
<ACUTE+DOT>
<GRAVE>
<DOUBLE-GRAVE>
<BREVE>
<BREVE+ACUTE>
<BREVE+GRAVE>
<BREVE+MACRON>
<BREVE+HOOK>
<BREVE+TILDE>
<BREVE+DOT-BELOW>
<BREVE-BELOW>
<INVERTED-BREVE>
<CIRCUMFLEX>
<CIRCUMFLEX+ACUTE>
<CIRCUMFLEX+GRAVE>
<CIRCUMFLEX+HOOK>
<CIRCUMFLEX+TILDE>
<CIRCUMFLEX+DOT-BELOW>
<CARON>
<CARON+DIAERESIS>
<CARON+DOT>
<RING>
<RING+ACUTE>
<RING-BELOW>
<DIAERESIS>
<DIAERESIS+MACRON>
<DIAERESIS+ACUTE>
<DIAERESIS+GRAVE>
<DIAERESIS+CARON>
<DOUBLE-ACUTE>
<HOOK>
<TILDE>
<TILDE+ACUTE>
<TILDE+DIAERESIS>
<TILDE-BELOW>
<DOT>
<DOT-BELOW>
<DOT+DOT-BELOW>
<STROKE>
<STROKE+ACUTE>
<CEDILLA>
<CEDILLA+ACUTE>
<CEDILLA+GRAVE>
<CEDILLA+BREVE>
<OGONEK>
<OGONEK+MACRON>
<MACRON>
<MACRON+ACUTE>
<MACRON+GRAVE>
<MACRON+DIAERESIS>
<MACRON+DIAERESIS-BELOW>
<MACRON+DOT>
<MACRON+DOT-BELOW>
<MACRON+CIRCUMFLEX>
<LINE-BELOW>
<HORN>
<HORN+ACUTE>
<HORN+GRAVE>
<HORN+HOOK>
<HORN+TILDE>
<HORN+DOT-BELOW>
<PRECEDED-BY-APOSTROPHE>
<GREEK>
<TONOS>
<DIALYTICA>
<DIALYTICA+TONOS>
<CYRILLIC>
<HIRAGANA>
<KATAKANA>
<SPECIAL>

<NS>	<NS>;<NS>;<NS>;IGNORE	<U00a0>	NO-BREAK SPACE
<SP>	IGNORE;IGNORE;IGNORE;<SP>	<U0020>	SPACE
<HT>	IGNORE;IGNORE;IGNORE;<HT>	<U0009>	CHARACTER TABULATION (HT)
<VT>	IGNORE;IGNORE;IGNORE;<VT>	<U000b>	LINE TABULATION (VT)
<CR>	IGNORE;IGNORE;IGNORE;<CR>	<U000d>	CARRIAGE RETURN (CR)
<LF>	IGNORE;IGNORE;IGNORE;<LF>	<U000a>	LINE FEED (LF)
<FF>	IGNORE;IGNORE;IGNORE;<FF>	<U000c>	FORM FEED (FF)
<_>	IGNORE;IGNORE;IGNORE;<_>	<U005f>	LOW LINE
<'m>	IGNORE;IGNORE;IGNORE;<'m>	<U00af>	MACRON
<-->	IGNORE;IGNORE;IGNORE;<-->	<U00ad>	SOFT HYPHEN
<->	IGNORE;IGNORE;IGNORE;<->	<U002d>	HYPHEN-MINUS
<,>	IGNORE;IGNORE;IGNORE;<,>	<U002c>	COMMA
<;>	IGNORE;IGNORE;IGNORE;<;>	<U003b>	SEMICOLON
<:>	IGNORE;IGNORE;IGNORE;<:>	<U003a>	COLON
<!>	IGNORE;IGNORE;IGNORE;<!>	<U0021>	EXCLAMATION MARK
<!I>	IGNORE;IGNORE;IGNORE;<!I>	<U00a1>	INVERTED EXCLAMATION MARK
<?>	IGNORE;IGNORE;IGNORE;<?>	<U003f>	QUESTION MARK
<?I>	IGNORE;IGNORE;IGNORE;<?I>	<U00bf>	INVERTED QUESTION MARK
<//>	IGNORE;IGNORE;IGNORE;<//>	<U002f>	SOLIDUS
<.>	IGNORE;IGNORE;IGNORE;<.>	<U002e>	FULL STOP
<''>	IGNORE;IGNORE;IGNORE;<''>	<U00b4>	ACUTE ACCENT
<'!>	IGNORE;IGNORE;IGNORE;<'!>	<U0060>	GRAVE ACCENT
<'/>>	IGNORE;IGNORE;IGNORE;<'/>>	<U005e>	CIRCUMFLEX ACCENT
<':>	IGNORE;IGNORE;IGNORE;<':>	<U00a8>	DIAERESIS
<'?>	IGNORE;IGNORE;IGNORE;<'?>	<U007e>	TILDE
<.M>	IGNORE;IGNORE;IGNORE;<.M>	<U00b7>	MIDDLE DOT
<',>	IGNORE;IGNORE;IGNORE;<',>	<U00b8>	CEDILLA
<'>	IGNORE;IGNORE;IGNORE;<'>	<U0027>	APOSTROPHE
<'6>	IGNORE;IGNORE;IGNORE;<'6>	<U2018>	LEFT SINGLE QUOTATION MARK
<'9>	IGNORE;IGNORE;IGNORE;<'9>	<U2019>	RIGHT SINGLE QUOTATION MARK
<">	IGNORE;IGNORE;IGNORE;<">	<U0022>	QUOTATION MARK
<"6>	IGNORE;IGNORE;IGNORE;<"6>	<U201c>	LEFT DOUBLE QUOTATION MARK
<"9>	IGNORE;IGNORE;IGNORE;<"9>	<U201d>	RIGHT DOUBLE QUOTATION MARK
<<<>	IGNORE;IGNORE;IGNORE;<<<>	<U00ab>	LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
</>/>>	IGNORE;IGNORE;IGNORE;</>/>>	<U00bb>	RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
<(>	IGNORE;IGNORE;IGNORE;<(>	<U0028>	LEFT PARENTHESIS
<(S>	IGNORE;IGNORE;IGNORE;<(S>	<U207d>	SUPERSCRIPT LEFT PARENTHESIS
<)>	IGNORE;IGNORE;IGNORE;<)>	<U0029>	RIGHT PARENTHESIS
<)S>	IGNORE;IGNORE;IGNORE;<)S>	<U207e>	SUPERSCRIPT RIGHT PARENTHESIS
<<(>	IGNORE;IGNORE;IGNORE;<<(>	<U005b>	LEFT SQUARE BRACKET
<)/>>	IGNORE;IGNORE;IGNORE;<)/>>	<U005d>	RIGHT SQUARE BRACKET
<(!>	IGNORE;IGNORE;IGNORE;<(!>	<U007b>	LEFT CURLY BRACKET
<!)>	IGNORE;IGNORE;IGNORE;<!)>	<U007d>	RIGHT CURLY BRACKET
<SE>	IGNORE;IGNORE;IGNORE;<SE>	<U00a7>	SECTION SIGN
<PI>	IGNORE;IGNORE;IGNORE;<PI>	<U00b6>	PILCROW SIGN
<Co>	IGNORE;IGNORE;IGNORE;<Co>	<U00a9>	COPYRIGHT SIGN
<Rg>	IGNORE;IGNORE;IGNORE;<Rg>	<U00ae>	REGISTERED SIGN
<At>	IGNORE;IGNORE;IGNORE;<At>	<U0040>	COMMERCIAL AT
<Cu>	IGNORE;IGNORE;IGNORE;<Cu>	<U00a4>	CURRENCY SIGN
<Ct>	IGNORE;IGNORE;IGNORE;<Ct>	<U00a2>	CENT SIGN
<DO>	IGNORE;IGNORE;IGNORE;<DO>	<U0024>	DOLLAR SIGN
<Pd>	IGNORE;IGNORE;IGNORE;<Pd>	<U00a3>	POUND SIGN
<Ye>	IGNORE;IGNORE;IGNORE;<Ye>	<U00a5>	YEN SIGN
<*>	IGNORE;IGNORE;IGNORE;<*>	<U002a>	ASTERISK
<////>	IGNORE;IGNORE;IGNORE;<////>	<U005c>	REVERSE SOLIDUS
<&>	IGNORE;IGNORE;IGNORE;<&>	<U0026>	AMPERSAND
<Nb>	IGNORE;IGNORE;IGNORE;<Nb>	<U0023>	NUMBER SIGN
<%>	IGNORE;IGNORE;IGNORE;<%>	<U0025>	PERCENT SIGN
<-S>	IGNORE;IGNORE;IGNORE;<-S>	<U207b>	SUPERSCRIPT MINUS
<+>	IGNORE;IGNORE;IGNORE;<+>	<U002b>	PLUS SIGN
<+S>	IGNORE;IGNORE;IGNORE;<+S>	<U207a>	SUPERSCRIPT PLUS SIGN
<+->	IGNORE;IGNORE;IGNORE;<+->	<U00b1>	PLUS-MINUS SIGN
<-:>	IGNORE;IGNORE;IGNORE;<-:>	<U00f7>	DIVISION SIGN
<*X>	IGNORE;IGNORE;IGNORE;<*X>	<U00d7>	MULTIPLICATION SIGN
<!=>	IGNORE;IGNORE;IGNORE;<!=>	<U2260>	NOT EQUAL TO
<<>	IGNORE;IGNORE;IGNORE;<<>	<U003c>	LESS-THAN SIGN
<=<>	IGNORE;IGNORE;IGNORE;<=<>	<U2264>	LESS-THAN OR EQUAL TO
<=>	IGNORE;IGNORE;IGNORE;<=>	<U003d>	EQUALS SIGN
</>=>	IGNORE;IGNORE;IGNORE;</>=>	<U2265>	GREATER-THAN OR EQUAL TO
</>>	IGNORE;IGNORE;IGNORE;</>>	<U003e>	GREATER-THAN SIGN
<NO>	IGNORE;IGNORE;IGNORE;<NO>	<U00ac>	NOT SIGN
<!!>	IGNORE;IGNORE;IGNORE;<!!>	<U007c>	VERTICAL LINE
<BB>	IGNORE;IGNORE;IGNORE;<BB>	<U00a6>	BROKEN BAR
<DG>	IGNORE;IGNORE;IGNORE;<DG>	<U00b0>	DEGREE SIGN
<My>	IGNORE;IGNORE;IGNORE;<My>	<U00b5>	MICRO SIGN
<'<>	IGNORE;IGNORE;IGNORE;<'<>	<U02c7>	CARON (Mandarin Chinese third tone)
<'(>	IGNORE;IGNORE;IGNORE;<'(>	<U02d8>	BREVE
<'.>	IGNORE;IGNORE;IGNORE;<'.>	<U02d9>	DOT ABOVE (Mandarin Chinese light tone)
<'0>	IGNORE;IGNORE;IGNORE;<'0>	<U02da>	RING ABOVE
<';>	IGNORE;IGNORE;IGNORE;<';>	<U02db>	OGONEK
<1?>	IGNORE;IGNORE;IGNORE;<1?>	<U02dc>	SMALL TILDE
<'">	IGNORE;IGNORE;IGNORE;<'">	<U02dd>	DOUBLE ACUTE ACCENT
<'G>	IGNORE;IGNORE;IGNORE;<'G>	<U0374>	GREEK NUMERAL SIGN (Dexia keraia)
<,G>	IGNORE;IGNORE;IGNORE;<,G>	<U0375>	GREEK LOWER NUMERAL SIGN (Aristeri keraia)
<j3>	IGNORE;IGNORE;IGNORE;<j3>	<U037a>	GREEK YPOGEGRAMMENI
<?%>	IGNORE;IGNORE;IGNORE;<?%>	<U037e>	GREEK QUESTION MARK (Erotimatiko)
<'*>	IGNORE;IGNORE;IGNORE;<'*>	<U0384>	GREEK TONOS
<'%>	IGNORE;IGNORE;IGNORE;<'%>	<U0385>	GREEK DIALYTIKA TONOS
<.*>	IGNORE;IGNORE;IGNORE;<.*>	<U0387>	GREEK ANO TELEIA
<b3>	IGNORE;IGNORE;IGNORE;<b3>	<U03d0>	GREEK BETA SYMBOL
<,,>	IGNORE;IGNORE;IGNORE;<,,>	<U1fbf>	GREEK PSILI
<?*>	IGNORE;IGNORE;IGNORE;<?*>	<U1fc0>	GREEK PERISPOMENI
<?:>	IGNORE;IGNORE;IGNORE;<?:>	<U1fc1>	GREEK DIALYTIKA AND PERISPOMENI
<,!>	IGNORE;IGNORE;IGNORE;<,!>	<U1fcd>	GREEK PSILI AND VARIA
<,'>	IGNORE;IGNORE;IGNORE;<,'>	<U1fce>	GREEK PSILI AND OXIA
<?,>	IGNORE;IGNORE;IGNORE;<?,>	<U1fcf>	GREEK PSILI AND PERISPOMENI
<;!>	IGNORE;IGNORE;IGNORE;<;!>	<U1fdd>	GREEK DASIA AND VARIA
<;'>	IGNORE;IGNORE;IGNORE;<;'>	<U1fde>	GREEK DASIA AND OXIA
<?;>	IGNORE;IGNORE;IGNORE;<?;>	<U1fdf>	GREEK DASIA AND PERISPOMENI
<!:>	IGNORE;IGNORE;IGNORE;<!:>	<U1fed>	GREEK DIALYTIKA AND VARIA
<!*>	IGNORE;IGNORE;IGNORE;<!*>	<U1fef>	GREEK VARIA
<;;>	IGNORE;IGNORE;IGNORE;<;;>	<U1ffe>	GREEK DASIA
<1N>	IGNORE;IGNORE;IGNORE;<1N>	<U2002>	EN SPACE
<1M>	IGNORE;IGNORE;IGNORE;<1M>	<U2003>	EM SPACE
<3M>	IGNORE;IGNORE;IGNORE;<3M>	<U2004>	THREE-PER-EM SPACE
<4M>	IGNORE;IGNORE;IGNORE;<4M>	<U2005>	FOUR-PER-EM SPACE
<6M>	IGNORE;IGNORE;IGNORE;<6M>	<U2006>	SIX-PER-EM SPACE
<LR>	IGNORE;IGNORE;IGNORE;<LR>	<U200e>	LEFT-TO-RIGHT MARK
<RL>	IGNORE;IGNORE;IGNORE;<RL>	<U200f>	RIGHT-TO-LEFT MARK
<1T>	IGNORE;IGNORE;IGNORE;<1T>	<U2009>	THIN SPACE
<1H>	IGNORE;IGNORE;IGNORE;<1H>	<U200a>	HAIR SPACE
<-1>	IGNORE;IGNORE;IGNORE;<-1>	<U2010>	HYPHEN
<-N>	IGNORE;IGNORE;IGNORE;<-N>	<U2013>	EN DASH
<-M>	IGNORE;IGNORE;IGNORE;<-M>	<U2014>	EM DASH
<-3>	IGNORE;IGNORE;IGNORE;<-3>	<U2015>	HORIZONTAL BAR
<!2>	IGNORE;IGNORE;IGNORE;<!2>	<U2016>	DOUBLE VERTICAL LINE
<=2>	IGNORE;IGNORE;IGNORE;<=2>	<U2017>	DOUBLE LOW LINE
<.9>	IGNORE;IGNORE;IGNORE;<.9>	<U201a>	SINGLE LOW-9 QUOTATION MARK
<9'>	IGNORE;IGNORE;IGNORE;<9'>	<U201b>	SINGLE HIGH-REVERSED-9 QUOTATION MARK
<:9>	IGNORE;IGNORE;IGNORE;<:9>	<U201e>	DOUBLE LOW-9 QUOTATION MARK
<9">	IGNORE;IGNORE;IGNORE;<9">	<U201f>	DOUBLE HIGH-REVERSED-9 QUOTATION MARK
<//->	IGNORE;IGNORE;IGNORE;<//->	<U2020>	DAGGER
<//=>	IGNORE;IGNORE;IGNORE;<//=>	<U2021>	DOUBLE DAGGER
<Sb>	IGNORE;IGNORE;IGNORE;<Sb>	<U2022>	BULLET
<..>	IGNORE;IGNORE;IGNORE;<..>	<U2025>	TWO DOT LEADER
<.3>	IGNORE;IGNORE;IGNORE;<.3>	<U2026>	HORIZONTAL ELLIPSIS
<%0>	IGNORE;IGNORE;IGNORE;<%0>	<U2030>	PER MILLE SIGN
<1'>	IGNORE;IGNORE;IGNORE;<1'>	<U2032>	PRIME
<2'>	IGNORE;IGNORE;IGNORE;<2'>	<U2033>	DOUBLE PRIME
<3'>	IGNORE;IGNORE;IGNORE;<3'>	<U2034>	TRIPLE PRIME
<1">	IGNORE;IGNORE;IGNORE;<1">	<U2035>	REVERSED PRIME
<2">	IGNORE;IGNORE;IGNORE;<2">	<U2036>	REVERSED DOUBLE PRIME
<3">	IGNORE;IGNORE;IGNORE;<3">	<U2037>	REVERSED TRIPLE PRIME
<Ca>	IGNORE;IGNORE;IGNORE;<Ca>	<U2038>	CARET
<<1>	IGNORE;IGNORE;IGNORE;<<1>	<U2039>	SINGLE LEFT-POINTING ANGLE QUOTATION MARK
</>1>	IGNORE;IGNORE;IGNORE;</>1>	<U203a>	SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
<:X>	IGNORE;IGNORE;IGNORE;<:X>	<U203b>	REFERENCE MARK
<!*2>	IGNORE;IGNORE;IGNORE;<!*2>	<U203c>	DOUBLE EXCLAMATION MARK
<'->	IGNORE;IGNORE;IGNORE;<'->	<U203e>	OVERLINE
<=S>	IGNORE;IGNORE;IGNORE;<=S>	<U207c>	SUPERSCRIPT EQUALS SIGN
<0s>	IGNORE;IGNORE;IGNORE;<0s>	<U2080>	SUBSCRIPT ZERO
<1s>	IGNORE;IGNORE;IGNORE;<1s>	<U2081>	SUBSCRIPT ONE
<2s>	IGNORE;IGNORE;IGNORE;<2s>	<U2082>	SUBSCRIPT TWO
<3s>	IGNORE;IGNORE;IGNORE;<3s>	<U2083>	SUBSCRIPT THREE
<4s>	IGNORE;IGNORE;IGNORE;<4s>	<U2084>	SUBSCRIPT FOUR
<5s>	IGNORE;IGNORE;IGNORE;<5s>	<U2085>	SUBSCRIPT FIVE
<6s>	IGNORE;IGNORE;IGNORE;<6s>	<U2086>	SUBSCRIPT SIX
<7s>	IGNORE;IGNORE;IGNORE;<7s>	<U2087>	SUBSCRIPT SEVEN
<8s>	IGNORE;IGNORE;IGNORE;<8s>	<U2088>	SUBSCRIPT EIGHT
<9s>	IGNORE;IGNORE;IGNORE;<9s>	<U2089>	SUBSCRIPT NINE
<+s>	IGNORE;IGNORE;IGNORE;<+s>	<U208a>	SUBSCRIPT PLUS SIGN
<-s>	IGNORE;IGNORE;IGNORE;<-s>	<U208b>	SUBSCRIPT MINUS
<=s>	IGNORE;IGNORE;IGNORE;<=s>	<U208c>	SUBSCRIPT EQUALS SIGN
<(s>	IGNORE;IGNORE;IGNORE;<(s>	<U208d>	SUBSCRIPT LEFT PARENTHESIS
<)s>	IGNORE;IGNORE;IGNORE;<)s>	<U208e>	SUBSCRIPT RIGHT PARENTHESIS
<Ff>	IGNORE;IGNORE;IGNORE;<Ff>	<U20a3>	FRENCH FRANK SIGN
<Li>	IGNORE;IGNORE;IGNORE;<Li>	<U20a4>	LIRA SIGN
<Pt>	IGNORE;IGNORE;IGNORE;<Pt>	<U20a7>	PESETA SIGN
<W=>	IGNORE;IGNORE;IGNORE;<W=>	<U20a9>	WON SIGN
<oC>	IGNORE;IGNORE;IGNORE;<oC>	<U2103>	DEGREE CELSIUS
<co>	IGNORE;IGNORE;IGNORE;<co>	<U2105>	CARE OF
<oF>	IGNORE;IGNORE;IGNORE;<oF>	<U2109>	DEGREE FAHRENHEIT
<N0>	IGNORE;IGNORE;IGNORE;<N0>	<U2116>	NUMERO SIGN
<PO>	IGNORE;IGNORE;IGNORE;<PO>	<U2117>	SOUND RECORDING COPYRIGHT
<Rx>	IGNORE;IGNORE;IGNORE;<Rx>	<U211e>	PRESCRIPTION TAKE
<SM>	IGNORE;IGNORE;IGNORE;<SM>	<U2120>	SERVICE MARK
<TM>	IGNORE;IGNORE;IGNORE;<TM>	<U2122>	TRADE MARK SIGN
<Om>	IGNORE;IGNORE;IGNORE;<Om>	<U2126>	OHM SIGN
<AO>	IGNORE;IGNORE;IGNORE;<AO>	<U212b>	ANGSTROM SIGN
<13>	IGNORE;IGNORE;IGNORE;<13>	<U2153>	VULGAR FRACTION ONE THIRD
<23>	IGNORE;IGNORE;IGNORE;<23>	<U2154>	VULGAR FRACTION TWO THIRDS
<15>	IGNORE;IGNORE;IGNORE;<15>	<U2155>	VULGAR FRACTION ONE FIFTH
<25>	IGNORE;IGNORE;IGNORE;<25>	<U2156>	VULGAR FRACTION TWO FIFTHS
<35>	IGNORE;IGNORE;IGNORE;<35>	<U2157>	VULGAR FRACTION THREE FIFTHS
<45>	IGNORE;IGNORE;IGNORE;<45>	<U2158>	VULGAR FRACTION FOUR FIFTHS
<16>	IGNORE;IGNORE;IGNORE;<16>	<U2159>	VULGAR FRACTION ONE SIXTH
<56>	IGNORE;IGNORE;IGNORE;<56>	<U215a>	VULGAR FRACTION FIVE SIXTHS
<1R>	IGNORE;IGNORE;IGNORE;<1R>	<U2160>	ROMAN NUMERAL ONE
<2R>	IGNORE;IGNORE;IGNORE;<2R>	<U2161>	ROMAN NUMERAL TWO
<3R>	IGNORE;IGNORE;IGNORE;<3R>	<U2162>	ROMAN NUMERAL THREE
<4R>	IGNORE;IGNORE;IGNORE;<4R>	<U2163>	ROMAN NUMERAL FOUR
<5R>	IGNORE;IGNORE;IGNORE;<5R>	<U2164>	ROMAN NUMERAL FIVE
<6R>	IGNORE;IGNORE;IGNORE;<6R>	<U2165>	ROMAN NUMERAL SIX
<7R>	IGNORE;IGNORE;IGNORE;<7R>	<U2166>	ROMAN NUMERAL SEVEN
<8R>	IGNORE;IGNORE;IGNORE;<8R>	<U2167>	ROMAN NUMERAL EIGHT
<9R>	IGNORE;IGNORE;IGNORE;<9R>	<U2168>	ROMAN NUMERAL NINE
<aR>	IGNORE;IGNORE;IGNORE;<aR>	<U2169>	ROMAN NUMERAL TEN
<bR>	IGNORE;IGNORE;IGNORE;<bR>	<U216a>	ROMAN NUMERAL ELEVEN
<cR>	IGNORE;IGNORE;IGNORE;<cR>	<U216b>	ROMAN NUMERAL TWELVE
<50R>	IGNORE;IGNORE;IGNORE;<50R>	<U216c>	ROMAN NUMERAL FIFTY
<100R>	IGNORE;IGNORE;IGNORE;<100R>	<U216d>	ROMAN NUMERAL ONE HUNDRED
<500R>	IGNORE;IGNORE;IGNORE;<500R>	<U216e>	ROMAN NUMERAL FIVE HUNDRED
<1000R>	IGNORE;IGNORE;IGNORE;<1000R>	<U216f>	ROMAN NUMERAL ONE THOUSAND
<1r>	IGNORE;IGNORE;IGNORE;<1r>	<U2170>	SMALL ROMAN NUMERAL ONE
<2r>	IGNORE;IGNORE;IGNORE;<2r>	<U2171>	SMALL ROMAN NUMERAL TWO
<3r>	IGNORE;IGNORE;IGNORE;<3r>	<U2172>	SMALL ROMAN NUMERAL THREE
<4r>	IGNORE;IGNORE;IGNORE;<4r>	<U2173>	SMALL ROMAN NUMERAL FOUR
<5r>	IGNORE;IGNORE;IGNORE;<5r>	<U2174>	SMALL ROMAN NUMERAL FIVE
<6r>	IGNORE;IGNORE;IGNORE;<6r>	<U2175>	SMALL ROMAN NUMERAL SIX
<7r>	IGNORE;IGNORE;IGNORE;<7r>	<U2176>	SMALL ROMAN NUMERAL SEVEN
<8r>	IGNORE;IGNORE;IGNORE;<8r>	<U2177>	SMALL ROMAN NUMERAL EIGHT
<9r>	IGNORE;IGNORE;IGNORE;<9r>	<U2178>	SMALL ROMAN NUMERAL NINE
<ar>	IGNORE;IGNORE;IGNORE;<ar>	<U2179>	SMALL ROMAN NUMERAL TEN
<br>	IGNORE;IGNORE;IGNORE;<br>	<U217a>	SMALL ROMAN NUMERAL ELEVEN
<cr>	IGNORE;IGNORE;IGNORE;<cr>	<U217b>	SMALL ROMAN NUMERAL TWELVE
<50r>	IGNORE;IGNORE;IGNORE;<50r>	<U217c>	SMALL ROMAN NUMERAL FIFTY
<100r>	IGNORE;IGNORE;IGNORE;<100r>	<U217d>	SMALL ROMAN NUMERAL ONE HUNDRED
<500r>	IGNORE;IGNORE;IGNORE;<500r>	<U217e>	SMALL ROMAN NUMERAL FIVE HUNDRED
<1000r>	IGNORE;IGNORE;IGNORE;<1000r>	<U217f>	SMALL ROMAN NUMERAL ONE THOUSAND
<1000RCD>	IGNORE;IGNORE;IGNORE;<1000RCD>	<U2180>	ROMAN NUMERAL ONE THOUSAND C D
<5000R>	IGNORE;IGNORE;IGNORE;<5000R>	<U2181>	ROMAN NUMERAL FIVE THOUSAND
<10000R>	IGNORE;IGNORE;IGNORE;<10000R>	<U2182>	ROMAN NUMERAL TEN THOUSAND
<-!>	IGNORE;IGNORE;IGNORE;<-!>	<U2191>	UPWARDS ARROW
<-v>	IGNORE;IGNORE;IGNORE;<-v>	<U2193>	DOWNWARDS ARROW
<</>>	IGNORE;IGNORE;IGNORE;<</>>	<U2194>	LEFT RIGHT ARROW
<UD>	IGNORE;IGNORE;IGNORE;<UD>	<U2195>	UP DOWN ARROW
<<!!>	IGNORE;IGNORE;IGNORE;<<!!>	<U2196>	NORTH WEST ARROW
</////>>	IGNORE;IGNORE;IGNORE;</////>>	<U2197>	NORTH EAST ARROW
<!!/>>	IGNORE;IGNORE;IGNORE;<!!/>>	<U2198>	SOUTH EAST ARROW
<<////>	IGNORE;IGNORE;IGNORE;<<////>	<U2199>	SOUTH WEST ARROW
<UD->	IGNORE;IGNORE;IGNORE;<UD->	<U21a8>	UP DOWN ARROW WITH BASE
</>V>	IGNORE;IGNORE;IGNORE;</>V>	<U21c0>	RIGHTWARDS HARPOON WITH BARB UPWARDS
<<=>	IGNORE;IGNORE;IGNORE;<<=>	<U21d0>	LEFTWARDS DOUBLE ARROW
<=/>>	IGNORE;IGNORE;IGNORE;<=/>>	<U21d2>	RIGHTWARDS DOUBLE ARROW
<==>	IGNORE;IGNORE;IGNORE;<==>	<U21d4>	LEFT RIGHT DOUBLE ARROW
<FA>	IGNORE;IGNORE;IGNORE;<FA>	<U2200>	FOR ALL
<dP>	IGNORE;IGNORE;IGNORE;<dP>	<U2202>	PARTIAL DIFFERENTIAL
<TE>	IGNORE;IGNORE;IGNORE;<TE>	<U2203>	THERE EXISTS
<//0>	IGNORE;IGNORE;IGNORE;<//0>	<U2205>	EMPTY SET
<DE>	IGNORE;IGNORE;IGNORE;<DE>	<U2206>	INCREMENT
<NB>	IGNORE;IGNORE;IGNORE;<NB>	<U2207>	NABLA
<(->	IGNORE;IGNORE;IGNORE;<(->	<U2208>	ELEMENT OF
<-)>	IGNORE;IGNORE;IGNORE;<-)>	<U220b>	CONTAINS AS MEMBER
<*P>	IGNORE;IGNORE;IGNORE;<*P>	<U220f>	N-ARY PRODUCT
<+Z>	IGNORE;IGNORE;IGNORE;<+Z>	<U2211>	N-ARY SUMMATION
<-2>	IGNORE;IGNORE;IGNORE;<-2>	<U2212>	MINUS SIGN
<-+>	IGNORE;IGNORE;IGNORE;<-+>	<U2213>	MINUS-OR-PLUS SIGN
<.+>	IGNORE;IGNORE;IGNORE;<.+>	<U2214>	DOT PLUS
<//f>	IGNORE;IGNORE;IGNORE;<//f>	<U2215>	DIVISION SLASH
<*->	IGNORE;IGNORE;IGNORE;<*->	<U2217>	ASTERISK OPERATOR
<Ob>	IGNORE;IGNORE;IGNORE;<Ob>	<U2218>	RING OPERATOR
<sb>	IGNORE;IGNORE;IGNORE;<sb>	<U2219>	BULLET OPERATOR
<RT>	IGNORE;IGNORE;IGNORE;<RT>	<U221a>	SQUARE ROOT
<0(>	IGNORE;IGNORE;IGNORE;<0(>	<U221d>	PROPORTIONAL TO
<00>	IGNORE;IGNORE;IGNORE;<00>	<U221e>	INFINITY
<-L>	IGNORE;IGNORE;IGNORE;<-L>	<U221f>	RIGHT ANGLE
<-V>	IGNORE;IGNORE;IGNORE;<-V>	<U2220>	ANGLE
<PP>	IGNORE;IGNORE;IGNORE;<PP>	<U2225>	PARALLEL TO
<AN>	IGNORE;IGNORE;IGNORE;<AN>	<U2227>	LOGICAL AND
<OR>	IGNORE;IGNORE;IGNORE;<OR>	<U2228>	LOGICAL OR
<(U>	IGNORE;IGNORE;IGNORE;<(U>	<U2229>	INTERSECTION
<)U>	IGNORE;IGNORE;IGNORE;<)U>	<U222a>	UNION
<In>	IGNORE;IGNORE;IGNORE;<In>	<U222b>	INTEGRAL
<DI>	IGNORE;IGNORE;IGNORE;<DI>	<U222c>	DOUBLE INTEGRAL
<Io>	IGNORE;IGNORE;IGNORE;<Io>	<U222e>	CONTOUR INTEGRAL
<.:>	IGNORE;IGNORE;IGNORE;<.:>	<U2234>	THEREFORE
<:.>	IGNORE;IGNORE;IGNORE;<:.>	<U2235>	BECAUSE
<:R>	IGNORE;IGNORE;IGNORE;<:R>	<U2236>	RATIO
<::>	IGNORE;IGNORE;IGNORE;<::>	<U2237>	PROPORTION
<?1>	IGNORE;IGNORE;IGNORE;<?1>	<U223c>	TILDE OPERATOR
<CG>	IGNORE;IGNORE;IGNORE;<CG>	<U223e>	INVERTED LAZY S
<?->	IGNORE;IGNORE;IGNORE;<?->	<U2243>	ASYMPTOTICALLY EQUAL TO
<?=>	IGNORE;IGNORE;IGNORE;<?=>	<U2245>	APPROXIMATELY EQUAL TO
<?2>	IGNORE;IGNORE;IGNORE;<?2>	<U2248>	ALMOST EQUAL TO
<=?>	IGNORE;IGNORE;IGNORE;<=?>	<U224c>	ALL EQUAL TO
<HI>	IGNORE;IGNORE;IGNORE;<HI>	<U2253>	IMAGE OF OR APPROXIMATELY EQUAL TO
<=3>	IGNORE;IGNORE;IGNORE;<=3>	<U2261>	IDENTICAL TO
<<*>	IGNORE;IGNORE;IGNORE;<<*>	<U226a>	MUCH LESS-THAN
<*/>>	IGNORE;IGNORE;IGNORE;<*/>>	<U226b>	MUCH GREATER-THAN
<!<>	IGNORE;IGNORE;IGNORE;<!<>	<U226e>	NOT LESS-THAN
<!/>>	IGNORE;IGNORE;IGNORE;<!/>>	<U226f>	NOT GREATER-THAN
<(C>	IGNORE;IGNORE;IGNORE;<(C>	<U2282>	SUBSET OF
<)C>	IGNORE;IGNORE;IGNORE;<)C>	<U2283>	SUPERSET OF
<(_>	IGNORE;IGNORE;IGNORE;<(_>	<U2286>	SUBSET OF OR EQUAL TO
<)_>	IGNORE;IGNORE;IGNORE;<)_>	<U2287>	SUPERSET OF OR EQUAL TO
<0.>	IGNORE;IGNORE;IGNORE;<0.>	<U2299>	CIRCLED DOT OPERATOR
<02>	IGNORE;IGNORE;IGNORE;<02>	<U229a>	CIRCLED RING OPERATOR
<-T>	IGNORE;IGNORE;IGNORE;<-T>	<U22a5>	UP TACK
<.P>	IGNORE;IGNORE;IGNORE;<.P>	<U22c5>	DOT OPERATOR
<:3>	IGNORE;IGNORE;IGNORE;<:3>	<U22ee>	VERTICAL ELLIPSIS
<Eh>	IGNORE;IGNORE;IGNORE;<Eh>	<U2302>	HOUSE
<<7>	IGNORE;IGNORE;IGNORE;<<7>	<U2308>	LEFT CEILING
</>7>	IGNORE;IGNORE;IGNORE;</>7>	<U2309>	RIGHT CEILING
<7<>	IGNORE;IGNORE;IGNORE;<7<>	<U230a>	LEFT FLOOR
<7/>>	IGNORE;IGNORE;IGNORE;<7/>>	<U230b>	RIGHT FLOOR
<NI>	IGNORE;IGNORE;IGNORE;<NI>	<U2310>	REVERSED NOT SIGN
<(A>	IGNORE;IGNORE;IGNORE;<(A>	<U2312>	ARC
<TR>	IGNORE;IGNORE;IGNORE;<TR>	<U2315>	TELEPHONE RECORDER
<Iu>	IGNORE;IGNORE;IGNORE;<Iu>	<U2320>	TOP HALF INTEGRAL
<Il>	IGNORE;IGNORE;IGNORE;<Il>	<U2321>	BOTTOM HALF INTEGRAL
<Vs>	IGNORE;IGNORE;IGNORE;<Vs>	<U2423>	OPEN BOX
<1h>	IGNORE;IGNORE;IGNORE;<1h>	<U2440>	OCR HOOK
<3h>	IGNORE;IGNORE;IGNORE;<3h>	<U2441>	OCR CHAIR
<2h>	IGNORE;IGNORE;IGNORE;<2h>	<U2442>	OCR FORK
<4h>	IGNORE;IGNORE;IGNORE;<4h>	<U2443>	OCR INVERTED FORK
<1j>	IGNORE;IGNORE;IGNORE;<1j>	<U2446>	OCR BRANCH BANK IDENTIFICATION
<2j>	IGNORE;IGNORE;IGNORE;<2j>	<U2447>	OCR AMOUNT OF CHECK
<3j>	IGNORE;IGNORE;IGNORE;<3j>	<U2448>	OCR DASH
<4j>	IGNORE;IGNORE;IGNORE;<4j>	<U2449>	OCR CUSTOMER ACCOUNT NUMBER
<1-o>	IGNORE;IGNORE;IGNORE;<1-o>	<U2460>	CIRCLED DIGIT ONE
<2-o>	IGNORE;IGNORE;IGNORE;<2-o>	<U2461>	CIRCLED DIGIT TWO
<3-o>	IGNORE;IGNORE;IGNORE;<3-o>	<U2462>	CIRCLED DIGIT THREE
<4-o>	IGNORE;IGNORE;IGNORE;<4-o>	<U2463>	CIRCLED DIGIT FOUR
<5-o>	IGNORE;IGNORE;IGNORE;<5-o>	<U2464>	CIRCLED DIGIT FIVE
<6-o>	IGNORE;IGNORE;IGNORE;<6-o>	<U2465>	CIRCLED DIGIT SIX
<7-o>	IGNORE;IGNORE;IGNORE;<7-o>	<U2466>	CIRCLED DIGIT SEVEN
<8-o>	IGNORE;IGNORE;IGNORE;<8-o>	<U2467>	CIRCLED DIGIT EIGHT
<9-o>	IGNORE;IGNORE;IGNORE;<9-o>	<U2468>	CIRCLED DIGIT NINE
<10-o>	IGNORE;IGNORE;IGNORE;<10-o>	<U2469>	CIRCLED NUMBER TEN
<11-o>	IGNORE;IGNORE;IGNORE;<11-o>	<U246a>	CIRCLED NUMBER ELEVEN
<12-o>	IGNORE;IGNORE;IGNORE;<12-o>	<U246b>	CIRCLED NUMBER TWELVE
<13-o>	IGNORE;IGNORE;IGNORE;<13-o>	<U246c>	CIRCLED NUMBER THIRTEEN
<14-o>	IGNORE;IGNORE;IGNORE;<14-o>	<U246d>	CIRCLED NUMBER FOURTEEN
<15-o>	IGNORE;IGNORE;IGNORE;<15-o>	<U246e>	CIRCLED NUMBER FIFTEEN
<16-o>	IGNORE;IGNORE;IGNORE;<16-o>	<U246f>	CIRCLED NUMBER SIXTEEN
<17-o>	IGNORE;IGNORE;IGNORE;<17-o>	<U2470>	CIRCLED NUMBER SEVENTEEN
<18-o>	IGNORE;IGNORE;IGNORE;<18-o>	<U2471>	CIRCLED NUMBER EIGHTEEN
<19-o>	IGNORE;IGNORE;IGNORE;<19-o>	<U2472>	CIRCLED NUMBER NINETEEN
<20-o>	IGNORE;IGNORE;IGNORE;<20-o>	<U2473>	CIRCLED NUMBER TWENTY
<(1)>	IGNORE;IGNORE;IGNORE;<(1)>	<U2474>	PARENTHESIZED DIGIT ONE
<(2)>	IGNORE;IGNORE;IGNORE;<(2)>	<U2475>	PARENTHESIZED DIGIT TWO
<(3)>	IGNORE;IGNORE;IGNORE;<(3)>	<U2476>	PARENTHESIZED DIGIT THREE
<(4)>	IGNORE;IGNORE;IGNORE;<(4)>	<U2477>	PARENTHESIZED DIGIT FOUR
<(5)>	IGNORE;IGNORE;IGNORE;<(5)>	<U2478>	PARENTHESIZED DIGIT FIVE
<(6)>	IGNORE;IGNORE;IGNORE;<(6)>	<U2479>	PARENTHESIZED DIGIT SIX
<(7)>	IGNORE;IGNORE;IGNORE;<(7)>	<U247a>	PARENTHESIZED DIGIT SEVEN
<(8)>	IGNORE;IGNORE;IGNORE;<(8)>	<U247b>	PARENTHESIZED DIGIT EIGHT
<(9)>	IGNORE;IGNORE;IGNORE;<(9)>	<U247c>	PARENTHESIZED DIGIT NINE
<(10)>	IGNORE;IGNORE;IGNORE;<(10)>	<U247d>	PARENTHESIZED NUMBER TEN
<(11)>	IGNORE;IGNORE;IGNORE;<(11)>	<U247e>	PARENTHESIZED NUMBER ELEVEN
<(12)>	IGNORE;IGNORE;IGNORE;<(12)>	<U247f>	PARENTHESIZED NUMBER TWELVE
<(13)>	IGNORE;IGNORE;IGNORE;<(13)>	<U2480>	PARENTHESIZED NUMBER THIRTEEN
<(14)>	IGNORE;IGNORE;IGNORE;<(14)>	<U2481>	PARENTHESIZED NUMBER FOURTEEN
<(15)>	IGNORE;IGNORE;IGNORE;<(15)>	<U2482>	PARENTHESIZED NUMBER FIFTEEN
<(16)>	IGNORE;IGNORE;IGNORE;<(16)>	<U2483>	PARENTHESIZED NUMBER SIXTEEN
<(17)>	IGNORE;IGNORE;IGNORE;<(17)>	<U2484>	PARENTHESIZED NUMBER SEVENTEEN
<(18)>	IGNORE;IGNORE;IGNORE;<(18)>	<U2485>	PARENTHESIZED NUMBER EIGHTEEN
<(19)>	IGNORE;IGNORE;IGNORE;<(19)>	<U2486>	PARENTHESIZED NUMBER NINETEEN
<(20)>	IGNORE;IGNORE;IGNORE;<(20)>	<U2487>	PARENTHESIZED NUMBER TWENTY
<1.>	IGNORE;IGNORE;IGNORE;<1.>	<U2488>	DIGIT ONE FULL STOP
<2.>	IGNORE;IGNORE;IGNORE;<2.>	<U2489>	DIGIT TWO FULL STOP
<3.>	IGNORE;IGNORE;IGNORE;<3.>	<U248a>	DIGIT THREE FULL STOP
<4.>	IGNORE;IGNORE;IGNORE;<4.>	<U248b>	DIGIT FOUR FULL STOP
<5.>	IGNORE;IGNORE;IGNORE;<5.>	<U248c>	DIGIT FIVE FULL STOP
<6.>	IGNORE;IGNORE;IGNORE;<6.>	<U248d>	DIGIT SIX FULL STOP
<7.>	IGNORE;IGNORE;IGNORE;<7.>	<U248e>	DIGIT SEVEN FULL STOP
<8.>	IGNORE;IGNORE;IGNORE;<8.>	<U248f>	DIGIT EIGHT FULL STOP
<9.>	IGNORE;IGNORE;IGNORE;<9.>	<U2490>	DIGIT NINE FULL STOP
<10.>	IGNORE;IGNORE;IGNORE;<10.>	<U2491>	NUMBER TEN FULL STOP
<11.>	IGNORE;IGNORE;IGNORE;<11.>	<U2492>	NUMBER ELEVEN FULL STOP
<12.>	IGNORE;IGNORE;IGNORE;<12.>	<U2493>	NUMBER TWELVE FULL STOP
<13.>	IGNORE;IGNORE;IGNORE;<13.>	<U2494>	NUMBER THIRTEEN FULL STOP
<14.>	IGNORE;IGNORE;IGNORE;<14.>	<U2495>	NUMBER FOURTEEN FULL STOP
<15.>	IGNORE;IGNORE;IGNORE;<15.>	<U2496>	NUMBER FIFTEEN FULL STOP
<16.>	IGNORE;IGNORE;IGNORE;<16.>	<U2497>	NUMBER SIXTEEN FULL STOP
<17.>	IGNORE;IGNORE;IGNORE;<17.>	<U2498>	NUMBER SEVENTEEN FULL STOP
<18.>	IGNORE;IGNORE;IGNORE;<18.>	<U2499>	NUMBER EIGHTEEN FULL STOP
<19.>	IGNORE;IGNORE;IGNORE;<19.>	<U249a>	NUMBER NINETEEN FULL STOP
<20.>	IGNORE;IGNORE;IGNORE;<20.>	<U249b>	NUMBER TWENTY FULL STOP
<0-o>	IGNORE;IGNORE;IGNORE;<0-o>	<U24ea>	CIRCLED DIGIT ZERO
<hh>	IGNORE;IGNORE;IGNORE;<hh>	<U2500>	BOX DRAWINGS LIGHT HORIZONTAL
<HH>	IGNORE;IGNORE;IGNORE;<HH>	<U2501>	BOX DRAWINGS HEAVY HORIZONTAL
<vv>	IGNORE;IGNORE;IGNORE;<vv>	<U2502>	BOX DRAWINGS LIGHT VERTICAL
<VV>	IGNORE;IGNORE;IGNORE;<VV>	<U2503>	BOX DRAWINGS HEAVY VERTICAL
<3->	IGNORE;IGNORE;IGNORE;<3->	<U2504>	BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL
<3_>	IGNORE;IGNORE;IGNORE;<3_>	<U2505>	BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL
<3!>	IGNORE;IGNORE;IGNORE;<3!>	<U2506>	BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL
<3//>	IGNORE;IGNORE;IGNORE;<3//>	<U2507>	BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL
<4->	IGNORE;IGNORE;IGNORE;<4->	<U2508>	BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL
<4_>	IGNORE;IGNORE;IGNORE;<4_>	<U2509>	BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL
<4!>	IGNORE;IGNORE;IGNORE;<4!>	<U250a>	BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL
<4//>	IGNORE;IGNORE;IGNORE;<4//>	<U250b>	BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL
<dr>	IGNORE;IGNORE;IGNORE;<dr>	<U250c>	BOX DRAWINGS LIGHT DOWN AND RIGHT
<dR>	IGNORE;IGNORE;IGNORE;<dR>	<U250d>	BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY
<Dr>	IGNORE;IGNORE;IGNORE;<Dr>	<U250e>	BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT
<DR>	IGNORE;IGNORE;IGNORE;<DR>	<U250f>	BOX DRAWINGS HEAVY DOWN AND RIGHT
<dl>	IGNORE;IGNORE;IGNORE;<dl>	<U2510>	BOX DRAWINGS LIGHT DOWN AND LEFT
<dL>	IGNORE;IGNORE;IGNORE;<dL>	<U2511>	BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY
<Dl>	IGNORE;IGNORE;IGNORE;<Dl>	<U2512>	BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT
<LD>	IGNORE;IGNORE;IGNORE;<LD>	<U2513>	BOX DRAWINGS HEAVY DOWN AND LEFT
<ur>	IGNORE;IGNORE;IGNORE;<ur>	<U2514>	BOX DRAWINGS LIGHT UP AND RIGHT
<uR>	IGNORE;IGNORE;IGNORE;<uR>	<U2515>	BOX DRAWINGS UP LIGHT AND RIGHT HEAVY
<Ur>	IGNORE;IGNORE;IGNORE;<Ur>	<U2516>	BOX DRAWINGS UP HEAVY AND RIGHT LIGHT
<UR>	IGNORE;IGNORE;IGNORE;<UR>	<U2517>	BOX DRAWINGS HEAVY UP AND RIGHT
<ul>	IGNORE;IGNORE;IGNORE;<ul>	<U2518>	BOX DRAWINGS LIGHT UP AND LEFT
<uL>	IGNORE;IGNORE;IGNORE;<uL>	<U2519>	BOX DRAWINGS UP LIGHT AND LEFT HEAVY
<Ul>	IGNORE;IGNORE;IGNORE;<Ul>	<U251a>	BOX DRAWINGS UP HEAVY AND LEFT LIGHT
<UL>	IGNORE;IGNORE;IGNORE;<UL>	<U251b>	BOX DRAWINGS HEAVY UP AND LEFT
<vr>	IGNORE;IGNORE;IGNORE;<vr>	<U251c>	BOX DRAWINGS LIGHT VERTICAL AND RIGHT
<vR>	IGNORE;IGNORE;IGNORE;<vR>	<U251d>	BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY
<Udr>	IGNORE;IGNORE;IGNORE;<Udr>	<U251e>	BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT
<uDr>	IGNORE;IGNORE;IGNORE;<uDr>	<U251f>	BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT
<Vr>	IGNORE;IGNORE;IGNORE;<Vr>	<U2520>	BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT
<UdR>	IGNORE;IGNORE;IGNORE;<UdR>	<U2521>	BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY
<uDR>	IGNORE;IGNORE;IGNORE;<uDR>	<U2522>	BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY
<VR>	IGNORE;IGNORE;IGNORE;<VR>	<U2523>	BOX DRAWINGS HEAVY VERTICAL AND RIGHT
<vl>	IGNORE;IGNORE;IGNORE;<vl>	<U2524>	BOX DRAWINGS LIGHT VERTICAL AND LEFT
<vL>	IGNORE;IGNORE;IGNORE;<vL>	<U2525>	BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY
<Udl>	IGNORE;IGNORE;IGNORE;<Udl>	<U2526>	BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT
<uDl>	IGNORE;IGNORE;IGNORE;<uDl>	<U2527>	BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT
<Vl>	IGNORE;IGNORE;IGNORE;<Vl>	<U2528>	BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT
<UdL>	IGNORE;IGNORE;IGNORE;<UdL>	<U2529>	BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY
<uDL>	IGNORE;IGNORE;IGNORE;<uDL>	<U252a>	BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY
<VL>	IGNORE;IGNORE;IGNORE;<VL>	<U252b>	BOX DRAWINGS HEAVY VERTICAL AND LEFT
<dh>	IGNORE;IGNORE;IGNORE;<dh>	<U252c>	BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
<dLr>	IGNORE;IGNORE;IGNORE;<dLr>	<U252d>	BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT
<dlR>	IGNORE;IGNORE;IGNORE;<dlR>	<U252e>	BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT
<dH>	IGNORE;IGNORE;IGNORE;<dH>	<U252f>	BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY
<Dh>	IGNORE;IGNORE;IGNORE;<Dh>	<U2530>	BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT
<DLr>	IGNORE;IGNORE;IGNORE;<DLr>	<U2531>	BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY
<DlR>	IGNORE;IGNORE;IGNORE;<DlR>	<U2532>	BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY
<DH>	IGNORE;IGNORE;IGNORE;<DH>	<U2533>	BOX DRAWINGS HEAVY DOWN AND HORIZONTAL
<uh>	IGNORE;IGNORE;IGNORE;<uh>	<U2534>	BOX DRAWINGS LIGHT UP AND HORIZONTAL
<uLr>	IGNORE;IGNORE;IGNORE;<uLr>	<U2535>	BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT
<ulR>	IGNORE;IGNORE;IGNORE;<ulR>	<U2536>	BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT
<uH>	IGNORE;IGNORE;IGNORE;<uH>	<U2537>	BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY
<Uh>	IGNORE;IGNORE;IGNORE;<Uh>	<U2538>	BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT
<ULr>	IGNORE;IGNORE;IGNORE;<ULr>	<U2539>	BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY
<UlR>	IGNORE;IGNORE;IGNORE;<UlR>	<U253a>	BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY
<UH>	IGNORE;IGNORE;IGNORE;<UH>	<U253b>	BOX DRAWINGS HEAVY UP AND HORIZONTAL
<vh>	IGNORE;IGNORE;IGNORE;<vh>	<U253c>	BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
<vLr>	IGNORE;IGNORE;IGNORE;<vLr>	<U253d>	BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT
<vlR>	IGNORE;IGNORE;IGNORE;<vlR>	<U253e>	BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT
<vH>	IGNORE;IGNORE;IGNORE;<vH>	<U253f>	BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY
<Udh>	IGNORE;IGNORE;IGNORE;<Udh>	<U2540>	BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT
<uDh>	IGNORE;IGNORE;IGNORE;<uDh>	<U2541>	BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT
<Vh>	IGNORE;IGNORE;IGNORE;<Vh>	<U2542>	BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT
<UdLr>	IGNORE;IGNORE;IGNORE;<UdLr>	<U2543>	BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT
<UdlR>	IGNORE;IGNORE;IGNORE;<UdlR>	<U2544>	BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT
<uDLr>	IGNORE;IGNORE;IGNORE;<uDLr>	<U2545>	BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT
<uDlR>	IGNORE;IGNORE;IGNORE;<uDlR>	<U2546>	BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT
<UdH>	IGNORE;IGNORE;IGNORE;<UdH>	<U2547>	BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY
<uDH>	IGNORE;IGNORE;IGNORE;<uDH>	<U2548>	BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY
<VLr>	IGNORE;IGNORE;IGNORE;<VLr>	<U2549>	BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY
<VlR>	IGNORE;IGNORE;IGNORE;<VlR>	<U254a>	BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY
<VH>	IGNORE;IGNORE;IGNORE;<VH>	<U254b>	BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
<FD>	IGNORE;IGNORE;IGNORE;<FD>	<U2571>	BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT
<BD>	IGNORE;IGNORE;IGNORE;<BD>	<U2572>	BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT
<TB>	IGNORE;IGNORE;IGNORE;<TB>	<U2580>	UPPER HALF BLOCK
<LB>	IGNORE;IGNORE;IGNORE;<LB>	<U2584>	LOWER HALF BLOCK
<FB>	IGNORE;IGNORE;IGNORE;<FB>	<U2588>	FULL BLOCK
<lB>	IGNORE;IGNORE;IGNORE;<lB>	<U258c>	LEFT HALF BLOCK
<RB>	IGNORE;IGNORE;IGNORE;<RB>	<U2590>	RIGHT HALF BLOCK
<.S>	IGNORE;IGNORE;IGNORE;<.S>	<U2591>	LIGHT SHADE
<:S>	IGNORE;IGNORE;IGNORE;<:S>	<U2592>	MEDIUM SHADE
<?S>	IGNORE;IGNORE;IGNORE;<?S>	<U2593>	DARK SHADE
<fS>	IGNORE;IGNORE;IGNORE;<fS>	<U25a0>	BLACK SQUARE
<OS>	IGNORE;IGNORE;IGNORE;<OS>	<U25a1>	WHITE SQUARE
<RO>	IGNORE;IGNORE;IGNORE;<RO>	<U25a2>	WHITE SQUARE WITH ROUNDED CORNERS
<Rr>	IGNORE;IGNORE;IGNORE;<Rr>	<U25a3>	WHITE SQUARE CONTAINING BLACK SMALL SQUARE
<RF>	IGNORE;IGNORE;IGNORE;<RF>	<U25a4>	SQUARE WITH HORIZONTAL FILL
<RY>	IGNORE;IGNORE;IGNORE;<RY>	<U25a5>	SQUARE WITH VERTICAL FILL
<RH>	IGNORE;IGNORE;IGNORE;<RH>	<U25a6>	SQUARE WITH ORTHOGONAL CROSSHATCH FILL
<RZ>	IGNORE;IGNORE;IGNORE;<RZ>	<U25a7>	SQUARE WITH UPPER LEFT TO LOWER RIGHT FILL
<RK>	IGNORE;IGNORE;IGNORE;<RK>	<U25a8>	SQUARE WITH UPPER RIGHT TO LOWER LEFT FILL
<RX>	IGNORE;IGNORE;IGNORE;<RX>	<U25a9>	SQUARE WITH DIAGONAL CROSSHATCH FILL
<sB>	IGNORE;IGNORE;IGNORE;<sB>	<U25aa>	BLACK SMALL SQUARE
<SR>	IGNORE;IGNORE;IGNORE;<SR>	<U25ac>	BLACK RECTANGLE
<Or>	IGNORE;IGNORE;IGNORE;<Or>	<U25ad>	WHITE RECTANGLE
<UT>	IGNORE;IGNORE;IGNORE;<UT>	<U25b2>	BLACK UP-POINTING TRIANGLE
<uT>	IGNORE;IGNORE;IGNORE;<uT>	<U25b3>	WHITE UP-POINTING TRIANGLE
<Tr>	IGNORE;IGNORE;IGNORE;<Tr>	<U25b7>	WHITE RIGHT-POINTING TRIANGLE
<PR>	IGNORE;IGNORE;IGNORE;<PR>	<U25ba>	BLACK RIGHT-POINTING POINTER
<Dt>	IGNORE;IGNORE;IGNORE;<Dt>	<U25bc>	BLACK DOWN-POINTING TRIANGLE
<dT>	IGNORE;IGNORE;IGNORE;<dT>	<U25bd>	WHITE DOWN-POINTING TRIANGLE
<Tl>	IGNORE;IGNORE;IGNORE;<Tl>	<U25c1>	WHITE LEFT-POINTING TRIANGLE
<PL>	IGNORE;IGNORE;IGNORE;<PL>	<U25c4>	BLACK LEFT-POINTING POINTER
<Db>	IGNORE;IGNORE;IGNORE;<Db>	<U25c6>	BLACK DIAMOND
<Dw>	IGNORE;IGNORE;IGNORE;<Dw>	<U25c7>	WHITE DIAMOND
<LZ>	IGNORE;IGNORE;IGNORE;<LZ>	<U25ca>	LOZENGE
<0m>	IGNORE;IGNORE;IGNORE;<0m>	<U25cb>	WHITE CIRCLE
<0o>	IGNORE;IGNORE;IGNORE;<0o>	<U25ce>	BULLSEYE
<0M>	IGNORE;IGNORE;IGNORE;<0M>	<U25cf>	BLACK CIRCLE
<0L>	IGNORE;IGNORE;IGNORE;<0L>	<U25d0>	CIRCLE WITH LEFT HALF BLACK
<0R>	IGNORE;IGNORE;IGNORE;<0R>	<U25d1>	CIRCLE WITH RIGHT HALF BLACK
<Sn>	IGNORE;IGNORE;IGNORE;<Sn>	<U25d8>	INVERSE BULLET
<Ic>	IGNORE;IGNORE;IGNORE;<Ic>	<U25d9>	INVERSE WHITE CIRCLE
<Fd>	IGNORE;IGNORE;IGNORE;<Fd>	<U25e2>	BLACK LOWER RIGHT TRIANGLE
<Bd>	IGNORE;IGNORE;IGNORE;<Bd>	<U25e3>	BLACK LOWER LEFT TRIANGLE
<Ci>	IGNORE;IGNORE;IGNORE;<Ci>	<U25ef>	LARGE CIRCLE
<*2>	IGNORE;IGNORE;IGNORE;<*2>	<U2605>	BLACK STAR
<*1>	IGNORE;IGNORE;IGNORE;<*1>	<U2606>	WHITE STAR
<TEL>	IGNORE;IGNORE;IGNORE;<TEL>	<U260e>	BLACK TELEPHONE
<tel>	IGNORE;IGNORE;IGNORE;<tel>	<U260f>	WHITE TELEPHONE
<<H>	IGNORE;IGNORE;IGNORE;<<H>	<U261c>	WHITE LEFT POINTING INDEX
</>H>	IGNORE;IGNORE;IGNORE;</>H>	<U261e>	WHITE RIGHT POINTING INDEX
<0u>	IGNORE;IGNORE;IGNORE;<0u>	<U263a>	WHITE SMILING FACE
<0U>	IGNORE;IGNORE;IGNORE;<0U>	<U263b>	BLACK SMILING FACE
<SU>	IGNORE;IGNORE;IGNORE;<SU>	<U263c>	WHITE SUN WITH RAYS
<Fm>	IGNORE;IGNORE;IGNORE;<Fm>	<U2640>	FEMALE SIGN
<Ml>	IGNORE;IGNORE;IGNORE;<Ml>	<U2642>	MALE SIGN
<cS>	IGNORE;IGNORE;IGNORE;<cS>	<U2660>	BLACK SPADE SUIT
<cH>	IGNORE;IGNORE;IGNORE;<cH>	<U2661>	WHITE HEART SUIT
<cD>	IGNORE;IGNORE;IGNORE;<cD>	<U2662>	WHITE DIAMOND SUIT
<cC>	IGNORE;IGNORE;IGNORE;<cC>	<U2663>	BLACK CLUB SUIT
<cS->	IGNORE;IGNORE;IGNORE;<cS->	<U2664>	WHITE SPADE SUIT
<cH->	IGNORE;IGNORE;IGNORE;<cH->	<U2665>	BLACK HEART SUIT
<cD->	IGNORE;IGNORE;IGNORE;<cD->	<U2666>	BLACK DIAMOND SUIT
<cC->	IGNORE;IGNORE;IGNORE;<cC->	<U2667>	WHITE CLUB SUIT
<Md>	IGNORE;IGNORE;IGNORE;<Md>	<U2669>	QUARTER NOTE
<M8>	IGNORE;IGNORE;IGNORE;<M8>	<U266a>	EIGHTH NOTE
<M2>	IGNORE;IGNORE;IGNORE;<M2>	<U266b>	BEAMED EIGHTH NOTES
<M16>	IGNORE;IGNORE;IGNORE;<M16>	<U266c>	BEAMED SIXTEENTH NOTES
<Mb>	IGNORE;IGNORE;IGNORE;<Mb>	<U266d>	MUSIC FLAT SIGN
<Mx>	IGNORE;IGNORE;IGNORE;<Mx>	<U266e>	MUSIC NATURAL SIGN
<MX>	IGNORE;IGNORE;IGNORE;<MX>	<U266f>	MUSIC SHARP SIGN
<OK>	IGNORE;IGNORE;IGNORE;<OK>	<U2713>	CHECK MARK
<XX>	IGNORE;IGNORE;IGNORE;<XX>	<U2717>	BALLOT X
<-X>	IGNORE;IGNORE;IGNORE;<-X>	<U2720>	MALTESE CROSS
<IS>	IGNORE;IGNORE;IGNORE;<IS>	<U3000>	IDEOGRAPHIC SPACE
<,_>	IGNORE;IGNORE;IGNORE;<,_>	<U3001>	IDEOGRAPHIC COMMA
<._>	IGNORE;IGNORE;IGNORE;<._>	<U3002>	IDEOGRAPHIC FULL STOP
<+">	IGNORE;IGNORE;IGNORE;<+">	<U3003>	DITTO MARK
<JIS>	IGNORE;IGNORE;IGNORE;<JIS>	<U3004>	JAPANESE INDUSTRIAL STANDARD SIGN
<*_>	IGNORE;IGNORE;IGNORE;<*_>	<U3005>	IDEOGRAPHIC ITERATION MARK
<;_>	IGNORE;IGNORE;IGNORE;<;_>	<U3006>	IDEOGRAPHIC CLOSING MARK
<0_>	IGNORE;IGNORE;IGNORE;<0_>	<U3007>	IDEOGRAPHIC NUMBER ZERO
<<+>	IGNORE;IGNORE;IGNORE;<<+>	<U300a>	LEFT DOUBLE ANGLE BRACKET
</>+>	IGNORE;IGNORE;IGNORE;</>+>	<U300b>	RIGHT DOUBLE ANGLE BRACKET
<<'>	IGNORE;IGNORE;IGNORE;<<'>	<U300c>	LEFT CORNER BRACKET
</>'>	IGNORE;IGNORE;IGNORE;</>'>	<U300d>	RIGHT CORNER BRACKET
<<">	IGNORE;IGNORE;IGNORE;<<">	<U300e>	LEFT WHITE CORNER BRACKET
</>">	IGNORE;IGNORE;IGNORE;</>">	<U300f>	RIGHT WHITE CORNER BRACKET
<(">	IGNORE;IGNORE;IGNORE;<(">	<U3010>	LEFT BLACK LENTICULAR BRACKET
<)">	IGNORE;IGNORE;IGNORE;<)">	<U3011>	RIGHT BLACK LENTICULAR BRACKET
<=T>	IGNORE;IGNORE;IGNORE;<=T>	<U3012>	POSTAL MARK
<=_>	IGNORE;IGNORE;IGNORE;<=_>	<U3013>	GETA MARK
<('>	IGNORE;IGNORE;IGNORE;<('>	<U3014>	LEFT TORTOISE SHELL BRACKET
<)'>	IGNORE;IGNORE;IGNORE;<)'>	<U3015>	RIGHT TORTOISE SHELL BRACKET
<(I>	IGNORE;IGNORE;IGNORE;<(I>	<U3016>	LEFT WHITE LENTICULAR BRACKET
<)I>	IGNORE;IGNORE;IGNORE;<)I>	<U3017>	RIGHT WHITE LENTICULAR BRACKET
<-?>	IGNORE;IGNORE;IGNORE;<-?>	<U301c>	WAVE DASH
<=T:)>	IGNORE;IGNORE;IGNORE;<=T:)>	<U3020>	POSTAL MARK FACE
<"5>	IGNORE;IGNORE;IGNORE;<"5>	<U309b>	KATAKANA-HIRAGANA VOICED SOUND MARK
<05>	IGNORE;IGNORE;IGNORE;<05>	<U309c>	KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
<*5>	IGNORE;IGNORE;IGNORE;<*5>	<U309d>	HIRAGANA ITERATION MARK
<+5>	IGNORE;IGNORE;IGNORE;<+5>	<U309e>	HIRAGANA VOICED ITERATION MARK
<.6>	IGNORE;IGNORE;IGNORE;<.6>	<U30fb>	KATAKANA MIDDLE DOT
<-6>	IGNORE;IGNORE;IGNORE;<-6>	<U30fc>	KATAKANA-HIRAGANA PROLONGED SOUND MARK
<*6>	IGNORE;IGNORE;IGNORE;<*6>	<U30fd>	KATAKANA ITERATION MARK
<+6>	IGNORE;IGNORE;IGNORE;<+6>	<U30fe>	KATAKANA VOICED ITERATION MARK
<(JU)>	IGNORE;IGNORE;IGNORE;<(JU)>	<U321c>	PARENTHESIZED HANGUL CIEUC U
<1c>	IGNORE;IGNORE;IGNORE;<1c>	<U3220>	PARENTHESIZED IDEOGRAPH ONE
<2c>	IGNORE;IGNORE;IGNORE;<2c>	<U3221>	PARENTHESIZED IDEOGRAPH TWO
<3c>	IGNORE;IGNORE;IGNORE;<3c>	<U3222>	PARENTHESIZED IDEOGRAPH THREE
<4c>	IGNORE;IGNORE;IGNORE;<4c>	<U3223>	PARENTHESIZED IDEOGRAPH FOUR
<5c>	IGNORE;IGNORE;IGNORE;<5c>	<U3224>	PARENTHESIZED IDEOGRAPH FIVE
<6c>	IGNORE;IGNORE;IGNORE;<6c>	<U3225>	PARENTHESIZED IDEOGRAPH SIX
<7c>	IGNORE;IGNORE;IGNORE;<7c>	<U3226>	PARENTHESIZED IDEOGRAPH SEVEN
<8c>	IGNORE;IGNORE;IGNORE;<8c>	<U3227>	PARENTHESIZED IDEOGRAPH EIGHT
<9c>	IGNORE;IGNORE;IGNORE;<9c>	<U3228>	PARENTHESIZED IDEOGRAPH NINE
<10c>	IGNORE;IGNORE;IGNORE;<10c>	<U3229>	PARENTHESIZED IDEOGRAPH TEN
<KSC>	IGNORE;IGNORE;IGNORE;<KSC>	<U327f>	KOREAN STANDARD SYMBOL
<am>	IGNORE;IGNORE;IGNORE;<am>	<U33c2>	SQUARE AM
<pm>	IGNORE;IGNORE;IGNORE;<pm>	<U33d8>	SQUARE PM
<NU>	IGNORE;IGNORE;IGNORE;<NU>	<U0000>	NULL (NUL)
<SH>	IGNORE;IGNORE;IGNORE;<SH>	<U0001>	START OF HEADING (SOH)
<SX>	IGNORE;IGNORE;IGNORE;<SX>	<U0002>	START OF TEXT (STX)
<EX>	IGNORE;IGNORE;IGNORE;<EX>	<U0003>	END OF TEXT (ETX)
<ET>	IGNORE;IGNORE;IGNORE;<ET>	<U0004>	END OF TRANSMISSION (EOT)
<EQ>	IGNORE;IGNORE;IGNORE;<EQ>	<U0005>	ENQUIRY (ENQ)
<AK>	IGNORE;IGNORE;IGNORE;<AK>	<U0006>	ACKNOWLEDGE (ACK)
<BL>	IGNORE;IGNORE;IGNORE;<BL>	<U0007>	BELL (BEL)
<BS>	IGNORE;IGNORE;IGNORE;<BS>	<U0008>	BACKSPACE (BS)
<SO>	IGNORE;IGNORE;IGNORE;<SO>	<U000e>	SHIFT OUT (SO)
<SI>	IGNORE;IGNORE;IGNORE;<SI>	<U000f>	SHIFT IN (SI)
<DL>	IGNORE;IGNORE;IGNORE;<DL>	<U0010>	DATALINK ESCAPE (DLE)
<D1>	IGNORE;IGNORE;IGNORE;<D1>	<U0011>	DEVICE CONTROL ONE (DC1)
<D2>	IGNORE;IGNORE;IGNORE;<D2>	<U0012>	DEVICE CONTROL TWO (DC2)
<D3>	IGNORE;IGNORE;IGNORE;<D3>	<U0013>	DEVICE CONTROL THREE (DC3)
<D4>	IGNORE;IGNORE;IGNORE;<D4>	<U0014>	DEVICE CONTROL FOUR (DC4)
<NK>	IGNORE;IGNORE;IGNORE;<NK>	<U0015>	NEGATIVE ACKNOWLEDGE (NAK)
<SY>	IGNORE;IGNORE;IGNORE;<SY>	<U0016>	SYNCRONOUS IDLE (SYN)
<EB>	IGNORE;IGNORE;IGNORE;<EB>	<U0017>	END OF TRANSMISSION BLOCK (ETB)
<CN>	IGNORE;IGNORE;IGNORE;<CN>	<U0018>	CANCEL (CAN)
<EM>	IGNORE;IGNORE;IGNORE;<EM>	<U0019>	END OF MEDIUM (EM)
<SB>	IGNORE;IGNORE;IGNORE;<SB>	<U001a>	SUBSTITUTE (SUB)
<EC>	IGNORE;IGNORE;IGNORE;<EC>	<U001b>	ESCAPE (ESC)
<FS>	IGNORE;IGNORE;IGNORE;<FS>	<U001c>	FILE SEPARATOR (IS4)
<GS>	IGNORE;IGNORE;IGNORE;<GS>	<U001d>	GROUP SEPARATOR (IS3)
<RS>	IGNORE;IGNORE;IGNORE;<RS>	<U001e>	RECORD SEPARATOR (IS2)
<US>	IGNORE;IGNORE;IGNORE;<US>	<U001f>	UNIT SEPARATOR (IS1)
<DT>	IGNORE;IGNORE;IGNORE;<DT>	<U007f>	DELETE (DEL)
<PA>	IGNORE;IGNORE;IGNORE;<PA>	<U0080>	PADDING CHARACTER (PAD)
<HO>	IGNORE;IGNORE;IGNORE;<HO>	<U0081>	HIGH OCTET PRESET (HOP)
<BH>	IGNORE;IGNORE;IGNORE;<BH>	<U0082>	BREAK PERMITTED HERE (BPH)
<NH>	IGNORE;IGNORE;IGNORE;<NH>	<U0083>	NO BREAK HERE (NBH)
<IN>	IGNORE;IGNORE;IGNORE;<IN>	<U0084>	INDEX (IND)
<NL>	IGNORE;IGNORE;IGNORE;<NL>	<U0085>	NEXT LINE (NEL)
<SA>	IGNORE;IGNORE;IGNORE;<SA>	<U0086>	START OF SELECTED AREA (SSA)
<ES>	IGNORE;IGNORE;IGNORE;<ES>	<U0087>	END OF SELECTED AREA (ESA)
<HS>	IGNORE;IGNORE;IGNORE;<HS>	<U0088>	CHARACTER TABULATION SET (HTS)
<HJ>	IGNORE;IGNORE;IGNORE;<HJ>	<U0089>	CHARACTER TABULATION WITH JUSTIFICATION (HTJ)
<VS>	IGNORE;IGNORE;IGNORE;<VS>	<U008a>	LINE TABULATION SET (VTS)
<PD>	IGNORE;IGNORE;IGNORE;<PD>	<U008b>	PARTIAL LINE FORWARD (PLD)
<PU>	IGNORE;IGNORE;IGNORE;<PU>	<U008c>	PARTIAL LINE BACKWARD (PLU)
<RI>	IGNORE;IGNORE;IGNORE;<RI>	<U008d>	REVERSE LINE FEED (RI)
<S2>	IGNORE;IGNORE;IGNORE;<S2>	<U008e>	SINGLE-SHIFT TWO (SS2)
<S3>	IGNORE;IGNORE;IGNORE;<S3>	<U008f>	SINGLE-SHIFT THREE (SS3)
<DC>	IGNORE;IGNORE;IGNORE;<DC>	<U0090>	DEVICE CONTROL STRING (DCS)
<P1>	IGNORE;IGNORE;IGNORE;<P1>	<U0091>	PRIVATE USE ONE (PU1)
<P2>	IGNORE;IGNORE;IGNORE;<P2>	<U0092>	PRIVATE USE TWO (PU2)
<TS>	IGNORE;IGNORE;IGNORE;<TS>	<U0093>	SET TRANSMIT STATE (STS)
<CC>	IGNORE;IGNORE;IGNORE;<CC>	<U0094>	CANCEL CHARACTER (CCH)
<MW>	IGNORE;IGNORE;IGNORE;<MW>	<U0095>	MESSAGE WAITING (MW)
<SG>	IGNORE;IGNORE;IGNORE;<SG>	<U0096>	START OF GUARDED AREA (SPA)
<EG>	IGNORE;IGNORE;IGNORE;<EG>	<U0097>	END OF GUARDED AREA (EPA)
<SS>	IGNORE;IGNORE;IGNORE;<SS>	<U0098>	START OF STRING (SOS)
<GC>	IGNORE;IGNORE;IGNORE;<GC>	<U0099>	SINGLE GRAPHIC CHARACTER INTRODUCER (SGCI)
<SC>	IGNORE;IGNORE;IGNORE;<SC>	<U009a>	SINGLE CHARACTER INTRODUCER (SCI)
<CI>	IGNORE;IGNORE;IGNORE;<CI>	<U009b>	CONTROL SEQUENCE INTRODUCER (CSI)
<ST>	IGNORE;IGNORE;IGNORE;<ST>	<U009c>	STRING TERMINATOR (ST)
<OC>	IGNORE;IGNORE;IGNORE;<OC>	<U009d>	OPERATING SYSTEM COMMAND (OSC)
<PM>	IGNORE;IGNORE;IGNORE;<PM>	<U009e>	PRIVACY MESSAGE (PM)
<AC>	IGNORE;IGNORE;IGNORE;<AC>	<U009f>	APPLICATION PROGRAM COMMAND (APC)
<"3>	IGNORE;IGNORE;IGNORE;<"3>	<ISO-IR-53_C9>   	NON-SPACING UMLAUT  (not a real character)
<"1>	IGNORE;IGNORE;IGNORE;<"1>	<ISO-IR-70_C0>   	NON-SPACING DIAERESIS WITH ACCENT  (not a real character)
<"!>	IGNORE;IGNORE;IGNORE;<"!>	<ISO-IR-103_C1>   	NON-SPACING GRAVE ACCENT  (not a real character)
<"'>	IGNORE;IGNORE;IGNORE;<"'>	<ISO-IR-103_C2>   	NON-SPACING ACUTE ACCENT  (not a real character)
<"/>>	IGNORE;IGNORE;IGNORE;<"/>>	<ISO-IR-103_C3>   	NON-SPACING CIRCUMFLEX ACCENT  (not a real character)
<"?>	IGNORE;IGNORE;IGNORE;<"?>	<ISO-IR-103_C4>   	NON-SPACING TILDE  (not a real character)
<"->	IGNORE;IGNORE;IGNORE;<"->	<ISO-IR-103_C5>   	NON-SPACING MACRON  (not a real character)
<"(>	IGNORE;IGNORE;IGNORE;<"(>	<ISO-IR-103_C6>   	NON-SPACING BREVE  (not a real character)
<".>	IGNORE;IGNORE;IGNORE;<".>	<ISO-IR-103_C7>   	NON-SPACING DOT ABOVE  (not a real character)
<":>	IGNORE;IGNORE;IGNORE;<":>	<ISO-IR-103_C8>   	NON-SPACING DIAERESIS  (not a real character)
<"0>	IGNORE;IGNORE;IGNORE;<"0>	<ISO-IR-103_CA>   	NON-SPACING RING ABOVE  (not a real character)
<",>	IGNORE;IGNORE;IGNORE;<",>	<ISO-IR-103_CB>   	NON-SPACING CEDILLA  (not a real character)
<"_>	IGNORE;IGNORE;IGNORE;<"_>	<ISO-IR-103_CC>   	NON-SPACING LOW LINE  (not a real character)
<"">	IGNORE;IGNORE;IGNORE;<"">	<ISO-IR-103_CD>   	NON-SPACING DOUBLE ACCUTE ACCENT  (not a real character)
<";>	IGNORE;IGNORE;IGNORE;<";>	<ISO-IR-103_CE>   	NON-SPACING OGONEK  (not a real character)
<"<>	IGNORE;IGNORE;IGNORE;<"<>	<ISO-IR-103_CF>   	NON-SPACING CARON  (not a real character)
<"=>	IGNORE;IGNORE;IGNORE;<"=>	<ISO-IR-38_D9>   	NON-SPACING DOUBLE LOW LINE  (not a real character)
<"//>	IGNORE;IGNORE;IGNORE;<"//>	<ISO-IR-128_C9>   	NON-SPACING LONG SOLIDUS OVERLAY  (not a real character)
<"p>	IGNORE;IGNORE;IGNORE;<"p>	<ISO-IR-55_25>   	GREEK NON-SPACING PSILI PNEUMATA  (not a real character)
<"d>	IGNORE;IGNORE;IGNORE;<"d>	<ISO-IR-55_26>   	GREEK NON-SPACING DASIA PNEUMATA  (not a real character)
<"i>	IGNORE;IGNORE;IGNORE;<"i>	<ISO-IR-55_27>   	GREEK NON-SPACING IOTA BELOW  (not a real character)
<+_>	IGNORE;IGNORE;IGNORE;<+_>	<ISO-IR-87_2138>   	IDEOGRAPHIC DITTO MARK
<Tel>	IGNORE;IGNORE;IGNORE;<Tel>	<ISO-IR-149_2265>   	TEL COMPATIBILITY SIGN
<UA>	IGNORE;IGNORE;IGNORE;<UA>	<ISO-IR-8-1_40>   	Unit space A
<UB>	IGNORE;IGNORE;IGNORE;<UB>	<ISO-IR-8-1_60>   	Unit space B
UNDEFINED	IGNORE;IGNORE;IGNORE

<0>	<0>;<0>;IGNORE;IGNORE	<U0030>	DIGIT ZERO
<0S>	<0>;<0S>;IGNORE;IGNORE	<U2070>	SUPERSCRIPT ZERO
<18>	<0>;<18>;IGNORE;IGNORE	<U215b>	VULGAR FRACTION ONE EIGHTH
<14>	<0>;<14>;IGNORE;IGNORE	<U00bc>	VULGAR FRACTION ONE QUARTER
<38>	<0>;<38>;IGNORE;IGNORE	<U215c>	VULGAR FRACTION THREE EIGHTHS
<12>	<0>;<12>;IGNORE;IGNORE	<U00bd>	VULGAR FRACTION ONE HALF
<58>	<0>;<58>;IGNORE;IGNORE	<U215d>	VULGAR FRACTION FIVE EIGHTHS
<34>	<0>;<34>;IGNORE;IGNORE	<U00be>	VULGAR FRACTION THREE QUARTERS
<78>	<0>;<78>;IGNORE;IGNORE	<U215e>	VULGAR FRACTION SEVEN EIGHTHS
<1>	<1>;<1>;IGNORE;IGNORE	<U0031>	DIGIT ONE
<2>	<2>;<2>;IGNORE;IGNORE	<U0032>	DIGIT TWO
<3>	<3>;<3>;IGNORE;IGNORE	<U0033>	DIGIT THREE
<4>	<4>;<4>;IGNORE;IGNORE	<U0034>	DIGIT FOUR
<5>	<5>;<5>;IGNORE;IGNORE	<U0035>	DIGIT FIVE
<6>	<6>;<6>;IGNORE;IGNORE	<U0036>	DIGIT SIX
<7>	<7>;<7>;IGNORE;IGNORE	<U0037>	DIGIT SEVEN
<8>	<8>;<8>;IGNORE;IGNORE	<U0038>	DIGIT EIGHT
<9>	<9>;<9>;IGNORE;IGNORE	<U0039>	DIGIT NINE
<1S>	<1>;<1S>;IGNORE;IGNORE	<U00b9>	SUPERSCRIPT ONE
<2S>	<2>;<2S>;IGNORE;IGNORE	<U00b2>	SUPERSCRIPT TWO
<3S>	<3>;<3S>;IGNORE;IGNORE	<U00b3>	SUPERSCRIPT THREE
<4S>	<4>;<4S>;IGNORE;IGNORE	<U2074>	SUPERSCRIPT FOUR
<5S>	<5>;<5S>;IGNORE;IGNORE	<U2075>	SUPERSCRIPT FIVE
<6S>	<6>;<6S>;IGNORE;IGNORE	<U2076>	SUPERSCRIPT SIX
<7S>	<7>;<7S>;IGNORE;IGNORE	<U2077>	SUPERSCRIPT SEVEN
<8S>	<8>;<8S>;IGNORE;IGNORE	<U2078>	SUPERSCRIPT EIGHT
<9S>	<9>;<9S>;IGNORE;IGNORE	<U2079>	SUPERSCRIPT NINE
<A>	<A>;<NONE>;<CAPITAL>;IGNORE	<U0041>	LATIN CAPITAL LETTER A
<a>	<A>;<NONE>;<SMALL>;IGNORE	<U0061>	LATIN SMALL LETTER A
<-a>	<A>;<NONE>;<-a>;IGNORE	<U00aa>	FEMININE ORDINAL INDICATOR
<A'>	<A>;<ACUTE>;<CAPITAL>;IGNORE	<U00c1>	LATIN CAPITAL LETTER A WITH ACUTE
<a'>	<A>;<ACUTE>;<SMALL>;IGNORE	<U00e1>	LATIN SMALL LETTER A WITH ACUTE
<A!>	<A>;<GRAVE>;<CAPITAL>;IGNORE	<U00c0>	LATIN CAPITAL LETTER A WITH GRAVE
<a!>	<A>;<GRAVE>;<SMALL>;IGNORE	<U00e0>	LATIN SMALL LETTER A WITH GRAVE
<A!!>	<A>;<DOUBLE-GRAVE>;<CAPITAL>;IGNORE	<U0200>	LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
<a!!>	<A>;<DOUBLE-GRAVE>;<SMALL>;IGNORE	<U0201>	LATIN SMALL LETTER A WITH DOUBLE GRAVE
<A(>	<A>;<BREVE>;<CAPITAL>;IGNORE	<U0102>	LATIN CAPITAL LETTER A WITH BREVE
<a(>	<A>;<BREVE>;<SMALL>;IGNORE	<U0103>	LATIN SMALL LETTER A WITH BREVE
<A('>	<A>;<BREVE+ACUTE>;<CAPITAL>;IGNORE	<U1eae>	LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
<a('>	<A>;<BREVE+ACUTE>;<SMALL>;IGNORE	<U1eaf>	LATIN SMALL LETTER A WITH BREVE AND ACUTE
<A(!>	<A>;<BREVE+GRAVE>;<CAPITAL>;IGNORE	<U1eb0>	LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
<a(!>	<A>;<BREVE+GRAVE>;<SMALL>;IGNORE	<U1eb1>	LATIN SMALL LETTER A WITH BREVE AND GRAVE
<A(2>	<A>;<BREVE+HOOK>;<CAPITAL>;IGNORE	<U1eb2>	LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
<a(2>	<A>;<BREVE+HOOK>;<SMALL>;IGNORE	<U1eb3>	LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE
<A(?>	<A>;<BREVE+TILDE>;<CAPITAL>;IGNORE	<U1eb4>	LATIN CAPITAL LETTER A WITH BREVE AND TILDE
<a(?>	<A>;<BREVE+TILDE>;<SMALL>;IGNORE	<U1eb5>	LATIN SMALL LETTER A WITH BREVE AND TILDE
<A(-.>	<A>;<BREVE+DOT-BELOW>;<CAPITAL>;IGNORE	<U1eb6>	LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
<a(-.>	<A>;<BREVE+DOT-BELOW>;<SMALL>;IGNORE	<U1eb7>	LATIN SMALL LETTER A WITH BREVE AND DOT BELOW
<A)>	<A>;<INVERTED-BREVE>;<CAPITAL>;IGNORE	<U0202>	LATIN CAPITAL LETTER A WITH INVERTED BREVE
<a)>	<A>;<INVERTED-BREVE>;<SMALL>;IGNORE	<U0203>	LATIN SMALL LETTER A WITH INVERTED BREVE
<A/>>	<A>;<CIRCUMFLEX>;<CAPITAL>;IGNORE	<U00c2>	LATIN CAPITAL LETTER A WITH CIRCUMFLEX
<a/>>	<A>;<CIRCUMFLEX>;<SMALL>;IGNORE	<U00e2>	LATIN SMALL LETTER A WITH CIRCUMFLEX
<A/>'>	<A>;<CIRCUMFLEX+ACUTE>;<CAPITAL>;IGNORE	<U1ea4>	LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
<a/>'>	<A>;<CIRCUMFLEX+ACUTE>;<SMALL>;IGNORE	<U1ea5>	LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE
<A/>!>	<A>;<CIRCUMFLEX+GRAVE>;<CAPITAL>;IGNORE	<U1ea6>	LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
<a/>!>	<A>;<CIRCUMFLEX+GRAVE>;<SMALL>;IGNORE	<U1ea7>	LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE
<A/>2>	<A>;<CIRCUMFLEX+HOOK>;<CAPITAL>;IGNORE	<U1ea8>	LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
<a/>2>	<A>;<CIRCUMFLEX+HOOK>;<SMALL>;IGNORE	<U1ea9>	LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
<A/>?>	<A>;<CIRCUMFLEX+TILDE>;<CAPITAL>;IGNORE	<U1eaa>	LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
<a/>?>	<A>;<CIRCUMFLEX+TILDE>;<SMALL>;IGNORE	<U1eab>	LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE
<A/>-.>	<A>;<CIRCUMFLEX+DOT-BELOW>;<CAPITAL>;IGNORE	<U1eac>	LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
<a/>-.>	<A>;<CIRCUMFLEX+DOT-BELOW>;<SMALL>;IGNORE	<U1ead>	LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW
<A<>	<A>;<CARON>;<CAPITAL>;IGNORE	<U01cd>	LATIN CAPITAL LETTER A WITH CARON
<a<>	<A>;<CARON>;<SMALL>;IGNORE	<U01ce>	LATIN SMALL LETTER A WITH CARON
<AA>	<A>;<RING>;<CAPITAL>;IGNORE	<U00c5>	LATIN CAPITAL LETTER A WITH RING ABOVE
<aa>	<A>;<RING>;<SMALL>;IGNORE	<U00e5>	LATIN SMALL LETTER A WITH RING ABOVE
<AA'>	<A>;<RING+ACUTE>;<CAPITAL>;IGNORE	<U01fa>	LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
<aa'>	<A>;<RING+ACUTE>;<SMALL>;IGNORE	<U01fb>	LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
<A-0>	<A>;<RING-BELOW>;<CAPITAL>;IGNORE	<U1e00>	LATIN CAPITAL LETTER A WITH RING BELOW
<a-0>	<A>;<RING-BELOW>;<SMALL>;IGNORE	<U1e01>	LATIN SMALL LETTER A WITH RING BELOW
<A:>	<A>;<DIAERESIS>;<CAPITAL>;IGNORE	<U00c4>	LATIN CAPITAL LETTER A WITH DIAERESIS
<a:>	<A>;<DIAERESIS>;<SMALL>;IGNORE	<U00e4>	LATIN SMALL LETTER A WITH DIAERESIS
<A1>	<A>;<DIAERESIS+MACRON>;<CAPITAL>;IGNORE	<U01de>	LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
<a1>	<A>;<DIAERESIS+MACRON>;<SMALL>;IGNORE	<U01df>	LATIN SMALL LETTER A WITH DIAERESIS AND MACRON
<A2>	<A>;<HOOK>;<CAPITAL>;IGNORE	<U1ea2>	LATIN CAPITAL LETTER A WITH HOOK ABOVE
<a2>	<A>;<HOOK>;<SMALL>;IGNORE	<U1ea3>	LATIN SMALL LETTER A WITH HOOK ABOVE
<A?>	<A>;<TILDE>;<CAPITAL>;IGNORE	<U00c3>	LATIN CAPITAL LETTER A WITH TILDE
<a?>	<A>;<TILDE>;<SMALL>;IGNORE	<U00e3>	LATIN SMALL LETTER A WITH TILDE
<A-.>	<A>;<DOT-BELOW>;<CAPITAL>;IGNORE	<U1ea0>	LATIN CAPITAL LETTER A WITH DOT BELOW
<a-.>	<A>;<DOT-BELOW>;<SMALL>;IGNORE	<U1ea1>	LATIN SMALL LETTER A WITH DOT BELOW
<A;>	<A>;<OGONEK>;<CAPITAL>;IGNORE	<U0104>	LATIN CAPITAL LETTER A WITH OGONEK
<a;>	<A>;<OGONEK>;<SMALL>;IGNORE	<U0105>	LATIN SMALL LETTER A WITH OGONEK
<A->	<A>;<MACRON>;<CAPITAL>;IGNORE	<U0100>	LATIN CAPITAL LETTER A WITH MACRON
<a->	<A>;<MACRON>;<SMALL>;IGNORE	<U0101>	LATIN SMALL LETTER A WITH MACRON
<A7>	<A>;<MACRON+DOT>;<CAPITAL>;IGNORE	<U01e0>	LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
<a7>	<A>;<MACRON+DOT>;<SMALL>;IGNORE	<U01e1>	LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON
<a8>
<AE>	"<A><E>";"<AE><AE>";"<CAPITAL><CAPITAL>";IGNORE	<U00c6>	LATIN CAPITAL LETTER AE
<ae>	"<A><E>";"<AE><AE>";"<SMALL><SMALL>";IGNORE	<U00e6>	LATIN SMALL LETTER AE
<AE'>	"<A><E>";"<AE'><AE'>";"<CAPITAL><CAPITAL>";IGNORE	<U01fc>	LATIN CAPITAL LETTER AE WITH ACUTE
<ae'>	"<A><E>";"<AE'><AE'>";"<SMALL><SMALL>";IGNORE	<U01fd>	LATIN SMALL LETTER AE WITH ACUTE
<A3>	"<A><E>";"<A3><A3>";"<CAPITAL><CAPITAL>";IGNORE	<U01e2>	LATIN CAPITAL LETTER AE WITH MACRON
<a3>	"<A><E>";"<A3><A3>";"<SMALL><SMALL>";IGNORE	<U01e3>	LATIN SMALL LETTER AE WITH MACRON
<B>	<B>;<NONE>;<CAPITAL>;IGNORE	<U0042>	LATIN CAPITAL LETTER B
<b>	<B>;<NONE>;<SMALL>;IGNORE	<U0062>	LATIN SMALL LETTER B
<B.>	<B>;<DOT>;<CAPITAL>;IGNORE	<U1e02>	LATIN CAPITAL LETTER B WITH DOT ABOVE
<b.>	<B>;<DOT>;<SMALL>;IGNORE	<U1e03>	LATIN SMALL LETTER B WITH DOT ABOVE
<B-.>	<B>;<DOT-BELOW>;<CAPITAL>;IGNORE	<U1e04>	LATIN CAPITAL LETTER B WITH DOT BELOW
<b-.>	<B>;<DOT-BELOW>;<SMALL>;IGNORE	<U1e05>	LATIN SMALL LETTER B WITH DOT BELOW
<B_>	<B>;<LINE-BELOW>;<CAPITAL>;IGNORE	<U1e06>	LATIN CAPITAL LETTER B WITH LINE BELOW
<b_>	<B>;<LINE-BELOW>;<SMALL>;IGNORE	<U1e07>	LATIN SMALL LETTER B WITH LINE BELOW
<b8>
<C>	<C>;<NONE>;<CAPITAL>;IGNORE	<U0043>	LATIN CAPITAL LETTER C
<c>	<C>;<NONE>;<SMALL>;IGNORE	<U0063>	LATIN SMALL LETTER C
<C'>	<C>;<ACUTE>;<CAPITAL>;IGNORE	<U0106>	LATIN CAPITAL LETTER C WITH ACUTE
<c'>	<C>;<ACUTE>;<SMALL>;IGNORE	<U0107>	LATIN SMALL LETTER C WITH ACUTE
<C/>>	<C>;<CIRCUMFLEX>;<CAPITAL>;IGNORE	<U0108>	LATIN CAPITAL LETTER C WITH CIRCUMFLEX
<c/>>	<C>;<CIRCUMFLEX>;<SMALL>;IGNORE	<U0109>	LATIN SMALL LETTER C WITH CIRCUMFLEX
<C<>	<C>;<CARON>;<CAPITAL>;IGNORE	<U010c>	LATIN CAPITAL LETTER C WITH CARON
<c<>	<C>;<CARON>;<SMALL>;IGNORE	<U010d>	LATIN SMALL LETTER C WITH CARON
<C2>	<C>;<HOOK>;<CAPITAL>;IGNORE	<U0187>	LATIN CAPITAL LETTER C WITH HOOK
<c2>	<C>;<HOOK>;<SMALL>;IGNORE	<U0188>	LATIN SMALL LETTER C WITH HOOK
<C.>	<C>;<DOT>;<CAPITAL>;IGNORE	<U010a>	LATIN CAPITAL LETTER C WITH DOT ABOVE
<c.>	<C>;<DOT>;<SMALL>;IGNORE	<U010b>	LATIN SMALL LETTER C WITH DOT ABOVE
<C,>	<C>;<CEDILLA>;<CAPITAL>;IGNORE	<U00c7>	LATIN CAPITAL LETTER C WITH CEDILLA
<c,>	<C>;<CEDILLA>;<SMALL>;IGNORE	<U00e7>	LATIN SMALL LETTER C WITH CEDILLA
<C,'>	<C>;<CEDILLA+ACUTE>;<CAPITAL>;IGNORE	<U1e08>	LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
<c,'>	<C>;<CEDILLA+ACUTE>;<SMALL>;IGNORE	<U1e09>	LATIN SMALL LETTER C WITH CEDILLA AND ACUTE
<c8>
<D>	<D>;<NONE>;<CAPITAL>;IGNORE	<U0044>	LATIN CAPITAL LETTER D
<d>	<D>;<NONE>;<SMALL>;IGNORE	<U0064>	LATIN SMALL LETTER D
<D<>	<D>;<CARON>;<CAPITAL>;IGNORE	<U010e>	LATIN CAPITAL LETTER D WITH CARON
<d<>	<D>;<CARON>;<SMALL>;IGNORE	<U010f>	LATIN SMALL LETTER D WITH CARON
<D.>	<D>;<DOT>;<CAPITAL>;IGNORE	<U1e0a>	LATIN CAPITAL LETTER D WITH DOT ABOVE
<d.>	<D>;<DOT>;<SMALL>;IGNORE	<U1e0b>	LATIN SMALL LETTER D WITH DOT ABOVE
<D-.>	<D>;<DOT-BELOW>;<CAPITAL>;IGNORE	<U1e0c>	LATIN CAPITAL LETTER D WITH DOT BELOW
<d-.>	<D>;<DOT-BELOW>;<SMALL>;IGNORE	<U1e0d>	LATIN SMALL LETTER D WITH DOT BELOW
<D//>	<D>;<STROKE>;<CAPITAL>;IGNORE	<U0110>	LATIN CAPITAL LETTER D WITH STROKE
<d//>	<D>;<STROKE>;<SMALL>;IGNORE	<U0111>	LATIN SMALL LETTER D WITH STROKE
<D,>	<D>;<CEDILLA>;<CAPITAL>;IGNORE	<U1e10>	LATIN CAPITAL LETTER D WITH CEDILLA
<d,>	<D>;<CEDILLA>;<SMALL>;IGNORE	<U1e11>	LATIN SMALL LETTER D WITH CEDILLA
<D-/>>	<D>;<MACRON+CIRCUMFLEX>;<CAPITAL>;IGNORE	<U1e12>	LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
<d-/>>	<D>;<MACRON+CIRCUMFLEX>;<SMALL>;IGNORE	<U1e13>	LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW
<D_>	<D>;<LINE-BELOW>;<CAPITAL>;IGNORE	<U1e0e>	LATIN CAPITAL LETTER D WITH LINE BELOW
<d_>	<D>;<LINE-BELOW>;<SMALL>;IGNORE	<U1e0f>	LATIN SMALL LETTER D WITH LINE BELOW
<d8>
<E>	<E>;<NONE>;<CAPITAL>;IGNORE	<U0045>	LATIN CAPITAL LETTER E
<e>	<E>;<NONE>;<SMALL>;IGNORE	<U0065>	LATIN SMALL LETTER E
<E'>	<E>;<ACUTE>;<CAPITAL>;IGNORE	<U00c9>	LATIN CAPITAL LETTER E WITH ACUTE
<e'>	<E>;<ACUTE>;<SMALL>;IGNORE	<U00e9>	LATIN SMALL LETTER E WITH ACUTE
<E!>	<E>;<GRAVE>;<CAPITAL>;IGNORE	<U00c8>	LATIN CAPITAL LETTER E WITH GRAVE
<e!>	<E>;<GRAVE>;<SMALL>;IGNORE	<U00e8>	LATIN SMALL LETTER E WITH GRAVE
<E!!>	<E>;<DOUBLE-GRAVE>;<CAPITAL>;IGNORE	<U0204>	LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
<e!!>	<E>;<DOUBLE-GRAVE>;<SMALL>;IGNORE	<U0205>	LATIN SMALL LETTER E WITH DOUBLE GRAVE
<E(>	<E>;<BREVE>;<CAPITAL>;IGNORE	<U0114>	LATIN CAPITAL LETTER E WITH BREVE
<e(>	<E>;<BREVE>;<SMALL>;IGNORE	<U0115>	LATIN SMALL LETTER E WITH BREVE
<E)>	<E>;<INVERTED-BREVE>;<CAPITAL>;IGNORE	<U0206>	LATIN CAPITAL LETTER E WITH INVERTED BREVE
<e)>	<E>;<INVERTED-BREVE>;<SMALL>;IGNORE	<U0207>	LATIN SMALL LETTER E WITH INVERTED BREVE
<E/>>	<E>;<CIRCUMFLEX>;<CAPITAL>;IGNORE	<U00ca>	LATIN CAPITAL LETTER E WITH CIRCUMFLEX
<e/>>	<E>;<CIRCUMFLEX>;<SMALL>;IGNORE	<U00ea>	LATIN SMALL LETTER E WITH CIRCUMFLEX
<E/>'>	<E>;<CIRCUMFLEX+ACUTE>;<CAPITAL>;IGNORE	<U1ebe>	LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
<e/>'>	<E>;<CIRCUMFLEX+ACUTE>;<SMALL>;IGNORE	<U1ebf>	LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
<E/>!>	<E>;<CIRCUMFLEX+GRAVE>;<CAPITAL>;IGNORE	<U1ec0>	LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
<e/>!>	<E>;<CIRCUMFLEX+GRAVE>;<SMALL>;IGNORE	<U1ec1>	LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
<E/>2>	<E>;<CIRCUMFLEX+HOOK>;<CAPITAL>;IGNORE	<U1ec2>	LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
<e/>2>	<E>;<CIRCUMFLEX+HOOK>;<SMALL>;IGNORE	<U1ec3>	LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
<E/>?>	<E>;<CIRCUMFLEX+TILDE>;<CAPITAL>;IGNORE	<U1ec4>	LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
<e/>?>	<E>;<CIRCUMFLEX+TILDE>;<SMALL>;IGNORE	<U1ec5>	LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
<E/>-.>	<E>;<CIRCUMFLEX+DOT-BELOW>;<CAPITAL>;IGNORE	<U1ec6>	LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
<e/>-.>	<E>;<CIRCUMFLEX+DOT-BELOW>;<SMALL>;IGNORE	<U1ec7>	LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
<E<>	<E>;<CARON>;<CAPITAL>;IGNORE	<U011a>	LATIN CAPITAL LETTER E WITH CARON
<e<>	<E>;<CARON>;<SMALL>;IGNORE	<U011b>	LATIN SMALL LETTER E WITH CARON
<E:>	<E>;<DIAERESIS>;<CAPITAL>;IGNORE	<U00cb>	LATIN CAPITAL LETTER E WITH DIAERESIS
<e:>	<E>;<DIAERESIS>;<SMALL>;IGNORE	<U00eb>	LATIN SMALL LETTER E WITH DIAERESIS
<E2>	<E>;<HOOK>;<CAPITAL>;IGNORE	<U1eba>	LATIN CAPITAL LETTER E WITH HOOK ABOVE
<e2>	<E>;<HOOK>;<SMALL>;IGNORE	<U1ebb>	LATIN SMALL LETTER E WITH HOOK ABOVE
<E?>	<E>;<TILDE>;<CAPITAL>;IGNORE	<U1ebc>	LATIN CAPITAL LETTER E WITH TILDE
<e?>	<E>;<TILDE>;<SMALL>;IGNORE	<U1ebd>	LATIN SMALL LETTER E WITH TILDE
<E-?>	<E>;<TILDE-BELOW>;<CAPITAL>;IGNORE	<U1e1a>	LATIN CAPITAL LETTER E WITH TILDE BELOW
<e-?>	<E>;<TILDE-BELOW>;<SMALL>;IGNORE	<U1e1b>	LATIN SMALL LETTER E WITH TILDE BELOW
<E.>	<E>;<DOT>;<CAPITAL>;IGNORE	<U0116>	LATIN CAPITAL LETTER E WITH DOT ABOVE
<e.>	<E>;<DOT>;<SMALL>;IGNORE	<U0117>	LATIN SMALL LETTER E WITH DOT ABOVE
<E-.>	<E>;<DOT-BELOW>;<CAPITAL>;IGNORE	<U1eb8>	LATIN CAPITAL LETTER E WITH DOT BELOW
<e-.>	<E>;<DOT-BELOW>;<SMALL>;IGNORE	<U1eb9>	LATIN SMALL LETTER E WITH DOT BELOW
<E,(>	<E>;<CEDILLA+BREVE>;<CAPITAL>;IGNORE	<U1e1c>	LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
<e,(>	<E>;<CEDILLA+BREVE>;<SMALL>;IGNORE	<U1e1d>	LATIN SMALL LETTER E WITH CEDILLA AND BREVE
<E;>	<E>;<OGONEK>;<CAPITAL>;IGNORE	<U0118>	LATIN CAPITAL LETTER E WITH OGONEK
<e;>	<E>;<OGONEK>;<SMALL>;IGNORE	<U0119>	LATIN SMALL LETTER E WITH OGONEK
<E->	<E>;<MACRON>;<CAPITAL>;IGNORE	<U0112>	LATIN CAPITAL LETTER E WITH MACRON
<e->	<E>;<MACRON>;<SMALL>;IGNORE	<U0113>	LATIN SMALL LETTER E WITH MACRON
<E-'>	<E>;<MACRON+ACUTE>;<CAPITAL>;IGNORE	<U1e16>	LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
<e-'>	<E>;<MACRON+ACUTE>;<SMALL>;IGNORE	<U1e17>	LATIN SMALL LETTER E WITH MACRON AND ACUTE
<E-!>	<E>;<MACRON+GRAVE>;<CAPITAL>;IGNORE	<U1e14>	LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
<e-!>	<E>;<MACRON+GRAVE>;<SMALL>;IGNORE	<U1e15>	LATIN SMALL LETTER E WITH MACRON AND GRAVE
<E-/>>	<E>;<MACRON+CIRCUMFLEX>;<CAPITAL>;IGNORE	<U1e18>	LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
<e-/>>	<E>;<MACRON+CIRCUMFLEX>;<SMALL>;IGNORE	<U1e19>	LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW
<e8>
<F>	<F>;<NONE>;<CAPITAL>;IGNORE	<U0046>	LATIN CAPITAL LETTER F
<f>	<F>;<NONE>;<SMALL>;IGNORE	<U0066>	LATIN SMALL LETTER F
<F2>	<F>;<HOOK>;<CAPITAL>;IGNORE	<U0191>	LATIN CAPITAL LETTER F WITH HOOK
<f2>	<F>;<HOOK>;<SMALL>;IGNORE	<U0192>	LATIN SMALL LETTER F WITH HOOK
<F.>	<F>;<DOT>;<CAPITAL>;IGNORE	<U1e1e>	LATIN CAPITAL LETTER F WITH DOT ABOVE
<f.>	<F>;<DOT>;<SMALL>;IGNORE	<U1e1f>	LATIN SMALL LETTER F WITH DOT ABOVE
<f8>
<ff>	"<F><F>";"<NONE><NONE>";"<ff><ff>";IGNORE	<Ufb00>	LATIN SMALL LIGATURE FF
<fi>	"<F><I>";"<NONE><NONE>";"<fi><fi>";IGNORE	<Ufb01>	LATIN SMALL LIGATURE FI
<fl>	"<F><L>";"<NONE><NONE>";"<fl><fl>";IGNORE	<Ufb02>	LATIN SMALL LIGATURE FL
<ffi>	"<F><F><I>";"<NONE><NONE><NONE>";"<ffi><ffi><ffi>";IGNORE	<Ufb03>	LATIN SMALL LIGATURE FFI
<ffl>	"<F><F><L>";"<NONE><NONE><NONE>";"<ffl><ffl><ffl>";IGNORE	<Ufb04>	LATIN SMALL LIGATURE FFL
<G>	<G>;<NONE>;<CAPITAL>;IGNORE	<U0047>	LATIN CAPITAL LETTER G
<g>	<G>;<NONE>;<SMALL>;IGNORE	<U0067>	LATIN SMALL LETTER G
<G'>	<G>;<ACUTE>;<CAPITAL>;IGNORE	<U01f8>	LATIN CAPITAL LETTER G WITH ACUTE
<g'>	<G>;<ACUTE>;<SMALL>;IGNORE	<U01f9>	LATIN SMALL LETTER G WITH ACUTE
<G(>	<G>;<BREVE>;<CAPITAL>;IGNORE	<U011e>	LATIN CAPITAL LETTER G WITH BREVE
<g(>	<G>;<BREVE>;<SMALL>;IGNORE	<U011f>	LATIN SMALL LETTER G WITH BREVE
<G/>>	<G>;<CIRCUMFLEX>;<CAPITAL>;IGNORE	<U011c>	LATIN CAPITAL LETTER G WITH CIRCUMFLEX
<g/>>	<G>;<CIRCUMFLEX>;<SMALL>;IGNORE	<U011d>	LATIN SMALL LETTER G WITH CIRCUMFLEX
<G<>	<G>;<CARON>;<CAPITAL>;IGNORE	<U01e6>	LATIN CAPITAL LETTER G WITH CARON
<g<>	<G>;<CARON>;<SMALL>;IGNORE	<U01e7>	LATIN SMALL LETTER G WITH CARON
<G.>	<G>;<DOT>;<CAPITAL>;IGNORE	<U0120>	LATIN CAPITAL LETTER G WITH DOT ABOVE
<g.>	<G>;<DOT>;<SMALL>;IGNORE	<U0121>	LATIN SMALL LETTER G WITH DOT ABOVE
<G//>	<G>;<STROKE>;<CAPITAL>;IGNORE	<U01e4>	LATIN CAPITAL LETTER G WITH STROKE
<g//>	<G>;<STROKE>;<SMALL>;IGNORE	<U01e5>	LATIN SMALL LETTER G WITH STROKE
<G,>	<G>;<CEDILLA>;<CAPITAL>;IGNORE	<U0122>	LATIN CAPITAL LETTER G WITH CEDILLA
<g,>	<G>;<CEDILLA>;<SMALL>;IGNORE	<U0123>	LATIN SMALL LETTER G WITH CEDILLA
<G->	<G>;<MACRON>;<CAPITAL>;IGNORE	<U1e20>	LATIN CAPITAL LETTER G WITH MACRON
<g->	<G>;<MACRON>;<SMALL>;IGNORE	<U1e21>	LATIN SMALL LETTER G WITH MACRON
<g8>
<H>	<H>;<NONE>;<CAPITAL>;IGNORE	<U0048>	LATIN CAPITAL LETTER H
<h>	<H>;<NONE>;<SMALL>;IGNORE	<U0068>	LATIN SMALL LETTER H
<H-(>	<H>;<BREVE-BELOW>;<CAPITAL>;IGNORE	<U1e2a>	LATIN CAPITAL LETTER H WITH BREVE BELOW
<h-(>	<H>;<BREVE-BELOW>;<SMALL>;IGNORE	<U1e2b>	LATIN SMALL LETTER H WITH BREVE BELOW
<H/>>	<H>;<CIRCUMFLEX>;<CAPITAL>;IGNORE	<U0124>	LATIN CAPITAL LETTER H WITH CIRCUMFLEX
<h/>>	<H>;<CIRCUMFLEX>;<SMALL>;IGNORE	<U0125>	LATIN SMALL LETTER H WITH CIRCUMFLEX
<H:>	<H>;<DIAERESIS>;<CAPITAL>;IGNORE	<U1e26>	LATIN CAPITAL LETTER H WITH DIAERESIS
<h:>	<H>;<DIAERESIS>;<SMALL>;IGNORE	<U1e27>	LATIN SMALL LETTER H WITH DIAERESIS
<H.>	<H>;<DOT>;<CAPITAL>;IGNORE	<U1e22>	LATIN CAPITAL LETTER H WITH DOT ABOVE
<h.>	<H>;<DOT>;<SMALL>;IGNORE	<U1e23>	LATIN SMALL LETTER H WITH DOT ABOVE
<H-.>	<H>;<DOT-BELOW>;<CAPITAL>;IGNORE	<U1e24>	LATIN CAPITAL LETTER H WITH DOT BELOW
<h-.>	<H>;<DOT-BELOW>;<SMALL>;IGNORE	<U1e25>	LATIN SMALL LETTER H WITH DOT BELOW
<H//>	<H>;<STROKE>;<CAPITAL>;IGNORE	<U0126>	LATIN CAPITAL LETTER H WITH STROKE
<h//>	<H>;<STROKE>;<SMALL>;IGNORE	<U0127>	LATIN SMALL LETTER H WITH STROKE
<H,>	<H>;<CEDILLA>;<CAPITAL>;IGNORE	<U1e28>	LATIN CAPITAL LETTER H WITH CEDILLA
<h,>	<H>;<CEDILLA>;<SMALL>;IGNORE	<U1e29>	LATIN SMALL LETTER H WITH CEDILLA
<h8>
<I>	<I>;<NONE>;<CAPITAL>;IGNORE	<U0049>	LATIN CAPITAL LETTER I
<i>	<I>;<NONE>;<SMALL>;IGNORE	<U0069>	LATIN SMALL LETTER I
<I'>	<I>;<ACUTE>;<CAPITAL>;IGNORE	<U00cd>	LATIN CAPITAL LETTER I WITH ACUTE
<i'>	<I>;<ACUTE>;<SMALL>;IGNORE	<U00ed>	LATIN SMALL LETTER I WITH ACUTE
<I!>	<I>;<GRAVE>;<CAPITAL>;IGNORE	<U00cc>	LATIN CAPITAL LETTER I WITH GRAVE
<i!>	<I>;<GRAVE>;<SMALL>;IGNORE	<U00ec>	LATIN SMALL LETTER I WITH GRAVE
<I!!>	<I>;<DOUBLE-GRAVE>;<CAPITAL>;IGNORE	<U0208>	LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
<i!!>	<I>;<DOUBLE-GRAVE>;<SMALL>;IGNORE	<U0209>	LATIN SMALL LETTER I WITH DOUBLE GRAVE
<I(>	<I>;<BREVE>;<CAPITAL>;IGNORE	<U012c>	LATIN CAPITAL LETTER I WITH BREVE
<i(>	<I>;<BREVE>;<SMALL>;IGNORE	<U012d>	LATIN SMALL LETTER I WITH BREVE
<I)>	<I>;<INVERTED-BREVE>;<CAPITAL>;IGNORE	<U020a>	LATIN CAPITAL LETTER I WITH INVERTED BREVE
<i)>	<I>;<INVERTED-BREVE>;<SMALL>;IGNORE	<U020b>	LATIN SMALL LETTER I WITH INVERTED BREVE
<I/>>	<I>;<CIRCUMFLEX>;<CAPITAL>;IGNORE	<U00ce>	LATIN CAPITAL LETTER I WITH CIRCUMFLEX
<i/>>	<I>;<CIRCUMFLEX>;<SMALL>;IGNORE	<U00ee>	LATIN SMALL LETTER I WITH CIRCUMFLEX
<I<>	<I>;<CARON>;<CAPITAL>;IGNORE	<U01cf>	LATIN CAPITAL LETTER I WITH CARON
<i<>	<I>;<CARON>;<SMALL>;IGNORE	<U01d0>	LATIN SMALL LETTER I WITH CARON
<I:>	<I>;<DIAERESIS>;<CAPITAL>;IGNORE	<U00cf>	LATIN CAPITAL LETTER I WITH DIAERESIS
<i:>	<I>;<DIAERESIS>;<SMALL>;IGNORE	<U00ef>	LATIN SMALL LETTER I WITH DIAERESIS
<I:'>	<I>;<DIAERESIS+ACUTE>;<CAPITAL>;IGNORE	<U1e2e>	LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
<i:'>	<I>;<DIAERESIS+ACUTE>;<SMALL>;IGNORE	<U1e2f>	LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE
<I2>	<I>;<HOOK>;<CAPITAL>;IGNORE	<U1ec8>	LATIN CAPITAL LETTER I WITH HOOK ABOVE
<i2>	<I>;<HOOK>;<SMALL>;IGNORE	<U1ec9>	LATIN SMALL LETTER I WITH HOOK ABOVE
<I?>	<I>;<TILDE>;<CAPITAL>;IGNORE	<U0128>	LATIN CAPITAL LETTER I WITH TILDE
<i?>	<I>;<TILDE>;<SMALL>;IGNORE	<U0129>	LATIN SMALL LETTER I WITH TILDE
<I-?>	<I>;<TILDE-BELOW>;<CAPITAL>;IGNORE	<U1e2c>	LATIN CAPITAL LETTER I WITH TILDE BELOW
<i-?>	<I>;<TILDE-BELOW>;<SMALL>;IGNORE	<U1e2d>	LATIN SMALL LETTER I WITH TILDE BELOW
<I.>	<I>;<DOT>;<CAPITAL>;IGNORE	<U0130>	LATIN CAPITAL LETTER I WITH DOT ABOVE
<i.>	<I>;<DOT>;<SMALL>;IGNORE	<U0131>	LATIN SMALL LETTER DOTLESS I
<I-.>	<I>;<DOT-BELOW>;<CAPITAL>;IGNORE	<U1eca>	LATIN CAPITAL LETTER I WITH DOT BELOW
<i-.>	<I>;<DOT-BELOW>;<SMALL>;IGNORE	<U1ecb>	LATIN SMALL LETTER I WITH DOT BELOW
<I;>	<I>;<OGONEK>;<CAPITAL>;IGNORE	<U012e>	LATIN CAPITAL LETTER I WITH OGONEK
<i;>	<I>;<OGONEK>;<SMALL>;IGNORE	<U012f>	LATIN SMALL LETTER I WITH OGONEK
<I->	<I>;<MACRON>;<CAPITAL>;IGNORE	<U012a>	LATIN CAPITAL LETTER I WITH MACRON
<i->	<I>;<MACRON>;<SMALL>;IGNORE	<U012b>	LATIN SMALL LETTER I WITH MACRON
<i8>
<IJ>	"<I><J>";"<IJ><IJ>";"<CAPITAL><CAPITAL>";IGNORE	<U0132>	LATIN CAPITAL LIGATURE IJ
<ij>	"<I><J>";"<IJ><IJ>";"<SMALL><SMALL>";IGNORE	<U0133>	LATIN SMALL LIGATURE IJ
<J>	<J>;<NONE>;<CAPITAL>;IGNORE	<U004a>	LATIN CAPITAL LETTER J
<j>	<J>;<NONE>;<SMALL>;IGNORE	<U006a>	LATIN SMALL LETTER J
<J/>>	<J>;<CIRCUMFLEX>;<CAPITAL>;IGNORE	<U0134>	LATIN CAPITAL LETTER J WITH CIRCUMFLEX
<j/>>	<J>;<CIRCUMFLEX>;<SMALL>;IGNORE	<U0135>	LATIN SMALL LETTER J WITH CIRCUMFLEX
<j8>
<K>	<K>;<NONE>;<CAPITAL>;IGNORE	<U004b>	LATIN CAPITAL LETTER K
<k>	<K>;<NONE>;<SMALL>;IGNORE	<U006b>	LATIN SMALL LETTER K
<K'>	<K>;<ACUTE>;<CAPITAL>;IGNORE	<U1e30>	LATIN CAPITAL LETTER K WITH ACUTE
<k'>	<K>;<ACUTE>;<SMALL>;IGNORE	<U1e31>	LATIN SMALL LETTER K WITH ACUTE
<K<>	<K>;<CARON>;<CAPITAL>;IGNORE	<U01e8>	LATIN CAPITAL LETTER K WITH CARON
<k<>	<K>;<CARON>;<SMALL>;IGNORE	<U01e9>	LATIN SMALL LETTER K WITH CARON
<K2>	<K>;<HOOK>;<CAPITAL>;IGNORE	<U0198>	LATIN CAPITAL LETTER K WITH HOOK
<k2>	<K>;<HOOK>;<SMALL>;IGNORE	<U0199>	LATIN SMALL LETTER K WITH HOOK
<K-.>	<K>;<DOT-BELOW>;<CAPITAL>;IGNORE	<U1e32>	LATIN CAPITAL LETTER K WITH DOT BELOW
<k-.>	<K>;<DOT-BELOW>;<SMALL>;IGNORE	<U1e33>	LATIN SMALL LETTER K WITH DOT BELOW
<K,>	<K>;<CEDILLA>;<CAPITAL>;IGNORE	<U0136>	LATIN CAPITAL LETTER K WITH CEDILLA
<k,>	<K>;<CEDILLA>;<SMALL>;IGNORE	<U0137>	LATIN SMALL LETTER K WITH CEDILLA
<K_>	<K>;<LINE-BELOW>;<CAPITAL>;IGNORE	<U1e34>	LATIN CAPITAL LETTER K WITH LINE BELOW
<k_>	<K>;<LINE-BELOW>;<SMALL>;IGNORE	<U1e35>	LATIN SMALL LETTER K WITH LINE BELOW
<k8>
<kk>	<K>;<kk>;<SMALL>;IGNORE	<U0138>	LATIN SMALL LETTER KRA (Greenlandic)
<L>	<L>;<NONE>;<CAPITAL>;IGNORE	<U004c>	LATIN CAPITAL LETTER L
<l>	<L>;<NONE>;<SMALL>;IGNORE	<U006c>	LATIN SMALL LETTER L
<L'>	<L>;<ACUTE>;<CAPITAL>;IGNORE	<U0139>	LATIN CAPITAL LETTER L WITH ACUTE
<l'>	<L>;<ACUTE>;<SMALL>;IGNORE	<U013a>	LATIN SMALL LETTER L WITH ACUTE
<L<>	<L>;<CARON>;<CAPITAL>;IGNORE	<U013d>	LATIN CAPITAL LETTER L WITH CARON
<l<>	<L>;<CARON>;<SMALL>;IGNORE	<U013e>	LATIN SMALL LETTER L WITH CARON
<L.>	<L>;<DOT>;<CAPITAL>;IGNORE	<U013f>	LATIN CAPITAL LETTER L WITH MIDDLE DOT
<l.>	<L>;<DOT>;<SMALL>;IGNORE	<U0140>	LATIN SMALL LETTER L WITH MIDDLE DOT
<L-.>	<L>;<DOT-BELOW>;<CAPITAL>;IGNORE	<U1e36>	LATIN CAPITAL LETTER L WITH DOT BELOW
<l-.>	<L>;<DOT-BELOW>;<SMALL>;IGNORE	<U1e37>	LATIN SMALL LETTER L WITH DOT BELOW
<L//>	<L>;<STROKE>;<CAPITAL>;IGNORE	<U0141>	LATIN CAPITAL LETTER L WITH STROKE
<l//>	<L>;<STROKE>;<SMALL>;IGNORE	<U0142>	LATIN SMALL LETTER L WITH STROKE
<L,>	<L>;<CEDILLA>;<CAPITAL>;IGNORE	<U013b>	LATIN CAPITAL LETTER L WITH CEDILLA
<l,>	<L>;<CEDILLA>;<SMALL>;IGNORE	<U013c>	LATIN SMALL LETTER L WITH CEDILLA
<L--.>	<L>;<MACRON+DOT-BELOW>;<CAPITAL>;IGNORE	<U1e38>	LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
<l--.>	<L>;<MACRON+DOT-BELOW>;<SMALL>;IGNORE	<U1e39>	LATIN SMALL LETTER L WITH DOT BELOW AND MACRON
<L-/>>	<L>;<MACRON+CIRCUMFLEX>;<CAPITAL>;IGNORE	<U1e3c>	LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
<l-/>>	<L>;<MACRON+CIRCUMFLEX>;<SMALL>;IGNORE	<U1e3d>	LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW
<L_>	<L>;<LINE-BELOW>;<CAPITAL>;IGNORE	<U1e3a>	LATIN CAPITAL LETTER L WITH LINE BELOW
<l_>	<L>;<LINE-BELOW>;<SMALL>;IGNORE	<U1e3b>	LATIN SMALL LETTER L WITH LINE BELOW
<l8>
<M>	<M>;<NONE>;<CAPITAL>;IGNORE	<U004d>	LATIN CAPITAL LETTER M
<m>	<M>;<NONE>;<SMALL>;IGNORE	<U006d>	LATIN SMALL LETTER M
<M'>	<M>;<ACUTE>;<CAPITAL>;IGNORE	<U1e3e>	LATIN CAPITAL LETTER M WITH ACUTE
<m'>	<M>;<ACUTE>;<SMALL>;IGNORE	<U1e3f>	LATIN SMALL LETTER M WITH ACUTE
<M.>	<M>;<DOT>;<CAPITAL>;IGNORE	<U1e40>	LATIN CAPITAL LETTER M WITH DOT ABOVE
<m.>	<M>;<DOT>;<SMALL>;IGNORE	<U1e41>	LATIN SMALL LETTER M WITH DOT ABOVE
<M-.>	<M>;<DOT-BELOW>;<CAPITAL>;IGNORE	<U1e42>	LATIN CAPITAL LETTER M WITH DOT BELOW
<m-.>	<M>;<DOT-BELOW>;<SMALL>;IGNORE	<U1e43>	LATIN SMALL LETTER M WITH DOT BELOW
<m8>
<N>	<N>;<NONE>;<CAPITAL>;IGNORE	<U004e>	LATIN CAPITAL LETTER N
<n>	<N>;<NONE>;<SMALL>;IGNORE	<U006e>	LATIN SMALL LETTER N
<N'>	<N>;<ACUTE>;<CAPITAL>;IGNORE	<U0143>	LATIN CAPITAL LETTER N WITH ACUTE
<n'>	<N>;<ACUTE>;<SMALL>;IGNORE	<U0144>	LATIN SMALL LETTER N WITH ACUTE
<N<>	<N>;<CARON>;<CAPITAL>;IGNORE	<U0147>	LATIN CAPITAL LETTER N WITH CARON
<n<>	<N>;<CARON>;<SMALL>;IGNORE	<U0148>	LATIN SMALL LETTER N WITH CARON
<N?>	<N>;<TILDE>;<CAPITAL>;IGNORE	<U00d1>	LATIN CAPITAL LETTER N WITH TILDE
<n?>	<N>;<TILDE>;<SMALL>;IGNORE	<U00f1>	LATIN SMALL LETTER N WITH TILDE
<N.>	<N>;<DOT>;<CAPITAL>;IGNORE	<U1e44>	LATIN CAPITAL LETTER N WITH DOT ABOVE
<n.>	<N>;<DOT>;<SMALL>;IGNORE	<U1e45>	LATIN SMALL LETTER N WITH DOT ABOVE
<N-.>	<N>;<DOT-BELOW>;<CAPITAL>;IGNORE	<U1e46>	LATIN CAPITAL LETTER N WITH DOT BELOW
<n-.>	<N>;<DOT-BELOW>;<SMALL>;IGNORE	<U1e47>	LATIN SMALL LETTER N WITH DOT BELOW
<N,>	<N>;<CEDILLA>;<CAPITAL>;IGNORE	<U0145>	LATIN CAPITAL LETTER N WITH CEDILLA
<n,>	<N>;<CEDILLA>;<SMALL>;IGNORE	<U0146>	LATIN SMALL LETTER N WITH CEDILLA
<N-/>>	<N>;<MACRON+CIRCUMFLEX>;<CAPITAL>;IGNORE	<U1e4a>	LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
<n-/>>	<N>;<MACRON+CIRCUMFLEX>;<SMALL>;IGNORE	<U1e4b>	LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW
<N_>	<N>;<LINE-BELOW>;<CAPITAL>;IGNORE	<U1e48>	LATIN CAPITAL LETTER N WITH LINE BELOW
<n_>	<N>;<LINE-BELOW>;<SMALL>;IGNORE	<U1e49>	LATIN SMALL LETTER N WITH LINE BELOW
<'n>	<N>;<PRECEDED-BY-APOSTROPHE>;<SMALL>;IGNORE	<U0149>	LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
<n8>
<NG>	"<N><G>";"<NG><NG>";"<CAPITAL><CAPITAL>";IGNORE	<U014a>	LATIN CAPITAL LETTER ENG (Sami)
<ng>	"<N><G>";"<NG><NG>";"<SMALL><SMALL>";IGNORE	<U014b>	LATIN SMALL LETTER ENG (Sami)
<O>	<O>;<NONE>;<CAPITAL>;IGNORE	<U004f>	LATIN CAPITAL LETTER O
<o>	<O>;<NONE>;<SMALL>;IGNORE	<U006f>	LATIN SMALL LETTER O
<-o>	<O>;<NONE>;<-o>;IGNORE	<U00ba>	MASCULINE ORDINAL INDICATOR
<O'>	<O>;<ACUTE>;<CAPITAL>;IGNORE	<U00d3>	LATIN CAPITAL LETTER O WITH ACUTE
<o'>	<O>;<ACUTE>;<SMALL>;IGNORE	<U00f3>	LATIN SMALL LETTER O WITH ACUTE
<O!>	<O>;<GRAVE>;<CAPITAL>;IGNORE	<U00d2>	LATIN CAPITAL LETTER O WITH GRAVE
<o!>	<O>;<GRAVE>;<SMALL>;IGNORE	<U00f2>	LATIN SMALL LETTER O WITH GRAVE
<O!!>	<O>;<DOUBLE-GRAVE>;<CAPITAL>;IGNORE	<U020c>	LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
<o!!>	<O>;<DOUBLE-GRAVE>;<SMALL>;IGNORE	<U020d>	LATIN SMALL LETTER O WITH DOUBLE GRAVE
<O(>	<O>;<BREVE>;<CAPITAL>;IGNORE	<U014e>	LATIN CAPITAL LETTER O WITH BREVE
<o(>	<O>;<BREVE>;<SMALL>;IGNORE	<U014f>	LATIN SMALL LETTER O WITH BREVE
<O)>	<O>;<INVERTED-BREVE>;<CAPITAL>;IGNORE	<U020e>	LATIN CAPITAL LETTER O WITH INVERTED BREVE
<o)>	<O>;<INVERTED-BREVE>;<SMALL>;IGNORE	<U020f>	LATIN SMALL LETTER O WITH INVERTED BREVE
<O/>>	<O>;<CIRCUMFLEX>;<CAPITAL>;IGNORE	<U00d4>	LATIN CAPITAL LETTER O WITH CIRCUMFLEX
<o/>>	<O>;<CIRCUMFLEX>;<SMALL>;IGNORE	<U00f4>	LATIN SMALL LETTER O WITH CIRCUMFLEX
<O/>'>	<O>;<CIRCUMFLEX+ACUTE>;<CAPITAL>;IGNORE	<U1ed0>	LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
<o/>'>	<O>;<CIRCUMFLEX+ACUTE>;<SMALL>;IGNORE	<U1ed1>	LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE
<O/>!>	<O>;<CIRCUMFLEX+GRAVE>;<CAPITAL>;IGNORE	<U1ed2>	LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
<o/>!>	<O>;<CIRCUMFLEX+GRAVE>;<SMALL>;IGNORE	<U1ed3>	LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE
<O/>2>	<O>;<CIRCUMFLEX+HOOK>;<CAPITAL>;IGNORE	<U1ed4>	LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
<o/>2>	<O>;<CIRCUMFLEX+HOOK>;<SMALL>;IGNORE	<U1ed5>	LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
<O/>?>	<O>;<CIRCUMFLEX+TILDE>;<CAPITAL>;IGNORE	<U1ed6>	LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
<o/>?>	<O>;<CIRCUMFLEX+TILDE>;<SMALL>;IGNORE	<U1ed7>	LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE
<O/>-.>	<O>;<CIRCUMFLEX+DOT-BELOW>;<CAPITAL>;IGNORE	<U1ed8>	LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
<o/>-.>	<O>;<CIRCUMFLEX+DOT-BELOW>;<SMALL>;IGNORE	<U1ed9>	LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW
<O<>	<O>;<CARON>;<CAPITAL>;IGNORE	<U01d1>	LATIN CAPITAL LETTER O WITH CARON
<o<>	<O>;<CARON>;<SMALL>;IGNORE	<U01d2>	LATIN SMALL LETTER O WITH CARON
<O:>	<O>;<DIAERESIS>;<CAPITAL>;IGNORE	<U00d6>	LATIN CAPITAL LETTER O WITH DIAERESIS
<o:>	<O>;<DIAERESIS>;<SMALL>;IGNORE	<U00f6>	LATIN SMALL LETTER O WITH DIAERESIS
<O">	<O>;<DOUBLE-ACUTE>;<CAPITAL>;IGNORE	<U0150>	LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
<o">	<O>;<DOUBLE-ACUTE>;<SMALL>;IGNORE	<U0151>	LATIN SMALL LETTER O WITH DOUBLE ACUTE
<O2>	<O>;<HOOK>;<CAPITAL>;IGNORE	<U1ece>	LATIN CAPITAL LETTER O WITH HOOK ABOVE
<o2>	<O>;<HOOK>;<SMALL>;IGNORE	<U1ecf>	LATIN SMALL LETTER O WITH HOOK ABOVE
<O?>	<O>;<TILDE>;<CAPITAL>;IGNORE	<U00d5>	LATIN CAPITAL LETTER O WITH TILDE
<o?>	<O>;<TILDE>;<SMALL>;IGNORE	<U00f5>	LATIN SMALL LETTER O WITH TILDE
<O?'>	<O>;<TILDE+ACUTE>;<CAPITAL>;IGNORE	<U1e4c>	LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
<o?'>	<O>;<TILDE+ACUTE>;<SMALL>;IGNORE	<U1e4d>	LATIN SMALL LETTER O WITH TILDE AND ACUTE
<O?:>	<O>;<TILDE+DIAERESIS>;<CAPITAL>;IGNORE	<U1e4e>	LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
<o?:>	<O>;<TILDE+DIAERESIS>;<SMALL>;IGNORE	<U1e4f>	LATIN SMALL LETTER O WITH TILDE AND DIAERESIS
<O-.>	<O>;<DOT-BELOW>;<CAPITAL>;IGNORE	<U1ecc>	LATIN CAPITAL LETTER O WITH DOT BELOW
<o-.>	<O>;<DOT-BELOW>;<SMALL>;IGNORE	<U1ecd>	LATIN SMALL LETTER O WITH DOT BELOW
<O//>	<O>;<STROKE>;<CAPITAL>;IGNORE	<U00d8>	LATIN CAPITAL LETTER O WITH STROKE
<o//>	<O>;<STROKE>;<SMALL>;IGNORE	<U00f8>	LATIN SMALL LETTER O WITH STROKE
<O//'>	<O>;<STROKE+ACUTE>;<CAPITAL>;IGNORE	<U01fe>	LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
<o//'>	<O>;<STROKE+ACUTE>;<SMALL>;IGNORE	<U01ff>	LATIN SMALL LETTER O WITH STROKE AND ACUTE
<O;>	<O>;<OGONEK>;<CAPITAL>;IGNORE	<U01ea>	LATIN CAPITAL LETTER O WITH OGONEK
<o;>	<O>;<OGONEK>;<SMALL>;IGNORE	<U01eb>	LATIN SMALL LETTER O WITH OGONEK
<O1>	<O>;<OGONEK+MACRON>;<CAPITAL>;IGNORE	<U01ec>	LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
<o1>	<O>;<OGONEK+MACRON>;<SMALL>;IGNORE	<U01ed>	LATIN SMALL LETTER O WITH OGONEK AND MACRON
<O->	<O>;<MACRON>;<CAPITAL>;IGNORE	<U014c>	LATIN CAPITAL LETTER O WITH MACRON
<o->	<O>;<MACRON>;<SMALL>;IGNORE	<U014d>	LATIN SMALL LETTER O WITH MACRON
<O-'>	<O>;<MACRON+ACUTE>;<CAPITAL>;IGNORE	<U1e52>	LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
<o-'>	<O>;<MACRON+ACUTE>;<SMALL>;IGNORE	<U1e53>	LATIN SMALL LETTER O WITH MACRON AND ACUTE
<O-!>	<O>;<MACRON+GRAVE>;<CAPITAL>;IGNORE	<U1e50>	LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
<o-!>	<O>;<MACRON+GRAVE>;<SMALL>;IGNORE	<U1e51>	LATIN SMALL LETTER O WITH MACRON AND GRAVE
<O9>	<O>;<HORN>;<CAPITAL>;IGNORE	<U01a0>	LATIN CAPITAL LETTER O WITH HORN
<o9>	<O>;<HORN>;<SMALL>;IGNORE	<U01a1>	LATIN SMALL LETTER O WITH HORN
<O9'>	<O>;<HORN+ACUTE>;<CAPITAL>;IGNORE	<U1eda>	LATIN CAPITAL LETTER O WITH HORN AND ACUTE
<o9'>	<O>;<HORN+ACUTE>;<SMALL>;IGNORE	<U1edb>	LATIN SMALL LETTER O WITH HORN AND ACUTE
<O9!>	<O>;<HORN+GRAVE>;<CAPITAL>;IGNORE	<U1edc>	LATIN CAPITAL LETTER O WITH HORN AND GRAVE
<o9!>	<O>;<HORN+GRAVE>;<SMALL>;IGNORE	<U1edd>	LATIN SMALL LETTER O WITH HORN AND GRAVE
<O92>	<O>;<HORN+HOOK>;<CAPITAL>;IGNORE	<U1ede>	LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
<o92>	<O>;<HORN+HOOK>;<SMALL>;IGNORE	<U1edf>	LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE
<O9?>	<O>;<HORN+TILDE>;<CAPITAL>;IGNORE	<U1ee0>	LATIN CAPITAL LETTER O WITH HORN AND TILDE
<o9?>	<O>;<HORN+TILDE>;<SMALL>;IGNORE	<U1ee1>	LATIN SMALL LETTER O WITH HORN AND TILDE
<O9-.>	<O>;<HORN+DOT-BELOW>;<CAPITAL>;IGNORE	<U1ee2>	LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
<o9-.>	<O>;<HORN+DOT-BELOW>;<SMALL>;IGNORE	<U1ee3>	LATIN SMALL LETTER O WITH HORN AND DOT BELOW
<o8>
<OE>	"<O><E>";"<OE><OE>";"<CAPITAL><CAPITAL>";IGNORE	<U0152>	LATIN CAPITAL LIGATURE OE
<oe>	"<O><E>";"<OE><OE>";"<SMALL><SMALL>";IGNORE	<U0153>	LATIN SMALL LIGATURE OE
<P>	<P>;<NONE>;<CAPITAL>;IGNORE	<U0050>	LATIN CAPITAL LETTER P
<p>	<P>;<NONE>;<SMALL>;IGNORE	<U0070>	LATIN SMALL LETTER P
<P'>	<P>;<ACUTE>;<CAPITAL>;IGNORE	<U1e54>	LATIN CAPITAL LETTER P WITH ACUTE
<p'>	<P>;<ACUTE>;<SMALL>;IGNORE	<U1e55>	LATIN SMALL LETTER P WITH ACUTE
<P.>	<P>;<DOT>;<CAPITAL>;IGNORE	<U1e56>	LATIN CAPITAL LETTER P WITH DOT ABOVE
<p.>	<P>;<DOT>;<SMALL>;IGNORE	<U1e57>	LATIN SMALL LETTER P WITH DOT ABOVE
<p8>
<Q>	<Q>;<NONE>;<CAPITAL>;IGNORE	<U0051>	LATIN CAPITAL LETTER Q
<q>	<Q>;<NONE>;<SMALL>;IGNORE	<U0071>	LATIN SMALL LETTER Q
<q8>
<R>	<R>;<NONE>;<CAPITAL>;IGNORE	<U0052>	LATIN CAPITAL LETTER R
<r>	<R>;<NONE>;<SMALL>;IGNORE	<U0072>	LATIN SMALL LETTER R
<R'>	<R>;<ACUTE>;<CAPITAL>;IGNORE	<U0154>	LATIN CAPITAL LETTER R WITH ACUTE
<r'>	<R>;<ACUTE>;<SMALL>;IGNORE	<U0155>	LATIN SMALL LETTER R WITH ACUTE
<R!!>	<R>;<DOUBLE-GRAVE>;<CAPITAL>;IGNORE	<U0210>	LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
<r!!>	<R>;<DOUBLE-GRAVE>;<SMALL>;IGNORE	<U0211>	LATIN SMALL LETTER R WITH DOUBLE GRAVE
<R)>	<R>;<INVERTED-BREVE>;<CAPITAL>;IGNORE	<U0212>	LATIN CAPITAL LETTER R WITH INVERTED BREVE
<r)>	<R>;<INVERTED-BREVE>;<SMALL>;IGNORE	<U0213>	LATIN SMALL LETTER R WITH INVERTED BREVE
<R<>	<R>;<CARON>;<CAPITAL>;IGNORE	<U0158>	LATIN CAPITAL LETTER R WITH CARON
<r<>	<R>;<CARON>;<SMALL>;IGNORE	<U0159>	LATIN SMALL LETTER R WITH CARON
<R.>	<R>;<DOT>;<CAPITAL>;IGNORE	<U1e58>	LATIN CAPITAL LETTER R WITH DOT ABOVE
<r.>	<R>;<DOT>;<SMALL>;IGNORE	<U1e59>	LATIN SMALL LETTER R WITH DOT ABOVE
<R-.>	<R>;<DOT-BELOW>;<CAPITAL>;IGNORE	<U1e5a>	LATIN CAPITAL LETTER R WITH DOT BELOW
<r-.>	<R>;<DOT-BELOW>;<SMALL>;IGNORE	<U1e5b>	LATIN SMALL LETTER R WITH DOT BELOW
<R,>	<R>;<CEDILLA>;<CAPITAL>;IGNORE	<U0156>	LATIN CAPITAL LETTER R WITH CEDILLA
<r,>	<R>;<CEDILLA>;<SMALL>;IGNORE	<U0157>	LATIN SMALL LETTER R WITH CEDILLA
<R--.>	<R>;<MACRON+DOT-BELOW>;<CAPITAL>;IGNORE	<U1e5c>	LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
<r--.>	<R>;<MACRON+DOT-BELOW>;<SMALL>;IGNORE	<U1e5d>	LATIN SMALL LETTER R WITH DOT BELOW AND MACRON
<R_>	<R>;<LINE-BELOW>;<CAPITAL>;IGNORE	<U1e5e>	LATIN CAPITAL LETTER R WITH LINE BELOW
<r_>	<R>;<LINE-BELOW>;<SMALL>;IGNORE	<U1e5f>	LATIN SMALL LETTER R WITH LINE BELOW
<r8>
<S>	<S>;<NONE>;<CAPITAL>;IGNORE	<U0053>	LATIN CAPITAL LETTER S
<s>	<S>;<NONE>;<SMALL>;IGNORE	<U0073>	LATIN SMALL LETTER S
<st>	"<S><T>";"<NONE><NONE>";"<st><st>";IGNORE	<Ufb06>	LATIN SMALL LIGATURE ST
<S'>	<S>;<ACUTE>;<CAPITAL>;IGNORE	<U015a>	LATIN CAPITAL LETTER S WITH ACUTE
<s'>	<S>;<ACUTE>;<SMALL>;IGNORE	<U015b>	LATIN SMALL LETTER S WITH ACUTE
<S'.>	<S>;<ACUTE+DOT>;<CAPITAL>;IGNORE	<U1e64>	LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
<s'.>	<S>;<ACUTE+DOT>;<SMALL>;IGNORE	<U1e65>	LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE
<S/>>	<S>;<CIRCUMFLEX>;<CAPITAL>;IGNORE	<U015c>	LATIN CAPITAL LETTER S WITH CIRCUMFLEX
<s/>>	<S>;<CIRCUMFLEX>;<SMALL>;IGNORE	<U015d>	LATIN SMALL LETTER S WITH CIRCUMFLEX
<S<>	<S>;<CARON>;<CAPITAL>;IGNORE	<U0160>	LATIN CAPITAL LETTER S WITH CARON
<s<>	<S>;<CARON>;<SMALL>;IGNORE	<U0161>	LATIN SMALL LETTER S WITH CARON
<S<.>	<S>;<CARON+DOT>;<CAPITAL>;IGNORE	<U1e66>	LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
<s<.>	<S>;<CARON+DOT>;<SMALL>;IGNORE	<U1e67>	LATIN SMALL LETTER S WITH CARON AND DOT ABOVE
<S.>	<S>;<DOT>;<CAPITAL>;IGNORE	<U1e60>	LATIN CAPITAL LETTER S WITH DOT ABOVE
<s.>	<S>;<DOT>;<SMALL>;IGNORE	<U1e61>	LATIN SMALL LETTER S WITH DOT ABOVE
<S-.>	<S>;<DOT-BELOW>;<CAPITAL>;IGNORE	<U1e62>	LATIN CAPITAL LETTER S WITH DOT BELOW
<s-.>	<S>;<DOT-BELOW>;<SMALL>;IGNORE	<U1e63>	LATIN SMALL LETTER S WITH DOT BELOW
<S.-.>	<S>;<DOT+DOT-BELOW>;<CAPITAL>;IGNORE	<U1e68>	LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
<s.-.>	<S>;<DOT+DOT-BELOW>;<SMALL>;IGNORE	<U1e69>	LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE
<S,>	<S>;<CEDILLA>;<CAPITAL>;IGNORE	<U015e>	LATIN CAPITAL LETTER S WITH CEDILLA
<s,>	<S>;<CEDILLA>;<SMALL>;IGNORE	<U015f>	LATIN SMALL LETTER S WITH CEDILLA
<s8>
<s1>	<S>;<s1>;<SMALL>;IGNORE	<U017f>	LATIN SMALL LETTER LONG S
<St>	"<S><T>";"<NONE><NONE>";"<St><St>";IGNORE	<Ufb05>	LATIN SMALL LIGATURE LONG S T
<ss>	"<S><S>";"<NONE><NONE>";"<SMALL><ss>";IGNORE	<U00df>	LATIN SMALL LETTER SHARP S (German)
<T>	<T>;<NONE>;<CAPITAL>;IGNORE	<U0054>	LATIN CAPITAL LETTER T
<t>	<T>;<NONE>;<SMALL>;IGNORE	<U0074>	LATIN SMALL LETTER T
<T<>	<T>;<CARON>;<CAPITAL>;IGNORE	<U0164>	LATIN CAPITAL LETTER T WITH CARON
<t<>	<T>;<CARON>;<SMALL>;IGNORE	<U0165>	LATIN SMALL LETTER T WITH CARON
<T.>	<T>;<DOT>;<CAPITAL>;IGNORE	<U1e6a>	LATIN CAPITAL LETTER T WITH DOT ABOVE
<t.>	<T>;<DOT>;<SMALL>;IGNORE	<U1e6b>	LATIN SMALL LETTER T WITH DOT ABOVE
<T-.>	<T>;<DOT-BELOW>;<CAPITAL>;IGNORE	<U1e6c>	LATIN CAPITAL LETTER T WITH DOT BELOW
<t-.>	<T>;<DOT-BELOW>;<SMALL>;IGNORE	<U1e6d>	LATIN SMALL LETTER T WITH DOT BELOW
<T//>	<T>;<STROKE>;<CAPITAL>;IGNORE	<U0166>	LATIN CAPITAL LETTER T WITH STROKE
<t//>	<T>;<STROKE>;<SMALL>;IGNORE	<U0167>	LATIN SMALL LETTER T WITH STROKE
<T,>	<T>;<CEDILLA>;<CAPITAL>;IGNORE	<U0162>	LATIN CAPITAL LETTER T WITH CEDILLA
<t,>	<T>;<CEDILLA>;<SMALL>;IGNORE	<U0163>	LATIN SMALL LETTER T WITH CEDILLA
<T-/>>	<T>;<MACRON+CIRCUMFLEX>;<CAPITAL>;IGNORE	<U1e70>	LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
<t-/>>	<T>;<MACRON+CIRCUMFLEX>;<SMALL>;IGNORE	<U1e71>	LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW
<T_>	<T>;<LINE-BELOW>;<CAPITAL>;IGNORE	<U1e6e>	LATIN CAPITAL LETTER T WITH LINE BELOW
<t_>	<T>;<LINE-BELOW>;<SMALL>;IGNORE	<U1e6f>	LATIN SMALL LETTER T WITH LINE BELOW
<t8>
<TH>	"<T><H>";"<TH><TH>";"<CAPITAL><CAPITAL>";IGNORE	<U00de>	LATIN CAPITAL LETTER THORN (Icelandic)
<th>	"<T><H>";"<TH><TH>";"<SMALL><SMALL>";IGNORE	<U00fe>	LATIN SMALL LETTER THORN (Icelandic)
<U>	<U>;<NONE>;<CAPITAL>;IGNORE	<U0055>	LATIN CAPITAL LETTER U
<u>	<U>;<NONE>;<SMALL>;IGNORE	<U0075>	LATIN SMALL LETTER U
<U'>	<U>;<ACUTE>;<CAPITAL>;IGNORE	<U00da>	LATIN CAPITAL LETTER U WITH ACUTE
<u'>	<U>;<ACUTE>;<SMALL>;IGNORE	<U00fa>	LATIN SMALL LETTER U WITH ACUTE
<U!>	<U>;<GRAVE>;<CAPITAL>;IGNORE	<U00d9>	LATIN CAPITAL LETTER U WITH GRAVE
<u!>	<U>;<GRAVE>;<SMALL>;IGNORE	<U00f9>	LATIN SMALL LETTER U WITH GRAVE
<U!!>	<U>;<DOUBLE-GRAVE>;<CAPITAL>;IGNORE	<U0214>	LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
<u!!>	<U>;<DOUBLE-GRAVE>;<SMALL>;IGNORE	<U0215>	LATIN SMALL LETTER U WITH DOUBLE GRAVE
<U(>	<U>;<BREVE>;<CAPITAL>;IGNORE	<U016c>	LATIN CAPITAL LETTER U WITH BREVE
<u(>	<U>;<BREVE>;<SMALL>;IGNORE	<U016d>	LATIN SMALL LETTER U WITH BREVE
<U)>	<U>;<INVERTED-BREVE>;<CAPITAL>;IGNORE	<U0216>	LATIN CAPITAL LETTER U WITH INVERTED BREVE
<u)>	<U>;<INVERTED-BREVE>;<SMALL>;IGNORE	<U0217>	LATIN SMALL LETTER U WITH INVERTED BREVE
<U/>>	<U>;<CIRCUMFLEX>;<CAPITAL>;IGNORE	<U00db>	LATIN CAPITAL LETTER U WITH CIRCUMFLEX
<u/>>	<U>;<CIRCUMFLEX>;<SMALL>;IGNORE	<U00fb>	LATIN SMALL LETTER U WITH CIRCUMFLEX
<U<>	<U>;<CARON>;<CAPITAL>;IGNORE	<U01d3>	LATIN CAPITAL LETTER U WITH CARON
<u<>	<U>;<CARON>;<SMALL>;IGNORE	<U01d4>	LATIN SMALL LETTER U WITH CARON
<U0>	<U>;<RING>;<CAPITAL>;IGNORE	<U016e>	LATIN CAPITAL LETTER U WITH RING ABOVE
<u0>	<U>;<RING>;<SMALL>;IGNORE	<U016f>	LATIN SMALL LETTER U WITH RING ABOVE
<U:>	<U>;<DIAERESIS>;<CAPITAL>;IGNORE	<U00dc>	LATIN CAPITAL LETTER U WITH DIAERESIS
<u:>	<U>;<DIAERESIS>;<SMALL>;IGNORE	<U00fc>	LATIN SMALL LETTER U WITH DIAERESIS
<U:->	<U>;<DIAERESIS+MACRON>;<CAPITAL>;IGNORE	<U01d5>	LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
<u:->	<U>;<DIAERESIS+MACRON>;<SMALL>;IGNORE	<U01d6>	LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
<U:'>	<U>;<DIAERESIS+ACUTE>;<CAPITAL>;IGNORE	<U01d7>	LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
<u:'>	<U>;<DIAERESIS+ACUTE>;<SMALL>;IGNORE	<U01d8>	LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
<U:!>	<U>;<DIAERESIS+GRAVE>;<CAPITAL>;IGNORE	<U01db>	LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
<u:!>	<U>;<DIAERESIS+GRAVE>;<SMALL>;IGNORE	<U01dc>	LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
<U:<>	<U>;<DIAERESIS+CARON>;<CAPITAL>;IGNORE	<U01d9>	LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
<u:<>	<U>;<DIAERESIS+CARON>;<SMALL>;IGNORE	<U01da>	LATIN SMALL LETTER U WITH DIAERESIS AND CARON
<U">	<U>;<DOUBLE-ACUTE>;<CAPITAL>;IGNORE	<U0170>	LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
<u">	<U>;<DOUBLE-ACUTE>;<SMALL>;IGNORE	<U0171>	LATIN SMALL LETTER U WITH DOUBLE ACUTE
<U2>	<U>;<HOOK>;<CAPITAL>;IGNORE	<U1ee6>	LATIN CAPITAL LETTER U WITH HOOK ABOVE
<u2>	<U>;<HOOK>;<SMALL>;IGNORE	<U1ee7>	LATIN SMALL LETTER U WITH HOOK ABOVE
<U?>	<U>;<TILDE>;<CAPITAL>;IGNORE	<U0168>	LATIN CAPITAL LETTER U WITH TILDE
<u?>	<U>;<TILDE>;<SMALL>;IGNORE	<U0169>	LATIN SMALL LETTER U WITH TILDE
<U?'>	<U>;<TILDE+ACUTE>;<CAPITAL>;IGNORE	<U1e78>	LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
<u?'>	<U>;<TILDE+ACUTE>;<SMALL>;IGNORE	<U1e79>	LATIN SMALL LETTER U WITH TILDE AND ACUTE
<U-?>	<U>;<TILDE-BELOW>;<CAPITAL>;IGNORE	<U1e74>	LATIN CAPITAL LETTER U WITH TILDE BELOW
<u-?>	<U>;<TILDE-BELOW>;<SMALL>;IGNORE	<U1e75>	LATIN SMALL LETTER U WITH TILDE BELOW
<U-.>	<U>;<DOT-BELOW>;<CAPITAL>;IGNORE	<U1ee4>	LATIN CAPITAL LETTER U WITH DOT BELOW
<u-.>	<U>;<DOT-BELOW>;<SMALL>;IGNORE	<U1ee5>	LATIN SMALL LETTER U WITH DOT BELOW
<U;>	<U>;<OGONEK>;<CAPITAL>;IGNORE	<U0172>	LATIN CAPITAL LETTER U WITH OGONEK
<u;>	<U>;<OGONEK>;<SMALL>;IGNORE	<U0173>	LATIN SMALL LETTER U WITH OGONEK
<U->	<U>;<MACRON>;<CAPITAL>;IGNORE	<U016a>	LATIN CAPITAL LETTER U WITH MACRON
<u->	<U>;<MACRON>;<SMALL>;IGNORE	<U016b>	LATIN SMALL LETTER U WITH MACRON
<U-:>	<U>;<MACRON+DIAERESIS>;<CAPITAL>;IGNORE	<U1e7a>	LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
<u-:>	<U>;<MACRON+DIAERESIS>;<SMALL>;IGNORE	<U1e7b>	LATIN SMALL LETTER U WITH MACRON AND DIAERESIS
<U--:>	<U>;<MACRON+DIAERESIS-BELOW>;<CAPITAL>;IGNORE	<U1e72>	LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
<u--:>	<U>;<MACRON+DIAERESIS-BELOW>;<SMALL>;IGNORE	<U1e73>	LATIN SMALL LETTER U WITH DIAERESIS BELOW
<U-/>>	<U>;<MACRON+CIRCUMFLEX>;<CAPITAL>;IGNORE	<U1e76>	LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
<u-/>>	<U>;<MACRON+CIRCUMFLEX>;<SMALL>;IGNORE	<U1e77>	LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW
<U9>	<U>;<HORN>;<CAPITAL>;IGNORE	<U01af>	LATIN CAPITAL LETTER U WITH HORN
<u9>	<U>;<HORN>;<SMALL>;IGNORE	<U01b0>	LATIN SMALL LETTER U WITH HORN
<U9'>	<U>;<HORN+ACUTE>;<CAPITAL>;IGNORE	<U1ee8>	LATIN CAPITAL LETTER U WITH HORN AND ACUTE
<u9'>	<U>;<HORN+ACUTE>;<SMALL>;IGNORE	<U1ee9>	LATIN SMALL LETTER U WITH HORN AND ACUTE
<U9!>	<U>;<HORN+GRAVE>;<CAPITAL>;IGNORE	<U1eea>	LATIN CAPITAL LETTER U WITH HORN AND GRAVE
<u9!>	<U>;<HORN+GRAVE>;<SMALL>;IGNORE	<U1eeb>	LATIN SMALL LETTER U WITH HORN AND GRAVE
<U92>	<U>;<HORN+HOOK>;<CAPITAL>;IGNORE	<U1eec>	LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
<u92>	<U>;<HORN+HOOK>;<SMALL>;IGNORE	<U1eed>	LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE
<U9?>	<U>;<HORN+TILDE>;<CAPITAL>;IGNORE	<U1eee>	LATIN CAPITAL LETTER U WITH HORN AND TILDE
<u9?>	<U>;<HORN+TILDE>;<SMALL>;IGNORE	<U1eef>	LATIN SMALL LETTER U WITH HORN AND TILDE
<U9-.>	<U>;<HORN+DOT-BELOW>;<CAPITAL>;IGNORE	<U1ef0>	LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
<u9-.>	<U>;<HORN+DOT-BELOW>;<SMALL>;IGNORE	<U1ef1>	LATIN SMALL LETTER U WITH HORN AND DOT BELOW
<u8>
<V>	<V>;<NONE>;<CAPITAL>;IGNORE	<U0056>	LATIN CAPITAL LETTER V
<v>	<V>;<NONE>;<SMALL>;IGNORE	<U0076>	LATIN SMALL LETTER V
<V?>	<V>;<TILDE>;<CAPITAL>;IGNORE	<U1e7c>	LATIN CAPITAL LETTER V WITH TILDE
<v?>	<V>;<TILDE>;<SMALL>;IGNORE	<U1e7d>	LATIN SMALL LETTER V WITH TILDE
<V-.>	<V>;<DOT-BELOW>;<CAPITAL>;IGNORE	<U1e7e>	LATIN CAPITAL LETTER V WITH DOT BELOW
<v-.>	<V>;<DOT-BELOW>;<SMALL>;IGNORE	<U1e7f>	LATIN SMALL LETTER V WITH DOT BELOW
<v8>
<W>	<W>;<NONE>;<CAPITAL>;IGNORE	<U0057>	LATIN CAPITAL LETTER W
<w>	<W>;<NONE>;<SMALL>;IGNORE	<U0077>	LATIN SMALL LETTER W
<W'>	<W>;<ACUTE>;<CAPITAL>;IGNORE	<U1e82>	LATIN CAPITAL LETTER W WITH ACUTE
<w'>	<W>;<ACUTE>;<SMALL>;IGNORE	<U1e83>	LATIN SMALL LETTER W WITH ACUTE
<W!>	<W>;<GRAVE>;<CAPITAL>;IGNORE	<U1e80>	LATIN CAPITAL LETTER W WITH GRAVE
<w!>	<W>;<GRAVE>;<SMALL>;IGNORE	<U1e81>	LATIN SMALL LETTER W WITH GRAVE
<W/>>	<W>;<CIRCUMFLEX>;<CAPITAL>;IGNORE	<U0174>	LATIN CAPITAL LETTER W WITH CIRCUMFLEX
<w/>>	<W>;<CIRCUMFLEX>;<SMALL>;IGNORE	<U0175>	LATIN SMALL LETTER W WITH CIRCUMFLEX
<W:>	<W>;<DIAERESIS>;<CAPITAL>;IGNORE	<U1e84>	LATIN CAPITAL LETTER W WITH DIAERESIS
<w:>	<W>;<DIAERESIS>;<SMALL>;IGNORE	<U1e85>	LATIN SMALL LETTER W WITH DIAERESIS
<W.>	<W>;<DOT>;<CAPITAL>;IGNORE	<U1e86>	LATIN CAPITAL LETTER W WITH DOT ABOVE
<w.>	<W>;<DOT>;<SMALL>;IGNORE	<U1e87>	LATIN SMALL LETTER W WITH DOT ABOVE
<W-.>	<W>;<DOT-BELOW>;<CAPITAL>;IGNORE	<U1e88>	LATIN CAPITAL LETTER W WITH DOT BELOW
<w-.>	<W>;<DOT-BELOW>;<SMALL>;IGNORE	<U1e89>	LATIN SMALL LETTER W WITH DOT BELOW
<w8>
<X>	<X>;<NONE>;<CAPITAL>;IGNORE	<U0058>	LATIN CAPITAL LETTER X
<x>	<X>;<NONE>;<SMALL>;IGNORE	<U0078>	LATIN SMALL LETTER X
<X:>	<X>;<DIAERESIS>;<CAPITAL>;IGNORE	<U1e8c>	LATIN CAPITAL LETTER X WITH DIAERESIS
<x:>	<X>;<DIAERESIS>;<SMALL>;IGNORE	<U1e8d>	LATIN SMALL LETTER X WITH DIAERESIS
<X.>	<X>;<DOT>;<CAPITAL>;IGNORE	<U1e8a>	LATIN CAPITAL LETTER X WITH DOT ABOVE
<x.>	<X>;<DOT>;<SMALL>;IGNORE	<U1e8b>	LATIN SMALL LETTER X WITH DOT ABOVE
<x8>
<Y>	<Y>;<NONE>;<CAPITAL>;IGNORE	<U0059>	LATIN CAPITAL LETTER Y
<y>	<Y>;<NONE>;<SMALL>;IGNORE	<U0079>	LATIN SMALL LETTER Y
<Y'>	<Y>;<ACUTE>;<CAPITAL>;IGNORE	<U00dd>	LATIN CAPITAL LETTER Y WITH ACUTE
<y'>	<Y>;<ACUTE>;<SMALL>;IGNORE	<U00fd>	LATIN SMALL LETTER Y WITH ACUTE
<Y!>	<Y>;<GRAVE>;<CAPITAL>;IGNORE	<U1ef2>	LATIN CAPITAL LETTER Y WITH GRAVE
<y!>	<Y>;<GRAVE>;<SMALL>;IGNORE	<U1ef3>	LATIN SMALL LETTER Y WITH GRAVE
<Y/>>	<Y>;<CIRCUMFLEX>;<CAPITAL>;IGNORE	<U0176>	LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
<y/>>	<Y>;<CIRCUMFLEX>;<SMALL>;IGNORE	<U0177>	LATIN SMALL LETTER Y WITH CIRCUMFLEX
<Y:>	<Y>;<DIAERESIS>;<CAPITAL>;IGNORE	<U0178>	LATIN CAPITAL LETTER Y WITH DIAERESIS
<y:>	<Y>;<DIAERESIS>;<SMALL>;IGNORE	<U00ff>	LATIN SMALL LETTER Y WITH DIAERESIS
<Y2>	<Y>;<HOOK>;<CAPITAL>;IGNORE	<U1ef6>	LATIN CAPITAL LETTER Y WITH HOOK ABOVE
<y2>	<Y>;<HOOK>;<SMALL>;IGNORE	<U1ef7>	LATIN SMALL LETTER Y WITH HOOK ABOVE
<Y?>	<Y>;<TILDE>;<CAPITAL>;IGNORE	<U1ef8>	LATIN CAPITAL LETTER Y WITH TILDE
<y?>	<Y>;<TILDE>;<SMALL>;IGNORE	<U1ef9>	LATIN SMALL LETTER Y WITH TILDE
<Y.>	<Y>;<DOT>;<CAPITAL>;IGNORE	<U1e8e>	LATIN CAPITAL LETTER Y WITH DOT ABOVE
<y.>	<Y>;<DOT>;<SMALL>;IGNORE	<U1e8f>	LATIN SMALL LETTER Y WITH DOT ABOVE
<Y-.>	<Y>;<DOT-BELOW>;<CAPITAL>;IGNORE	<U1ef4>	LATIN CAPITAL LETTER Y WITH DOT BELOW
<y-.>	<Y>;<DOT-BELOW>;<SMALL>;IGNORE	<U1ef5>	LATIN SMALL LETTER Y WITH DOT BELOW
<y8>
<Z>	<Z>;<NONE>;<CAPITAL>;IGNORE	<U005a>	LATIN CAPITAL LETTER Z
<z>	<Z>;<NONE>;<SMALL>;IGNORE	<U007a>	LATIN SMALL LETTER Z
<Z'>	<Z>;<ACUTE>;<CAPITAL>;IGNORE	<U0179>	LATIN CAPITAL LETTER Z WITH ACUTE
<z'>	<Z>;<ACUTE>;<SMALL>;IGNORE	<U017a>	LATIN SMALL LETTER Z WITH ACUTE
<Z/>>	<Z>;<CIRCUMFLEX>;<CAPITAL>;IGNORE	<U1e90>	LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
<z/>>	<Z>;<CIRCUMFLEX>;<SMALL>;IGNORE	<U1e91>	LATIN SMALL LETTER Z WITH CIRCUMFLEX
<Z<>	<Z>;<CARON>;<CAPITAL>;IGNORE	<U017d>	LATIN CAPITAL LETTER Z WITH CARON
<z<>	<Z>;<CARON>;<SMALL>;IGNORE	<U017e>	LATIN SMALL LETTER Z WITH CARON
<Z.>	<Z>;<DOT>;<CAPITAL>;IGNORE	<U017b>	LATIN CAPITAL LETTER Z WITH DOT ABOVE
<z.>	<Z>;<DOT>;<SMALL>;IGNORE	<U017c>	LATIN SMALL LETTER Z WITH DOT ABOVE
<Z-.>	<Z>;<DOT-BELOW>;<CAPITAL>;IGNORE	<U1e92>	LATIN CAPITAL LETTER Z WITH DOT BELOW
<z-.>	<Z>;<DOT-BELOW>;<SMALL>;IGNORE	<U1e93>	LATIN SMALL LETTER Z WITH DOT BELOW
<Z//>	<Z>;<STROKE>;<CAPITAL>;IGNORE	<U01b5>	LATIN CAPITAL LETTER Z WITH STROKE
<z//>	<Z>;<STROKE>;<SMALL>;IGNORE	<U01b6>	LATIN SMALL LETTER Z WITH STROKE
<Z_>	<Z>;<LINE-BELOW>;<CAPITAL>;IGNORE	<U1e94>	LATIN CAPITAL LETTER Z WITH LINE BELOW
<z_>	<Z>;<LINE-BELOW>;<SMALL>;IGNORE	<U1e95>	LATIN SMALL LETTER Z WITH LINE BELOW
<z8>
<A*>	<A*>;<CAPITAL>;<GREEK>;IGNORE	<U0391>	GREEK CAPITAL LETTER ALPHA
<A%>	<A*>;<CAPITAL>;<TONOS>;IGNORE	<U0386>	GREEK CAPITAL LETTER ALPHA WITH TONOS
<a*>	<A*>;<SMALL>;<GREEK>;IGNORE	<U03b1>	GREEK SMALL LETTER ALPHA
<a%>	<A*>;<SMALL>;<TONOS>;IGNORE	<U03ac>	GREEK SMALL LETTER ALPHA WITH TONOS
<B*>	<B*>;<CAPITAL>;<GREEK>;IGNORE	<U0392>	GREEK CAPITAL LETTER BETA
<b*>	<B*>;<SMALL>;<GREEK>;IGNORE	<U03b2>	GREEK SMALL LETTER BETA
<G*>	<G*>;<CAPITAL>;<GREEK>;IGNORE	<U0393>	GREEK CAPITAL LETTER GAMMA
<g*>	<G*>;<SMALL>;<GREEK>;IGNORE	<U03b3>	GREEK SMALL LETTER GAMMA
<D*>	<D*>;<CAPITAL>;<GREEK>;IGNORE	<U0394>	GREEK CAPITAL LETTER DELTA
<d*>	<D*>;<SMALL>;<GREEK>;IGNORE	<U03b4>	GREEK SMALL LETTER DELTA
<E*>	<E*>;<CAPITAL>;<GREEK>;IGNORE	<U0395>	GREEK CAPITAL LETTER EPSILON
<E%>	<E*>;<CAPITAL>;<TONOS>;IGNORE	<U0388>	GREEK CAPITAL LETTER EPSILON WITH TONOS
<e*>	<E*>;<SMALL>;<GREEK>;IGNORE	<U03b5>	GREEK SMALL LETTER EPSILON
<e%>	<E*>;<SMALL>;<TONOS>;IGNORE	<U03ad>	GREEK SMALL LETTER EPSILON WITH TONOS
<Z*>	<Z*>;<CAPITAL>;<GREEK>;IGNORE	<U0396>	GREEK CAPITAL LETTER ZETA
<z*>	<Z*>;<SMALL>;<GREEK>;IGNORE	<U03b6>	GREEK SMALL LETTER ZETA
<Y*>	<Y*>;<CAPITAL>;<GREEK>;IGNORE	<U0397>	GREEK CAPITAL LETTER ETA
<Y%>	<Y*>;<CAPITAL>;<TONOS>;IGNORE	<U0389>	GREEK CAPITAL LETTER ETA WITH TONOS
<y*>	<Y*>;<SMALL>;<GREEK>;IGNORE	<U03b7>	GREEK SMALL LETTER ETA
<y%>	<Y*>;<SMALL>;<TONOS>;IGNORE	<U03ae>	GREEK SMALL LETTER ETA WITH TONOS
<H*>	<H*>;<CAPITAL>;<GREEK>;IGNORE	<U0398>	GREEK CAPITAL LETTER THETA
<h*>	<H*>;<SMALL>;<GREEK>;IGNORE	<U03b8>	GREEK SMALL LETTER THETA
<I*>	<I*>;<CAPITAL>;<GREEK>;IGNORE	<U0399>	GREEK CAPITAL LETTER IOTA
<I%>	<I*>;<CAPITAL>;<TONOS>;IGNORE	<U038a>	GREEK CAPITAL LETTER IOTA WITH TONOS
<J*>	<I*>;<CAPITAL>;<DIALYTICA>;IGNORE	<U03aa>	GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
<i*>	<I*>;<SMALL>;<GREEK>;IGNORE	<U03b9>	GREEK SMALL LETTER IOTA
<i%>	<I*>;<SMALL>;<TONOS>;IGNORE	<U03af>	GREEK SMALL LETTER IOTA WITH TONOS
<j*>	<I*>;<SMALL>;<DIALYTICA>;IGNORE	<U03ca>	GREEK SMALL LETTER IOTA WITH DIALYTIKA
<i3>	<I*>;<SMALL>;<DIALYTICA+TONOS>;IGNORE	<U0390>	GREEK SMALL LETTER IOTA WITH DIALYTICA AND TONOS
<K*>	<K*>;<CAPITAL>;<GREEK>;IGNORE	<U039a>	GREEK CAPITAL LETTER KAPPA
<k*>	<K*>;<SMALL>;<GREEK>;IGNORE	<U03ba>	GREEK SMALL LETTER KAPPA
<L*>	<L*>;<CAPITAL>;<GREEK>;IGNORE	<U039b>	GREEK CAPITAL LETTER LAMDA
<l*>	<L*>;<SMALL>;<GREEK>;IGNORE	<U03bb>	GREEK SMALL LETTER LAMDA
<M*>	<M*>;<CAPITAL>;<GREEK>;IGNORE	<U039c>	GREEK CAPITAL LETTER MU
<m*>	<M*>;<SMALL>;<GREEK>;IGNORE	<U03bc>	GREEK SMALL LETTER MU
<N*>	<N*>;<CAPITAL>;<GREEK>;IGNORE	<U039d>	GREEK CAPITAL LETTER NU
<n*>	<N*>;<SMALL>;<GREEK>;IGNORE	<U03bd>	GREEK SMALL LETTER NU
<C*>	<C*>;<CAPITAL>;<GREEK>;IGNORE	<U039e>	GREEK CAPITAL LETTER XI
<c*>	<C*>;<SMALL>;<GREEK>;IGNORE	<U03be>	GREEK SMALL LETTER XI
<O*>	<O*>;<CAPITAL>;<GREEK>;IGNORE	<U039f>	GREEK CAPITAL LETTER OMICRON
<O%>	<O*>;<CAPITAL>;<TONOS>;IGNORE	<U038c>	GREEK CAPITAL LETTER OMICRON WITH TONOS
<o*>	<O*>;<SMALL>;<GREEK>;IGNORE	<U03bf>	GREEK SMALL LETTER OMICRON
<o%>	<O*>;<SMALL>;<TONOS>;IGNORE	<U03cc>	GREEK SMALL LETTER OMICRON WITH TONOS
<P*>	<P*>;<CAPITAL>;<GREEK>;IGNORE	<U03a0>	GREEK CAPITAL LETTER PI
<p*>	<P*>;<SMALL>;<GREEK>;IGNORE	<U03c0>	GREEK SMALL LETTER PI
<R*>	<R*>;<CAPITAL>;<GREEK>;IGNORE	<U03a1>	GREEK CAPITAL LETTER RHO
<r*>	<R*>;<SMALL>;<GREEK>;IGNORE	<U03c1>	GREEK SMALL LETTER RHO
<S*>	<S*>;<CAPITAL>;<GREEK>;IGNORE	<U03a3>	GREEK CAPITAL LETTER SIGMA
<s*>	<S*>;<SMALL>;<GREEK>;IGNORE	<U03c3>	GREEK SMALL LETTER SIGMA
<*s>	<S*>;<SMALL>;<*s>;IGNORE	<U03c2>	GREEK SMALL LETTER FINAL SIGMA
<T*>	<T*>;<CAPITAL>;<GREEK>;IGNORE	<U03a4>	GREEK CAPITAL LETTER TAU
<t*>	<T*>;<SMALL>;<GREEK>;IGNORE	<U03c4>	GREEK SMALL LETTER TAU
<U*>	<U*>;<CAPITAL>;<GREEK>;IGNORE	<U03a5>	GREEK CAPITAL LETTER UPSILON
<U%>	<U*>;<CAPITAL>;<TONOS>;IGNORE	<U038e>	GREEK CAPITAL LETTER UPSILON WITH TONOS
<V*>	<U*>;<CAPITAL>;<DIALYTICA>;IGNORE	<U03ab>	GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
<u*>	<U*>;<SMALL>;<GREEK>;IGNORE	<U03c5>	GREEK SMALL LETTER UPSILON
<u%>	<U*>;<SMALL>;<TONOS>;IGNORE	<U03cd>	GREEK SMALL LETTER UPSILON WITH TONOS
<v*>	<U*>;<SMALL>;<DIALYTICA>;IGNORE	<U03cb>	GREEK SMALL LETTER UPSILON WITH DIALYTIKA
<u3>	<U*>;<SMALL>;<DIALYTICA+TONOS>;IGNORE	<U03b0>	GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
<F*>	<F*>;<CAPITAL>;<GREEK>;IGNORE	<U03a6>	GREEK CAPITAL LETTER PHI
<f*>	<F*>;<SMALL>;<GREEK>;IGNORE	<U03c6>	GREEK SMALL LETTER PHI
<X*>	<X*>;<CAPITAL>;<GREEK>;IGNORE	<U03a7>	GREEK CAPITAL LETTER CHI
<x*>	<X*>;<SMALL>;<GREEK>;IGNORE	<U03c7>	GREEK SMALL LETTER CHI
<Q*>	<Q*>;<CAPITAL>;<GREEK>;IGNORE	<U03a8>	GREEK CAPITAL LETTER PSI
<q*>	<Q*>;<SMALL>;<GREEK>;IGNORE	<U03c8>	GREEK SMALL LETTER PSI
<W*>	<W*>;<CAPITAL>;<GREEK>;IGNORE	<U03a9>	GREEK CAPITAL LETTER OMEGA
<W%>	<W*>;<CAPITAL>;<TONOS>;IGNORE	<U038f>	GREEK CAPITAL LETTER OMEGA WITH TONOS
<w*>	<W*>;<SMALL>;<GREEK>;IGNORE	<U03c9>	GREEK SMALL LETTER OMEGA
<w%>	<W*>;<SMALL>;<TONOS>;IGNORE	<U03ce>	GREEK SMALL LETTER OMEGA WITH TONOS
<A=>	<A=>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0410>	CYRILLIC CAPITAL LETTER A
<a=>	<A=>;<CYRILLIC>;<SMALL>;IGNORE	<U0430>	CYRILLIC SMALL LETTER A
<B=>	<B=>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0411>	CYRILLIC CAPITAL LETTER BE
<b=>	<B=>;<CYRILLIC>;<SMALL>;IGNORE	<U0431>	CYRILLIC SMALL LETTER BE
<V=>	<V=>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0412>	CYRILLIC CAPITAL LETTER VE
<v=>	<V=>;<CYRILLIC>;<SMALL>;IGNORE	<U0432>	CYRILLIC SMALL LETTER VE
<G=>	<G=>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0413>	CYRILLIC CAPITAL LETTER GHE
<g=>	<G=>;<CYRILLIC>;<SMALL>;IGNORE	<U0433>	CYRILLIC SMALL LETTER GHE
<G%>	<G%>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0403>	CYRILLIC CAPITAL LETTER GJE
<g%>	<G%>;<CYRILLIC>;<SMALL>;IGNORE	<U0453>	CYRILLIC SMALL LETTER GJE
<G3>	<G3>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0490>	CYRILLIC CAPITAL LETTER GHE WITH UPTURN
<g3>	<G3>;<CYRILLIC>;<SMALL>;IGNORE	<U0491>	CYRILLIC SMALL LETTER GHE WITH UPTURN
<D=>	<D=>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0414>	CYRILLIC CAPITAL LETTER DE
<d=>	<D=>;<CYRILLIC>;<SMALL>;IGNORE	<U0434>	CYRILLIC SMALL LETTER DE
<D%>	<D%>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0402>	CYRILLIC CAPITAL LETTER DJE (Serbocroatian)
<d%>	<D%>;<CYRILLIC>;<SMALL>;IGNORE	<U0452>	CYRILLIC SMALL LETTER DJE (Serbocroatian)
<E=>	<E=>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0415>	CYRILLIC CAPITAL LETTER IE
<e=>	<E=>;<CYRILLIC>;<SMALL>;IGNORE	<U0435>	CYRILLIC SMALL LETTER IE
<IO>	<IO>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0401>	CYRILLIC CAPITAL LETTER IO
<io>	<IO>;<CYRILLIC>;<SMALL>;IGNORE	<U0451>	CYRILLIC SMALL LETTER IO
<IE>	<IE>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0404>	CYRILLIC CAPITAL LETTER UKRAINIAN IE
<ie>	<IE>;<CYRILLIC>;<SMALL>;IGNORE	<U0454>	CYRILLIC SMALL LETTER UKRAINIAN IE
<Z%>	<Z%>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0416>	CYRILLIC CAPITAL LETTER ZHE
<z%>	<Z%>;<CYRILLIC>;<SMALL>;IGNORE	<U0436>	CYRILLIC SMALL LETTER ZHE
<Z=>	<Z=>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0417>	CYRILLIC CAPITAL LETTER ZE
<z=>	<Z=>;<CYRILLIC>;<SMALL>;IGNORE	<U0437>	CYRILLIC SMALL LETTER ZE
<I=>	<I=>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0418>	CYRILLIC CAPITAL LETTER I
<i=>	<I=>;<CYRILLIC>;<SMALL>;IGNORE	<U0438>	CYRILLIC SMALL LETTER I
<II>	<II>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0406>	CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
<ii>	<II>;<CYRILLIC>;<SMALL>;IGNORE	<U0456>	CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
<YI>	<YI>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0407>	CYRILLIC CAPITAL LETTER YI (Ukrainian)
<yi>	<YI>;<CYRILLIC>;<SMALL>;IGNORE	<U0457>	CYRILLIC SMALL LETTER YI (Ukrainian)
<J%>	<J%>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0408>	CYRILLIC CAPITAL LETTER JE
<j%>	<J%>;<CYRILLIC>;<SMALL>;IGNORE	<U0458>	CYRILLIC SMALL LETTER JE
<J=>	<J=>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0419>	CYRILLIC CAPITAL LETTER SHORT I
<j=>	<J=>;<CYRILLIC>;<SMALL>;IGNORE	<U0439>	CYRILLIC SMALL LETTER SHORT I
<K=>	<K=>;<CYRILLIC>;<CAPITAL>;IGNORE	<U041a>	CYRILLIC CAPITAL LETTER KA
<k=>	<K=>;<CYRILLIC>;<SMALL>;IGNORE	<U043a>	CYRILLIC SMALL LETTER KA
<KJ>	<KJ>;<CYRILLIC>;<CAPITAL>;IGNORE	<U040c>	CYRILLIC CAPITAL LETTER KJE
<kj>	<KJ>;<CYRILLIC>;<SMALL>;IGNORE	<U045c>	CYRILLIC SMALL LETTER KJE
<L=>	<L=>;<CYRILLIC>;<CAPITAL>;IGNORE	<U041b>	CYRILLIC CAPITAL LETTER EL
<l=>	<L=>;<CYRILLIC>;<SMALL>;IGNORE	<U043b>	CYRILLIC SMALL LETTER EL
<LJ>	<LJ>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0409>	CYRILLIC CAPITAL LETTER LJE
<lj>	<LJ>;<CYRILLIC>;<SMALL>;IGNORE	<U0459>	CYRILLIC SMALL LETTER LJE
<M=>	<M=>;<CYRILLIC>;<CAPITAL>;IGNORE	<U041c>	CYRILLIC CAPITAL LETTER EM
<m=>	<M=>;<CYRILLIC>;<SMALL>;IGNORE	<U043c>	CYRILLIC SMALL LETTER EM
<N=>	<N=>;<CYRILLIC>;<CAPITAL>;IGNORE	<U041d>	CYRILLIC CAPITAL LETTER EN
<n=>	<N=>;<CYRILLIC>;<SMALL>;IGNORE	<U043d>	CYRILLIC SMALL LETTER EN
<NJ>	<NJ>;<CYRILLIC>;<CAPITAL>;IGNORE	<U040a>	CYRILLIC CAPITAL LETTER NJE
<nj>	<NJ>;<CYRILLIC>;<SMALL>;IGNORE	<U045a>	CYRILLIC SMALL LETTER NJE
<O=>	<O=>;<CYRILLIC>;<CAPITAL>;IGNORE	<U041e>	CYRILLIC CAPITAL LETTER O
<o=>	<O=>;<CYRILLIC>;<SMALL>;IGNORE	<U043e>	CYRILLIC SMALL LETTER O
<P=>	<P=>;<CYRILLIC>;<CAPITAL>;IGNORE	<U041f>	CYRILLIC CAPITAL LETTER PE
<p=>	<P=>;<CYRILLIC>;<SMALL>;IGNORE	<U043f>	CYRILLIC SMALL LETTER PE
<R=>	<R=>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0420>	CYRILLIC CAPITAL LETTER ER
<r=>	<R=>;<CYRILLIC>;<SMALL>;IGNORE	<U0440>	CYRILLIC SMALL LETTER ER
<S=>	<S=>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0421>	CYRILLIC CAPITAL LETTER ES
<s=>	<S=>;<CYRILLIC>;<SMALL>;IGNORE	<U0441>	CYRILLIC SMALL LETTER ES
<T=>	<T=>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0422>	CYRILLIC CAPITAL LETTER TE
<t=>	<T=>;<CYRILLIC>;<SMALL>;IGNORE	<U0442>	CYRILLIC SMALL LETTER TE
<Ts>	<Ts>;<CYRILLIC>;<CAPITAL>;IGNORE	<U040b>	CYRILLIC CAPITAL LETTER TSHE (Serbocroatian)
<ts>	<Ts>;<CYRILLIC>;<SMALL>;IGNORE	<U045b>	CYRILLIC SMALL LETTER TSHE (Serbocroatian)
<U=>	<U=>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0423>	CYRILLIC CAPITAL LETTER U
<u=>	<U=>;<CYRILLIC>;<SMALL>;IGNORE	<U0443>	CYRILLIC SMALL LETTER U
<V%>	<V%>;<CYRILLIC>;<CAPITAL>;IGNORE	<U040e>	CYRILLIC CAPITAL LETTER SHORT U (Byelorussian)
<v%>	<V%>;<CYRILLIC>;<SMALL>;IGNORE	<U045e>	CYRILLIC SMALL LETTER SHORT U (Byelorussian)
<F=>	<F=>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0424>	CYRILLIC CAPITAL LETTER EF
<f=>	<F=>;<CYRILLIC>;<SMALL>;IGNORE	<U0444>	CYRILLIC SMALL LETTER EF
<H=>	<H=>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0425>	CYRILLIC CAPITAL LETTER HA
<h=>	<H=>;<CYRILLIC>;<SMALL>;IGNORE	<U0445>	CYRILLIC SMALL LETTER HA
<C=>	<C=>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0426>	CYRILLIC CAPITAL LETTER TSE
<c=>	<C=>;<CYRILLIC>;<SMALL>;IGNORE	<U0446>	CYRILLIC SMALL LETTER TSE
<DS>	<DS>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0405>	CYRILLIC CAPITAL LETTER DZE
<ds>	<DS>;<CYRILLIC>;<SMALL>;IGNORE	<U0455>	CYRILLIC SMALL LETTER DZE
<C%>	<C%>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0427>	CYRILLIC CAPITAL LETTER CHE
<c%>	<C%>;<CYRILLIC>;<SMALL>;IGNORE	<U0447>	CYRILLIC SMALL LETTER CHE
<DZ>	<DZ>;<CYRILLIC>;<CAPITAL>;IGNORE	<U040f>	CYRILLIC CAPITAL LETTER DZHE
<dz>	<DZ>;<CYRILLIC>;<SMALL>;IGNORE	<U045f>	CYRILLIC SMALL LETTER DZHE
<S%>	<S%>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0428>	CYRILLIC CAPITAL LETTER SHA
<s%>	<S%>;<CYRILLIC>;<SMALL>;IGNORE	<U0448>	CYRILLIC SMALL LETTER SHA
<Sc>	<Sc>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0429>	CYRILLIC CAPITAL LETTER SHCHA
<sc>	<Sc>;<CYRILLIC>;<SMALL>;IGNORE	<U0449>	CYRILLIC SMALL LETTER SHCHA
<='>	<='>;<CYRILLIC>;<SMALL>;IGNORE	<U044a>	CYRILLIC SMALL LETTER HARD SIGN
<=">	<='>;<CYRILLIC>;<CAPITAL>;IGNORE	<U042a>	CYRILLIC CAPITAL LETTER HARD SIGN
<Y=>	<Y=>;<CYRILLIC>;<CAPITAL>;IGNORE	<U042b>	CYRILLIC CAPITAL LETTER YERU
<y=>	<Y=>;<CYRILLIC>;<SMALL>;IGNORE	<U044b>	CYRILLIC SMALL LETTER YERU
<%'>	<%'>;<CYRILLIC>;<SMALL>;IGNORE	<U044c>	CYRILLIC SMALL LETTER SOFT SIGN
<%">	<%'>;<CYRILLIC>;<CAPITAL>;IGNORE	<U042c>	CYRILLIC CAPITAL LETTER SOFT SIGN
<JE>	<JE>;<CYRILLIC>;<CAPITAL>;IGNORE	<U042d>	CYRILLIC CAPITAL LETTER E
<je>	<JE>;<CYRILLIC>;<SMALL>;IGNORE	<U044d>	CYRILLIC SMALL LETTER E
<JU>	<JU>;<CYRILLIC>;<CAPITAL>;IGNORE	<U042e>	CYRILLIC CAPITAL LETTER YU
<ju>	<JU>;<CYRILLIC>;<SMALL>;IGNORE	<U044e>	CYRILLIC SMALL LETTER YU
<JA>	<JA>;<CYRILLIC>;<CAPITAL>;IGNORE	<U042f>	CYRILLIC CAPITAL LETTER YA
<ja>	<JA>;<CYRILLIC>;<SMALL>;IGNORE	<U044f>	CYRILLIC SMALL LETTER YA
<Y3>	<Y3>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0462>	CYRILLIC CAPITAL LETTER YAT
<y3>	<Y3>;<CYRILLIC>;<SMALL>;IGNORE	<U0463>	CYRILLIC SMALL LETTER YAT
<O3>	<O3>;<CYRILLIC>;<CAPITAL>;IGNORE	<U046a>	CYRILLIC CAPITAL LETTER BIG YUS
<o3>	<O3>;<CYRILLIC>;<SMALL>;IGNORE	<U046b>	CYRILLIC SMALL LETTER BIG YUS
<F3>	<F3>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0472>	CYRILLIC CAPITAL LETTER FITA
<f3>	<F3>;<CYRILLIC>;<SMALL>;IGNORE	<U0473>	CYRILLIC SMALL LETTER FITA
<V3>	<V3>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0474>	CYRILLIC CAPITAL LETTER IZHITSA
<v3>	<V3>;<CYRILLIC>;<SMALL>;IGNORE	<U0475>	CYRILLIC SMALL LETTER IZHITSA
<C3>	<C3>;<CYRILLIC>;<CAPITAL>;IGNORE	<U0480>	CYRILLIC CAPITAL LETTER KOPPA
<c3>	<C3>;<CYRILLIC>;<SMALL>;IGNORE	<U0481>	CYRILLIC SMALL LETTER KOPPA
<A+>	<A+>;IGNORE;IGNORE;IGNORE	<U05d0>	HEBREW LETTER ALEF
<B+>	<B+>;IGNORE;IGNORE;IGNORE	<U05d1>	HEBREW LETTER BET
<G+>	<G+>;IGNORE;IGNORE;IGNORE	<U05d2>	HEBREW LETTER GIMEL
<D+>	<D+>;IGNORE;IGNORE;IGNORE	<U05d3>	HEBREW LETTER DALET
<H+>	<H+>;IGNORE;IGNORE;IGNORE	<U05d4>	HEBREW LETTER HE
<W+>	<W+>;IGNORE;IGNORE;IGNORE	<U05d5>	HEBREW LETTER VAV
<Z+>	<Z+>;IGNORE;IGNORE;IGNORE	<U05d6>	HEBREW LETTER ZAYIN
<X+>	<X+>;IGNORE;IGNORE;IGNORE	<U05d7>	HEBREW LETTER HET
<Tj>	<Tj>;IGNORE;IGNORE;IGNORE	<U05d8>	HEBREW LETTER TET
<J+>	<J+>;IGNORE;IGNORE;IGNORE	<U05d9>	HEBREW LETTER YOD
<K%>	<K%>;IGNORE;IGNORE;IGNORE	<U05da>	HEBREW LETTER FINAL KAF
<K+>	<K+>;IGNORE;IGNORE;IGNORE	<U05db>	HEBREW LETTER KAF
<L+>	<L+>;IGNORE;IGNORE;IGNORE	<U05dc>	HEBREW LETTER LAMED
<M%>	<M%>;IGNORE;IGNORE;IGNORE	<U05dd>	HEBREW LETTER FINAL MEM
<M+>	<M+>;IGNORE;IGNORE;IGNORE	<U05de>	HEBREW LETTER MEM
<N%>	<N%>;IGNORE;IGNORE;IGNORE	<U05df>	HEBREW LETTER FINAL NUN
<N+>	<N+>;IGNORE;IGNORE;IGNORE	<U05e0>	HEBREW LETTER NUN
<S+>	<S+>;IGNORE;IGNORE;IGNORE	<U05e1>	HEBREW LETTER SAMEKH
<E+>	<E+>;IGNORE;IGNORE;IGNORE	<U05e2>	HEBREW LETTER AYIN
<P%>	<P%>;IGNORE;IGNORE;IGNORE	<U05e3>	HEBREW LETTER FINAL PE
<P+>	<P+>;IGNORE;IGNORE;IGNORE	<U05e4>	HEBREW LETTER PE
<Zj>	<Zj>;IGNORE;IGNORE;IGNORE	<U05e5>	HEBREW LETTER FINAL TSADI
<ZJ>	<ZJ>;IGNORE;IGNORE;IGNORE	<U05e6>	HEBREW LETTER TSADI
<Q+>	<Q+>;IGNORE;IGNORE;IGNORE	<U05e7>	HEBREW LETTER QOF
<R+>	<R+>;IGNORE;IGNORE;IGNORE	<U05e8>	HEBREW LETTER RESH
<Sh>	<Sh>;IGNORE;IGNORE;IGNORE	<U05e9>	HEBREW LETTER SHIN
<T+>	<T+>;IGNORE;IGNORE;IGNORE	<U05ea>	HEBREW LETTER TAV

% Arabic collating

<,+>	IGNORE;IGNORE;IGNORE;<,+>	<U060c>	ARABIC COMMA
<;+>	IGNORE;IGNORE;IGNORE;<;+>	<U061b>	ARABIC SEMICOLON
<?+>	IGNORE;IGNORE;IGNORE;<?+>	<U061f>	ARABIC QUESTION MARK
<++>	IGNORE;IGNORE;IGNORE;<++>	<U0640>	ARABIC TATWEEL

<H'>	<H'>;<H'>;IGNORE;IGNORE	<U0621>	ARABIC LETTER HAMZA
<aM>	<aM>;<aM>;IGNORE;IGNORE	<U0622>	ARABIC LETTER ALEF WITH MADDA ABOVE
<aM.>	<aM>;<aM.>;IGNORE;IGNORE	<Ufe82>	ARABIC LETTER ALEF WITH MADDA ABOVE FINAL FORM
<aH>	<H'>;<aH>;IGNORE;IGNORE	<U0623>	ARABIC LETTER ALEF WITH HAMZA ABOVE
<aH.>	<H'>;<aH.>;IGNORE;IGNORE	<Ufe84>	ARABIC LETTER ALEF WITH HAMZA ABOVE FINAL FORM
<wH>	<H'>;<wH>;IGNORE;IGNORE	<U0624>	ARABIC LETTER WAW WITH HAMZA ABOVE
<ah>	<H'>;<ah>;IGNORE;IGNORE	<U0625>	ARABIC LETTER ALEF WITH HAMZA BELOW
<ah.>	<H'>;<ah.>;IGNORE;IGNORE	<Ufe88>	ARABIC LETTER ALEF WITH HAMZA BELOW FINAL FORM
<yH>	<H'>;<yH>;IGNORE;IGNORE	<U0626>	ARABIC LETTER YEH WITH HAMZA ABOVE
<aS>	<aS>;<aS>;IGNORE;IGNORE	<U0670>	ARABIC LETTER SUPERSCRIPT ALEF
<a+>	<a+>;<a+>;IGNORE;IGNORE	<U0627>	ARABIC LETTER ALEF
<a+->	<a+>;<a+->;IGNORE;IGNORE	<Ufe8d>	ARABIC LETTER ALEF ISOLATED FORM
<a+.>	<a+>;<a+.>;IGNORE;IGNORE	<Ufe8e>	ARABIC LETTER ALEF FINAL FORM
<a+:>	<a+>;<a+:>;IGNORE;IGNORE	<IBM868_90>   	ARABIC LETTER ALEF FINAL FORM COMPATIBILITY
<b+>	<b+>;<b+>;IGNORE;IGNORE	<U0628>	ARABIC LETTER BEH
<b+->	<b+>;<b+->;IGNORE;IGNORE	<Ufe8f>	ARABIC LETTER BEH ISOLATED FORM
<b+.>	<b+>;<b+.>;IGNORE;IGNORE	<Ufe90>	ARABIC LETTER BEH FINAL FORM
<b+,>	<b+>;<b+,>;IGNORE;IGNORE	<Ufe91>	ARABIC LETTER BEH INITIAL FORM
<b+;>	<b+>;<b+;>;IGNORE;IGNORE	<Ufe92>	ARABIC LETTER BEH MEDIAL FORM
<p+>	<p+>;<p+>;IGNORE;IGNORE	<U067e>	ARABIC LETTER PEH
<v+>	<v+>;<v+>;IGNORE;IGNORE	<U06a4>	ARABIC LETTER VEH
<tm>	<tm>;<tm>;IGNORE;IGNORE	<U0629>	ARABIC LETTER TEH MARBUTA
<tm->	<tm>;<tm->;IGNORE;IGNORE	<Ufe93>	ARABIC LETTER TEH MARBUTA ISOLATED FORM
<tm.>	<tm>;<tm.>;IGNORE;IGNORE	<Ufe94>	ARABIC LETTER TEH MARBUTA FINAL FORM
<t+>	<tm>;<t+>;IGNORE;IGNORE	<U062a>	ARABIC LETTER TEH
<t+->	<tm>;<t+->;IGNORE;IGNORE	<Ufe95>	ARABIC LETTER TEH ISOLATED FORM
<t+.>	<tm>;<t+.>;IGNORE;IGNORE	<Ufe96>	ARABIC LETTER TEH FINAL FORM
<t+,>	<tm>;<t+,>;IGNORE;IGNORE	<Ufe97>	ARABIC LETTER TEH INITIAL FORM
<t+;>	<tm>;<t+;>;IGNORE;IGNORE	<Ufe98>	ARABIC LETTER TEH MEDIAL FORM
<tk>	<tk>;<tk>;IGNORE;IGNORE	<U062b>	ARABIC LETTER THEH
<tk->	<tk>;<tk->;IGNORE;IGNORE	<Ufe99>	ARABIC LETTER THEH ISOLATED FORM
<tk.>	<tk>;<tk.>;IGNORE;IGNORE	<Ufe9a>	ARABIC LETTER THEH FINAL FORM
<tk,>	<tk>;<tk,>;IGNORE;IGNORE	<Ufe9b>	ARABIC LETTER THEH INITIAL FORM
<tk;>	<tk>;<tk;>;IGNORE;IGNORE	<Ufe9c>	ARABIC LETTER THEH MEDIAL FORM
<g+>	<g+>;<g+>;IGNORE;IGNORE	<U062c>	ARABIC LETTER JEEM
<g+->	<g+>;<g+->;IGNORE;IGNORE	<Ufe9d>	ARABIC LETTER JEEM ISOLATED FORM
<g+.>	<g+>;<g+.>;IGNORE;IGNORE	<Ufe9e>	ARABIC LETTER JEEM FINAL FORM
<g+,>	<g+>;<g+,>;IGNORE;IGNORE	<Ufe9f>	ARABIC LETTER JEEM INITIAL FORM
<g+;>	<g+>;<g+;>;IGNORE;IGNORE	<Ufea0>	ARABIC LETTER JEEM MEDIAL FORM
<hk>	<hk>;<hk>;IGNORE;IGNORE	<U062d>	ARABIC LETTER HAH
<hk->	<hk>;<hk->;IGNORE;IGNORE	<Ufea1>	ARABIC LETTER HAH ISOLATED FORM
<hk.>	<hk>;<hk.>;IGNORE;IGNORE	<Ufea2>	ARABIC LETTER HAH FINAL FORM
<hk,>	<hk>;<hk,>;IGNORE;IGNORE	<Ufea3>	ARABIC LETTER HAH INITIAL FORM
<hk;>	<hk>;<hk;>;IGNORE;IGNORE	<Ufea4>	ARABIC LETTER HAH MEDIAL FORM
<x+>	<x+>;<x+>;IGNORE;IGNORE	<U062e>	ARABIC LETTER KHAH
<x+->	<x+>;<x+->;IGNORE;IGNORE	<Ufea5>	ARABIC LETTER KHAH ISOLATED FORM
<x+.>	<x+>;<x+.>;IGNORE;IGNORE	<Ufea6>	ARABIC LETTER KHAH FINAL FORM
<x+,>	<x+>;<x+,>;IGNORE;IGNORE	<Ufea7>	ARABIC LETTER KHAH INITIAL FORM
<x+;>	<x+>;<x+;>;IGNORE;IGNORE	<Ufea8>	ARABIC LETTER KHAH MEDIAL FORM
<d+>	<d+>;<d+>;IGNORE;IGNORE	<U062f>	ARABIC LETTER DAL
<d+->	<d+>;<d+->;IGNORE;IGNORE	<Ufea9>	ARABIC LETTER DAL ISOLATED FORM
<d+.>	<d+>;<d+.>;IGNORE;IGNORE	<Ufeaa>	ARABIC LETTER DAL FINAL FORM
<dk>	<dk>;<dk>;IGNORE;IGNORE	<U0630>	ARABIC LETTER THAL
<dk->	<dk>;<dk->;IGNORE;IGNORE	<Ufeab>	ARABIC LETTER THAL ISOLATED FORM
<dk.>	<dk>;<dk.>;IGNORE;IGNORE	<Ufeac>	ARABIC LETTER THAL FINAL FORM
<r+>	<r+>;<r+>;IGNORE;IGNORE	<U0631>	ARABIC LETTER REH
<r+->	<r+>;<r+->;IGNORE;IGNORE	<Ufead>	ARABIC LETTER REH ISOLATED FORM
<r+.>	<r+>;<r+.>;IGNORE;IGNORE	<Ufeae>	ARABIC LETTER REH FINAL FORM
<z+>	<z+>;<z+>;IGNORE;IGNORE	<U0632>	ARABIC LETTER ZAIN
<z+->	<z+>;<z+->;IGNORE;IGNORE	<Ufeaf>	ARABIC LETTER ZAIN ISOLATED FORM
<z+.>	<z+>;<z+.>;IGNORE;IGNORE	<Ufeb0>	ARABIC LETTER ZAIN FINAL FORM
<s+>	<s+>;<s+>;IGNORE;IGNORE	<U0633>	ARABIC LETTER SEEN
<s+->	<s+>;<s+->;IGNORE;IGNORE	<Ufeb1>	ARABIC LETTER SEEN ISOLATED FORM
<s+.>	<s+>;<s+.>;IGNORE;IGNORE	<Ufeb2>	ARABIC LETTER SEEN FINAL FORM
<s+,>	<s+>;<s+,>;IGNORE;IGNORE	<Ufeb3>	ARABIC LETTER SEEN INITIAL FORM
<s+;>	<s+>;<s+;>;IGNORE;IGNORE	<Ufeb4>	ARABIC LETTER SEEN MEDIAL FORM
<sn>	<sn>;<sn>;IGNORE;IGNORE	<U0634>	ARABIC LETTER SHEEN
<sn->	<sn>;<sn->;IGNORE;IGNORE	<Ufeb5>	ARABIC LETTER SHEEN ISOLATED FORM
<sn.>	<sn>;<sn.>;IGNORE;IGNORE	<Ufeb6>	ARABIC LETTER SHEEN FINAL FORM
<sn,>	<sn>;<sn,>;IGNORE;IGNORE	<Ufeb7>	ARABIC LETTER SHEEN INITIAL FORM
<sn;>	<sn>;<sn;>;IGNORE;IGNORE	<Ufeb8>	ARABIC LETTER SHEEN MEDIAL FORM
<c+>	<c+>;<c+>;IGNORE;IGNORE	<U0635>	ARABIC LETTER SAD
<c+->	<c+>;<c+->;IGNORE;IGNORE	<Ufeb9>	ARABIC LETTER SAD ISOLATED FORM
<c+.>	<c+>;<c+.>;IGNORE;IGNORE	<Ufeba>	ARABIC LETTER SAD FINAL FORM
<c+,>	<c+>;<c+,>;IGNORE;IGNORE	<Ufebb>	ARABIC LETTER SAD INITIAL FORM
<c+;>	<c+>;<c+;>;IGNORE;IGNORE	<Ufebc>	ARABIC LETTER SAD MEDIAL FORM
<dd>	<dd>;<dd>;IGNORE;IGNORE	<U0636>	ARABIC LETTER DAD
<dd->	<dd>;<dd->;IGNORE;IGNORE	<Ufebd>	ARABIC LETTER DAD ISOLATED FORM
<dd.>	<dd>;<dd.>;IGNORE;IGNORE	<Ufebe>	ARABIC LETTER DAD FINAL FORM
<dd,>	<dd>;<dd,>;IGNORE;IGNORE	<Ufebf>	ARABIC LETTER DAD INITIAL FORM
<dd;>	<dd>;<dd;>;IGNORE;IGNORE	<Ufec0>	ARABIC LETTER DAD MEDIAL FORM
<tj>	<tj>;<tj>;IGNORE;IGNORE	<U0637>	ARABIC LETTER TAH
<tj->	<tj>;<tj->;IGNORE;IGNORE	<Ufec1>	ARABIC LETTER TAH ISOLATED FORM
<tj.>	<tj>;<tj.>;IGNORE;IGNORE	<Ufec2>	ARABIC LETTER TAH FINAL FORM
<tj,>	<tj>;<tj,>;IGNORE;IGNORE	<Ufec3>	ARABIC LETTER TAH INITIAL FORM
<tj;>	<tj>;<tj;>;IGNORE;IGNORE	<Ufec4>	ARABIC LETTER TAH MEDIAL FORM
<zH>	<zH>;<zH>;IGNORE;IGNORE	<U0638>	ARABIC LETTER ZAH
<zH->	<zH>;<zH->;IGNORE;IGNORE	<Ufec5>	ARABIC LETTER ZAH ISOLATED FORM
<zH.>	<zH>;<zH.>;IGNORE;IGNORE	<Ufec6>	ARABIC LETTER ZAH FINAL FORM
<zH,>	<zH>;<zH,>;IGNORE;IGNORE	<Ufec7>	ARABIC LETTER ZAH INITIAL FORM
<zH;>	<zH>;<zH;>;IGNORE;IGNORE	<Ufec8>	ARABIC LETTER ZAH MEDIAL FORM
<e+>	<e+>;<e+>;IGNORE;IGNORE	<U0639>	ARABIC LETTER AIN
<e+->	<e+>;<e+->;IGNORE;IGNORE	<Ufec9>	ARABIC LETTER AIN ISOLATED FORM
<e+.>	<e+>;<e+.>;IGNORE;IGNORE	<Ufeca>	ARABIC LETTER AIN FINAL FORM
<e+,>	<e+>;<e+,>;IGNORE;IGNORE	<Ufecb>	ARABIC LETTER AIN INITIAL FORM
<e+;>	<e+>;<e+;>;IGNORE;IGNORE	<Ufecc>	ARABIC LETTER AIN MEDIAL FORM
<i+>	<i+>;<i+>;IGNORE;IGNORE	<U063a>	ARABIC LETTER GHAIN
<i+->	<i+>;<i+->;IGNORE;IGNORE	<Ufecd>	ARABIC LETTER GHAIN ISOLATED FORM
<i+.>	<i+>;<i+.>;IGNORE;IGNORE	<Ufece>	ARABIC LETTER GHAIN FINAL FORM
<i+,>	<i+>;<i+,>;IGNORE;IGNORE	<Ufecf>	ARABIC LETTER GHAIN INITIAL FORM
<i+;>	<i+>;<i+;>;IGNORE;IGNORE	<Ufed0>	ARABIC LETTER GHAIN MEDIAL FORM
<f+>	<f+>;<f+>;IGNORE;IGNORE	<U0641>	ARABIC LETTER FEH
<f+->	<f+>;<f+->;IGNORE;IGNORE	<Ufed1>	ARABIC LETTER FEH ISOLATED FORM
<f+.>	<f+>;<f+.>;IGNORE;IGNORE	<Ufed2>	ARABIC LETTER FEH FINAL FORM
<f+,>	<f+>;<f+,>;IGNORE;IGNORE	<Ufed3>	ARABIC LETTER FEH INITIAL FORM
<f+;>	<f+>;<f+;>;IGNORE;IGNORE	<Ufed4>	ARABIC LETTER FEH MEDIAL FORM
<q+>	<q+>;<q+>;IGNORE;IGNORE	<U0642>	ARABIC LETTER QAF
<q+->	<q+>;<q+->;IGNORE;IGNORE	<Ufed5>	ARABIC LETTER QAF ISOLATED FORM
<q+.>	<q+>;<q+.>;IGNORE;IGNORE	<Ufed6>	ARABIC LETTER QAF FINAL FORM
<q+,>	<q+>;<q+,>;IGNORE;IGNORE	<Ufed7>	ARABIC LETTER QAF INITIAL FORM
<q+;>	<q+>;<q+;>;IGNORE;IGNORE	<Ufed8>	ARABIC LETTER QAF MEDIAL FORM
<k+>	<k+>;<k+>;IGNORE;IGNORE	<U0643>	ARABIC LETTER KAF
<k+->	<k+>;<k+->;IGNORE;IGNORE	<Ufed9>	ARABIC LETTER KAF ISOLATED FORM
<k+.>	<k+>;<k+.>;IGNORE;IGNORE	<Ufeda>	ARABIC LETTER KAF FINAL FORM
<k+,>	<k+>;<k+,>;IGNORE;IGNORE	<Ufedb>	ARABIC LETTER KAF INITIAL FORM
<k+;>	<k+>;<k+;>;IGNORE;IGNORE	<Ufedc>	ARABIC LETTER KAF MEDIAL FORM
<l+>	<l+>;<l+>;IGNORE;IGNORE	<U0644>	ARABIC LETTER LAM
<l+->	<l+>;<l+->;IGNORE;IGNORE	<Ufedd>	ARABIC LETTER LAM ISOLATED FORM
<l+.>	<l+>;<l+.>;IGNORE;IGNORE	<Ufede>	ARABIC LETTER LAM FINAL FORM
<l+,>	<l+>;<l+,>;IGNORE;IGNORE	<Ufedf>	ARABIC LETTER LAM INITIAL FORM
<l+;>	<l+>;<l+;>;IGNORE;IGNORE	<Ufee0>	ARABIC LETTER LAM MEDIAL FORM
<m+>	<m+>;<m+>;IGNORE;IGNORE	<U0645>	ARABIC LETTER MEEM
<m+->	<m+>;<m+->;IGNORE;IGNORE	<Ufee1>	ARABIC LETTER MEEM ISOLATED FORM
<m+.>	<m+>;<m+.>;IGNORE;IGNORE	<Ufee2>	ARABIC LETTER MEEM FINAL FORM
<m+,>	<m+>;<m+,>;IGNORE;IGNORE	<Ufee3>	ARABIC LETTER MEEM INITIAL FORM
<m+;>	<m+>;<m+;>;IGNORE;IGNORE	<Ufee4>	ARABIC LETTER MEEM MEDIAL FORM
<n+>	<n+>;<n+>;IGNORE;IGNORE	<U0646>	ARABIC LETTER NOON
<n+->	<n+>;<n+->;IGNORE;IGNORE	<Ufee5>	ARABIC LETTER NOON ISOLATED FORM
<n+.>	<n+>;<n+.>;IGNORE;IGNORE	<Ufee6>	ARABIC LETTER NOON FINAL FORM
<n+,>	<n+>;<n+,>;IGNORE;IGNORE	<Ufee7>	ARABIC LETTER NOON INITIAL FORM
<n+;>	<n+>;<n+;>;IGNORE;IGNORE	<Ufee8>	ARABIC LETTER NOON MEDIAL FORM
<h+>	<h+>;<h+>;IGNORE;IGNORE	<U0647>	ARABIC LETTER HEH
<h+->	<h+>;<h+->;IGNORE;IGNORE	<Ufee9>	ARABIC LETTER HEH ISOLATED FORM
<h+.>	<h+>;<h+.>;IGNORE;IGNORE	<Ufeea>	ARABIC LETTER HEH FINAL FORM
<h+,>	<h+>;<h+,>;IGNORE;IGNORE	<Ufeeb>	ARABIC LETTER HEH INITIAL FORM
<h+;>	<h+>;<h+;>;IGNORE;IGNORE	<Ufeec>	ARABIC LETTER HEH MEDIAL FORM
<w+>	<w+>;<w+>;IGNORE;IGNORE	<U0648>	ARABIC LETTER WAW
<w+->	<w+>;<w+->;IGNORE;IGNORE	<Ufeed>	ARABIC LETTER WAW ISOLATED FORM
<w+.>	<w+>;<w+.>;IGNORE;IGNORE	<Ufeee>	ARABIC LETTER WAW FINAL FORM
<j+>	<j+>;<j+>;IGNORE;IGNORE	<U0649>	ARABIC LETTER ALEF MAKSURA
<j+->	<j+>;<j+->;IGNORE;IGNORE	<Ufeef>	ARABIC LETTER ALEF MAKSURA ISOLATED FORM
<j+.>	<j+>;<j+.>;IGNORE;IGNORE	<Ufef0>	ARABIC LETTER ALEF MAKSURA FINAL FORM
<y+>	<y+>;<y+>;IGNORE;IGNORE	<U064a>	ARABIC LETTER YEH
<y+->	<y+>;<y+->;IGNORE;IGNORE	<Ufef1>	ARABIC LETTER YEH ISOLATED FORM
<y+.>	<y+>;<y+.>;IGNORE;IGNORE	<Ufef2>	ARABIC LETTER YEH FINAL FORM
<y+,>	<y+>;<y+,>;IGNORE;IGNORE	<Ufef3>	ARABIC LETTER YEH INITIAL FORM
<y+;>	<y+>;<y+;>;IGNORE;IGNORE	<Ufef4>	ARABIC LETTER YEH MEDIAL FORM

<:+>	IGNORE;IGNORE;<:+>;IGNORE	<U064b>	ARABIC FATHATAN
<"+>	IGNORE;IGNORE;<"+>;IGNORE	<U064c>	ARABIC DAMMATAN
<=+>	IGNORE;IGNORE;<=+>;IGNORE	<U064d>	ARABIC KASRATAN
<//+>	IGNORE;IGNORE;<//+>;IGNORE	<U064e>	ARABIC FATHA
<'+>	IGNORE;IGNORE;<'+>;IGNORE	<U064f>	ARABIC DAMMA
<1+>	IGNORE;IGNORE;<1+>;IGNORE	<U0650>	ARABIC KASRA
<3+>	IGNORE;IGNORE;<3+>;IGNORE	<U0651>	ARABIC SHADDA
<3+;>	IGNORE;IGNORE;<3+;>;IGNORE	<Ufe7d>	ARABIC SHADDA MEDIAL FORM
<0+>	IGNORE;IGNORE;<0+>;IGNORE	<U0652>	ARABIC SUKUN

<0a>	<0>;<0a>;IGNORE;IGNORE	<U0660>	ARABIC-INDIC DIGIT ZERO
<1a>	<1>;<1a>;IGNORE;IGNORE	<U0661>	ARABIC-INDIC DIGIT ONE
<2a>	<2>;<2a>;IGNORE;IGNORE	<U0662>	ARABIC-INDIC DIGIT TWO
<3a>	<3>;<3a>;IGNORE;IGNORE	<U0663>	ARABIC-INDIC DIGIT THREE
<4a>	<4>;<4a>;IGNORE;IGNORE	<U0664>	ARABIC-INDIC DIGIT FOUR
<5a>	<5>;<5a>;IGNORE;IGNORE	<U0665>	ARABIC-INDIC DIGIT FIVE
<6a>	<6>;<6a>;IGNORE;IGNORE	<U0666>	ARABIC-INDIC DIGIT SIX
<7a>	<7>;<7a>;IGNORE;IGNORE	<U0667>	ARABIC-INDIC DIGIT SEVEN
<8a>	<8>;<8a>;IGNORE;IGNORE	<U0668>	ARABIC-INDIC DIGIT EIGHT
<9a>	<9>;<9a>;IGNORE;IGNORE	<U0669>	ARABIC-INDIC DIGIT NINE

<lM->	<l+><aM>;<l+><aM>;<lM-><lM->;IGNORE	<Ufef5>	ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE ISOLATED FORM
<lM.>	<l+><aM>;<l+><aM.>;<lM.><lM.>;IGNORE	<Ufef6>	ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE FINAL FORM
<lH->	<l+><aH>;<l+><aH>;<lH-><lH->;IGNORE	<Ufef7>	ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE ISOLATED FORM
<lH.>	<l+><aH>;<l+><aH.>;<lH.><lH.>;IGNORE	<Ufef8>	ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE FINAL FORM
<lh->	<l+><ah>;<l+><ah>;<lh-><lh->;IGNORE	<Ufef9>	ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW ISOLATED FORM
<lh.>	<l+><ah>;<l+><ah.>;<lh.><lh.>;IGNORE	<Ufefa>	ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW FINAL FORM
<la->	<l+><a+>;<l+><a+->;<la-><la->;IGNORE	<Ufefb>	ARABIC LIGATURE LAM WITH ALEF ISOLATED FORM
<la.>	<l+><a+>;<l+><a+.>;<la.><la.>;IGNORE	<Ufefc>	ARABIC LIGATURE LAM WITH ALEF FINAL FORM

% katakana/hiragana sorting
% base is katakana, as this is present in most charsets
% normal before voiced before semi-voiced
% small vocals before normal vocals
% katakana before hiragana

<a6>	<a6>;<a6>;IGNORE;IGNORE	<U30a1>	KATAKANA LETTER SMALL A
<A5>	<a6>;<A5>;IGNORE;IGNORE	<U3041>	HIRAGANA LETTER SMALL A
<A6>	<a6>;<A6>;IGNORE;IGNORE	<U30a2>	KATAKANA LETTER A
<a5>	<a6>;<a5>;IGNORE;IGNORE	<U3042>	HIRAGANA LETTER A
<i6>	<i6>;<i6>;IGNORE;IGNORE	<U30a3>	KATAKANA LETTER SMALL I
<I5>	<i6>;<I5>;IGNORE;IGNORE	<U3043>	HIRAGANA LETTER SMALL I
<I6>	<i6>;<I6>;IGNORE;IGNORE	<U30a4>	KATAKANA LETTER I
<i5>	<i6>;<i5>;IGNORE;IGNORE	<U3044>	HIRAGANA LETTER I
<u6>	<u6>;<u6>;IGNORE;IGNORE	<U30a5>	KATAKANA LETTER SMALL U
<U5>	<u6>;<U5>;IGNORE;IGNORE	<U3045>	HIRAGANA LETTER SMALL U
<U6>	<u6>;<U6>;IGNORE;IGNORE	<U30a6>	KATAKANA LETTER U
<u5>	<u6>;<u5>;IGNORE;IGNORE	<U3046>	HIRAGANA LETTER U
<Vu>	<u6>;<Vu>;IGNORE;IGNORE	<U30f4>	KATAKANA LETTER VU
<e6>	<e6>;<e6>;IGNORE;IGNORE	<U30a7>	KATAKANA LETTER SMALL E
<E5>	<e6>;<E5>;IGNORE;IGNORE	<U3047>	HIRAGANA LETTER SMALL E
<E6>	<e6>;<E6>;IGNORE;IGNORE	<U30a8>	KATAKANA LETTER E
<e5>	<e6>;<e5>;IGNORE;IGNORE	<U3048>	HIRAGANA LETTER E
<o6>	<o6>;<o6>;IGNORE;IGNORE	<U30a9>	KATAKANA LETTER SMALL O
<O5>	<o6>;<O5>;IGNORE;IGNORE	<U3049>	HIRAGANA LETTER SMALL O
<O6>	<o6>;<O6>;IGNORE;IGNORE	<U30aa>	KATAKANA LETTER O
<o5>	<o6>;<o5>;IGNORE;IGNORE	<U304a>	HIRAGANA LETTER O
<KA>	<KA>;<KA>;IGNORE;IGNORE	<U30f5>	KATAKANA LETTER SMALL KA
<Ka>	<KA>;<Ka>;IGNORE;IGNORE	<U30ab>	KATAKANA LETTER KA
<ka>	<KA>;<ka>;IGNORE;IGNORE	<U304b>	HIRAGANA LETTER KA
<Ga>	<KA>;<Ga>;IGNORE;IGNORE	<U30ac>	KATAKANA LETTER GA
<ga>	<KA>;<ga>;IGNORE;IGNORE	<U304c>	HIRAGANA LETTER GA
<Ki>	<Ki>;<Ki>;IGNORE;IGNORE	<U30ad>	KATAKANA LETTER KI
<ki>	<Ki>;<ki>;IGNORE;IGNORE	<U304d>	HIRAGANA LETTER KI
<Gi>	<Ki>;<Gi>;IGNORE;IGNORE	<U30ae>	KATAKANA LETTER GI
<gi>	<Ki>;<gi>;IGNORE;IGNORE	<U304e>	HIRAGANA LETTER GI
<Ku>	<Ku>;<Ku>;IGNORE;IGNORE	<U30af>	KATAKANA LETTER KU
<ku>	<Ku>;<ku>;IGNORE;IGNORE	<U304f>	HIRAGANA LETTER KU
<Gu>	<Ku>;<Gu>;IGNORE;IGNORE	<U30b0>	KATAKANA LETTER GU
<gu>	<Ku>;<gu>;IGNORE;IGNORE	<U3050>	HIRAGANA LETTER GU
<KE>	<KE>;<KE>;IGNORE;IGNORE	<U30f6>	KATAKANA LETTER SMALL KE
<Ke>	<KE>;<Ke>;IGNORE;IGNORE	<U30b1>	KATAKANA LETTER KE
<ke>	<KE>;<ke>;IGNORE;IGNORE	<U3051>	HIRAGANA LETTER KE
<Ge>	<KE>;<Ge>;IGNORE;IGNORE	<U30b2>	KATAKANA LETTER GE
<ge>	<KE>;<ge>;IGNORE;IGNORE	<U3052>	HIRAGANA LETTER GE
<Ko>	<Ko>;<Ko>;IGNORE;IGNORE	<U30b3>	KATAKANA LETTER KO
<ko>	<Ko>;<ko>;IGNORE;IGNORE	<U3053>	HIRAGANA LETTER KO
<Go>	<Ko>;<Go>;IGNORE;IGNORE	<U30b4>	KATAKANA LETTER GO
<go>	<Ko>;<go>;IGNORE;IGNORE	<U3054>	HIRAGANA LETTER GO
<Sa>	<Sa>;<Sa>;IGNORE;IGNORE	<U30b5>	KATAKANA LETTER SA
<sa>	<Sa>;<sa>;IGNORE;IGNORE	<U3055>	HIRAGANA LETTER SA
<Za>	<Sa>;<Za>;IGNORE;IGNORE	<U30b6>	KATAKANA LETTER ZA
<za>	<Sa>;<za>;IGNORE;IGNORE	<U3056>	HIRAGANA LETTER ZA
<Si>	<Si>;<Si>;IGNORE;IGNORE	<U30b7>	KATAKANA LETTER SI
<si>	<Si>;<si>;IGNORE;IGNORE	<U3057>	HIRAGANA LETTER SI
<Zi>	<Si>;<Zi>;IGNORE;IGNORE	<U30b8>	KATAKANA LETTER ZI
<zi>	<Si>;<zi>;IGNORE;IGNORE	<U3058>	HIRAGANA LETTER ZI
<Su>	<Su>;<Su>;IGNORE;IGNORE	<U30b9>	KATAKANA LETTER SU
<su>	<Su>;<su>;IGNORE;IGNORE	<U3059>	HIRAGANA LETTER SU
<Zu>	<Su>;<Zu>;IGNORE;IGNORE	<U30ba>	KATAKANA LETTER ZU
<zu>	<Su>;<zu>;IGNORE;IGNORE	<U305a>	HIRAGANA LETTER ZU
<Se>	<Se>;<Se>;IGNORE;IGNORE	<U30bb>	KATAKANA LETTER SE
<se>	<Se>;<se>;IGNORE;IGNORE	<U305b>	HIRAGANA LETTER SE
<Ze>	<Se>;<Ze>;IGNORE;IGNORE	<U30bc>	KATAKANA LETTER ZE
<ze>	<Se>;<ze>;IGNORE;IGNORE	<U305c>	HIRAGANA LETTER ZE
<So>	<So>;<So>;IGNORE;IGNORE	<U30bd>	KATAKANA LETTER SO
<so>	<So>;<so>;IGNORE;IGNORE	<U305d>	HIRAGANA LETTER SO
<Zo>	<So>;<Zo>;IGNORE;IGNORE	<U30be>	KATAKANA LETTER ZO
<zo>	<So>;<zo>;IGNORE;IGNORE	<U305e>	HIRAGANA LETTER ZO
<Ta>	<Ta>;<Ta>;IGNORE;IGNORE	<U30bf>	KATAKANA LETTER TA
<ta>	<Ta>;<ta>;IGNORE;IGNORE	<U305f>	HIRAGANA LETTER TA
<Da>	<Ta>;<Da>;IGNORE;IGNORE	<U30c0>	KATAKANA LETTER DA
<da>	<Ta>;<da>;IGNORE;IGNORE	<U3060>	HIRAGANA LETTER DA
<Ti>	<Ti>;<Ti>;IGNORE;IGNORE	<U30c1>	KATAKANA LETTER TI
<ti>	<Ti>;<ti>;IGNORE;IGNORE	<U3061>	HIRAGANA LETTER TI
<Di>	<Ti>;<Di>;IGNORE;IGNORE	<U30c2>	KATAKANA LETTER DI
<di>	<Ti>;<di>;IGNORE;IGNORE	<U3062>	HIRAGANA LETTER DI
<TU>	<TU>;<TU>;IGNORE;IGNORE	<U30c3>	KATAKANA LETTER SMALL TU
<tU>	<TU>;<tU>;IGNORE;IGNORE	<U3063>	HIRAGANA LETTER SMALL TU
<Tu>	<TU>;<Tu>;IGNORE;IGNORE	<U30c4>	KATAKANA LETTER TU
<tu>	<TU>;<tu>;IGNORE;IGNORE	<U3064>	HIRAGANA LETTER TU
<Du>	<TU>;<Du>;IGNORE;IGNORE	<U30c5>	KATAKANA LETTER DU
<du>	<TU>;<du>;IGNORE;IGNORE	<U3065>	HIRAGANA LETTER DU
<Te>	<Te>;<Te>;IGNORE;IGNORE	<U30c6>	KATAKANA LETTER TE
<te>	<Te>;<te>;IGNORE;IGNORE	<U3066>	HIRAGANA LETTER TE
<De>	<Te>;<De>;IGNORE;IGNORE	<U30c7>	KATAKANA LETTER DE
<de>	<Te>;<de>;IGNORE;IGNORE	<U3067>	HIRAGANA LETTER DE
<To>	<To>;<To>;IGNORE;IGNORE	<U30c8>	KATAKANA LETTER TO
<to>	<To>;<to>;IGNORE;IGNORE	<U3068>	HIRAGANA LETTER TO
<Do>	<To>;<Do>;IGNORE;IGNORE	<U30c9>	KATAKANA LETTER DO
<do>	<To>;<do>;IGNORE;IGNORE	<U3069>	HIRAGANA LETTER DO
<Na>	<Na>;<Na>;IGNORE;IGNORE	<U30ca>	KATAKANA LETTER NA
<na>	<Na>;<na>;IGNORE;IGNORE	<U306a>	HIRAGANA LETTER NA
<Ni>	<Ni>;<Ni>;IGNORE;IGNORE	<U30cb>	KATAKANA LETTER NI
<ni>	<Ni>;<ni>;IGNORE;IGNORE	<U306b>	HIRAGANA LETTER NI
<Nu>	<Nu>;<Nu>;IGNORE;IGNORE	<U30cc>	KATAKANA LETTER NU
<nu>	<Nu>;<nu>;IGNORE;IGNORE	<U306c>	HIRAGANA LETTER NU
<Ne>	<Ne>;<Ne>;IGNORE;IGNORE	<U30cd>	KATAKANA LETTER NE
<ne>	<Ne>;<ne>;IGNORE;IGNORE	<U306d>	HIRAGANA LETTER NE
<No>	<No>;<No>;IGNORE;IGNORE	<U30ce>	KATAKANA LETTER NO
<no>	<No>;<no>;IGNORE;IGNORE	<U306e>	HIRAGANA LETTER NO
<Ha>	<Ha>;<Ha>;IGNORE;IGNORE	<U30cf>	KATAKANA LETTER HA
<ha>	<Ha>;<ha>;IGNORE;IGNORE	<U306f>	HIRAGANA LETTER HA
<Ba>	<Ha>;<Ba>;IGNORE;IGNORE	<U30d0>	KATAKANA LETTER BA
<ba>	<Ha>;<ba>;IGNORE;IGNORE	<U3070>	HIRAGANA LETTER BA
<Pa>	<Ha>;<Pa>;IGNORE;IGNORE	<U30d1>	KATAKANA LETTER PA
<pa>	<Ha>;<pa>;IGNORE;IGNORE	<U3071>	HIRAGANA LETTER PA
<Hi>	<Hi>;<Hi>;IGNORE;IGNORE	<U30d2>	KATAKANA LETTER HI
<hi>	<Hi>;<hi>;IGNORE;IGNORE	<U3072>	HIRAGANA LETTER HI
<Bi>	<Hi>;<Bi>;IGNORE;IGNORE	<U30d3>	KATAKANA LETTER BI
<bi>	<Hi>;<bi>;IGNORE;IGNORE	<U3073>	HIRAGANA LETTER BI
<Pi>	<Hi>;<Pi>;IGNORE;IGNORE	<U30d4>	KATAKANA LETTER PI
<pi>	<Hi>;<pi>;IGNORE;IGNORE	<U3074>	HIRAGANA LETTER PI
<Hu>	<Hu>;<Hu>;IGNORE;IGNORE	<U30d5>	KATAKANA LETTER HU
<hu>	<Hu>;<hu>;IGNORE;IGNORE	<U3075>	HIRAGANA LETTER HU
<Bu>	<Hu>;<Bu>;IGNORE;IGNORE	<U30d6>	KATAKANA LETTER BU
<bu>	<Hu>;<bu>;IGNORE;IGNORE	<U3076>	HIRAGANA LETTER BU
<Pu>	<Hu>;<Pu>;IGNORE;IGNORE	<U30d7>	KATAKANA LETTER PU
<pu>	<Hu>;<pu>;IGNORE;IGNORE	<U3077>	HIRAGANA LETTER PU
<He>	<He>;<He>;IGNORE;IGNORE	<U30d8>	KATAKANA LETTER HE
<he>	<He>;<he>;IGNORE;IGNORE	<U3078>	HIRAGANA LETTER HE
<Be>	<He>;<Be>;IGNORE;IGNORE	<U30d9>	KATAKANA LETTER BE
<be>	<He>;<be>;IGNORE;IGNORE	<U3079>	HIRAGANA LETTER BE
<Pe>	<He>;<Pe>;IGNORE;IGNORE	<U30da>	KATAKANA LETTER PE
<pe>	<He>;<pe>;IGNORE;IGNORE	<U307a>	HIRAGANA LETTER PE
<Ho>	<Ho>;<Ho>;IGNORE;IGNORE	<U30db>	KATAKANA LETTER HO
<ho>	<Ho>;<ho>;IGNORE;IGNORE	<U307b>	HIRAGANA LETTER HO
<Bo>	<Ho>;<Bo>;IGNORE;IGNORE	<U30dc>	KATAKANA LETTER BO
<bo>	<Ho>;<bo>;IGNORE;IGNORE	<U307c>	HIRAGANA LETTER BO
<Po>	<Ho>;<Po>;IGNORE;IGNORE	<U30dd>	KATAKANA LETTER PO
<po>	<Ho>;<po>;IGNORE;IGNORE	<U307d>	HIRAGANA LETTER PO
<Ma>	<Ma>;<Ma>;IGNORE;IGNORE	<U30de>	KATAKANA LETTER MA
<ma>	<Ma>;<ma>;IGNORE;IGNORE	<U307e>	HIRAGANA LETTER MA
<Mi>	<Mi>;<Mi>;IGNORE;IGNORE	<U30df>	KATAKANA LETTER MI
<mi>	<Mi>;<mi>;IGNORE;IGNORE	<U307f>	HIRAGANA LETTER MI
<Mu>	<Mu>;<Mu>;IGNORE;IGNORE	<U30e0>	KATAKANA LETTER MU
<mu>	<Mu>;<mu>;IGNORE;IGNORE	<U3080>	HIRAGANA LETTER MU
<Me>	<Me>;<Me>;IGNORE;IGNORE	<U30e1>	KATAKANA LETTER ME
<me>	<Me>;<me>;IGNORE;IGNORE	<U3081>	HIRAGANA LETTER ME
<Mo>	<Mo>;<Mo>;IGNORE;IGNORE	<U30e2>	KATAKANA LETTER MO
<mo>	<Mo>;<mo>;IGNORE;IGNORE	<U3082>	HIRAGANA LETTER MO
<YA>	<YA>;<YA>;IGNORE;IGNORE	<U30e3>	KATAKANA LETTER SMALL YA
<yA>	<YA>;<yA>;IGNORE;IGNORE	<U3083>	HIRAGANA LETTER SMALL YA
<Ya>	<YA>;<Ya>;IGNORE;IGNORE	<U30e4>	KATAKANA LETTER YA
<ya>	<YA>;<ya>;IGNORE;IGNORE	<U3084>	HIRAGANA LETTER YA
<YU>	<YU>;<YU>;IGNORE;IGNORE	<U30e5>	KATAKANA LETTER SMALL YU
<yU>	<YU>;<yU>;IGNORE;IGNORE	<U3085>	HIRAGANA LETTER SMALL YU
<Yu>	<YU>;<Yu>;IGNORE;IGNORE	<U30e6>	KATAKANA LETTER YU
<yu>	<YU>;<yu>;IGNORE;IGNORE	<U3086>	HIRAGANA LETTER YU
<YO>	<YO>;<YO>;IGNORE;IGNORE	<U30e7>	KATAKANA LETTER SMALL YO
<yO>	<YO>;<yO>;IGNORE;IGNORE	<U3087>	HIRAGANA LETTER SMALL YO
<Yo>	<YO>;<Yo>;IGNORE;IGNORE	<U30e8>	KATAKANA LETTER YO
<yo>	<YO>;<yo>;IGNORE;IGNORE	<U3088>	HIRAGANA LETTER YO
<Ra>	<Ra>;<Ra>;IGNORE;IGNORE	<U30e9>	KATAKANA LETTER RA
<ra>	<Ra>;<ra>;IGNORE;IGNORE	<U3089>	HIRAGANA LETTER RA
<Ri>	<Ri>;<Ri>;IGNORE;IGNORE	<U30ea>	KATAKANA LETTER RI
<ri>	<Ri>;<ri>;IGNORE;IGNORE	<U308a>	HIRAGANA LETTER RI
<Ru>	<Ru>;<Ru>;IGNORE;IGNORE	<U30eb>	KATAKANA LETTER RU
<ru>	<Ru>;<ru>;IGNORE;IGNORE	<U308b>	HIRAGANA LETTER RU
<Re>	<Re>;<Re>;IGNORE;IGNORE	<U30ec>	KATAKANA LETTER RE
<re>	<Re>;<re>;IGNORE;IGNORE	<U308c>	HIRAGANA LETTER RE
<Ro>	<Ro>;<Ro>;IGNORE;IGNORE	<U30ed>	KATAKANA LETTER RO
<ro>	<Ro>;<ro>;IGNORE;IGNORE	<U308d>	HIRAGANA LETTER RO
<WA>	<WA>;<WA>;IGNORE;IGNORE	<U30ee>	KATAKANA LETTER SMALL WA
<wA>	<WA>;<wA>;IGNORE;IGNORE	<U308e>	HIRAGANA LETTER SMALL WA
<Wa>	<WA>;<Wa>;IGNORE;IGNORE	<U30ef>	KATAKANA LETTER WA
<wa>	<WA>;<wa>;IGNORE;IGNORE	<U308f>	HIRAGANA LETTER WA
<Wi>	<Wi>;<Wi>;IGNORE;IGNORE	<U30f0>	KATAKANA LETTER WI
<wi>	<Wi>;<wi>;IGNORE;IGNORE	<U3090>	HIRAGANA LETTER WI
<We>	<We>;<We>;IGNORE;IGNORE	<U30f1>	KATAKANA LETTER WE
<we>	<We>;<we>;IGNORE;IGNORE	<U3091>	HIRAGANA LETTER WE
<Wo>	<Wo>;<Wo>;IGNORE;IGNORE	<U30f2>	KATAKANA LETTER WO
<wo>	<Wo>;<wo>;IGNORE;IGNORE	<U3092>	HIRAGANA LETTER WO
<N6>	<N6>;<N6>;IGNORE;IGNORE	<U30f3>	KATAKANA LETTER N
<n5>	<N6>;<n5>;IGNORE;IGNORE	<U3093>	HIRAGANA LETTER N

order_end

END LC_COLLATE

LC_CTYPE

digit   <0>;<1>;<2>;<3>;<4>;/
        <5>;<6>;<7>;<8>;<9>

xdigit  <0>;<1>;<2>;<3>;<4>;/
        <5>;<6>;<7>;<8>;<9>;/
        <A>;<B>;<C>;<D>;<E>;<F>;/
        <a>;<b>;<c>;<d>;<e>;<f>

blank   <SP>;<HT>;<NS>

space   <SP>;<LF>;<VT>;<FF>;/
        <CR>;<HT>;<NS>

upper   <A>;<B>;<C>;<D>;<E>;<F>;<G>;/
        <H>;<I>;<J>;<K>;<L>;<M>;<N>;/
        <O>;<P>;<Q>;<R>;<S>;<T>;<U>;/
        <V>;<W>;<X>;<Y>;<Z>;<A!>;<A'>;/
        <A/>>;<A?>;<A:>;<AA>;<AE>;<C,>;/
        <E!>;<E'>;<E/>>;<E:>;<I!>;<I'>;/
        <I/>>;<I:>;<D->;<N?>;<O!>;<O'>;/
        <O/>>;<O?>;<O:>;<O//>;<U!>;/
        <U'>;<U/>>;<U:>;<Y'>;<TH>;<A->;/
        <A(>;<A;>;<C'>;<C/>>;<C.>;<C<>;/
        <D<>;<D//>;<E->;<E(>;<E.>;<E;>;/
        <E<>;<G/>>;<G(>;<G.>;<G,>;/
        <H/>>;<H//>;<I?>;<I->;<I(>;/
        <I;>;<I.>;<IJ>;<J/>>;<K,>;<L'>;/
        <L,>;<L<>;<L.>;<L//>;<N'>;<N,>;/
        <N<>;<NG>;<O->;<O(>;<O">;<OE>;/
        <R'>;<R,>;<R<>;<S'>;<S/>>;<S,>;/
        <S<>;<T,>;<T<>;<T//>;<U?>;<U->;/
        <U(>;<U0>;<U">;<U;>;<W/>>;/
        <Y/>>;<Y:>;<Z'>;<Z.>;<Z<>;<C2>;/
        <F2>;<K2>;<O9>;<OI>;<U9>;<Z//>;/
        <ED>;<A<>;<I<>;<O<>;<U<>;<U:->;/
        <U:'>;<U:<>;<U:!>;<A1>;<A7>;/
        <A3>;<G//>;<G<>;<K<>;<O;>;<O1>;/
        <EZ>;<G'>;<AA'>;<AE'>;<O//'>;/
        <A!!>;<A)>;<E!!>;<E)>;<I!!>;/
        <I)>;<O!!>;<O)>;<R!!>;<R)>;/
        <U!!>;<U)>;<A%>;<E%>;<Y%>;<I%>;/
        <O%>;<U%>;<W%>;<A*>;<B*>;<G*>;/
        <D*>;<E*>;<Z*>;<Y*>;<H*>;<I*>;/
        <K*>;<L*>;<M*>;<N*>;<C*>;<O*>;/
        <P*>;<R*>;<S*>;<T*>;<U*>;<F*>;/
        <X*>;<Q*>;<W*>;<J*>;<V*>;<IO>;/
        <D%>;<G%>;<IE>;<DS>;<II>;<YI>;/
        <J%>;<LJ>;<NJ>;<Ts>;<KJ>;<V%>;/
        <DZ>;<A=>;<B=>;<V=>;<G=>;<D=>;/
        <E=>;<Z%>;<Z=>;<I=>;<J=>;<K=>;/
        <L=>;<M=>;<N=>;<O=>;<P=>;<R=>;/
        <S=>;<T=>;<U=>;<F=>;<H=>;<C=>;/
        <C%>;<S%>;<Sc>;<=">;<Y=>;<%">;/
        <JE>;<JU>;<JA>;<Y3>;<O3>;<F3>;/
        <V3>;<C3>;<G3>;<A-0>;<B.>;/
        <B-.>;<B_>;<C,'>;<D.>;<D-.>;/
        <D_>;<D,>;<D-/>>;<E-!>;<E-'>;/
        <E-/>>;<E-?>;<E,(>;<F.>;<G->;/
        <H.>;<H-.>;<H:>;<H,>;<H-(>;/
        <I-?>;<I:'>;<K'>;<K-.>;<K_>;/
        <L-.>;<L--.>;<L_>;<L-/>>;<M'>;/
        <M.>;<M-.>;<N.>;<N-.>;<N_>;/
        <N-/>>;<O?'>;<O?:>;<O-!>;<O-'>;/
        <P'>;<P.>;<R.>;<R-.>;<R--.>;/
        <R_>;<S.>;<S-.>;<S'.>;<S<.>;/
        <S.-.>;<T.>;<T-.>;<T_>;<T-/>>;/
        <U--:>;<U-?>;<U-/>>;<U?'>;/
        <U-:>;<V?>;<V-.>;<W!>;<W'>;/
        <W:>;<W.>;<W-.>;<X.>;<X:>;<Y.>;/
        <Z/>>;<Z-.>;<Z_>;<A-.>;<A2>;/
        <A/>'>;<A/>!>;<A/>2>;<A/>?>;/
        <A/>-.>;<A('>;<A(!>;<A(2>;/
        <A(?>;<A(-.>;<E-.>;<E2>;<E?>;/
        <E/>'>;<E/>!>;<E/>2>;<E/>?>;/
        <E/>-.>;<I2>;<I-.>;<O-.>;<O2>;/
        <O/>'>;<O/>!>;<O/>2>;<O/>?>;/
        <O/>-.>;<O9'>;<O9!>;<O92>;/
        <O9?>;<O9-.>;<U-.>;<U2>;<U9'>;/
        <U9!>;<U92>;<U9?>;<U9-.>;<Y!>;/
        <Y-.>;<Y2>;<Y?>;<A-o>;<B-o>;/
        <C-o>;<D-o>;<E-o>;<F-o>;<G-o>;/
        <H-o>;<I-o>;<J-o>;<K-o>;<L-o>;/
        <M-o>;<N-o>;<O-o>;<P-o>;<Q-o>;/
        <R-o>;<S-o>;<T-o>;<U-o>;<V-o>;/
        <W-o>;<X-o>;<Y-o>;<Z-o>

lower   <a>;<b>;<c>;<d>;<e>;<f>;<g>;/
        <h>;<i>;<j>;<k>;<l>;<m>;<n>;/
        <o>;<p>;<q>;<r>;<s>;<t>;<u>;/
        <v>;<w>;<x>;<y>;<z>;<ss>;<a!>;/
        <a'>;<a/>>;<a?>;<a:>;<aa>;<ae>;/
        <c,>;<e!>;<e'>;<e/>>;<e:>;<i!>;/
        <i'>;<i/>>;<i:>;<d->;<n?>;<o!>;/
        <o'>;<o/>>;<o?>;<o:>;<o//>;/
        <u!>;<u'>;<u/>>;<u:>;<y'>;<th>;/
        <y:>;<a->;<a(>;<a;>;<c'>;<c/>>;/
        <c.>;<c<>;<d<>;<d//>;<e->;<e(>;/
        <e.>;<e;>;<e<>;<g/>>;<g(>;<g.>;/
        <g,>;<h/>>;<h//>;<i?>;<i->;/
        <i(>;<i;>;<i.>;<ij>;<j/>>;<k,>;/
        <kk>;<l'>;<l,>;<l<>;<l.>;<l//>;/
        <n'>;<n,>;<n<>;<'n>;<ng>;<o->;/
        <o(>;<o">;<oe>;<r'>;<r,>;<r<>;/
        <s'>;<s/>>;<s,>;<s<>;<t,>;<t<>;/
        <t//>;<u?>;<u->;<u(>;<u0>;<u">;/
        <u;>;<w/>>;<y/>>;<z'>;<z.>;/
        <z<>;<s1>;<c2>;<f2>;<k2>;<o9>;/
        <oi>;<u9>;<z//>;<a<>;<i<>;<o<>;/
        <u<>;<u:->;<u:'>;<u:<>;<u:!>;/
        <a1>;<a7>;<a3>;<g//>;<g<>;<k<>;/
        <o;>;<o1>;<ez>;<g'>;<aa'>;/
        <ae'>;<o//'>;<a!!>;<a)>;<e!!>;/
        <e)>;<i!!>;<i)>;<o!!>;<o)>;/
        <r!!>;<r)>;<u!!>;<u)>;<ed>;/
        <i3>;<a%>;<e%>;<y%>;<i%>;<u3>;/
        <a*>;<b*>;<g*>;<d*>;<e*>;<z*>;/
        <y*>;<h*>;<i*>;<k*>;<l*>;<m*>;/
        <n*>;<c*>;<o*>;<p*>;<r*>;<*s>;/
        <s*>;<t*>;<u*>;<f*>;<x*>;<q*>;/
        <w*>;<j*>;<v*>;<o%>;<u%>;<w%>;/
        <a=>;<b=>;<v=>;<g=>;<d=>;<e=>;/
        <z%>;<z=>;<i=>;<j=>;<k=>;<l=>;/
        <m=>;<n=>;<o=>;<p=>;<r=>;<s=>;/
        <t=>;<u=>;<f=>;<h=>;<c=>;<c%>;/
        <s%>;<sc>;<='>;<y=>;<%'>;<je>;/
        <ju>;<ja>;<io>;<d%>;<g%>;<ie>;/
        <ds>;<ii>;<yi>;<j%>;<lj>;<nj>;/
        <ts>;<kj>;<v%>;<dz>;<y3>;<o3>;/
        <f3>;<v3>;<c3>;<g3>;<a-0>;<b.>;/
        <b-.>;<b_>;<c,'>;<d.>;<d-.>;/
        <d_>;<d,>;<d-/>>;<e-!>;<e-'>;/
        <e-/>>;<e-?>;<e,(>;<f.>;<g->;/
        <h.>;<h-.>;<h:>;<h,>;<h-(>;/
        <i-?>;<i:'>;<k'>;<k-.>;<k_>;/
        <l-.>;<l--.>;<l_>;<l-/>>;<m'>;/
        <m.>;<m-.>;<n.>;<n-.>;<n_>;/
        <n-/>>;<o?'>;<o?:>;<o-!>;<o-'>;/
        <p'>;<p.>;<r.>;<r-.>;<r--.>;/
        <r_>;<s.>;<s-.>;<s'.>;<s<.>;/
        <s.-.>;<t.>;<t-.>;<t_>;<t-/>>;/
        <u--:>;<u-?>;<u-/>>;<u?'>;/
        <u-:>;<v?>;<v-.>;<w!>;<w'>;/
        <w:>;<w.>;<w-.>;<x.>;<x:>;<y.>;/
        <z/>>;<z-.>;<z_>;<a-.>;<a2>;/
        <a/>'>;<a/>!>;<a/>2>;<a/>?>;/
        <a/>-.>;<a('>;<a(!>;<a(2>;/
        <a(?>;<a(-.>;<e-.>;<e2>;<e?>;/
        <e/>'>;<e/>!>;<e/>2>;<e/>?>;/
        <e/>-.>;<i2>;<i-.>;<o-.>;<o2>;/
        <o/>'>;<o/>!>;<o/>2>;<o/>?>;/
        <o/>-.>;<o9'>;<o9!>;<o92>;/
        <o9?>;<o9-.>;<u-.>;<u2>;<u9'>;/
        <u9!>;<u92>;<u9?>;<u9-.>;<y!>;/
        <y-.>;<y2>;<y?>;<nS>;<(a)>;/
        <(b)>;<(c)>;<(d)>;<(e)>;<(f)>;/
        <(g)>;<(h)>;<(i)>;<(j)>;<(k)>;/
        <(l)>;<(m)>;<(n)>;<(o)>;<(p)>;/
        <(q)>;<(r)>;<(s)>;<(t)>;<(u)>;/
        <(v)>;<(w)>;<(x)>;<(y)>;<(z)>;/
        <a-o>;<b-o>;<c-o>;<d-o>;<e-o>;/
        <f-o>;<g-o>;<h-o>;<i-o>;<j-o>;/
        <k-o>;<l-o>;<m-o>;<n-o>;<o-o>;/
        <p-o>;<q-o>;<r-o>;<s-o>;<t-o>;/
        <u-o>;<v-o>;<w-o>;<x-o>;<y-o>;/
        <z-o>;<ff>;<fi>;<fl>;<ffi>;/
        <ffl>;<St>;<st>

alpha   <A>;<B>;<C>;<D>;<E>;<F>;<G>;/
        <H>;<I>;<J>;<K>;<L>;<M>;<N>;/
        <O>;<P>;<Q>;<R>;<S>;<T>;<U>;/
        <V>;<W>;<X>;<Y>;<Z>;<a>;<b>;/
        <c>;<d>;<e>;<f>;<g>;<h>;<i>;/
        <j>;<k>;<l>;<m>;<n>;<o>;<p>;/
        <q>;<r>;<s>;<t>;<u>;<v>;<w>;/
        <x>;<y>;<z>;<-->;<A!>;<A'>;/
        <A/>>;<A?>;<A:>;<AA>;<AE>;<C,>;/
        <E!>;<E'>;<E/>>;<E:>;<I!>;<I'>;/
        <I/>>;<I:>;<D->;<N?>;<O!>;<O'>;/
        <O/>>;<O?>;<O:>;<O//>;<U!>;/
        <U'>;<U/>>;<U:>;<Y'>;<TH>;<ss>;/
        <a!>;<a'>;<a/>>;<a?>;<a:>;<aa>;/
        <ae>;<c,>;<e!>;<e'>;<e/>>;<e:>;/
        <i!>;<i'>;<i/>>;<i:>;<d->;<n?>;/
        <o!>;<o'>;<o/>>;<o?>;<o:>;/
        <o//>;<u!>;<u'>;<u/>>;<u:>;/
        <y'>;<th>;<y:>;<A->;<a->;<A(>;/
        <a(>;<A;>;<a;>;<C'>;<c'>;<C/>>;/
        <c/>>;<C.>;<c.>;<C<>;<c<>;<D<>;/
        <d<>;<D//>;<d//>;<E->;<e->;/
        <E(>;<e(>;<E.>;<e.>;<E;>;<e;>;/
        <E<>;<e<>;<G/>>;<g/>>;<G(>;/
        <g(>;<G.>;<g.>;<G,>;<g,>;<H/>>;/
        <h/>>;<H//>;<h//>;<I?>;<i?>;/
        <I->;<i->;<I(>;<i(>;<I;>;<i;>;/
        <I.>;<i.>;<IJ>;<ij>;<J/>>;/
        <j/>>;<K,>;<k,>;<kk>;<L'>;<l'>;/
        <L,>;<l,>;<L<>;<l<>;<L.>;<l.>;/
        <L//>;<l//>;<N'>;<n'>;<N,>;/
        <n,>;<N<>;<n<>;<'n>;<NG>;<ng>;/
        <O->;<o->;<O(>;<o(>;<O">;<o">;/
        <OE>;<oe>;<R'>;<r'>;<R,>;<r,>;/
        <R<>;<r<>;<S'>;<s'>;<S/>>;/
        <s/>>;<S,>;<s,>;<S<>;<s<>;<T,>;/
        <t,>;<T<>;<t<>;<T//>;<t//>;/
        <U?>;<u?>;<U->;<u->;<U(>;<u(>;/
        <U0>;<u0>;<U">;<u">;<U;>;<u;>;/
        <W/>>;<w/>>;<Y/>>;<y/>>;<Y:>;/
        <Z'>;<z'>;<Z.>;<z.>;<Z<>;<z<>;/
        <s1>;<C2>;<c2>;<F2>;<f2>;<K2>;/
        <k2>;<O9>;<o9>;<OI>;<oi>;<yr>;/
        <U9>;<u9>;<Z//>;<z//>;<ED>;/
        <A<>;<a<>;<I<>;<i<>;<O<>;<o<>;/
        <U<>;<u<>;<U:->;<u:->;<U:'>;/
        <u:'>;<U:<>;<u:<>;<U:!>;<u:!>;/
        <A1>;<a1>;<A7>;<a7>;<A3>;<a3>;/
        <G//>;<g//>;<G<>;<g<>;<K<>;/
        <k<>;<O;>;<o;>;<O1>;<o1>;<EZ>;/
        <ez>;<G'>;<g'>;<AA'>;<aa'>;/
        <AE'>;<ae'>;<O//'>;<o//'>;/
        <A!!>;<a!!>;<A)>;<a)>;<E!!>;/
        <e!!>;<E)>;<e)>;<I!!>;<i!!>;/
        <I)>;<i)>;<O!!>;<o!!>;<O)>;/
        <o)>;<R!!>;<r!!>;<R)>;<r)>;/
        <U!!>;<u!!>;<U)>;<u)>;<ed>;/
        <;S>;<1/>>;<1!>;<A%>;<E%>;<Y%>;/
        <I%>;<O%>;<U%>;<W%>;<i3>;<A*>;/
        <B*>;<G*>;<D*>;<E*>;<Z*>;<Y*>;/
        <H*>;<I*>;<K*>;<L*>;<M*>;<N*>;/
        <C*>;<O*>;<P*>;<R*>;<S*>;<T*>;/
        <U*>;<F*>;<X*>;<Q*>;<W*>;<J*>;/
        <V*>;<a%>;<e%>;<y%>;<i%>;<u3>;/
        <a*>;<b*>;<g*>;<d*>;<e*>;<z*>;/
        <y*>;<h*>;<i*>;<k*>;<l*>;<m*>;/
        <n*>;<c*>;<o*>;<p*>;<r*>;<*s>;/
        <s*>;<t*>;<u*>;<f*>;<x*>;<q*>;/
        <w*>;<j*>;<v*>;<o%>;<u%>;<w%>;/
        <IO>;<D%>;<G%>;<IE>;<DS>;<II>;/
        <YI>;<J%>;<LJ>;<NJ>;<Ts>;<KJ>;/
        <V%>;<DZ>;<A=>;<B=>;<V=>;<G=>;/
        <D=>;<E=>;<Z%>;<Z=>;<I=>;<J=>;/
        <K=>;<L=>;<M=>;<N=>;<O=>;<P=>;/
        <R=>;<S=>;<T=>;<U=>;<F=>;<H=>;/
        <C=>;<C%>;<S%>;<Sc>;<=">;<Y=>;/
        <%">;<JE>;<JU>;<JA>;<a=>;<b=>;/
        <v=>;<g=>;<d=>;<e=>;<z%>;<z=>;/
        <i=>;<j=>;<k=>;<l=>;<m=>;<n=>;/
        <o=>;<p=>;<r=>;<s=>;<t=>;<u=>;/
        <f=>;<h=>;<c=>;<c%>;<s%>;<sc>;/
        <='>;<y=>;<%'>;<je>;<ju>;<ja>;/
        <io>;<d%>;<g%>;<ie>;<ds>;<ii>;/
        <yi>;<j%>;<lj>;<nj>;<ts>;<kj>;/
        <v%>;<dz>;<Y3>;<y3>;<O3>;<o3>;/
        <F3>;<f3>;<V3>;<v3>;<C3>;<c3>;/
        <G3>;<g3>;<A+>;<B+>;<G+>;<D+>;/
        <H+>;<W+>;<Z+>;<X+>;<Tj>;<J+>;/
        <K%>;<K+>;<L+>;<M%>;<M+>;<N%>;/
        <N+>;<S+>;<E+>;<P%>;<P+>;<Zj>;/
        <ZJ>;<Q+>;<R+>;<Sh>;<T+>;<H'>;/
        <aM>;<aH>;<wH>;<ah>;<yH>;<a+>;/
        <b+>;<tm>;<t+>;<tk>;<g+>;<hk>;/
        <x+>;<d+>;<dk>;<r+>;<z+>;<s+>;/
        <sn>;<c+>;<dd>;<tj>;<zH>;<e+>;/
        <i+>;<f+>;<q+>;<k+>;<l+>;<m+>;/
        <n+>;<h+>;<w+>;<j+>;<y+>;<aS>;/
        <p+>;<hH>;<tc>;<zj>;<v+>;<gf>;/
        <A-0>;<a-0>;<B.>;<b.>;<B-.>;/
        <b-.>;<B_>;<b_>;<C,'>;<c,'>;/
        <D.>;<d.>;<D-.>;<d-.>;<D_>;/
        <d_>;<D,>;<d,>;<D-/>>;<d-/>>;/
        <E-!>;<e-!>;<E-'>;<e-'>;<E-/>>;/
        <e-/>>;<E-?>;<e-?>;<E,(>;<e,(>;/
        <F.>;<f.>;<G->;<g->;<H.>;<h.>;/
        <H-.>;<h-.>;<H:>;<h:>;<H,>;/
        <h,>;<H-(>;<h-(>;<I-?>;<i-?>;/
        <I:'>;<i:'>;<K'>;<k'>;<K-.>;/
        <k-.>;<K_>;<k_>;<L-.>;<l-.>;/
        <L--.>;<l--.>;<L_>;<l_>;<L-/>>;/
        <l-/>>;<M'>;<m'>;<M.>;<m.>;/
        <M-.>;<m-.>;<N.>;<n.>;<N-.>;/
        <n-.>;<N_>;<n_>;<N-/>>;<n-/>>;/
        <O?'>;<o?'>;<O?:>;<o?:>;<O-!>;/
        <o-!>;<O-'>;<o-'>;<P'>;<p'>;/
        <P.>;<p.>;<R.>;<r.>;<R-.>;/
        <r-.>;<R--.>;<r--.>;<R_>;<r_>;/
        <S.>;<s.>;<S-.>;<s-.>;<S'.>;/
        <s'.>;<S<.>;<s<.>;<S.-.>;/
        <s.-.>;<T.>;<t.>;<T-.>;<t-.>;/
        <T_>;<t_>;<T-/>>;<t-/>>;<U--:>;/
        <u--:>;<U-?>;<u-?>;<U-/>>;/
        <u-/>>;<U?'>;<u?'>;<U-:>;<u-:>;/
        <V?>;<v?>;<V-.>;<v-.>;<W!>;/
        <w!>;<W'>;<w'>;<W:>;<w:>;<W.>;/
        <w.>;<W-.>;<w-.>;<X.>;<x.>;/
        <X:>;<x:>;<Y.>;<y.>;<Z/>>;/
        <z/>>;<Z-.>;<z-.>;<Z_>;<z_>;/
        <A-.>;<a-.>;<A2>;<a2>;<A/>'>;/
        <a/>'>;<A/>!>;<a/>!>;<A/>2>;/
        <a/>2>;<A/>?>;<a/>?>;<A/>-.>;/
        <a/>-.>;<A('>;<a('>;<A(!>;/
        <a(!>;<A(2>;<a(2>;<A(?>;<a(?>;/
        <A(-.>;<a(-.>;<E-.>;<e-.>;<E2>;/
        <e2>;<E?>;<e?>;<E/>'>;<e/>'>;/
        <E/>!>;<e/>!>;<E/>2>;<e/>2>;/
        <E/>?>;<e/>?>;<E/>-.>;<e/>-.>;/
        <I2>;<i2>;<I-.>;<i-.>;<O-.>;/
        <o-.>;<O2>;<o2>;<O/>'>;<o/>'>;/
        <O/>!>;<o/>!>;<O/>2>;<o/>2>;/
        <O/>?>;<o/>?>;<O/>-.>;<o/>-.>;/
        <O9'>;<o9'>;<O9!>;<o9!>;<O92>;/
        <o92>;<O9?>;<o9?>;<O9-.>;/
        <o9-.>;<U-.>;<u-.>;<U2>;<u2>;/
        <U9'>;<u9'>;<U9!>;<u9!>;<U92>;/
        <u92>;<U9?>;<u9?>;<U9-.>;/
        <u9-.>;<Y!>;<y!>;<Y-.>;<y-.>;/
        <Y2>;<y2>;<Y?>;<y?>;<nS>;<(a)>;/
        <(b)>;<(c)>;<(d)>;<(e)>;<(f)>;/
        <(g)>;<(h)>;<(i)>;<(j)>;<(k)>;/
        <(l)>;<(m)>;<(n)>;<(o)>;<(p)>;/
        <(q)>;<(r)>;<(s)>;<(t)>;<(u)>;/
        <(v)>;<(w)>;<(x)>;<(y)>;<(z)>;/
        <A-o>;<B-o>;<C-o>;<D-o>;<E-o>;/
        <F-o>;<G-o>;<H-o>;<I-o>;<J-o>;/
        <K-o>;<L-o>;<M-o>;<N-o>;<O-o>;/
        <P-o>;<Q-o>;<R-o>;<S-o>;<T-o>;/
        <U-o>;<V-o>;<W-o>;<X-o>;<Y-o>;/
        <Z-o>;<a-o>;<b-o>;<c-o>;<d-o>;/
        <e-o>;<f-o>;<g-o>;<h-o>;<i-o>;/
        <j-o>;<k-o>;<l-o>;<m-o>;<n-o>;/
        <o-o>;<p-o>;<q-o>;<r-o>;<s-o>;/
        <t-o>;<u-o>;<v-o>;<w-o>;<x-o>;/
        <y-o>;<z-o>;<A5>;<a5>;<I5>;/
        <i5>;<U5>;<u5>;<E5>;<e5>;<O5>;/
        <o5>;<ka>;<ga>;<ki>;<gi>;<ku>;/
        <gu>;<ke>;<ge>;<ko>;<go>;<sa>;/
        <za>;<si>;<zi>;<su>;<zu>;<se>;/
        <ze>;<so>;<zo>;<ta>;<da>;<ti>;/
        <di>;<tU>;<tu>;<du>;<te>;<de>;/
        <to>;<do>;<na>;<ni>;<nu>;<ne>;/
        <no>;<ha>;<ba>;<pa>;<hi>;<bi>;/
        <pi>;<hu>;<bu>;<pu>;<he>;<be>;/
        <pe>;<ho>;<bo>;<po>;<ma>;<mi>;/
        <mu>;<me>;<mo>;<yA>;<ya>;<yU>;/
        <yu>;<yO>;<yo>;<ra>;<ri>;<ru>;/
        <re>;<ro>;<wA>;<wa>;<wi>;<we>;/
        <wo>;<n5>;<vu>;<a6>;<A6>;<i6>;/
        <I6>;<u6>;<U6>;<e6>;<E6>;<o6>;/
        <O6>;<Ka>;<Ga>;<Ki>;<Gi>;<Ku>;/
        <Gu>;<Ke>;<Ge>;<Ko>;<Go>;<Sa>;/
        <Za>;<Si>;<Zi>;<Su>;<Zu>;<Se>;/
        <Ze>;<So>;<Zo>;<Ta>;<Da>;<Ti>;/
        <Di>;<TU>;<Tu>;<Du>;<Te>;<De>;/
        <To>;<Do>;<Na>;<Ni>;<Nu>;<Ne>;/
        <No>;<Ha>;<Ba>;<Pa>;<Hi>;<Bi>;/
        <Pi>;<Hu>;<Bu>;<Pu>;<He>;<Be>;/
        <Pe>;<Ho>;<Bo>;<Po>;<Ma>;<Mi>;/
        <Mu>;<Me>;<Mo>;<YA>;<Ya>;<YU>;/
        <Yu>;<YO>;<Yo>;<Ra>;<Ri>;<Ru>;/
        <Re>;<Ro>;<WA>;<Wa>;<Wi>;<We>;/
        <Wo>;<N6>;<Vu>;<KA>;<KE>;<Va>;/
        <Vi>;<Ve>;<Vo>;<ff>;<fi>;<fl>;/
        <ffi>;<ffl>;<St>;<st>;<aM.>;/
        <aH.>;<ah.>;<a+->;<a+.>;<b+->;/
        <b+.>;<b+,>;<b+;>;<tm->;<tm.>;/
        <t+->;<t+.>;<t+,>;<t+;>;<tk->;/
        <tk.>;<tk,>;<tk;>;<g+->;<g+.>;/
        <g+,>;<g+;>;<hk->;<hk.>;<hk,>;/
        <hk;>;<x+->;<x+.>;<x+,>;<x+;>;/
        <d+->;<d+.>;<dk->;<dk.>;<r+->;/
        <r+.>;<z+->;<z+.>;<s+->;<s+.>;/
        <s+,>;<s+;>;<sn->;<sn.>;<sn,>;/
        <sn;>;<c+->;<c+.>;<c+,>;<c+;>;/
        <dd->;<dd.>;<dd,>;<dd;>;<tj->;/
        <tj.>;<tj,>;<tj;>;<zH->;<zH.>;/
        <zH,>;<zH;>;<e+->;<e+.>;<e+,>;/
        <e+;>;<i+->;<i+.>;<i+,>;<i+;>;/
        <f+->;<f+.>;<f+,>;<f+;>;<q+->;/
        <q+.>;<q+,>;<q+;>;<k+->;<k+.>;/
        <k+,>;<k+;>;<l+->;<l+.>;<l+,>;/
        <l+;>;<m+->;<m+.>;<m+,>;<m+;>;/
        <n+->;<n+.>;<n+,>;<n+;>;<h+->;/
        <h+.>;<h+,>;<h+;>;<w+->;<w+.>;/
        <j+->;<j+.>;<y+->;<y+.>;<y+,>;/
        <y+;>;<lM->;<lM.>;<lH->;<lH.>;/
        <lh->;<lh.>;<la->;<la.>;<a+:>

cntrl   <NU>;<SH>;<SX>;<EX>;<ET>;<EQ>;/
        <AK>;<BL>;<BS>;<HT>;<LF>;<VT>;/
        <FF>;<CR>;<SO>;<SI>;<DL>;<D1>;/
        <D2>;<D3>;<D4>;<NK>;<SY>;<EB>;/
        <CN>;<EM>;<SB>;<EC>;<FS>;<GS>;/
        <RS>;<US>;<DT>;<PA>;<HO>;<BH>;/
        <NH>;<IN>;<NL>;<SA>;<ES>;<HS>;/
        <HJ>;<VS>;<PD>;<PU>;<RI>;<S2>;/
        <S3>;<DC>;<P1>;<P2>;<TS>;<CC>;/
        <MW>;<SG>;<EG>;<SS>;<GC>;<SC>;/
        <CI>;<ST>;<OC>;<PM>;<AC>

punct   <!>;<">;<Nb>;<DO>;<%>;<&>;<'>;/
        <(>;<)>;<*>;<+>;<,>;<->;<.>;/
        <//>;<:>;<;>;<<>;<=>;</>>;<?>;/
        <At>;<<(>;<////>;<)/>>;<'/>>;/
        <_>;<'!>;<(!>;<!!>;<!)>;<'?>;/
        <!I>;<Ct>;<Pd>;<Cu>;<Ye>;<BB>;/
        <SE>;<':>;<Co>;<-a>;<<<>;<NO>;/
        <Rg>;<'m>;<DG>;<+->;<2S>;<3S>;/
        <''>;<My>;<PI>;<.M>;<',>;<1S>;/
        <-o>;</>/>>;<14>;<12>;<34>;/
        <?I>;<*X>;<-:>;<'<>;<'(>;<'.>;/
        <'0>;<';>;<1?>;<'">;<'G>;<,G>;/
        <j3>;<?%>;<'*>;<'%>;<.*>;<b3>;/
        <,+>;<;+>;<?+>;<++>;<:+>;<"+>;/
        <=+>;<//+>;<'+>;<1+>;<3+>;<0+>;/
        <0a>;<1a>;<2a>;<3a>;<4a>;<5a>;/
        <6a>;<7a>;<8a>;<9a>;<,,>;<?*>;/
        <?:>;<,!>;<,'>;<?,>;<;!>;<;'>;/
        <?;>;<!:>;<!*>;<;;>;<1N>;<1M>;/
        <3M>;<4M>;<6M>;<LR>;<RL>;<1T>;/
        <1H>;<-1>;<-N>;<-M>;<-3>;<!2>;/
        <=2>;<'6>;<'9>;<.9>;<9'>;<"6>;/
        <"9>;<:9>;<9">;<//->;<//=>;/
        <Sb>;<..>;<.3>;<%0>;<1'>;<2'>;/
        <3'>;<1">;<2">;<3">;<Ca>;<<1>;/
        </>1>;<:X>;<!*2>;<'->;<0S>;/
        <4S>;<5S>;<6S>;<7S>;<8S>;<9S>;/
        <+S>;<-S>;<=S>;<(S>;<)S>;<0s>;/
        <1s>;<2s>;<3s>;<4s>;<5s>;<6s>;/
        <7s>;<8s>;<9s>;<+s>;<-s>;<=s>;/
        <(s>;<)s>;<Ff>;<Li>;<Pt>;<W=>;/
        <oC>;<co>;<oF>;<N0>;<PO>;<Rx>;/
        <SM>;<TM>;<Om>;<AO>;<13>;<23>;/
        <15>;<25>;<35>;<45>;<16>;<56>;/
        <18>;<38>;<58>;<78>;<1R>;<2R>;/
        <3R>;<4R>;<5R>;<6R>;<7R>;<8R>;/
        <9R>;<aR>;<bR>;<cR>;<50R>;/
        <100R>;<500R>;<1000R>;<1r>;/
        <2r>;<3r>;<4r>;<5r>;<6r>;<7r>;/
        <8r>;<9r>;<ar>;<br>;<cr>;<50r>;/
        <100r>;<500r>;<1000r>;/
        <1000RCD>;<5000R>;<10000R>;/
        <<->;<-!>;<-/>>;<-v>;<</>>;/
        <UD>;<<!!>;</////>>;<!!/>>;/
        <<////>;<UD->;</>V>;<<=>;<=/>>;/
        <==>;<FA>;<dP>;<TE>;<//0>;<DE>;/
        <NB>;<(->;<-)>;<*P>;<+Z>;<-2>;/
        <-+>;<.+>;<//f>;<*->;<Ob>;<sb>;/
        <RT>;<0(>;<00>;<-L>;<-V>;<PP>;/
        <AN>;<OR>;<(U>;<)U>;<In>;<DI>;/
        <Io>;<.:>;<:.>;<:R>;<::>;<?1>;/
        <CG>;<?->;<?=>;<?2>;<=?>;<HI>;/
        <!=>;<=3>;<=<>;</>=>;<<*>;/
        <*/>>;<!<>;<!/>>;<(C>;<)C>;/
        <(_>;<)_>;<0.>;<02>;<-T>;<.P>;/
        <:3>;<Eh>;<<7>;</>7>;<7<>;/
        <7/>>;<NI>;<(A>;<TR>;<Iu>;<Il>;/
        <<//>;<///>>;<Vs>;<1h>;<3h>;/
        <2h>;<4h>;<1j>;<2j>;<3j>;<4j>;/
        <1-o>;<2-o>;<3-o>;<4-o>;<5-o>;/
        <6-o>;<7-o>;<8-o>;<9-o>;<10-o>;/
        <11-o>;<12-o>;<13-o>;<14-o>;/
        <15-o>;<16-o>;<17-o>;<18-o>;/
        <19-o>;<20-o>;<(1)>;<(2)>;/
        <(3)>;<(4)>;<(5)>;<(6)>;<(7)>;/
        <(8)>;<(9)>;<(10)>;<(11)>;/
        <(12)>;<(13)>;<(14)>;<(15)>;/
        <(16)>;<(17)>;<(18)>;<(19)>;/
        <(20)>;<1.>;<2.>;<3.>;<4.>;/
        <5.>;<6.>;<7.>;<8.>;<9.>;<10.>;/
        <11.>;<12.>;<13.>;<14.>;<15.>;/
        <16.>;<17.>;<18.>;<19.>;<20.>;/
        <0-o>;<hh>;<HH>;<vv>;<VV>;<3->;/
        <3_>;<3!>;<3//>;<4->;<4_>;<4!>;/
        <4//>;<dr>;<dR>;<Dr>;<DR>;<dl>;/
        <dL>;<Dl>;<LD>;<ur>;<uR>;<Ur>;/
        <UR>;<ul>;<uL>;<Ul>;<UL>;<vr>;/
        <vR>;<Udr>;<uDr>;<Vr>;<UdR>;/
        <uDR>;<VR>;<vl>;<vL>;<Udl>;/
        <uDl>;<Vl>;<UdL>;<uDL>;<VL>;/
        <dh>;<dLr>;<dlR>;<dH>;<Dh>;/
        <DLr>;<DlR>;<DH>;<uh>;<uLr>;/
        <ulR>;<uH>;<Uh>;<ULr>;<UlR>;/
        <UH>;<vh>;<vLr>;<vlR>;<vH>;/
        <Udh>;<uDh>;<Vh>;<UdLr>;<UdlR>;/
        <uDLr>;<uDlR>;<UdH>;<uDH>;/
        <VLr>;<VlR>;<VH>;<FD>;<BD>;/
        <TB>;<LB>;<FB>;<lB>;<RB>;<.S>;/
        <:S>;<?S>;<fS>;<OS>;<RO>;<Rr>;/
        <RF>;<RY>;<RH>;<RZ>;<RK>;<RX>;/
        <sB>;<SR>;<Or>;<UT>;<uT>;<Tr>;/
        <PR>;<Dt>;<dT>;<Tl>;<PL>;<Db>;/
        <Dw>;<LZ>;<0m>;<0o>;<0M>;<0L>;/
        <0R>;<Sn>;<Ic>;<Fd>;<Bd>;<Ci>;/
        <*2>;<*1>;<TEL>;<tel>;<<H>;/
        </>H>;<0u>;<0U>;<SU>;<Fm>;<Ml>;/
        <cS>;<cH>;<cD>;<cC>;<cS->;/
        <cH->;<cD->;<cC->;<Md>;<M8>;/
        <M2>;<M16>;<Mb>;<Mx>;<MX>;<OK>;/
        <XX>;<-X>;<IS>;<,_>;<._>;<+">;/
        <JIS>;<*_>;<;_>;<0_>;<<+>;/
        </>+>;<<'>;</>'>;<<">;</>">;/
        <(">;<)">;<=T>;<=_>;<('>;<)'>;/
        <(I>;<)I>;<-?>;<=T:)>;<"5>;/
        <05>;<*5>;<+5>;<.6>;<-6>;<*6>;/
        <+6>;<(JU)>;<1c>;<2c>;<3c>;/
        <4c>;<5c>;<6c>;<7c>;<8c>;<9c>;/
        <10c>;<KSC>;<am>;<pm>;<3+;>;/
        <"3>;<"1>;<"!>;<"'>;<"/>>;<"?>;/
        <"->;<"(>;<".>;<":>;<"0>;<",>;/
        <"_>;<"">;<";>;<"<>;<"=>;<"//>;/
        <"p>;<"d>;<"i>;<+_>;<Tel>;<UA>;/
        <UB>

tolower (<A>,<a>);(<A!>,<a!>);/
        (<A!!>,<a!!>);(<A'>,<a'>);/
        (<A(>,<a(>);(<A(!>,<a(!>);/
        (<A('>,<a('>);(<A(-.>,<a(-.>);/
        (<A(2>,<a(2>);(<A(?>,<a(?>);/
        (<A)>,<a)>);(<A->,<a->);/
        (<A-.>,<a-.>);(<A-0>,<a-0>);/
        (<A-o>,<a-o>);(<A1>,<a1>);/
        (<A2>,<a2>);(<A3>,<a3>);/
        (<A7>,<a7>);(<A:>,<a:>);/
        (<A;>,<a;>);(<A<>,<a<>);/
        (<A/>>,<a/>>);(<A/>!>,<a/>!>);/
        (<A/>'>,<a/>'>);/
        (<A/>-.>,<a/>-.>);/
        (<A/>2>,<a/>2>);/
        (<A/>?>,<a/>?>);(<A?>,<a?>);/
        (<AA>,<aa>);(<AA'>,<aa'>);/
        (<AE>,<ae>);(<AE'>,<ae'>);/
        (<B>,<b>);(<B-.>,<b-.>);/
        (<B-o>,<b-o>);(<B.>,<b.>);/
        (<B_>,<b_>);(<C>,<c>);/
        (<C'>,<c'>);(<C,>,<c,>);/
        (<C,'>,<c,'>);(<C-o>,<c-o>);/
        (<C.>,<c.>);(<C2>,<c2>);/
        (<C<>,<c<>);(<C/>>,<c/>>);/
        (<D>,<d>);(<D,>,<d,>);/
        (<D->,<d->);(<D-.>,<d-.>);/
        (<D-/>>,<d-/>>);(<D-o>,<d-o>);/
        (<D.>,<d.>);(<D//>,<d//>);/
        (<D<>,<d<>);(<D_>,<d_>);/
        (<E>,<e>);(<E!>,<e!>);/
        (<E!!>,<e!!>);(<E'>,<e'>);/
        (<E(>,<e(>);(<E)>,<e)>);/
        (<E,(>,<e,(>);(<E->,<e->);/
        (<E-!>,<e-!>);(<E-'>,<e-'>);/
        (<E-.>,<e-.>);(<E-/>>,<e-/>>);/
        (<E-?>,<e-?>);(<E-o>,<e-o>);/
        (<E.>,<e.>);(<E2>,<e2>);/
        (<E:>,<e:>);(<E;>,<e;>);/
        (<E<>,<e<>);(<E/>>,<e/>>);/
        (<E/>!>,<e/>!>);/
        (<E/>'>,<e/>'>);/
        (<E/>-.>,<e/>-.>);/
        (<E/>2>,<e/>2>);/
        (<E/>?>,<e/>?>);(<E?>,<e?>);/
        (<ED>,<ed>);(<EZ>,<ez>);/
        (<F>,<f>);(<F-o>,<f-o>);/
        (<F.>,<f.>);(<F2>,<f2>);/
        (<G>,<g>);(<G'>,<g'>);/
        (<G(>,<g(>);(<G,>,<g,>);/
        (<G->,<g->);(<G-o>,<g-o>);/
        (<G.>,<g.>);(<G//>,<g//>);/
        (<G<>,<g<>);(<G/>>,<g/>>);/
        (<H>,<h>);(<H,>,<h,>);/
        (<H-(>,<h-(>);(<H-.>,<h-.>);/
        (<H-o>,<h-o>);(<H.>,<h.>);/
        (<H//>,<h//>);(<H:>,<h:>);/
        (<H/>>,<h/>>);(<I>,<i>);/
        (<I!>,<i!>);(<I!!>,<i!!>);/
        (<I'>,<i'>);(<I(>,<i(>);/
        (<I)>,<i)>);(<I->,<i->);/
        (<I-.>,<i-.>);(<I-?>,<i-?>);/
        (<I-o>,<i-o>);(<I.>,<i.>);/
        (<I2>,<i2>);(<I:>,<i:>);/
        (<I:'>,<i:'>);(<I;>,<i;>);/
        (<I<>,<i<>);(<I/>>,<i/>>);/
        (<I?>,<i?>);(<IJ>,<ij>);/
        (<J>,<j>);(<J-o>,<j-o>);/
        (<J/>>,<j/>>);(<K>,<k>);/
        (<K'>,<k'>);(<K,>,<k,>);/
        (<K-.>,<k-.>);(<K-o>,<k-o>);/
        (<K2>,<k2>);(<K<>,<k<>);/
        (<K_>,<k_>);(<L>,<l>);/
        (<L'>,<l'>);(<L,>,<l,>);/
        (<L--.>,<l--.>);(<L-.>,<l-.>);/
        (<L-/>>,<l-/>>);(<L-o>,<l-o>);/
        (<L.>,<l.>);(<L//>,<l//>);/
        (<L<>,<l<>);(<L_>,<l_>);/
        (<M>,<m>);(<M'>,<m'>);/
        (<M-.>,<m-.>);(<M-o>,<m-o>);/
        (<M.>,<m.>);(<N>,<n>);/
        (<N'>,<n'>);(<N,>,<n,>);/
        (<N-.>,<n-.>);(<N-/>>,<n-/>>);/
        (<N-o>,<n-o>);(<N.>,<n.>);/
        (<N<>,<n<>);(<N?>,<n?>);/
        (<NG>,<ng>);(<N_>,<n_>);/
        (<O>,<o>);(<O!>,<o!>);/
        (<O!!>,<o!!>);(<O">,<o">);/
        (<O'>,<o'>);(<O(>,<o(>);/
        (<O)>,<o)>);(<O->,<o->);/
        (<O-!>,<o-!>);(<O-'>,<o-'>);/
        (<O-.>,<o-.>);(<O-o>,<o-o>);/
        (<O//>,<o//>);(<O1>,<o1>);/
        (<O2>,<o2>);(<O9>,<o9>);/
        (<O9!>,<o9!>);(<O9'>,<o9'>);/
        (<O9-.>,<o9-.>);(<O92>,<o92>);/
        (<O9?>,<o9?>);(<O:>,<o:>);/
        (<O;>,<o;>);(<O<>,<o<>);/
        (<O/>>,<o/>>);(<O/>!>,<o/>!>);/
        (<O/>'>,<o/>'>);/
        (<O/>-.>,<o/>-.>);/
        (<O/>2>,<o/>2>);/
        (<O/>?>,<o/>?>);(<O?>,<o?>);/
        (<O?'>,<o?'>);(<O?:>,<o?:>);/
        (<OE>,<oe>);(<OI>,<oi>);/
        (<P>,<p>);(<P'>,<p'>);/
        (<P-o>,<p-o>);(<P.>,<p.>);/
        (<Q>,<q>);(<Q-o>,<q-o>);/
        (<R>,<r>);(<R!!>,<r!!>);/
        (<R'>,<r'>);(<R)>,<r)>);/
        (<R,>,<r,>);(<R--.>,<r--.>);/
        (<R-.>,<r-.>);(<R-o>,<r-o>);/
        (<R.>,<r.>);(<R<>,<r<>);/
        (<R_>,<r_>);(<S>,<s>);/
        (<S'>,<s'>);(<S'.>,<s'.>);/
        (<S,>,<s,>);(<S-.>,<s-.>);/
        (<S-o>,<s-o>);(<S.>,<s.>);/
        (<S.-.>,<s.-.>);(<S<>,<s<>);/
        (<S<.>,<s<.>);(<S/>>,<s/>>);/
        (<T>,<t>);(<T,>,<t,>);/
        (<T-.>,<t-.>);(<T-/>>,<t-/>>);/
        (<T-o>,<t-o>);(<T.>,<t.>);/
        (<T//>,<t//>);(<T<>,<t<>);/
        (<TH>,<th>);(<T_>,<t_>);/
        (<U>,<u>);(<U!>,<u!>);/
        (<U!!>,<u!!>);(<U">,<u">);/
        (<U'>,<u'>);(<U(>,<u(>);/
        (<U)>,<u)>);(<U->,<u->);/
        (<U--:>,<u--:>);(<U-.>,<u-.>);/
        (<U-:>,<u-:>);(<U-/>>,<u-/>>);/
        (<U-?>,<u-?>);(<U-o>,<u-o>);/
        (<U0>,<u0>);(<U2>,<u2>);/
        (<U9>,<u9>);(<U9!>,<u9!>);/
        (<U9'>,<u9'>);(<U9-.>,<u9-.>);/
        (<U92>,<u92>);(<U9?>,<u9?>);/
        (<U:>,<u:>);(<U:!>,<u:!>);/
        (<U:'>,<u:'>);(<U:->,<u:->);/
        (<U:<>,<u:<>);(<U;>,<u;>);/
        (<U<>,<u<>);(<U/>>,<u/>>);/
        (<U?>,<u?>);(<U?'>,<u?'>);/
        (<V>,<v>);(<V-.>,<v-.>);/
        (<V-o>,<v-o>);(<V?>,<v?>);/
        (<W>,<w>);(<W!>,<w!>);/
        (<W'>,<w'>);(<W-.>,<w-.>);/
        (<W-o>,<w-o>);(<W.>,<w.>);/
        (<W:>,<w:>);(<W/>>,<w/>>);/
        (<X>,<x>);(<X-o>,<x-o>);/
        (<X.>,<x.>);(<X:>,<x:>);/
        (<Y>,<y>);(<Y!>,<y!>);/
        (<Y'>,<y'>);(<Y-.>,<y-.>);/
        (<Y-o>,<y-o>);(<Y.>,<y.>);/
        (<Y2>,<y2>);(<Y/>>,<y/>>);/
        (<Y?>,<y?>);(<Z>,<z>);/
        (<Z'>,<z'>);(<Z-.>,<z-.>);/
        (<Z-o>,<z-o>);(<Z.>,<z.>);/
        (<Z//>,<z//>);(<Z<>,<z<>);/
        (<Z/>>,<z/>>);(<Z_>,<z_>);/
        (<A%>,<a%>);(<A*>,<a*>);/
        (<B*>,<b*>);(<C*>,<c*>);/
        (<D*>,<d*>);(<E%>,<e%>);/
        (<E*>,<e*>);(<F*>,<f*>);/
        (<G*>,<g*>);(<H*>,<h*>);/
        (<I%>,<i%>);(<I*>,<i*>);/
        (<J*>,<j*>);(<K*>,<k*>);/
        (<L*>,<l*>);(<M*>,<m*>);/
        (<N*>,<n*>);(<O%>,<o%>);/
        (<O*>,<o*>);(<P*>,<p*>);/
        (<Q*>,<q*>);(<R*>,<r*>);/
        (<S*>,<s*>);(<T*>,<t*>);/
        (<U%>,<u%>);(<U*>,<u*>);/
        (<V*>,<v*>);(<W%>,<w%>);/
        (<W*>,<w*>);(<X*>,<x*>);/
        (<Y%>,<y%>);(<Y*>,<y*>);/
        (<Z*>,<z*>);(<%">,<%'>);/
        (<=">,<='>);(<A=>,<a=>);/
        (<B=>,<b=>);(<C%>,<c%>);/
        (<C3>,<c3>);(<C=>,<c=>);/
        (<D%>,<d%>);(<D=>,<d=>);/
        (<DS>,<ds>);(<DZ>,<dz>);/
        (<E=>,<e=>);(<F3>,<f3>);/
        (<F=>,<f=>);(<G%>,<g%>);/
        (<G3>,<g3>);(<G=>,<g=>);/
        (<H=>,<h=>);(<I=>,<i=>);/
        (<IE>,<ie>);(<II>,<ii>);/
        (<IO>,<io>);(<J%>,<j%>);/
        (<J=>,<j=>);(<JA>,<ja>);/
        (<JE>,<je>);(<JU>,<ju>);/
        (<K=>,<k=>);(<KJ>,<kj>);/
        (<L=>,<l=>);(<LJ>,<lj>);/
        (<M=>,<m=>);(<N=>,<n=>);/
        (<NJ>,<nj>);(<O3>,<o3>);/
        (<O=>,<o=>);(<P=>,<p=>);/
        (<R=>,<r=>);(<S%>,<s%>);/
        (<S=>,<s=>);(<Sc>,<sc>);/
        (<T=>,<t=>);(<Ts>,<ts>);/
        (<U=>,<u=>);(<V3>,<v3>);/
        (<V=>,<v=>);(<Y3>,<y3>);/
        (<Y=>,<y=>);(<YI>,<yi>);/
        (<Z%>,<z%>);(<Z=>,<z=>)

toupper (<a>,<A>);(<a!>,<A!>);/
        (<a!!>,<A!!>);(<a'>,<A'>);/
        (<a(>,<A(>);(<a(!>,<A(!>);/
        (<a('>,<A('>);(<a(-.>,<A(-.>);/
        (<a(2>,<A(2>);(<a(?>,<A(?>);/
        (<a)>,<A)>);(<a->,<A->);/
        (<a-.>,<A-.>);(<a-0>,<A-0>);/
        (<a-o>,<A-o>);(<a1>,<A1>);/
        (<a2>,<A2>);(<a3>,<A3>);/
        (<a7>,<A7>);(<a:>,<A:>);/
        (<a;>,<A;>);(<a<>,<A<>);/
        (<a/>>,<A/>>);(<a/>!>,<A/>!>);/
        (<a/>'>,<A/>'>);/
        (<a/>-.>,<A/>-.>);/
        (<a/>2>,<A/>2>);/
        (<a/>?>,<A/>?>);(<a?>,<A?>);/
        (<aa>,<AA>);(<aa'>,<AA'>);/
        (<ae>,<AE>);(<ae'>,<AE'>);/
        (<b>,<B>);(<b-.>,<B-.>);/
        (<b-o>,<B-o>);(<b.>,<B.>);/
        (<b_>,<B_>);(<c>,<C>);/
        (<c'>,<C'>);(<c,>,<C,>);/
        (<c,'>,<C,'>);(<c-o>,<C-o>);/
        (<c.>,<C.>);(<c2>,<C2>);/
        (<c<>,<C<>);(<c/>>,<C/>>);/
        (<d>,<D>);(<d,>,<D,>);/
        (<d->,<D->);(<d-.>,<D-.>);/
        (<d-/>>,<D-/>>);(<d-o>,<D-o>);/
        (<d.>,<D.>);(<d//>,<D//>);/
        (<d<>,<D<>);(<d_>,<D_>);/
        (<e>,<E>);(<e!>,<E!>);/
        (<e!!>,<E!!>);(<e'>,<E'>);/
        (<e(>,<E(>);(<e)>,<E)>);/
        (<e,(>,<E,(>);(<e->,<E->);/
        (<e-!>,<E-!>);(<e-'>,<E-'>);/
        (<e-.>,<E-.>);(<e-/>>,<E-/>>);/
        (<e-?>,<E-?>);(<e-o>,<E-o>);/
        (<e.>,<E.>);(<e2>,<E2>);/
        (<e:>,<E:>);(<e;>,<E;>);/
        (<e<>,<E<>);(<e/>>,<E/>>);/
        (<e/>!>,<E/>!>);/
        (<e/>'>,<E/>'>);/
        (<e/>-.>,<E/>-.>);/
        (<e/>2>,<E/>2>);/
        (<e/>?>,<E/>?>);(<e?>,<E?>);/
        (<ed>,<ED>);(<ez>,<EZ>);/
        (<f>,<F>);(<f-o>,<F-o>);/
        (<f.>,<F.>);(<f2>,<F2>);/
        (<g>,<G>);(<g'>,<G'>);/
        (<g(>,<G(>);(<g,>,<G,>);/
        (<g->,<G->);(<g-o>,<G-o>);/
        (<g.>,<G.>);(<g//>,<G//>);/
        (<g<>,<G<>);(<g/>>,<G/>>);/
        (<h>,<H>);(<h,>,<H,>);/
        (<h-(>,<H-(>);(<h-.>,<H-.>);/
        (<h-o>,<H-o>);(<h.>,<H.>);/
        (<h//>,<H//>);(<h:>,<H:>);/
        (<h/>>,<H/>>);(<i>,<I>);/
        (<i!>,<I!>);(<i!!>,<I!!>);/
        (<i'>,<I'>);(<i(>,<I(>);/
        (<i)>,<I)>);(<i->,<I->);/
        (<i-.>,<I-.>);(<i-?>,<I-?>);/
        (<i-o>,<I-o>);(<i.>,<I.>);/
        (<i2>,<I2>);(<i:>,<I:>);/
        (<i:'>,<I:'>);(<i;>,<I;>);/
        (<i<>,<I<>);(<i/>>,<I/>>);/
        (<i?>,<I?>);(<ij>,<IJ>);/
        (<j>,<J>);(<j-o>,<J-o>);/
        (<j/>>,<J/>>);(<k>,<K>);/
        (<k'>,<K'>);(<k,>,<K,>);/
        (<k-.>,<K-.>);(<k-o>,<K-o>);/
        (<k2>,<K2>);(<k<>,<K<>);/
        (<k_>,<K_>);(<l>,<L>);/
        (<l'>,<L'>);(<l,>,<L,>);/
        (<l--.>,<L--.>);(<l-.>,<L-.>);/
        (<l-/>>,<L-/>>);(<l-o>,<L-o>);/
        (<l.>,<L.>);(<l//>,<L//>);/
        (<l<>,<L<>);(<l_>,<L_>);/
        (<m>,<M>);(<m'>,<M'>);/
        (<m-.>,<M-.>);(<m-o>,<M-o>);/
        (<m.>,<M.>);(<n>,<N>);/
        (<n'>,<N'>);(<n,>,<N,>);/
        (<n-.>,<N-.>);(<n-/>>,<N-/>>);/
        (<n-o>,<N-o>);(<n.>,<N.>);/
        (<n<>,<N<>);(<n?>,<N?>);/
        (<ng>,<NG>);(<n_>,<N_>);/
        (<o>,<O>);(<o!>,<O!>);/
        (<o!!>,<O!!>);(<o">,<O">);/
        (<o'>,<O'>);(<o(>,<O(>);/
        (<o)>,<O)>);(<o->,<O->);/
        (<o-!>,<O-!>);(<o-'>,<O-'>);/
        (<o-.>,<O-.>);(<o-o>,<O-o>);/
        (<o//>,<O//>);(<o1>,<O1>);/
        (<o2>,<O2>);(<o9>,<O9>);/
        (<o9!>,<O9!>);(<o9'>,<O9'>);/
        (<o9-.>,<O9-.>);(<o92>,<O92>);/
        (<o9?>,<O9?>);(<o:>,<O:>);/
        (<o;>,<O;>);(<o<>,<O<>);/
        (<o/>>,<O/>>);(<o/>!>,<O/>!>);/
        (<o/>'>,<O/>'>);/
        (<o/>-.>,<O/>-.>);/
        (<o/>2>,<O/>2>);/
        (<o/>?>,<O/>?>);(<o?>,<O?>);/
        (<o?'>,<O?'>);(<o?:>,<O?:>);/
        (<oe>,<OE>);(<oi>,<OI>);/
        (<p>,<P>);(<p'>,<P'>);/
        (<p-o>,<P-o>);(<p.>,<P.>);/
        (<q>,<Q>);(<q-o>,<Q-o>);/
        (<r>,<R>);(<r!!>,<R!!>);/
        (<r'>,<R'>);(<r)>,<R)>);/
        (<r,>,<R,>);(<r--.>,<R--.>);/
        (<r-.>,<R-.>);(<r-o>,<R-o>);/
        (<r.>,<R.>);(<r<>,<R<>);/
        (<r_>,<R_>);(<s>,<S>);/
        (<s'>,<S'>);(<s'.>,<S'.>);/
        (<s,>,<S,>);(<s-.>,<S-.>);/
        (<s-o>,<S-o>);(<s.>,<S.>);/
        (<s.-.>,<S.-.>);(<s<>,<S<>);/
        (<s<.>,<S<.>);(<s/>>,<S/>>);/
        (<t>,<T>);(<t,>,<T,>);/
        (<t-.>,<T-.>);(<t-/>>,<T-/>>);/
        (<t-o>,<T-o>);(<t.>,<T.>);/
        (<t//>,<T//>);(<t<>,<T<>);/
        (<th>,<TH>);(<t_>,<T_>);/
        (<u>,<U>);(<u!>,<U!>);/
        (<u!!>,<U!!>);(<u">,<U">);/
        (<u'>,<U'>);(<u(>,<U(>);/
        (<u)>,<U)>);(<u->,<U->);/
        (<u--:>,<U--:>);(<u-.>,<U-.>);/
        (<u-:>,<U-:>);(<u-/>>,<U-/>>);/
        (<u-?>,<U-?>);(<u-o>,<U-o>);/
        (<u0>,<U0>);(<u2>,<U2>);/
        (<u9>,<U9>);(<u9!>,<U9!>);/
        (<u9'>,<U9'>);(<u9-.>,<U9-.>);/
        (<u92>,<U92>);(<u9?>,<U9?>);/
        (<u:>,<U:>);(<u:!>,<U:!>);/
        (<u:'>,<U:'>);(<u:->,<U:->);/
        (<u:<>,<U:<>);(<u;>,<U;>);/
        (<u<>,<U<>);(<u/>>,<U/>>);/
        (<u?>,<U?>);(<u?'>,<U?'>);/
        (<v>,<V>);(<v-.>,<V-.>);/
        (<v-o>,<V-o>);(<v?>,<V?>);/
        (<w>,<W>);(<w!>,<W!>);/
        (<w'>,<W'>);(<w-.>,<W-.>);/
        (<w-o>,<W-o>);(<w.>,<W.>);/
        (<w:>,<W:>);(<w/>>,<W/>>);/
        (<x>,<X>);(<x-o>,<X-o>);/
        (<x.>,<X.>);(<x:>,<X:>);/
        (<y>,<Y>);(<y!>,<Y!>);/
        (<y'>,<Y'>);(<y-.>,<Y-.>);/
        (<y-o>,<Y-o>);(<y.>,<Y.>);/
        (<y2>,<Y2>);(<y/>>,<Y/>>);/
        (<y?>,<Y?>);(<z>,<Z>);/
        (<z'>,<Z'>);(<z-.>,<Z-.>);/
        (<z-o>,<Z-o>);(<z.>,<Z.>);/
        (<z//>,<Z//>);(<z<>,<Z<>);/
        (<z/>>,<Z/>>);(<z_>,<Z_>);/
        (<a%>,<A%>);(<a*>,<A*>);/
        (<b*>,<B*>);(<c*>,<C*>);/
        (<d*>,<D*>);(<e%>,<E%>);/
        (<e*>,<E*>);(<f*>,<F*>);/
        (<g*>,<G*>);(<h*>,<H*>);/
        (<i%>,<I%>);(<i*>,<I*>);/
        (<j*>,<J*>);(<k*>,<K*>);/
        (<l*>,<L*>);(<m*>,<M*>);/
        (<n*>,<N*>);(<o%>,<O%>);/
        (<o*>,<O*>);(<p*>,<P*>);/
        (<q*>,<Q*>);(<r*>,<R*>);/
        (<s*>,<S*>);(<t*>,<T*>);/
        (<u%>,<U%>);(<u*>,<U*>);/
        (<v*>,<V*>);(<w%>,<W%>);/
        (<w*>,<W*>);(<x*>,<X*>);/
        (<y%>,<Y%>);(<y*>,<Y*>);/
        (<z*>,<Z*>);(<%'>,<%">);/
        (<='>,<=">);(<a=>,<A=>);/
        (<b=>,<B=>);(<c%>,<C%>);/
        (<c3>,<C3>);(<c=>,<C=>);/
        (<d%>,<D%>);(<d=>,<D=>);/
        (<ds>,<DS>);(<dz>,<DZ>);/
        (<e=>,<E=>);(<f3>,<F3>);/
        (<f=>,<F=>);(<g%>,<G%>);/
        (<g3>,<G3>);(<g=>,<G=>);/
        (<h=>,<H=>);(<i=>,<I=>);/
        (<ie>,<IE>);(<ii>,<II>);/
        (<io>,<IO>);(<j%>,<J%>);/
        (<j=>,<J=>);(<ja>,<JA>);/
        (<je>,<JE>);(<ju>,<JU>);/
        (<k=>,<K=>);(<kj>,<KJ>);/
        (<l=>,<L=>);(<lj>,<LJ>);/
        (<m=>,<M=>);(<n=>,<N=>);/
        (<nj>,<NJ>);(<o3>,<O3>);/
        (<o=>,<O=>);(<p=>,<P=>);/
        (<r=>,<R=>);(<s%>,<S%>);/
        (<s=>,<S=>);(<sc>,<Sc>);/
        (<t=>,<T=>);(<ts>,<Ts>);/
        (<u=>,<U=>);(<v3>,<V3>);/
        (<v=>,<V=>);(<y3>,<Y3>);/
        (<y=>,<Y=>);(<yi>,<YI>);/
        (<z%>,<Z%>);(<z=>,<Z=>);/
        (<*s>,<S*>)

END LC_CTYPE

LC_MONETARY
int_curr_symbol      "<D><K><K><SP>"
currency_symbol      "<Cu>"
mon_decimal_point    "<,>"
mon_thousands_sep    "<.>"
mon_grouping         3;3
positive_sign        ""
negative_sign        "<->"
int_frac_digits      2
frac_digits          2
p_cs_precedes        1
p_sep_by_space       0
n_cs_precedes        1
n_sep_by_space       0
p_sign_posn          1
n_sign_posn          1
END LC_MONETARY

LC_NUMERIC
decimal_point        "<,>"
thousands_sep        "<.>"
grouping             3;3
END LC_NUMERIC

LC_TIME
abday    "<S><u><n>";"<M><o><n>";/
         "<T><u><e>";"<W><e><d>";/
         "<T><h><u>";"<F><r><i>";/
         "<S><a><t>"
day      "<S><u><n><d><a><y>";/
         "<M><o><n><d><a><y>";/
         "<T><u><e><s><d><a><y>";/
         "<W><e><d><n><e><s><d><a><y>";/
         "<T><h><u><r><s><d><a><y>";/
         "<F><r><i><d><a><y>";/
         "<S><a><t><u><r><d><a><y>"
abmon    "<J><a><n>";"<F><e><b>";/
         "<M><a><r>";"<A><p><r>";/
         "<M><a><y>";"<J><u><n>";/
         "<J><u><l>";"<A><u><g>";/
         "<S><e><p>";"<O><c><t>";/
         "<N><o><v>";"<D><e><c>"
mon      "<J><a><n><u><a><r><y>";/
         "<F><e><b><r><u><a><r><y>";/
         "<M><a><r><c><h>";/
         "<A><p><r><i><l>";/
         "<M><a><y>";/
         "<J><u><n><e>";/
         "<J><u><l><y>";/
         "<A><u><g><u><s><t>";/
         "<S><e><p><t><e><m><b><e><r>";/
         "<O><c><t><o><b><e><r>";/
         "<N><o><v><e><m><b><e><r>";/
         "<D><e><c><e><m><b><e><r>"
% date formats following ISO 8601-1988
d_t_fmt  "<%><Y><-><%><m><-><%><d><T><%><T><SP><%><Z>"
d_fmt    "<%><Y><-><%><m><-><%><d>"
t_fmt    "<%><T>"
am_pm    "";""
t_fmt_ampm  ""
END LC_TIME

LC_MESSAGES
yesexpr  "<'/>><<(><1><J><j><s><S><y><Y><o><O><)/>><.><*>"
noexpr   "<'/>><<(><0><n><N><)/>><.><*>"
END LC_MESSAGES
