/* monkeys.c
 *
 * This spawns multiple simultaneous instances of the FTP Monkey.
 * I use this to load test an FTP server.
 */

#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <stdlib.h>
#include <signal.h>
#include <setjmp.h>

extern char *optarg;
extern int optind;

void
main(int argc, char **argv)
{
	int logfds[128];
	char lname[64];
	char seedstr[32];
	char dstr[32];
	char logstr[64];
	int f, i, n, seed, t;
	time_t now;
	struct tm *ltp;
	int es, status;
	int respawn;
	char *a[24];

	if (argc < 4) {
		fprintf(stderr, "Usage:    ftp_monkeys <#monkeys> <host> <respawn:1/0> [<extra monkey args>]\n");
		fprintf(stderr, "Examples: ftp_monkeys 25 Localhost 0 -a 7200 -R\n");
		fprintf(stderr, "Examples: ftp_monkeys 25 Localhost 1\n");
		fprintf(stderr, "Examples: ftp_monkeys 25 Localhost 1 -D /pub -Q\n");
		exit(1);
	}
	n = atoi(argv[1]);
	respawn = atoi(argv[3]);

	time(&now);
	ltp = localtime(&now);
	strftime(dstr, sizeof(dstr), "%m/%d %H:%M:%S", ltp);

	a[0] = "./ftp_monkey";
	a[1] = "-s";
	a[2] = "0";
	for (i=4; (i<argc) && (i<18); i++)
		a[i-1] = argv[i];
	a[i-1] = argv[2];
	a[i] = NULL;
	for (seed=0; seed<n; seed++) {
		i = seed;
		sprintf(lname, "out.%02d", i);
		logfds[i] = open(lname, O_WRONLY|O_APPEND|O_TRUNC|O_CREAT, 00666);
		sprintf(seedstr, "%d", seed);
		sprintf(logstr, "%s  seed=%d\n", dstr, seed);
		write(logfds[i], logstr, strlen(logstr));
		a[2] = seedstr;
		if ((f = fork()) < 0) {
			perror("fork");
			exit(1);
		} else if (f == 0) {
			/* child */
			close(1);
			close(2);
			dup2(logfds[i], 1);
			dup2(logfds[i], 2);
			execvp(a[0], a);
			perror(a[0]);
			exit(1);
		} else {
			printf("%s  ", dstr);
			for (t=0; a[t] != NULL; t++)
				printf("%s ", a[t]);
			printf("  (pid: %u)\n", f);
			sleep(1);
		}
	}

	while (1) {
		if ((f = wait(&status)) > 0) {
			if (WIFEXITED(status) == 0)
				continue;
			es = WEXITSTATUS(status);

			time(&now);
			ltp = localtime(&now);
			strftime(dstr, sizeof(dstr), "%m/%d %H:%M:%S", ltp);
			fprintf(stdout, "%s  pid=%d exited=%d.\n", dstr, f, es);
			
			if (respawn == 0)
				continue;
			if (es != 0) {
				sleep(3);
			}
			i = seed % n;
			sprintf(seedstr, "%d", seed);

			time(&now);
			ltp = localtime(&now);
			strftime(dstr, sizeof(dstr), "%m/%d %H:%M:%S", ltp);

			sprintf(logstr, "%s  seed=%d\n", dstr, seed);
			write(logfds[i], logstr, strlen(logstr));
			a[2] = seedstr;
			if ((f = fork()) < 0) {
				perror("fork");
				exit(1);
			} else if (f == 0) {
				/* child */
				close(1);
				close(2);
				dup2(logfds[i], 1);
				dup2(logfds[i], 2);
				execvp(a[0], a);
				perror(a[0]);
				exit(1);
			} else {
				printf("%s  ", dstr);
				for (t=0; a[t] != NULL; t++)
					printf("%s ", a[t]);
				printf("  (pid: %u)\n", f);
				++seed;
			}
		} else if ((f < 0) && (respawn == 0) && (errno != EINTR))
			exit(0);	/* all monkeys done */
	}
}
