/* (c) Silvano Maffeis, University of Zurich, Switzerland 1991   */
/* maffeis@ifi.unizh.ch                                          */

#include <stdio.h>

#include <sys/types.h>
#include <sys/errno.h>
#include <sys/user.h>
#include <sys/systm.h>
#include <sys/user.h>
#include <sun/vddrv.h>
#include <sun4c/clock.h>
#include <sun4c/intreg.h>
#include <sun4c/psl.h>

#include "utimer.h"

#define EN_CNTR14_BIT	0x80
#define MINPERIOD		50      /* Min. interrupt-period (usec) */

#define USECS(time) (((time) & CTR_USEC_MASK) >> CTR_USEC_SHIFT)
#define INTR14_ON		*intr |= EN_CNTR14_BIT
#define INTR14_OFF		*intr &= ~EN_CNTR14_BIT

#undef DEBUG
#ifdef DEBUG
#   define PR(string)	printf("%s\n",string);
#else
#   define PR(string)
#endif

int utimer();
int utimer_intr();

/* a trapvec that is basically a branch to the service routine */
 
extern int (*(int_vector[]))();
static int (*original_vector)();
static u_char original_state;

static u_char *intr = INTREG;

static u_int hicounter = 0, ret_hicounter = 0, period = 0;
static short ignore_itr = 0;

/**************************************************************************/

static struct sysent utimer_sysent ={
  3, /* total number of arguments */
  utimer /* handler */
};

static struct vdlsys vd = {
  VDMAGIC_SYS, /* magic number */
  "utimer", /* name */
  0, /* syscall number (filled in automagically) */
  &utimer_sysent /* description of syscall */
};

/**************************************************************************/

xxxinit(function_code, vdp, vdi, vds)
unsigned int function_code;
struct vddrv *vdp;
addr_t vdi;
struct vdstat *vds;
{
    register int s;
    register u_char *intr = INTREG;

    switch(function_code) {

    case VDLOAD: {
        vdp->vdd_vdtab = (struct vdlinkage *) &vd;

        /* save the old vector and install the new one */
        original_vector = int_vector[14];
        original_state = *intr & EN_CNTR14_BIT;
        int_vector[14]=utimer_intr;
        return(0);
        }

    case VDUNLOAD:
        /* disable interrupts while we restore the original state */
        INTR14_OFF;
        int_vector[14]=original_vector;
        if (original_state) INTR14_ON;
        return(0);

    case VDSTAT:
        return(0);

    default:
        return(EIO);
    }
}

extern getpsr();


/*
 * utimer_intr() is invoked whenever counter 14 reaches its limit.
 * In this case, pending interrupts are cleaned, hicounter is incremented
 * and limit14 is newly set.
 */
static utimer_intr(){
  register int s;
  INTR14_OFF;
  /*s=spl7();*/      

  { 
    register struct counterregs *counter = COUNTER;
    register int service = counter->limit14; 
    counter->limit14= period << CTR_USEC_SHIFT;

  }

  PR("This is the interrupt-routine");
  
    if(ignore_itr){
      ignore_itr=0;
      PR("interrupt ignored");
    }
    else{
      hicounter++;
      PR("interrupt accepted");
    }
  
  INTR14_ON;
  /*(void)splx(s);*/
}


int utimer(){
 register struct a { int cmd, period, pid ; } *ca;
 static int u_p_flag; 
 static short swapping_off=0;
 register struct counterregs *counter = COUNTER;
 static u_int hi_counter;
 
 /* disable cntr14 interrupts before doing anything else */
 INTR14_OFF;

 ca= (struct a *) u.u_ap;
 u.u_rval1 = 0;		/* Default return value */
 
 switch(ca->cmd){
      
   case ENQUIRE_LO: /* return the current content of counter14 */
     PR("ENQUIRE_LO");
     INTR14_OFF;
     u.u_rval1 = USECS(counter->counter14);
     ret_hicounter=hicounter;
     INTR14_ON;
     return;

   case ENQUIRE_HI: /* return the current content of hicounter */
     PR("ENQUIRE_HI");
     INTR14_OFF;
     u.u_rval1 = ret_hicounter;
     INTR14_ON;
     return;
     
   case START:       /* reset counter to zero */
     PR("START");
     INTR14_OFF;
     counter->counter14 = 0;
     hicounter = 0;
     ret_hicounter = 0;
     /* finally enable the cntr14 interrupts */
     ignore_itr = 1;
     INTR14_ON;
     
     u.u_rval1 = 1; 
     return;

   case INIT:	    /* set timeout parameters, reset & start */
     PR("INIT\n");
     period= ca->period;

     if (period <= MINPERIOD && period){
       u.u_rval1 = -1; 
       printf("Module %s: error: period below minimum %d\n", 
         vd.Sys_name, MINPERIOD);
       return;
     }

     INTR14_OFF;
     counter->limit14 = period << CTR_USEC_SHIFT;
     counter->counter14 = 0;
     hicounter = 0;
     ret_hicounter = 0;
     
     u.u_rval1 = 1; 
     return;
     
   case NOSWAP:
     u_p_flag=u.u_procp->p_flag;
     u.u_procp->p_flag |= SUANOM | SFAVORD | SULOCK;
     swapping_off=1;
     u.u_rval1 = 1; 
     return; 
     
   case SWAPOK:
     if(!swapping_off)
       u.u_rval1 = -1;
     else{
       u.u_procp->p_flag = u_p_flag;
       swapping_off = 0;
       u.u_rval1 = 1;
     }
     return;
     
   case NICENESS:
      u.u_rval1 = u.u_procp->p_nice;
      u.u_procp->p_nice=ca->period;
      return;
       
   default:
     printf("Module %s: illegal command #: %d\n", vd.Sys_name, ca->cmd);
     u.u_rval1 = -1;
     return;
  }
}

