/* $Copyright:	$
 * Copyright (c) 1991,1992,1993 by Steve Baker
 * All rights reserved
 *  
 * This software is provided as is without any express or implied
 * warranties, including, without limitation, the implied warranties
 * of merchantability and fitness for a particular purpose.
 */
#include "shell.h"
#include <utmp.h>
#include <pwd.h>
#include <sgtty.h>

extern char **PATH;
extern struct proc_tab *proc;
extern int max_ent,_pgrp;
extern char **history;
extern int _maxhist;
extern char *_prompt,*_home,*_mbox, *getenv();
extern char _loginshell, _echo, _verbose, _willecho, _willverbose;
extern char *_term[11];
extern char *_kbuf[MAX_GLVL], _kmax[MAX_GLVL];
extern struct _alias *alias[128];
extern struct custom_keys **keys[MAX_GLVL];
struct _setvar *sets[37], *statvar;
struct sgttyb OTTY;
struct sgttyb STTY;

extern char *gettime();
struct _setvar *makeset(), *makenvar(), *add_var();

extern char buf[1025], path[1025];


init()
{
  int i,j,k;
  char *tmp;
  struct utmp utmp;
  struct passwd *pwd;
  struct _setvar *VAR;

  i = NTTYDISC;
  ioctl(TTY,TIOCSETD,&i);

  for(i=0;i<128;i++) alias[i] = NULL;
  proc = (struct proc_tab *)calloc(10, sizeof(struct proc_tab));
  for(i=0;i<10;i++) proc[i].pid = 0;
  max_ent = 10;
  history = (char **)calloc(_maxhist, sizeof(char *));
  makenvar("history",30);
  makenvar("pid",getpid());
  if (getuid()) makeset("prompt","> ");
  else makeset("prompt","# ");

  _kmax[0] = 0;
  _kbuf[0] = (char *)malloc(1);
  _kbuf[0][0] = 0;

  makeset("cwd",getwd(path));
  statvar = makenvar("status",0);
  statvar->protect = 1;

  pwd = getpwuid(getuid());
  _home = (char*)malloc(strlen(pwd->pw_dir)+1);
  strcpy(_home,pwd->pw_dir);
  makeset("home",_home);

  _pgrp = getpgrp(0);
  
  makeset("tty",tmp = (char *)ttyname(0));
  i = open("/etc/utmp",O_RDONLY);
  while(read(i,&utmp,sizeof(utmp)) > 0) {
    if (!strncmp(utmp.ut_line,tmp+5,8)) {
      if (utmp.ut_host[0]) {
        strncpy(buf,utmp.ut_host,16);
	buf[16] = 0;
        makeset("remotehost",buf);
      }
      break;
    }
  }
  close(i);

  gethostname(buf,&i);
  makeset("host",buf);
  makeset("user",getenv("USER"));
  makenull("insert");
  if (_echo) makenull("echo");
  if (_verbose) makenull("verbose");

  strcpy(path,getenv("PATH"));
  VAR = makeset("path",".");
  PATH = VAR->sv.wrd;
  j = k = 0;
  free(PATH[0]);
  for(i=0;path[i];i++) if (path[i] == ':') k++;
  if (i > 0 && path[i-1] != ':') k++;
  PATH = (char **)realloc(PATH,sizeof(char *) * (k+2));
  k = 0;
  for(i=0;path[i];i++) {
    if (path[i] == ':') {
      buf[k] = 0;
      k = 0;
      PATH[j] = (char *)malloc(strlen(buf)+1);
      strcpy(PATH[j++],buf);
    } else buf[k++] = path[i];
  }
  buf[k] = 0;
  if (k != 0) {
    PATH[j] = (char *)malloc(strlen(buf)+1);
    strcpy(PATH[j++],buf);
  }
  PATH[j] = NULL;
  VAR->nwrds = j;
  VAR->sv.wrd = PATH;
  export(VAR);
}

init_term()
{
  char i;

  for(i=0;i<11;i++) _term[i] = NULL;
  makeset("term",getenv("TERM"));
}

set_term(term)
char *term;
{
  char *area = path, i;
  static char *info[11] = {"so","se","ce","ks","ke","dc","ic","ds","ts","fs",0};

  if (tgetent(buf,term) < 0) return -1;

  for(i=0;info[i];i++) {
    if (_term[i]) free(_term[i]);
    _term[i] = (char *)tgetstr(info[i],&area);
    if (!_term[i]) continue;
    while(isdigit(*_term[i])) _term[i]++;
    _term[i] = (char *)strcpy((char *)malloc(strlen(_term[i])+1),_term[i]);
  }
  _term[HS] = (char *)tgetflag("hs");
  return 0;
}

second_pass()
{
  FILE *fd, *fopen();
  int i;
  char pass[21],tmp[21];

  sprintf(path,"%s/%s",_home,SECOND_PASS);
  if ((fd = fopen(path,"r")) == NULL) return;
  fgets(pass,20,fd);
  fclose(fd);
  pass[20] = 0;
  noecho();
  printf("\nSecondary password: ");
  fgets(tmp,20,stdin);
  echo();
  putchar('\n');
  sprintf(path,"%s/%s",_home,WARNING);

  if (strcmp(pass,tmp)) {
    if ((fd = fopen(path,"a")) == NULL) exit(0);
    chmod(path,0600);
    fprintf(fd,"failed login attempt at %s ",gettime(0));
    fprintf(fd,"%s ",gettime(3));
    fprintf(fd,"%s ",gettime(2));
    fprintf(fd,"%s on %s : %s",gettime(4),ttyname(0),tmp);
    fclose(fd);
    exit(0);
  }

  if ((fd = fopen(path,"r")) == NULL) return;
  for(i=0;fgets(buf,256,fd);i++);
  fprintf(stderr,"\007There have been %d failed login attempts.\n",i);
  fclose(fd);  
}

load_hist()
{
  char l;
  FILE *fd;

  sprintf(path,"%s/%s",_home,HIST_SAVE);
  if ((fd = fopen(path,"r")) == NULL) return -1;
  fgets(buf,256,fd);
  buf[strlen(buf)-1] = 0;
  makenvar("history",atoi(buf));
  while(fgets(buf,256,fd) != NULL) {
    l = strlen(buf) - 1;
    if (buf[l] == '\n') buf[l] = 0;
    add_history(buf);
  }
  fclose(fd);
  return 0;
}
