/* Copyright 1992 by Simmule R. Turner

   Permission is granted to make and distribute VERBATIM copies
   of this software provided the above copyright notice and this
   permission notice are preserved in all copies.

   ALL other rights are reserved.

   NO WARRANTY is provided with this software. */


/*---- START: Input/Output */
extern int read(), write();

#define B_SIZE  100
static char screen_buf[B_SIZE];
static SIZE_T scount=0;

static void bflush()
{   if (scount)
    {   (void) write(2, screen_buf, scount);
        scount = 0;
    }
}

static void bputc(c)
char c;
{   screen_buf[scount++] = c;

    if (scount >= B_SIZE)
        bflush();
}

static void bputs(s)
char *s;
{   while (s && *s)
        bputc(*s++);
}

static int bgetc()
{   char c;


    bflush();
    if (el_pushedchar >= 0)
    {   c = el_pushedchar;
        el_pushedchar = (-1);
    }
    else if (el_stream && *el_stream)
        c = *el_stream++;
    else
        (void) read(0, &c, (SIZE_T)1);

    return (c & 0xFF);
}
/*---- END: Input/Output */

static char *find_word()
{   char *word;
    int dot = el_point;
    SIZE_T len;


    while (dot && !strchr("#;&|^$=`'{}()<>\n\t ", el_line[dot-1]))
        --dot;

    len = el_point - dot + 1;
    if ((word = malloc(len)) == NULL)
        return (NULL);
    else
        (void) memmove(word, &el_line[dot], len);
    word[len-1] = '\0';
    return (word);
}

#define COLUMNS       5
#define PRINT_WIDTH  14
static void columns(argc, argv)
int argc;
char **argv;
{   char name_buf[PRINT_WIDTH+1];
    int i;
    int j;
    SIZE_T len;
    int skip;


    bputs("\r\n");
    skip = argc / COLUMNS + 1;
    for (i=0; i < skip; i++)
    {   for (j=i; j < argc; j += skip)
        {   if ((len = strlen(argv[j])) > PRINT_WIDTH)
                len = PRINT_WIDTH;
            (void) memmove(name_buf, argv[j], len);
            name_buf[len] = '\0';
            bputs(name_buf);
            if ((j + skip) < argc)
                while (len++ < (PRINT_WIDTH+2))
                    bputc(' ');
        }
        bputs("\r\n");
    }
}

static void save_yank(begin, nchars)
int begin;
SIZE_T nchars;
{   if (el_yank)
    {   free(el_yank);
        el_yank = NULL;
    }

    if (nchars < 1)
        return;

    if ((el_yank = malloc(nchars+1)) != NULL)
    {   (void) memmove(el_yank, &el_line[begin], nchars);
        el_yank[nchars] = '\0';
    }
}

static void output_char(c)
char c;
{   if (ISCTL(c) || (c == DEL))
    {   bputc('^');
        bputc(ISCTL(c) ? (c | 0x40): '?');
    }
    else
        bputc(c);
}

static void print_string(str)
char *str;
{   char *p;


    for (p=str; p && *p; ++p)
        output_char(*p);
}

static void reposition_dot()
{   int i;


    bputc('\r');
    bputs(el_prompt);
    for (i=0; i<el_point; i++)
        output_char(el_line[i]);
}

static void left(change_point)
int change_point;
{   if (el_point && ISCTL(el_line[el_point-1]))
        bputc('\b');

    bputc('\b');
    if (change_point == REPOSITION)
        --el_point;
}

static void right(change_point)
int change_point;
{   output_char(el_line[el_point]);
    if (change_point == REPOSITION)
        ++el_point;
}

static int do_macro(c)
int c;
{   char name[4]; 


    (void) memmove(name, "_?_", (SIZE_T) 4);
    name[1] = c;

    if ((el_stream = getenv(name)) != NULL)
        return (DONTMOVE);
    else
        return (ring_bell());
}

static int do_forward(move)
int move;
{   int i = 0;


    do
    {   while (el_point < el_end &&
               (el_line[el_point] == ' ' || !isalnum(el_line[el_point])))
        {   if (move == REPOSITION)
                right(DONTMOVE);
            ++el_point;
        }

        while (el_point < el_end && isalnum(el_line[el_point]))
        {   if (move == REPOSITION)
                right(DONTMOVE);
            ++el_point;
        }

        if (el_point == el_end)
            break;
    }   while (++i < el_arg);

    return (DONTMOVE);
}

static int do_case(type)
int type;
{   (void) do_forward(DONTMOVE);
    if (el_oldpoint != el_point)
    {   int nchars = el_point - el_oldpoint;


        el_point = el_oldpoint;
        return (case_string(nchars, type));
    }
    return (DONTMOVE);
}

#ifdef ANSI_ARROWS
static int arrow(c)
int c;
{   if (c == '[')
    {   GET(c);
        switch(c)
        {   case 'A':
            case 'B':
            case 'C':
            case 'D':
                return (e_map[CTL("PNFB"[(c - 'A')])].function());
            default:
                return (ring_bell());
        }
    }
    return (-1);
}
#endif

static void ceol()
{   int ctl_chars = 0;
    int i;


    for (i=el_point; i<=el_end; i++)
    {   bputc(' ');
        if (ISCTL(el_line[i]))
        {   bputc(' ');
            ++ctl_chars;
        }
    }

    i += ctl_chars;
    for (; i>el_point; i--)
        bputc('\b');
}

static int do_history(func)
char *(*func)();
{   char *line;
    int i = 0;


    do
    {   if ((line = (*func)()) == NULL)
            break;
    }   while (++i < el_arg);

    return (do_insert_history(line));
}

static int do_insert_history(line)
char *line;
{   if (line && *line)
    {   el_point = 0;
        reposition_dot();
        ceol();
        el_end = 0;
        return (insert_string(line));
    }
    return (ring_bell());
}

static void clear_line()
{   el_point = -strlen(el_prompt);
    bputc('\r');
    ceol();
    el_point = 0;
    el_end = 0;
    el_line[0] = '\0';
}

static int case_string(nchars, type)
int nchars;
int type;
{   int i;
    int end = el_point + nchars;


    for (i=el_point; i<end && i<el_end; i++)
    {   el_line[i] = (type == TO_UPPER) ? UPPER(el_line[i]): LOWER(el_line[i]);
        right(REPOSITION);
    }
    return (DONTMOVE);
}

static int mkargv(line, argv)
char *line, ***argv;
{   char *c = line;
    char **p;
    int argc = 0;
    int inc = MEM_INC;


    if ((*argv = p = malloc(inc * sizeof(char **))) == NULL)
        return (0);

    while (isspace(*c))
        ++c;

    if ((*c == '\n') || (*c == '\0'))
        return (0);

    p[argc++] = c;

    while ((*c != '\n') && *c)
    {   if (isspace(*c))
        {   *c++ = '\0';
            if ((*c != '\n') && *c)
            {   if ((argc + 1) == inc)
                {   char  **t = malloc((inc + MEM_INC) * sizeof(char **));


                    if (t == NULL)
                    {   p[argc] = NULL;
                        return (argc);
                    }
                    else
                    {   (void) memmove(t, p, inc * sizeof(char **));
                        inc += MEM_INC;
                        free(p);
                        *argv = p = t;
                    }
                }
                p[argc++] = c;
            }
        }
        else
            ++c;
    }
    *c = '\0';
    p[argc] = NULL;
    return (argc);
}

/*---- START: Operating System Dependent */
static int el_eofc;
static int el_erasec;
static int el_interruptc;
static int el_killc;
static int el_quitc;

static int SpecialCharacter(c)
int c;
{   if ((c == el_erasec) || (c == DEL))
        return (e_map[CTL('H')].function());
    else if (c == el_killc)
    {   if (el_point != 0)
        {   el_point = 0;
            reposition_dot();
        }

        el_arg = NO_ARG;
        return (kill_line());
    }
    else if (c == el_interruptc || c == el_quitc)
    {   el_point = el_end = 0;
        el_line[0] = '\0';
        return (redisplay_line());
    }
    else if (c == el_eofc && !el_point && !el_end)
        return (GOT_EOF);
        
    return (NOT_SPECIAL);
}

#ifdef _POSIX_SOURCE
#include <termios.h>
static struct termios original;


static void SetupTerminal()
{   struct termios new;


    (void) tcgetattr(0, &original);
    (void) tcgetattr(0, &new);

    el_erasec = original.c_cc[VERASE];
    el_killc = original.c_cc[VKILL];
    el_eofc = original.c_cc[VEOF];
    el_interruptc = original.c_cc[VINTR];
    el_quitc = original.c_cc[VQUIT];

    new.c_cc[VINTR] = (-1);
    new.c_cc[VQUIT] = (-1);

    new.c_lflag &= ~(ECHO|ICANON);
    new.c_cc[VMIN] = 1;
    new.c_cc[VTIME] = 0;
    (void) tcsetattr(0, TCSANOW, &new);
}

static void ResetTerminal()
{   (void) tcsetattr(0, TCSANOW, &original);
}
#else
#include <sgtty.h>
static struct sgttyb orig_sgttyb;
static struct tchars orig_tchars;


static void SetupTerminal()
{   struct sgttyb new_sgttyb;
    struct tchars new_tchars;


    ioctl(0, TIOCGETP, &orig_sgttyb);
    ioctl(0, TIOCGETP, &new_sgttyb);

    el_erasec = orig_sgttyb.sg_erase;
    el_killc = orig_sgttyb.sg_kill;

    ioctl(0, TIOCGETC, &orig_tchars);
    ioctl(0, TIOCGETC, &new_tchars);
    el_eofc = orig_tchars.t_eofc;
    el_interruptc = orig_tchars.t_intrc;
    el_quitc = orig_tchars.t_quitc;

    new_tchars.t_intrc = (-1);
    new_tchars.t_quitc = (-1);

    new_sgttyb.sg_flags &= ~ECHO;
    new_sgttyb.sg_flags |= RAW;
    ioctl(0, TIOCSETP, &new_sgttyb);
    ioctl(0, TIOCSETC, &new_tchars);
}

static void ResetTerminal()
{   ioctl(0, TIOCSETP, &orig_sgttyb);
    ioctl(0, TIOCSETC, &orig_tchars);
}
#endif
