/* Copyright 1992 by Simmule R. Turner

   Permission is granted to make and distribute VERBATIM copies
   of this software provided the above copyright notice and this
   permission notice are preserved in all copies.

   ALL other rights are reserved.

   NO WARRANTY is provided with this software. */


#include "readline.h"


void *memmove(d, s, n)
void *d;
CONST void *s;
SIZE_T n;
{   char *ds = d;
    CONST char *ss = s;


    if (n <= 0)
        ;
    else if (ds < ss)
    {   do
            *ds++ = *ss++;
        while (--n > 0);
    }
    else if (ds > ss)
    {   ds += n;
        ss += n;
        do
            *--ds = *--ss;
        while (--n > 0);
    }
    return (d);
}

