/* Copyright 1992 by Simmule R. Turner

   Permission is granted to make and distribute VERBATIM copies
   of this software provided the above copyright notice and this
   permission notice are preserved in all copies.

   ALL other rights are reserved.

   NO WARRANTY is provided with this software. */


#include <stdio.h>
#ifndef NOSTDLIB
#include <stdlib.h>
#else
extern char *getenv();
#endif
#include <string.h>
#include <ctype.h>


/* Make long identifiers unique within first six characters */
#define backward_char         bkw_char
#define backward_delete_char  bkw_del_char
#define backward_kill_word    bkw_kill_word
#define backward_word         bkw_word
#define delete_char           del_char
#define forward_char          fwd_char
#define forward_word          fwd_word


#define SCREEN_WIDTH          80
#define MEM_INC               64

#define DONTMOVE               0
#define REPOSITION             1
#define GOT_LINE               2
#define GOT_EOF                3
#define NOT_SPECIAL            4

#define TO_LOWER               0
#define TO_UPPER               1

#define CTL(x)                 ((x)-64)
#define DEL                    127

#define NO_ARG                 (-1)

#define ISCTL(x)               ((x) && ((x) < ' '))
#define LOWER(x)               (isupper((x)) ? tolower((x)): (x))
#define UPPER(x)               (islower((x)) ? toupper((x)): (x))

/* I/O */
#define GET(c)                 (c = bgetc())
#define UNGET(c)               (el_pushedchar = (c))


#ifdef __STDC__
# define P(s) s
#else
# define P(s) ()
#endif


typedef struct
{   char key_code;
    int (*function) P((void));
}   KEYMAP;


/* editline.c */
static char *editinput P((void ));
static int emacs P((int c ));
static int self_insert_command P((int c ));
static int beginning_of_line P((void ));
static int backward_char P((void ));
static int up_letter P((void ));
static int delete_char P((void ));
static int end_of_line P((void ));
static int forward_char P((void ));
static int backward_delete_char P((void ));
static int c_complete P((void ));
static int accept_line P((void ));
static int kill_line P((void ));
static int redisplay_line P((void ));
static int h_next P((void ));
static int h_previous P((void ));
static int h_search P((void ));
static int transpose_chars P((void ));
static int quote P((void ));
static int wipe P((void ));
static int exchange_mark P((void ));
static int yank P((void ));
static int meta P((void ));
static int move_to_char P((void ));
static int backward_kill_word P((void ));
static int set_mark P((void ));
static int last_argument P((void ));
static int h_old P((void ));
static int h_new P((void ));
static int c_list_possible P((void ));
static int backward_word P((void ));
static int kill_word P((void ));
static int forward_word P((void ));
static int case_down_word P((void ));
static int case_up_word P((void ));
static int version P((void ));
static int push_region P((void ));
static int ring_bell P((void ));
static int insert_string P((char *str ));
static int delete_string P((int nchars ));

/* support.c */
static void bflush P((void ));
static void bputc P((int c ));
static void bputs P((char *s ));
static int bgetc P((void ));
static char *find_word P((void ));
static void columns P((int argc , char **argv ));
static void save_yank P((int begin , SIZE_T nchars ));
static void output_char P((int c ));
static void print_string P((char *str ));
static void reposition_dot P((void ));
static void left P((int change_point ));
static void right P((int change_point ));
static int do_macro P((int c ));
static int do_forward P((int move ));
static int do_case P((int type ));
#ifdef ANSI_ARROWS
static int arrow P((int c ));
#endif
static void ceol P((void ));
static int do_history P((char *(*func)(void) ));
static int do_insert_history P((char *line ));
static void clear_line P((void ));
static int case_string P((int nchars , int type ));
static int mkargv P((char *line , char ***argv ));
static int SpecialCharacter P((int c ));
static void SetupTerminal P((void ));
static void ResetTerminal P((void ));
#undef P


/* Keymap for emacs-mode */
static KEYMAP e_map[] =
  {{CTL('@'), ring_bell},
   {CTL('A'), beginning_of_line},
   {CTL('B'), backward_char},
   {CTL('C'), up_letter},
   {CTL('D'), delete_char},
   {CTL('E'), end_of_line},
   {CTL('F'), forward_char},
   {CTL('G'), ring_bell},
   {CTL('H'), backward_delete_char},
   {CTL('I'), c_complete},
   {CTL('J'), accept_line},
   {CTL('K'), kill_line},
   {CTL('L'), redisplay_line},
   {CTL('M'), accept_line},
   {CTL('N'), h_next},
   {CTL('O'), ring_bell},
   {CTL('P'), h_previous},
   {CTL('Q'), ring_bell},
   {CTL('R'), h_search},
   {CTL('S'), ring_bell},
   {CTL('T'), transpose_chars},
   {CTL('U'), ring_bell},
   {CTL('V'), quote},
   {CTL('W'), wipe},
   {CTL('X'), exchange_mark},
   {CTL('Y'), yank},
   {CTL('Z'), ring_bell},
   {CTL('['), meta},
   {0x1c    , ring_bell},
   {CTL(']'), move_to_char},
   {CTL('^'), ring_bell},
   {CTL('_'), ring_bell},
   {0       , 0}};


static KEYMAP meta_map[] =
  {{CTL('H'), backward_kill_word},
   {' '     , set_mark},
   {'.'     , last_argument},
   {'<'     , h_old},
   {'>'     , h_new},
   {'?'     , c_list_possible},
   {'b'     , backward_word},
   {'d'     , kill_word},
   {'f'     , forward_word},
   {'l'     , case_down_word},
   {'u'     , case_up_word},
   {'v'     , version},
   {'w'     , push_region},
   {DEL     , backward_kill_word},
   {0,        0}};


static char *el_line = NULL;
static char *el_prompt;
static char *el_stream = NULL;
static char *el_yank = NULL;
static int el_arg;
static int el_end;
static SIZE_T el_length;
static int el_mark;
static int el_oldpoint;
static int el_point;
static int el_pushedchar = (-1);
