/* Copyright 1992 by Simmule R. Turner

   Permission is granted to make and distribute VERBATIM copies
   of this software provided the above copyright notice and this
   permission notice are preserved in all copies.

   ALL other rights are reserved.

   NO WARRANTY is provided with this software. */


#include "readline.h"
#include "complete.h"


char *complete(pathname, unique)
char *pathname;
int *unique;
{   char **argp;
    char *dir;
    char *file;
    char *str = NULL;
    SIZE_T argc;
    SIZE_T i;
    SIZE_T j;
    SIZE_T len;


    if (xsplit(pathname, &dir, &file) < 0)
        return (NULL);

    if ((argc = xfind_names(dir, file, &argp)) == 0)
    {   free(dir);
        free(file);
        return (NULL);
    }

    len = strlen(file);
    if (argc == 1)
    {   if ((str = malloc(j = strlen(argp[0]) - len + 2)) != NULL)
        {   char *pathtest;


            (void) memmove(str, argp[0] + len, j);

            if ((pathtest = malloc(strlen(dir) + strlen(argp[0]) + 2)) != NULL)
            {   struct stat statbuf;


                (void) strcpy(pathtest, dir);
                (void) strcat(pathtest, "/");
                (void) strcat(pathtest, argp[0]);
                if (stat(pathtest, &statbuf) >= 0)
                {   if (S_ISDIR(statbuf.st_mode))
                        (void) strcat(str, "/");
                    else
                        (void) strcat(str, " ");
                }
                free(pathtest);
            }
        }
        *unique = 1;
    }
    else if (len)
    {   for (i=len; i<strlen(argp[0]); ++i)
            for (j=1; j<argc; ++j)
                if (argp[0][i] != argp[j][i])
                    goto lastmatch;

lastmatch:;
        if (i > len)
        {   if ((str = malloc(j = i - len + 1)) != NULL)
            {   (void) memmove(str, argp[0] + len, j);
                str[j-1] = '\0';
            }
        }
        *unique = 0;
    }

    free(dir);
    free(file);
    if (argc)
    {   for (i=0; i<argc; i++)
            free(argp[i]);
        free(argp);
    }
    return (str);
}

int list_possible(pathname, argp)
char *pathname;
char ***argp;
{   char *dir;
    char *file;
    int argc;

    if (xsplit(pathname, &dir, &file) < 0)
        return (0);

    argc = xfind_names(dir, file, argp);
    free(dir);
    free(file);
    return (argc);
}

static int xfind_names(dir, file, argp)
char *dir;
char *file;
char ***argp;
{   char **argv = NULL;
    SIZE_T argc = 0;
    SIZE_T len;
    DIR *dirp;
    struct dirent *entry;


    if ((dirp = opendir(dir)) == NULL)
        return (0);

    len = strlen(file);
    (void) readdir(dirp);
    (void) readdir(dirp);
    while ((entry = readdir(dirp)) != NULL)
    {   if (len)
        {   if (strncmp(entry->d_name, file, len))
                continue;
        }

        if ((argc % MEM_INC) == 0)
        {   char **t = malloc((argc + MEM_INC) * sizeof(char **));


            if (t == NULL)
                break;
            else if (argc)
            {   (void) memmove(t, argv, argc * sizeof(char **));
                free(argv);
            }
            *argp = argv = t;
        }

        if ((argv[argc] = xstrsave(entry->d_name)) == NULL)
        {   if (argc == 0)
                free(argv);
            break;
        }
        ++argc;
     }

     (void) closedir(dirp);
     if (argc)
         (void) qsort(argv, argc, sizeof(char **), xstrcmp);

     return (argc);
}

static char *xstrsave(line)
char *line;
{   SIZE_T len = strlen(line) + 1;
    char *p = malloc(len);


    if (p)
        (void) memmove(p, line, len);

    return (p);
}

static int xstrcmp(a,b)
CONST void *a;
CONST void *b;
{   return (strcmp(*(char **) a, *(char **) b));
}

static int xsplit(path, dirpart, filepart)
char *path;
char **dirpart;
char **filepart;
{   if ((*filepart = strrchr(path, '/')) == NULL)
    {   if ((*dirpart = xstrsave(".")) == NULL)
            return (-1);
        if ((*filepart = xstrsave(path)) == NULL)
        {   free(*dirpart);
            return (-1);
        }
    }
    else
    {   if ((*dirpart = xstrsave(path)) == NULL)
            return (-1);
        *filepart = *filepart + 1;
        *(*dirpart + (*filepart - path)) = '\0';
        if ((*filepart = xstrsave(*filepart)) == NULL)
        {   free(*dirpart);
            return (-1);
        }
    }
    return (0);
}
