/*
 * Decompiled with CFR 0.152.
 */
package cryptix.util.mime;

import cryptix.util.checksum.ChecksumException;
import cryptix.util.checksum.PRZ24;
import java.io.CharConversionException;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Checksum;

public class Base64InputStream
extends FilterInputStream {
    private boolean finished;
    private Checksum crc;
    private int crcLength;
    private byte[] inBuf = new byte[4];
    private byte[] outBuf = new byte[3];
    private int inOff;
    private int outOff;
    private int outBufMax;
    static final int CONV_WHITE = -1;
    static final int CONV_PAD = -2;
    static final int CONV_OTHER = -3;

    public Base64InputStream(InputStream inputStream, boolean bl) {
        super(inputStream);
        this.init(bl ? new PRZ24() : null, 3);
    }

    public Base64InputStream(InputStream inputStream) {
        super(inputStream);
        this.init(null, 0);
    }

    public Base64InputStream(InputStream inputStream, Checksum checksum, int n) {
        super(inputStream);
        checksum.reset();
        this.init(checksum, n);
    }

    public synchronized void close() throws IOException {
        this.finished = true;
        this.outOff = 0;
        super.close();
    }

    public synchronized int read() throws IOException {
        int n;
        if (this.outOff == 0) {
            if (this.finished) {
                return -1;
            }
            n = 0;
            int n2 = -1;
            while (n2 == -1) {
                n = this.in.read();
                if (n < 0) {
                    return -1;
                }
                n2 = this.toNumber(n);
            }
            if (n2 < 0) {
                if (this.crc == null || n2 == -3) {
                    throw new CharConversionException();
                }
                long l = this.crc.getValue();
                long l2 = 0L;
                this.crc = null;
                int n3 = 0;
                while (n3 < this.crcLength) {
                    n = this.read();
                    if (n < 0) {
                        throw new EOFException();
                    }
                    l2 = l2 << 8 | (long)n;
                    ++n3;
                }
                this.finished = true;
                this.outOff = 0;
                if (l2 != l) {
                    throw new ChecksumException();
                }
                return -1;
            }
            int n4 = 0;
            while (n4 < 4) {
                if (n2 == -2) {
                    if (n4 < 2) {
                        throw new CharConversionException();
                    }
                } else {
                    if (n2 < 0) {
                        throw new CharConversionException();
                    }
                    this.inBuf[this.inOff++] = (byte)n2;
                }
                if (n4 != 3) {
                    n = this.in.read();
                    if (n < 0) {
                        throw new EOFException();
                    }
                    n2 = this.toNumber(n);
                }
                ++n4;
            }
            this.writeTriplet();
        }
        n = this.outBuf[this.outOff++] & 0xFF;
        if (this.outOff == this.outBufMax) {
            this.outOff = 0;
        }
        if (this.crc != null) {
            this.crc.update(n);
        }
        return n;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read();
            if (n4 < 0) {
                if (n3 == 0) {
                    return -1;
                }
                return n3;
            }
            byArray[n++] = (byte)n4;
            ++n3;
        }
        return n2;
    }

    public synchronized long skip(long l) throws IOException {
        long l2 = 0L;
        while (l2 < l) {
            if (this.read() < 0) {
                return l2;
            }
            ++l2;
        }
        return l;
    }

    public synchronized int available() throws IOException {
        if (this.outOff == 0) {
            return 0;
        }
        return this.outBufMax - this.outOff;
    }

    public void mark(int n) {
    }

    public void reset() throws IOException {
        throw new IOException("Base64InputStream does not support mark/reset");
    }

    public boolean markSupported() {
        return false;
    }

    private void init(Checksum checksum, int n) {
        if (n < 0 || n > 8) {
            throw new IllegalArgumentException("length < 0 || length > 8");
        }
        this.outBufMax = 3;
        this.outOff = 0;
        this.inOff = 0;
        this.finished = false;
        this.crc = checksum;
        this.crcLength = n;
    }

    private void writeTriplet() {
        this.outBufMax = 0;
        this.outBuf[this.outBufMax++] = (byte)(this.inBuf[0] << 2 | this.inBuf[1] >>> 4);
        if (this.inOff > 2) {
            this.outBuf[this.outBufMax++] = (byte)(this.inBuf[1] << 4 | this.inBuf[2] >>> 2);
        }
        if (this.inOff > 3) {
            this.outBuf[this.outBufMax++] = (byte)(this.inBuf[2] << 6 | this.inBuf[3]);
        }
        this.inOff = 0;
    }

    private int toNumber(int n) {
        if (n >= 97 & n <= 122) {
            return n - 97 + 26;
        }
        if (n >= 65 & n <= 90) {
            return n - 65;
        }
        if (n >= 48 & n <= 57) {
            return n - 48 + 52;
        }
        if (n == 43) {
            return 62;
        }
        if (n == 47) {
            return 63;
        }
        if (n == 61) {
            return -2;
        }
        if (n == 10 || n == 13 || n == 32 || n == 9) {
            return -1;
        }
        return -3;
    }
}

