/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.pgp.FormatException;
import cryptix.pgp.Packet;
import cryptix.pgp.PacketInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;

public class PacketByteArray {
    protected byte[] data;
    protected Vector offsetVector;

    public PacketByteArray(byte[] byArray) throws FormatException {
        this.data = byArray;
        this.parseData();
    }

    public PacketByteArray(PacketInputStream packetInputStream) throws FormatException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = packetInputStream.read();
        while (n != -1) {
            byteArrayOutputStream.write(n);
            n = packetInputStream.read();
        }
        this.data = byteArrayOutputStream.toByteArray();
        this.parseData();
    }

    private void parseData() throws FormatException {
        int n = 0;
        this.offsetVector = new Vector();
        try {
            while (n < this.data.length) {
                byte by;
                if (!Packet.isCTB(by = this.data[n++])) {
                    throw new FormatException("PacketByteArray: Non-CTB found where CTB expected");
                }
                int n2 = Packet.ctbToType(by);
                if (!Packet.isLegalPacketType(n2)) {
                    throw new FormatException("PacketByteArray: Unknown packet type: " + n2);
                }
                int n3 = Packet.ctbToLengthSpecifier(by);
                int n4 = 0;
                switch (n3) {
                    case 2: {
                        n4 <<= 8;
                        n4 += this.data[n++] & 0xFF;
                        n4 <<= 8;
                        n4 += this.data[n++] & 0xFF;
                    }
                    case 1: {
                        n4 <<= 8;
                        n4 += this.data[n++] & 0xFF;
                    }
                    case 0: {
                        n4 <<= 8;
                        n4 += this.data[n++] & 0xFF;
                        break;
                    }
                    case 3: {
                        n4 = this.data.length - n;
                        break;
                    }
                }
                if (n4 < 0) {
                    throw new FormatException("PacketByteArray: Negative packet length");
                }
                this.offsetVector.addElement(new Integer(n += n4));
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new FormatException("PacketByteArray: Unexpected end of data");
        }
    }

    public int numPackets() {
        return this.offsetVector.size();
    }

    private int privatePacketOffset(int n) {
        if (n == 0) {
            return 0;
        }
        Integer n2 = (Integer)this.offsetVector.elementAt(n - 1);
        return n2;
    }

    public int getPacketOffset(int n) {
        if (n < 0 || n >= this.offsetVector.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.privatePacketOffset(n);
    }

    public int getPacketLength(int n) {
        if (n < 0 || n >= this.offsetVector.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.privatePacketOffset(n + 1) - this.privatePacketOffset(n);
    }

    public int getPacketType(int n) {
        if (n < 0 || n >= this.offsetVector.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return Packet.ctbToType(this.data[this.privatePacketOffset(n)]);
    }

    public byte[] toByteArray() {
        return this.data;
    }

    public String toString() {
        String string = "PacketByteArray[ ";
        int n = 0;
        while (n < this.numPackets()) {
            string = String.valueOf(string) + this.getPacketType(n) + " ";
            ++n;
        }
        return String.valueOf(string) + "]";
    }

    public PacketInputStream toPacketInputStream() {
        return new PacketInputStream(new ByteArrayInputStream(this.data));
    }

    public void add(PacketByteArray packetByteArray) throws FormatException {
        if (packetByteArray.numPackets() == 0) {
            return;
        }
        byte[] byArray = packetByteArray.toByteArray();
        if (this.numPackets() == 0) {
            this.data = byArray;
        } else {
            if (Packet.ctbToLengthSpecifier(this.getPacketOffset(this.numPackets() - 1)) == 3) {
                throw new FormatException("PacketByteArray: Cannot concatenate onto unterminated packet");
            }
            byte[] byArray2 = new byte[this.data.length + byArray.length];
            System.arraycopy(this.data, 0, byArray2, 0, this.data.length);
            System.arraycopy(byArray, 0, byArray2, this.data.length, byArray.length);
            this.data = byArray2;
        }
        this.parseData();
    }
}

