/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pgp;

import cryptix.mime.LegacyString;
import cryptix.pgp.CRC;
import cryptix.pgp.DashProtected;
import cryptix.pgp.FormatException;
import cryptix.pgp.PacketByteArray;
import cryptix.security.Cryptix;
import cryptix.util.mime.Base64;
import cryptix.util.mime.QuotedPrintable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public final class ArmouredData {
    private Properties properties;
    private byte[] clearText;
    private PacketByteArray payload;
    private static Base64 base64 = new Base64();
    protected static QuotedPrintable quotedPrintable = new QuotedPrintable();

    public ArmouredData(PacketByteArray packetByteArray) {
        this(new Properties(), packetByteArray);
    }

    public ArmouredData(Properties properties, PacketByteArray packetByteArray) {
        this.properties = properties;
        this.clearText = null;
        this.payload = packetByteArray;
        ((Hashtable)properties).put("version", Cryptix.getVersionString());
    }

    public ArmouredData(byte[] byArray, PacketByteArray packetByteArray) throws FormatException {
        this(new Properties(), byArray, packetByteArray);
    }

    public ArmouredData(Properties properties, byte[] byArray, PacketByteArray packetByteArray) throws FormatException {
        this.properties = properties;
        this.clearText = byArray;
        this.payload = this.payload;
        ((Hashtable)properties).put("version", Cryptix.getVersionString());
        if (this.payload.numPackets() != 1 || this.payload.getPacketType(0) != 2) {
            throw new FormatException("Payload for clearsigned text is not a Signature packet");
        }
    }

    public ArmouredData(String string) throws FormatException {
        this.properties = new Properties();
        this.parse(string);
    }

    public ArmouredData(byte[] byArray) throws FormatException {
        this(LegacyString.toString((byte[])byArray));
    }

    public Properties getProperties() {
        return this.properties;
    }

    public byte[] getClearText() {
        return this.clearText;
    }

    public PacketByteArray getPayload() {
        return this.payload;
    }

    public static String armour(PacketByteArray packetByteArray) {
        byte[] byArray = packetByteArray.toByteArray();
        String string = base64.encode(byArray);
        int n = CRC.checksum(byArray);
        byte[] byArray2 = new byte[]{(byte)(n >> 16), (byte)(n >> 8), (byte)n};
        String string2 = base64.encode(byArray2);
        return String.valueOf(string) + "=" + string2;
    }

    public static PacketByteArray unarmour(String string) throws FormatException {
        int n;
        int n2 = string.indexOf("\r\n=");
        String string2 = string.substring(0, n2);
        byte[] byArray = base64.decode(string2);
        String string3 = string.substring(n2 + 3, n2 + 7);
        byte[] byArray2 = base64.decode(string3);
        int n3 = (byArray2[0] & 0xFF) << 16 | (byArray2[1] & 0xFF) << 8 | byArray2[2] & 0xFF;
        if (n3 != (n = CRC.checksum(byArray))) {
            throw new FormatException("Armoured Data has incorrect CRC");
        }
        return new PacketByteArray(byArray);
    }

    private String propertiesToString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        Enumeration<?> enumeration = this.properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() <= 0) continue;
            String string2 = this.properties.getProperty(string);
            stringBuffer.append(string);
            stringBuffer.append(": ");
            int n = stringBuffer.length();
            stringBuffer.append(string2);
            stringBuffer.setCharAt(n, Character.toUpperCase(string2.charAt(0)));
            stringBuffer.append("\r\n");
        }
        stringBuffer.append("\r\n");
        return new String(stringBuffer);
    }

    private void stringToProperties(String string) throws FormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(": ");
            if (n == -1) {
                throw new FormatException("Header \"" + string2 + "\" does not conform to PGP standard \"Name: Value\"");
            }
            String string3 = string2.substring(0, n);
            if (string3.length() <= 0) continue;
            String string4 = string2.substring(n + 2);
            ((Hashtable)this.properties).put(string3.toLowerCase(), string4);
        }
    }

    public void parse(String string) throws FormatException {
        int n;
        while (string.indexOf(61) != -1 && QuotedPrintable.isProbablyEncoded((String)string)) {
            string = quotedPrintable.decode(string).toString();
        }
        int n2 = string.indexOf("-----BEGIN PGP SIGNED MESSAGE-----\r\n");
        if (n2 != -1) {
            int n3 = string.indexOf("\r\n-----BEGIN PGP SIGNATURE-----\r\n", n2 += 38);
            String string2 = string.substring(n2, n3);
            string2 = DashProtected.decode(string2);
            this.clearText = LegacyString.toByteArray((String)string2);
            n = n3 + 33;
        } else {
            n2 = string.indexOf("-----BEGIN PGP MESSAGE-----\r\n");
            if (n2 != -1) {
                n = n2 + 29;
            } else {
                throw new FormatException("Armoured Data without recognised -----BEGIN");
            }
        }
        int n4 = string.indexOf("\r\n\r\n", n);
        String string3 = string.substring(n, n4);
        this.stringToProperties(string3);
        this.payload = ArmouredData.unarmour(string.substring(n4 + 4));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(8192);
        if (this.clearText != null) {
            String string = LegacyString.toString((byte[])this.clearText);
            string = DashProtected.encode(string);
            stringBuffer.append("-----BEGIN PGP SIGNED MESSAGE-----\r\n\r\n");
            stringBuffer.append(string);
            stringBuffer.append("-----BEGIN PGP SIGNATURE-----\r\n");
            stringBuffer.append(this.propertiesToString());
            stringBuffer.append(ArmouredData.armour(this.payload));
            stringBuffer.append("-----END PGP SIGNATURE-----\r\n");
        } else {
            stringBuffer.append("-----BEGIN PGP MESSAGE-----\r\n");
            stringBuffer.append(this.propertiesToString());
            stringBuffer.append(ArmouredData.armour(this.payload));
            stringBuffer.append("-----END PGP MESSAGE-----\r\n");
        }
        return new String(stringBuffer);
    }
}

