/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.rsa;

import cryptix.CryptixException;
import cryptix.provider.rsa.RSAAlgorithm;
import cryptix.util.core.ArrayUtil;
import cryptix.util.core.BI;
import cryptix.util.core.Debug;
import cryptix.util.core.Hex;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.AsymmetricCipher;
import java.security.Cipher;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.interfaces.RSAFactors;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class RawRSACipher
extends Cipher
implements AsymmetricCipher,
Cloneable {
    private static final boolean DEBUG = true;
    private static final int debuglevel = Debug.getLevel((String)"RSA", (String)"RawRSACipher");
    private static final PrintWriter err = Debug.getOutput();
    private static final boolean WIPE = true;
    private static final int POSITIVE = 1;
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private BigInteger n;
    private BigInteger exp;
    private BigInteger p;
    private BigInteger q;
    private BigInteger u;
    private int blockSize;
    private byte[] temp;

    private static void debug(String string) {
        err.println("RawRSACipher: " + string);
    }

    public RawRSACipher() {
        super(false, false, "Cryptix");
    }

    protected void engineInitEncrypt(Key key) throws InvalidKeyException {
        if (!(key instanceof RSAPublicKey)) {
            throw new InvalidKeyException(String.valueOf(this.getAlgorithm()) + ": Not an RSA public key");
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
        this.n = rSAPublicKey.getModulus();
        this.exp = rSAPublicKey.getExponent();
        if (key instanceof RSAFactors) {
            RSAFactors rSAFactors = (RSAFactors)((Object)key);
            this.p = rSAFactors.getP();
            this.q = rSAFactors.getQ();
            this.u = rSAFactors.getInverseOfQModP();
        }
        this.initInternal();
    }

    protected void engineInitDecrypt(Key key) throws InvalidKeyException {
        if (!(key instanceof RSAPrivateKey)) {
            throw new InvalidKeyException(String.valueOf(this.getAlgorithm()) + ": Not an RSA private key");
        }
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)key;
        this.n = rSAPrivateKey.getModulus();
        this.exp = rSAPrivateKey.getExponent();
        if (key instanceof RSAFactors) {
            RSAFactors rSAFactors = (RSAFactors)((Object)key);
            this.p = rSAFactors.getP();
            this.q = rSAFactors.getQ();
            this.u = rSAFactors.getInverseOfQModP();
        }
        this.initInternal();
    }

    private void initInternal() {
        this.blockSize = BI.getMagnitude((BigInteger)this.n).length;
        this.temp = new byte[this.blockSize];
    }

    protected int enginePlaintextBlockSize() {
        if (this.blockSize == 0) {
            throw new CryptixException(String.valueOf(this.getAlgorithm()) + ": Block size is not valid until key is set");
        }
        return this.blockSize - 1;
    }

    protected int engineCiphertextBlockSize() {
        if (this.blockSize == 0) {
            throw new CryptixException(String.valueOf(this.getAlgorithm()) + ": Block size is not valid until key is set");
        }
        return this.blockSize;
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n4 = this.getState() == 1 ? this.enginePlaintextBlockSize() : this.engineCiphertextBlockSize();
        int n5 = this.getState() == 1 ? this.engineCiphertextBlockSize() : this.enginePlaintextBlockSize();
        int n6 = n2 / n4;
        int n7 = 0;
        while (n7 < n6) {
            ArrayUtil.clear((byte[])this.temp);
            System.arraycopy(byArray, n, this.temp, this.temp.length - n4, n4);
            BigInteger bigInteger = new BigInteger(1, this.temp);
            if (bigInteger.compareTo(this.n) >= 0) {
                throw new CryptixException(String.valueOf(this.getAlgorithm()) + ": Input block value is out of range (>= modulus)");
            }
            BigInteger bigInteger2 = RSAAlgorithm.rsa(bigInteger, this.n, this.exp, this.p, this.q, this.u);
            byte[] byArray3 = BI.getMagnitude((BigInteger)bigInteger2);
            ArrayUtil.clear((byte[])this.temp);
            System.arraycopy(byArray3, 0, this.temp, n5 - byArray3.length, byArray3.length);
            System.arraycopy(this.temp, 0, byArray2, n3, n5);
            n += n4;
            n3 += n5;
            ++n7;
        }
        return n6 * n5;
    }

    public static final void main(String[] stringArray) {
        try {
            RawRSACipher.self_test(new PrintWriter(System.out, true));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static void self_test(PrintWriter printWriter) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "Cryptix");
        SecureRandom secureRandom = new SecureRandom();
        long l = System.currentTimeMillis();
        keyPairGenerator.initialize(1024, secureRandom);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        long l2 = System.currentTimeMillis() - l;
        printWriter.println("Keygen: " + (float)l2 / 1000.0f + " seconds");
        RawRSACipher rawRSACipher = new RawRSACipher();
        rawRSACipher.test(printWriter, keyPair, secureRandom);
    }

    private void test(PrintWriter printWriter, KeyPair keyPair, SecureRandom secureRandom) throws KeyException {
        RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey rSAPublicKey = (RSAPublicKey)keyPair.getPublic();
        long l = System.currentTimeMillis();
        this.initEncrypt(rSAPublicKey);
        BigInteger bigInteger = this.exp;
        byte[] byArray = new byte[this.getPlaintextBlockSize()];
        secureRandom.nextBytes(byArray);
        byte[] byArray2 = this.crypt(byArray);
        long l2 = System.currentTimeMillis();
        this.initDecrypt(rSAPrivateKey);
        byte[] byArray3 = this.crypt(byArray2);
        long l3 = System.currentTimeMillis();
        printWriter.println("         n = " + BI.dumpString((BigInteger)this.n));
        printWriter.println("         e = " + BI.dumpString((BigInteger)bigInteger));
        printWriter.println("         d = " + BI.dumpString((BigInteger)this.exp));
        printWriter.println("         p = " + BI.dumpString((BigInteger)this.p));
        printWriter.println("         q = " + BI.dumpString((BigInteger)this.q));
        printWriter.println("q^-1 mod p = " + BI.dumpString((BigInteger)this.u));
        printWriter.println(" plaintext = " + Hex.toString((byte[])byArray) + "\n");
        printWriter.println("ciphertext = " + Hex.toString((byte[])byArray2) + "\n");
        if (!ArrayUtil.areEqual((byte[])byArray, (byte[])byArray3)) {
            printWriter.println("DECRYPTION FAILED!\n");
            printWriter.println("  computed = " + Hex.toString((byte[])byArray3) + "\n");
        }
        printWriter.println("Encrypt: " + (float)(l2 - l) / 1000.0f + " seconds");
        printWriter.println("Decrypt: " + (float)(l3 - l2) / 1000.0f + " seconds");
    }
}

