;;; $Id: irchat-400.el,v 1.2 1994/08/01 11:28:29 tmo Exp $
;;;
;;; see file irchat-copyright.el for change log and copyright info

(eval-when-compile
  (require 'irchat-inlines))
;;;
;;;  400 replies -- ERRORS
;;; 
(defun irchat-handle-400-msgs (number prefix rest)
  "Generic handler for 4?? messages. This is called if no specific handler exists"
  (if (string-match "[^ ]* \\([^ :]*\\) *\\([^ :]*\\) *:\\(.*\\)" rest)
      (let ((target1 (matching-substring rest 1))
	    (target2 (matching-substring rest 2))
	    (msg (matching-substring rest 3)))
	(cond ((string-equal target1 "")
	       (insert (format "*** Error: %s" msg)))
	      ((string-equal target2 "")
	       (insert (format "*** Error: %s (%s)" msg target1)))
	      (t
	       (insert (format "*** Error: %s %s (%s)" target1 msg target2))))
	(newline))
    (message "IRCHAT: Strange %s reply" number)))


(defun irchat-handle-401-msg (prefix rest) ;;; ERR_NOSUCHNICK
  (if (string-match "[^ ]+ \\([^ ]+\\) +:\\(.*\\)" rest)
      (let ((name (matching-substring rest 1))
	    (error (matching-substring rest 2)))
	(irchat-send "WHOWAS %s" name))
    (message "IRCHAT: Strange 401 reply")))


(defun irchat-handle-406-msg (prefix rest)
  (if (string-match "[^ ]+ \\([^ ]+\\) +:\\(.*\\)" rest)
      (let ((nickorchan (matching-substring rest 1)))
	(message "IRCHAT: No such user %s" nickorchan))))


(defun irchat-handle-412-msg (prefix rest)
  (message "IRCHAT: No text to send"))


(defun irchat-handle-433-msg (prefix rest) ;;; ERR_NICKNAMEINUSE
  "Handle the 433 reply (nickname already in use)"
  (save-excursion
    (set-buffer irchat-Command-buffer)
    (beep)
    (setq irchat-nickname irchat-old-nickname)
    (let ((nick (if (string-match "^\\([^ ]+\\) +\\([^ ]+\\) +:\\(.*\\)" rest)
		    (matching-substring rest 2)
		  (if (string-match "^ *\\([^ ]+\\) :.*" rest)
		      (matching-substring rest 1)
		    "UNKNOWN (Could not figure out, contact developers)"))))
      (message "IRCHAT: Nickname %s already in use.  Choose a new one with %s."
	       nick
	       (substitute-command-keys "\\[irchat-Command-nickname]")))))


(defun irchat-handle-482-msg (prefix rest)
  (message "IRCHAT: You are not a channel operator"))

;;;
;;; eof
;;;
