static char RCSid[] = "$Id: csm.c,v 1.14 1993/01/19 04:00:28 waite Exp waite $";
/* Copyright 1989, The Regents of the University of Colorado
 * Permission is granted to use any portion of this file for any purpose,
 * commercial or otherwise, provided that this notice remains unchanged.
 */

#include <stdio.h>
#include <stdlib.h>
#include "csm.h"
#include "csmtbl.h"


#ifndef NOPRINT

/***/
#if defined(__cplusplus) || defined(__STDC__)
char *
prtstcon(FILE *d, char *p)
#else
char *
prtstcon(d, p)
FILE *d; char *p;
#endif
/* Print a sequence of characters as a string constant without quotes
 *    On exit-
 *       The string pointed to by p has been added to the current
 *          line of d as a string constant without quotes
 *       prtstcon addresses the character following the terminator
 ***/
{
  char c;

  while ((c = *p++ & 0377) != '\0') {
    if (c >= '\177') fprintf(d, "\\%3o", c);
    else if (c == '\\') fprintf(d, "\\\\");
    else if (c == '"') fprintf(d, "\\\"");
    else if (c >= ' ') (void)putc(c, d);
    else switch (c) {
    case '\n': fprintf(d, "\\n"); break;
    case '\t': fprintf(d, "\\t"); break;
    case '\b': fprintf(d, "\\b"); break;
    case '\r': fprintf(d, "\\r"); break;
    case '\f': fprintf(d, "\\f"); break;
    default: fprintf(d, "\\%03o", c); }
  }
  return(p);
}

#ifdef SAVE
/***/
#if defined(__cplusplus) || defined(__STDC__) 
void
savestr(FILE *d)
#else
void
savestr(d)
FILE *d;
#endif
/* Save the current string table state
 *    On exit-
 *       File d is a symbolic encoding of the current state, suitable
 *          for inclusion in the string table module
 ***/
{
  char *p;
  int k, TotalCh;

  TotalCh = 0;
  for (k = 0; k < numstr; k++) TotalCh = TotalCh + strlen(string[k]) + 1;

  fprintf(d, "static struct {char *l; void *p; char c[%d];} csm_data = {\n\
\t&(csm_data.c[%d]),\n\
\t0,\n\
\"", TotalCh, TotalCh);

  for (k = 0; k < numstr; k++) {
    prtstcon(d, string[k]);
    if (k < numstr-1) fprintf(d, "\\0\\\n");
  }
  fprintf(d, "\"};\n\n");

  fprintf(d, "struct obstack csm_obstk = {\n\
\t0,\n\
\t((struct _obstack_chunk *)(&csm_data)),\n\
\t&(csm_data.c[%d]),\n\
\t&(csm_data.c[%d]),\n\
\t&(csm_data.c[%d]),\n\
\t0,\n\
\t0,\n\
\t(struct _obstack_chunk *(*)())obstack_chunk_alloc,\n\
\t(void (*)())obstack_chunk_free\n\
};\n\n", TotalCh, TotalCh, TotalCh);

  fprintf(d, "static struct {char **l; void *p; char *c[%d];} csm_indx = {\n\
\t&(csm_indx.c[%d]),\n\
\t0,\n", numstr, numstr);

  TotalCh = 0;
  for (k = 0; k < numstr; k++) {
    (void)fprintf(d, "\t&(csm_data.c[%d])", TotalCh);
    TotalCh = TotalCh + strlen(string[k]) + 1;
    if (k < numstr-1) fprintf(d, ",\n");
  }

  fprintf(d, "};\n\n");

  fprintf(d, "static struct obstack csm_indx_obstk = {\n\
\t0,\n\
\t((struct _obstack_chunk *)(&csm_indx)),\n\
\t(char *)csm_indx.c,\n\
\t(char *)&(csm_indx.c[%d]),\n\
\t(char *)&(csm_indx.c[%d]),\n\
\t0,\n\
\t0,\n\
\t(struct _obstack_chunk *(*)())obstack_chunk_alloc,\n\
\t(void (*)())obstack_chunk_free\n\
};\n\n", numstr, numstr);

  fprintf(d, "char **string = csm_indx.c;\n\
int numstr = %d;\n\n", numstr);
}
#endif

/***/
#if defined(__cplusplus) || defined(__STDC__) 
void
dmpstr(FILE *d)
#else
void
dmpstr(d)
FILE *d;
#endif
/* Dump the string table
 *    On exit-
 *       The string table contents have been written to d
 ***/
{
  int i;

  if (numstr == 0) fprintf(d,"\n String Table is empty");
  else {
    fprintf(d,"\n String Table Contents-\n");
    for (i = 0; i < numstr; i++) {
      fprintf(d, " \"");
      (void) prtstcon(d, string[i]);
      fprintf(d, "\"\n");
    }
  }
  fprintf(d,"\n\n");
}

#endif

/***/
#if defined(__cplusplus) || defined(__STDC__) 
int
stostr(char *c, int l)
#else
int
stostr(c, l)
char *c; int l;
#endif
/* Store a string in the string table
 *    On entry-
 *       c points to the string to be stored
 *       l>0 = length of the string to be stored
 *    On exit-
 *       stostr=string table index of the stored string
 ***/
{
  obstack_blank(&csm_indx_obstk, sizeof(char *));
  string = (char **)obstack_base(&csm_indx_obstk);

  string[numstr] = obstack_copy0(Csm_obstk, c, l);

  return(numstr++);
}
