SHELL	= /bin/sh

CFLAGS	= 

OBJS	= driver.o parse.o err.o source.o glahead.o auxScanEOL.o \
	idn.o csm.o obstack.o CchStr.o str.o Ccomment.o aux.o \
	pgs_gen.o treecon.o visitprocs.o ptg_gen.o treestack.o \
	attrmain.o dfltclp.o

EXE	= clp.exe

$(EXE):	$(OBJS)
	$(CC) -o $(EXE) $(CFLAGS) $(OBJS)

objects: $(OBJS)

clean:
	rm -f a.out *.o *.a *~ core ERRS $(EXE)

tidy:
	rm -f core a.out *.o *~ *.a ERRS

driver.o:	driver.c HEAD.h INIT.h FINL.h treecon.h ptg_gen.h aux.h \
		err.h treestack.h

parse.o:	parse.c parse.h pgs_gen.h err.h gla.h gsdescr.h

err.o:	err.c err.h source.h

source.o:	source.c source.h

glahead.o:	glahead.c err.h source.h xtables.h xcode.h

auxScanEOL.o:	auxScanEOL.c err.h gla.h source.h

idn.o:	idn.c err.h idn.h csm.h idntbl.h obstack.h

csm.o:	csm.c csm.h csmtbl.h obstack.h

obstack.o:	obstack.c obstack.h

CchStr.o:	CchStr.c err.h source.h gla.h

str.o:	str.c str.h csm.h obstack.h

Ccomment.o:	Ccomment.c err.h gla.h source.h

aux.o:	aux.c csm.h obstack.h

pgs_gen.o:	pgs_gen.c parse.h HEAD.h err.h gla.h gsdescr.h treecon.h \
		ptg_gen.h aux.h treestack.h

treecon.o:	treecon.c HEAD.h node.h visitprocs.h gsdescr.h obstack.h \
		treecon.h ptg_gen.h aux.h err.h treestack.h

visitprocs.o:	visitprocs.c HEAD.h err.h node.h visitprocs.h glattr.h \
		attrpredef.h treecon.h ptg_gen.h aux.h treestack.h

ptg_gen.o:	ptg_gen.c ptg_gen.h

treestack.o:	treestack.c err.h treecon.h treestack.h

attrmain.o:	attrmain.c treecon.h visitprocs.h err.h treestack.h

dfltclp.o:	dfltclp.c source.h

