//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TURLView
//	Include File:	turlview.h
//	Purpose:	Provide a view for a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		02-24-94	created
#define Uses_TInputLine
#define Uses_TLabel
#define Uses_THistory
#define Uses_TProgram
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TButton
#include"turlview.h"
#include"trace.h"
#include"globals.h"

void TURLView::print()	{
//	Purpose:	Print a rendered view image.
//	Arguments:	void
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//		Function does a little dos trick by saving to the requested
//		dos device like LPT1, LPT2, COM1, etc....
//	Revision History:
//		03-24-94	created

#ifndef RELEASE
	trace("printing rendered");
#endif // RELEASE
	//	General use rectangle.
	auto TRect TR(0, 0, 50, 7);

	//	Create a dialog that asks for which dos device to print on.
	TDialog *TDp_print = new TDialog(TR, "Print Rendering");
	if(TDp_print == NULL)	{
		doslynxmessage("Unable to create print dialog.");
		return;
	}

	//	Set some dialog options.
	TDp_print->options |= ofCentered;

	//      Make the input line to enter the dos device to print to.
	TR = TRect(6, 2, 44, 3);
	TInputLine *TILp_dosDevice = new TInputLine(TR, usi_TILURLSize - 1);
	TILp_dosDevice->setData(cp_Printer);
	TDp_print->insert(TILp_dosDevice);


	//	Make the input line's label.
	TR = TRect(5, 1, 25, 2);
	TLabel *TLp_prompt = new TLabel(TR, "~D~evice to print to",
		TILp_dosDevice);
	TDp_print->insert(TLp_prompt);

	//	Make the input line's history.
	TR = TRect(45, 2, 48, 3);
	THistory *THp_printHist = new THistory(TR, TILp_dosDevice,
		usi_PrintHist);
	TDp_print->insert(THp_printHist);

	//	Insert the Ok and Cancel buttons.
	auto TButton *TBp_button;
	TR = TRect(9, 4, 21, 6);
	TBp_button = new TButton(TR, "~O~K", cmOK, bfDefault);
	TDp_print->insert(TBp_button);
	TR = TRect(24, 4, 36, 6);
	TBp_button = new TButton(TR, "~C~ancel", cmCancel, bfNormal);
	TDp_print->insert(TBp_button);

	//	Stay in the device name field.
	TDp_print->selectNext(False);

	//	Draw the dialog.
	TDp_print->drawView();

	//	Execute the dialog.
	if(TProgram::deskTop->execView(TDp_print) != cmCancel)	{
		//	User didn't cancel, save what we got as the device
		//	name.
		auto char ca_buffer[usi_TILURLSize];
		TILp_dosDevice->getData(ca_buffer);
		save(ca_buffer, True);
	}

	//	Done with dialog.
	destroy(TDp_print);
	return;
}