//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TTempName
//	Include File:	ttempnam.h
//	Purpose:	Standardized way of creating a temporary file name.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		02-15-94	created
#include"ttempnam.h"
#include"trace.h"
#include<stdlib.h>
#include<dir.h>

TTempName::~TTempName()	{
//	Purpose:	Destructor
//	Arguments:	void
//	Return Value:	none
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		02-15-94	created

	//	If there is temporary memory to release.
	if(cp_TempName != NULL)	{
		//	If the file exists, delete it.
		struct ffblk ffblk_info;
		int i_done;
		i_done = ::findfirst(cp_TempName, &ffblk_info, 0);
		if(i_done == 0)	{
#ifndef RELEASE
			trace("deleting temporary file " << cp_TempName);
#endif // RELEASE
			unlink();
		}

		//	Release the name space.
		::free((void *)cp_TempName);
	}
}