//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TDosLynx
//	Include File:	tdoslynx.h
//	Purpose:	Application for WWW browser
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		04-05-94	created
#define Uses_TScreen
#define Uses_TDisplay
#define Uses_TMouse
#include"tdoslynx.h"

void TDosLynx::switchVideo()	{
//	Purpose:	Switch the video mode of the app.
//	Arguments:	void
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//		Depends heavily on TurboVision's functionality.
//		Any bugs will be the result of TurboVision.
//		In this function we should also reposition any views that
//		are not currently displayed correctly after a video switch.
//	Revision History:
//		04-05-94	created

	//	Destroy any views that will not reposition
	//	properly.
	remove(THV_heap);
	destroy(THV_heap);
	remove(TDV_disk);
	destroy(TDV_disk);
	remove(TSV_sock);
	destroy(TSV_sock);

	//	Attempt to switch the video mode.
	if(B_isLow == True)	{
		setScreenMode(TDisplay::smFont8x8);
		B_isLow = False;
	}
	else	{
		setScreenMode(TDisplay::smCO80);
		B_isLow = True;
	}

	//	Now that we have switched modes, there are
	//	our idle views that are not positioned
	//	properly.  Recreate them.
	//	Create a heap view in the lower right corner.
	auto TRect TR_extent = getExtent();
	TR_extent.a.x = TR_extent.b.x - 13;
	TR_extent.a.y = TR_extent.b.y - 1;
	THV_heap = (THeapView *)validView(new THeapView(TR_extent));
	insert(THV_heap);

	//	Create a disk view in the lower right corner.
	TR_extent = getExtent();
	TR_extent.a.x = TR_extent.b.x - 26;
	TR_extent.b.x -= 13;
	TR_extent.a.y = TR_extent.b.y - 1;
	TDV_disk = (TDiskView *)validView(new TDiskView(TR_extent));
	insert(TDV_disk);

	//	Create socket activity in the lower right corner.
	TR_extent = getExtent();
	TR_extent.a.x = TR_extent.b.x - 39;
	TR_extent.b.x -= 26;
	TR_extent.a.y = TR_extent.b.y - 1;
	TSV_sock = (TSockView *)validView(new TSockView(TR_extent));
	insert(TSV_sock);

	//	Lastly, the mouse needs to be told that the
	//	screen size is now different.
	TR_extent = getExtent();
	TMouse::setRange(TR_extent.b.x - 1, TR_extent.b.y - 1);
}