;;; $Id: irchat-timer.el,v 1.4 1994/08/01 11:28:29 tmo Exp $
;;;
;;; see file irchat-copyright.el for change log and copyright info

(if (string-match "18" (emacs-version))
    (defun irchat-timer (function interval)
      "Timers are not supported under emacs 18."
      nil)
  (if (string-match ".*Lucid.*" (emacs-version))
      (defun irchat-timer (function interval)
	(interactive)
	(if interval
	    (start-itimer "IRCHAT" function interval interval)))
    (progn
      (eval-when-compile
	(require 'timer))
      (defun irchat-timer (function interval)
	(interactive)
	(if interval
	    (run-at-time (format "%d sec" interval) interval function))))))

;;;
;;; eof
;;;

