/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import tcl.lang.Interp;
import tcl.lang.NamespaceCmd;
import tcl.lang.Procedure;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.Util;
import tcl.lang.Var;

class CallFrame {
    protected Interp interp;
    NamespaceCmd.Namespace ns;
    boolean isProcCallFrame;
    TclObject[] objv;
    protected CallFrame caller;
    protected CallFrame callerVar;
    protected int level;
    protected Hashtable varTable;

    /*
     * WARNING - void declaration
     */
    void chain(Procedure proc, TclObject[] objv) throws TclException {
        void var3_3;
        this.ns = proc.ns;
        this.objv = objv;
        this.level = this.interp.varFrame == null ? 1 : this.interp.varFrame.level + 1;
        this.caller = this.interp.frame;
        this.callerVar = this.interp.varFrame;
        this.interp.frame = this;
        this.interp.varFrame = this;
        int numArgs = proc.argList.length;
        if (!proc.isVarArgs && objv.length - 1 > numArgs) {
            throw new TclException(this.interp, "called \"" + objv[0] + "\" with too many arguments");
        }
        int i = 0;
        int j = 1;
        while (i < var3_3) {
            TclObject varName = proc.argList[i][0];
            TclObject value = null;
            if (i == numArgs - 1 && proc.isVarArgs) {
                value = TclList.newInstance();
                value.preserve();
                int k = j;
                while (k < objv.length) {
                    TclList.append(this.interp, value, objv[k]);
                    ++k;
                }
                this.interp.setVar(varName, value, 0);
                value.release();
            } else {
                if (j < objv.length) {
                    value = objv[j];
                } else if (proc.argList[i][1] != null) {
                    value = proc.argList[i][1];
                } else {
                    throw new TclException(this.interp, "no value given for parameter \"" + varName + "\" to \"" + objv[0] + "\"");
                }
                this.interp.setVar(varName, value, 0);
            }
            ++i;
            ++j;
        }
    }

    static boolean exists(Interp interp, String name) {
        try {
            Var[] result = Var.lookupVar(interp, name, null, 0, "lookup", false, false);
            if (result == null) {
                return false;
            }
            return !result[0].isVarUndefined();
        }
        catch (TclException e) {
            throw new TclRuntimeError("unexpected TclException: " + (Object)((Object)e));
        }
    }

    /*
     * WARNING - void declaration
     */
    Vector getVarNames() {
        void var1_1;
        Vector<String> vector = new Vector<String>();
        if (this.varTable == null) {
            return vector;
        }
        Enumeration e1 = this.varTable.elements();
        while (e1.hasMoreElements()) {
            Var v = (Var)e1.nextElement();
            if (v.isVarUndefined()) continue;
            vector.addElement(v.hashKey);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    Vector getLocalVarNames() {
        void var1_1;
        Vector<String> vector = new Vector<String>();
        if (this.varTable == null) {
            return vector;
        }
        Enumeration e1 = this.varTable.elements();
        while (e1.hasMoreElements()) {
            Var v = (Var)e1.nextElement();
            if (v.isVarUndefined() || v.isVarLink()) continue;
            vector.addElement(v.hashKey);
        }
        return var1_1;
    }

    static int getFrame(Interp interp, String string, CallFrame[] frameArr) throws TclException {
        CallFrame frame;
        int level;
        int curLevel;
        int result = 1;
        int n = curLevel = interp.varFrame == null ? 0 : interp.varFrame.level;
        if (string.length() > 0 && string.charAt(0) == '#') {
            level = Util.getInt(interp, string.substring(1));
            if (level < 0) {
                throw new TclException(interp, "bad level \"" + string + "\"");
            }
        } else if (string.length() > 0 && Character.isDigit(string.charAt(0))) {
            level = Util.getInt(interp, string);
            level = curLevel - level;
        } else {
            level = curLevel - 1;
            result = 0;
        }
        if (level == 0) {
            frame = null;
        } else {
            frame = interp.varFrame;
            while (frame != null) {
                if (frame.level == level) break;
                frame = frame.callerVar;
            }
            if (frame == null) {
                throw new TclException(interp, "bad level \"" + string + "\"");
            }
        }
        frameArr[0] = frame;
        return result;
    }

    protected void dispose() {
        this.interp.frame = this.caller;
        this.interp.varFrame = this.callerVar;
        this.caller = null;
        this.callerVar = null;
        if (this.varTable != null) {
            Var.deleteVars(this.interp, this.varTable);
        }
        this.varTable = null;
    }

    CallFrame(Interp i) {
        this.interp = i;
        this.ns = i.globalNs;
        this.varTable = new Hashtable();
        this.caller = null;
        this.callerVar = null;
        this.objv = null;
        this.level = 0;
        this.isProcCallFrame = true;
    }

    CallFrame(Interp i, Procedure proc, TclObject[] objv) throws TclException {
        this(i);
        try {
            this.chain(proc, objv);
        }
        catch (TclException e) {
            this.dispose();
            throw e;
        }
    }
}

