#include<math.h>

int IsingColor( int x, int y, int subLattices )
{
    return 1 + (x+y)%subLattices; /* square */
    /* return 1 + (x+2*y)%subLattices; */ /* triangular */
}

void hsv2rgb( double h, double s, double v, int *r, int *g, int *b )
{
    double i;
    double f;
    double p, q, t;
    int c;
    
    if(s == 0)
    {
	if(h == 0)
	{
	    *(r) = (int) 65535 * v;
	    *(g) = (int) 65535 * v;
	    *(b) = (int) 65535 * v;
	}
    }
    else
    {
	if(h == 360)
	    h = 0.0;
	h = h / 60.0;
	i = floor(h);
	f = h-i;
	p = 65535 * v * (1.0-s);
	q = 65535 * v * (1.0-(s*f));
	t = 65535 * v * (1.0-(s*(1.0-f)));
	v = 65535 * v;
	c = (int) i;
	
	switch(c)
	{
	    case 0:
	    {
		*(r) = (int) v;
		*(g) = (int) t;
		*(b) = (int) p;
		break;
	    }
	    case 1:
	    {
		*(r) = (int) q;
		*(g) = (int) v;
		*(b) = (int) p;
		break;
	    }
	    case 2:
	    {
		*(r) = (int) p;
		*(g) = (int) v;
		*(b) = (int) t;
		break;
	    }
	    case 3:
	    {
		*(r) = (int) p;
		*(g) = (int) q;
		*(b) = (int) v;
		break;
	    }
	    case 4:
	    {
		*(r) = (int) t;
		*(g) = (int) p;
		*(b) = (int) v;
		break;
	    }
	    case 5:
	    {
		*(r) = (int) v;
		*(g) = (int) p;
		*(b) = (int) q;
		break;
	    }
	}
    }
}
