/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import tcl.lang.Interp;
import tcl.lang.JarFilenameFilter;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;

class TclClassLoader
extends ClassLoader {
    private static Hashtable classes = new Hashtable();
    private String[] classpath;
    private String[] loadpath;

    /*
     * WARNING - void declaration
     */
    protected Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException, SecurityException {
        void var3_3;
        Class<?> result = (Class<?>)classes.get(className);
        if (result != null) {
            return result;
        }
        try {
            result = Class.forName(className);
            return result;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            // empty catch block
        }
        if (className.startsWith("java.") || className.startsWith("tcl.")) {
            throw new SecurityException("Java loader failed to load the class and the Tcl Java loader is not permitted to load classes in the tcl or java package at runtime, check your CLASSPATH.");
        }
        byte[] classData = this.getClassFromPath(this.classpath, className);
        if (classData == null) {
            classData = this.getClassFromPath(this.loadpath, className);
        }
        if (classData == null) {
            throw new ClassNotFoundException(className);
        }
        try {
            result = this.defineClass(className, classData, 0, classData.length);
        }
        catch (NoClassDefFoundError err) {
            throw new ClassFormatError();
        }
        if (result == null) {
            throw new ClassFormatError();
        }
        if (resolveIt) {
            this.resolveClass(result);
        }
        classes.put(className, result);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    Class defineClass(String className, byte[] classData) {
        void var3_3;
        Class<?> result = null;
        try {
            result = this.defineClass(null, classData, 0, classData.length);
        }
        catch (ClassFormatError classFormatError) {
            // empty catch block
        }
        if (result != null) {
            if (className == null) {
                className = result.getName();
            }
            classes.put(className, result);
        }
        return var3_3;
    }

    private byte[] getClassFromPath(String[] paths, String className) {
        int i = 0;
        byte[] classData = null;
        if (paths != null) {
            String curDir;
            className = className.replace('.', File.separatorChar) + ".class";
            i = 0;
            while (i < paths.length) {
                curDir = paths[i].toString();
                try {
                    if (curDir.endsWith(".jar") || curDir.endsWith(".zip")) {
                        classData = this.extractClassFromJar(curDir, className);
                        if (classData != null) {
                            return classData;
                        }
                    } else {
                        File file = new File(curDir, className);
                        if (file.exists()) {
                            FileInputStream fi = new FileInputStream(file);
                            classData = new byte[fi.available()];
                            int total = fi.read(classData);
                            while (total != classData.length) {
                                total += fi.read(classData, total, classData.length - total);
                            }
                            return classData;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            i = 0;
            while (i < paths.length) {
                curDir = paths[i].toString();
                try {
                    classData = this.getClassFromJar(curDir, className);
                    if (classData != null) {
                        return classData;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] getClassFromJar(String curDir, String className) throws IOException {
        void var3_3;
        byte[] result = null;
        JarFilenameFilter jarFilter = new JarFilenameFilter();
        String[] jarFiles = new File(curDir).list(jarFilter);
        int i = 0;
        while (i < jarFiles.length) {
            result = this.extractClassFromJar(curDir + File.separatorChar + jarFiles[i], className);
            if (result != null) break;
            ++i;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] extractClassFromJar(String jarName, String className) throws IOException {
        byte[] byArray;
        ZipInputStream zin;
        block5: {
            byte[] byArray2;
            zin = new ZipInputStream(new FileInputStream(jarName));
            try {
                void var4_4;
                do {
                    ZipEntry entry;
                    if ((entry = zin.getNextEntry()) != null) continue;
                    byArray = null;
                    break block5;
                } while (!className.equals(var4_4.getName()));
                int size = this.getEntrySize(jarName, className);
                byte[] result = new byte[size];
                int total = zin.read(result);
                while (true) {
                    if (total == size) {
                        byArray2 = result;
                        Object var9_10 = null;
                        break;
                    }
                    total += zin.read(result, total, size - total);
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                zin.close();
                throw throwable;
            }
            zin.close();
            return byArray2;
        }
        Object var9_11 = null;
        zin.close();
        return byArray;
    }

    private int getEntrySize(String jarName, String className) throws IOException {
        ZipFile zip = new ZipFile(jarName);
        Enumeration<? extends ZipEntry> enumeration = zip.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry entry = enumeration.nextElement();
            if (!className.equals(entry.getName())) continue;
            zip.close();
            return (int)entry.getSize();
        }
        return -1;
    }

    private static TclObject[] getEnvTclClasspath(Interp interp) throws TclException {
        try {
            return TclList.getElements((Interp)interp, (TclObject)interp.getVar("env", "TCL_CLASSPATH", 1));
        }
        catch (TclException e) {
            interp.resetResult();
            return null;
        }
    }

    private static String absolutePath(Interp interp, String dirName) throws TclException {
        File dir = new File(dirName);
        if (!dir.isAbsolute()) {
            String newName = interp.getWorkingDir().toString() + System.getProperty("file.separator") + dirName;
            dir = new File(newName);
        }
        return dir.toString();
    }

    void removeCache(String className) {
        classes.remove(className);
    }

    TclClassLoader(Interp interp, TclObject pathList) {
        try {
            int i;
            TclObject[] elem;
            if (pathList != null) {
                elem = TclList.getElements((Interp)interp, (TclObject)pathList);
                this.classpath = new String[elem.length];
                i = 0;
                while (i < elem.length) {
                    this.classpath[i] = TclClassLoader.absolutePath(interp, elem[i].toString());
                    ++i;
                }
            }
            if ((elem = TclClassLoader.getEnvTclClasspath(interp)) != null) {
                this.loadpath = new String[elem.length];
                i = 0;
                while (i < elem.length) {
                    this.loadpath[i] = TclClassLoader.absolutePath(interp, elem[i].toString());
                    ++i;
                }
            }
        }
        catch (TclException tclException) {
            // empty catch block
        }
    }
}

