C For Sun's replace ranf by rand and second by etime 
      Program sp
      integer LD,ASZ,K,NITER
C     parameter (LD=2**18-1,ASZ=LD,K=4,NITER=10)
      parameter (LD=2**15-1,ASZ=LD,K=4,NITER=10)
      REAL A(ASZ,K),X(ASZ),Y(ASZ),G(ASZ),B(ASZ),D(ASZ)
      REAL  elapsed,EPS,etime,dist,error,second,tarray(2)
      integer i,n,ncount
      INTEGER AJ(ASZ,K)
      N=ASZ
      EPS=1.0e-6
C INITIALIZATION
      call init(LD,N,K,A,AJ,X,G,B,D)
C     elapsed=second()
      elapsed=etime(tarray)
C MAIN LOOP
      ncount=0
      do 30 i=1,NITER/2
         call spmul(ASZ,n,K,A,AJ,G,X,Y)
         error=dist(N,X,Y)
         ncount=ncount+1
C        if (error.lt.EPS) goto 99
         if (error.lt.0.0) goto 99
         call spmul(ASZ,n,K,A,AJ,G,Y,X)
         error=dist(N,X,Y)
         ncount=ncount+1
C        if (error.lt.EPS) goto 99
         if (error.lt.0.0) goto 99
 30    continue
C Convergence has been met or NITER have been performed 
 99    continue
C     elapsed=second()-elapsed
      elapsed=etime(tarray)-elapsed
      print *, 'The elpased time is ',elapsed, ' seconds.'
      print *, 'N is ',n,' ncount is ',ncount
      print *, 'error is ',error
      print *, 'ORIGINAL MFLOPS = ',(n*K*ncount*2+n)/(1.0e6*elapsed)
      print *, 'MODIFIED MFLOPS = ',
     +          (n*K*ncount*2+n*3*ncount)/(1.0e6*elapsed)
      stop 
      end


      SUBROUTINE spmul(LD,N,K,A,AJ,G,X,Y)

C     Y=A*X+G where A is a sparse matrix with sparsity pattern
C     given by AJ and whose nonzero entries are A

      integer N,K
      integer AJ(LD,K)
      REAL X(N),Y(N),A(LD,K),G(N)
      do 5 i=1,n
         Y(i)=G(i)+A(I,1)*X(AJ(I,1))
 5     continue
      do 10 J=2,K
      do 10 I=1,N
          Y(I)=Y(I)+A(I,J)*X(AJ(I,J))
 10    continue
      return
      end

      subroutine init(LD,N,K,A,AJ,X,G,B,D)
      integer LD,N,K,AJ(LD,K)
      REAL A(LD,K),X(LD),G(LD),B(LD),D(LD)
C Initialize A to be a Jacobi iteation matrix for a
C random sparse matrix (D-A) which is diagonally
C dominant.  Note B is chosen so that the solution of (D-A)x=b is x=1.
      do 5 i=1,n
         D(i)=10.0
 5     continue
      do 10 j=1,K
      do 10 i=1,n
          A(i,j)=rand(0)
C         A(i,j)=ranf()
          D(i)=abs(A(i,j))+D(i)
 10    continue
      do 11 i=1,n
         B(i)=D(i)
 11    continue
      do 12 j=1,K
      do 12 i=1,n
          B(i)=A(i,j)+B(i)
          A(i,j)=-A(i,j)/D(i)
 12    continue
      do 15 j=1,K
      do 15 i=1,n
         AJ(i,j)=(n-1)*rand(0)
C        AJ(i,j)=(n-2)*ranf()+1
         if (AJ(i,j).eq.i) AJ(i,j)=n
 15    continue
      do 17 i=1,n
         G(i)=B(i)/D(i)
 17    continue
C Set the initial guess at the solution to be random.  
      do 20 i=1,n
 20    X(I)=rand(0)
C0    X(I)=ranf()
      return
      end
       
      function dist(n,x,y)
      integer n,i
      real dist,x(n),y(n)
      dist=0.0
      do 10 i=1,n
         dist=dist+(x(i)-y(i))*(x(i)-y(i))
 10    continue
      dist=sqrt(dist)
      return
      end
