use ExtUtils::MakeMaker;

use strict;
use warnings;

# CCFLAGS
my @ccflags;

push @ccflags, "-g3" if $ENV{JS_DEBUG};

# Make sure we know what platform we are compiling for
my @defines;

my $path_separator = ":";
if($^O eq 'MSWin32') {
    push @defines,  "XP_PC";
    $path_separator = ";";
} else {
    push @defines, "XP_UNIX";
}

# Name of lib to link
my $lib = 'js';

# Directories with include files
my @incs;

# Directories with libraries
my @libs;

# Extra header files (sans .h)
my @extra_headers;

# Directory to prefix #include with
my $inc_dir = '';

#test for debian type libsmjs
#this could probably be done better, but I'm not sure how to
#get this platform independant
if (-f "/usr/lib/libmozjs.so" or -f "/usr/local/lib/libmozjs.so") {
    $lib = "mozjs";
}
elsif (-f "/usr/lib/libsmjs.so" or -f "/usr/local/lib/libsmjs.so") {
    $lib = "smjs";
}
if (-f "/usr/include/smjs/jsapi.h") {
    push @incs, "/usr/include/smjs/";
    push @defines, "INCLUDES_IN_SMJS";
	$inc_dir = 'smjs/';
}
elsif(-f "/usr/local/include/smjs/jsapi.h") {
    push @incs, "/usr/local/include/smjs/";
    push @defines, "INCLUDES_IN_SMJS";
}
elsif(-f "/usr/include/mozjs/jsapi.h") {
    push @incs, "/usr/include/mozjs/";
    push @defines, "INCLUDES_IN_MOZJS";
	$inc_dir = 'mozjs/';
}
elsif(-f "/usr/local/include/mozjs/jsapi.h") {
    push @incs, "/usr/local/include/mozjs/";
    push @defines, "INCLUDES_IN_MOZJS";
}

# test for gentoo
if(-f "/etc/gentoo-release") {
    # Gentoo puts libjs in a slightly hidden spot.
    @incs = qw(/usr/lib/MozillaFirefox/include/js/
              /usr/lib/MozillaFirefox/);

}

# test for DarwinPorts
if (-d "/opt/local/include/spidermonkey") {
    push @incs, "/opt/local/include/spidermonkey";
    push @libs, "/opt/local/lib";
}

# Override with $ENV{JS_LIB} and $ENV{JS_INC}
if (exists $ENV{JS_LIB}) {
    @libs = get_paths($ENV{JS_LIB});
    $lib = 'js';
}
if (exists $ENV{JS_INC}) {
    @incs = get_paths($ENV{JS_INC});
    @defines = grep { $_ ne 'INCLUDES_IN_SMJS' } @defines;
	$inc_dir = '';
}

my $libs = join(" ", map { "-L$_" } @libs);

# Handle threadsafe
if(exists $ENV{JS_THREADSAFE}) {
    push @defines, "JS_THREADSAFE" if $ENV{JS_THREADSAFE};
}
else {
    my $enable_threadsafe = prompt("Is your SpiderMonkey compiled with JS_THREADSAFE (most things will fail if you answer wrong)? [y/N]");
    push @defines, "JS_THREADSAFE" if $enable_threadsafe eq 'y';
}

# Check if we need to enable JS_C_STRINGS_ARE_UTF8?
if(exists $ENV{JS_UTF8}) {
    push @defines, "JS_C_STRINGS_ARE_UTF8" if $ENV{JS_UTF8};
}
else {
    my $enable_utf8 = prompt("Is your SpiderMonkey compiled with support for unicode (t/23-unicode.t will fail if you answer wrong) ? [y/N]", "N");
    push @defines, "JS_C_STRINGS_ARE_UTF8" if $enable_utf8 eq 'y';
}

# Check if we want E4X support
if (exists $ENV{JS_ENABLE_E4X}) {
	if ($ENV{JS_ENABLE_E4X}) {
		push @extra_headers, "jsxml";
		push @defines, "JS_ENABLE_E4X";
	}
}
else {
	my $enable_e4x = prompt("Do you want support for E4X (requires SpiderMonkey > 1.5) ? [y/N]", "N");
	if ($enable_e4x eq 'y') {
		push @extra_headers, "jsxml";
		push @defines, "JS_ENABLE_E4X";		
	}
}

# Write JavaScript_Env.h
open my $header, ">JavaScript_Env.h" || die $!;

print $header "/* This file is autogenerated to suite your platform */\n\n";

print $header join("\n", map { "#define $_"} @defines), "\n\n";

foreach my $inc_file (qw(jsapi jsdbgapi jsinterp jsfun jsobj jsprf jsscope), @extra_headers) {
	print $header "#include <${inc_dir}${inc_file}.h>\n";
}

close $header;

# Write makefile

WriteMakefile('NAME'			=> 'JavaScript',
              'VERSION_FROM'	=> 'lib/JavaScript.pm', # finds $VERSION
              'PREREQ_PM'		=> {
                                    'Test::More' => 0,
                                    'Test::Exception' => 0,
                                }, # e.g., Module::Name => 1.1
              ($] >= 5.005 ?    ## Add these new keywords supported since 5.005
               (ABSTRACT_FROM   => 'lib/JavaScript.pm', # retrieve abstract from module
                AUTHOR          => 'Claes Jakobsson <claesjac@cpan.org>') : ()),
			  'CCFLAGS'			=> join(" ", @ccflags),
              'LIBS'			=> ["$libs -l${lib}"], # e.g., '-lm'
              'INC'				=> join(" ", map { "-I$_" } @incs),
			  'LICENSE'			=> 'perl',
          );

sub get_paths {
    my $paths = shift;
    my @paths = map { s/^\s+//; s/\s+$//; $_ } split/$path_separator/, $paths;
    return @paths;
}

package MY;

use File::Spec;

sub post_initialize {
    my($self) = shift;

	$self->{PM}->{"JavaScript.h"} = File::Spec->catfile($self->{INST_ARCHAUTODIR}, 'JavaScript.h');
	$self->{PM}->{"JavaScript_Env.h"} = File::Spec->catfile($self->{INST_ARCHAUTODIR}, 'JavaScript_Env.h');
	$self->{PM}->{"typemap"} = File::Spec->catfile($self->{INST_ARCHAUTODIR}, 'typemap');
	
    return '';
}
