/* Copyright (c) Stichting Mathematisch Centrum, Amsterdam, 1988. */

#include "b.h"
#include "bint.h"
#include "feat.h"
#include "bobj.h"
#include "bfil.h"
#include "i3env.h"
#include "i3scr.h"
#include "release.h"

Hidden Procedure print_heading() {
	if (!f_interactive(stdin))
		return;
	putSstr(stderr,
	"ABC Release %s.\n", RELEASE);
	putstr(stderr,
	"Copyright (c) Stichting Mathematisch Centrum, Amsterdam, 1989.\n");
}

Visible Procedure initcall(argc, argv) int argc; char **argv; {
	bool filearg= No;
	
	/* check call: */
	while (argc > 0) {
		if (argv[0][0] == '-' && argv[0][1] == '\0');
		else if (!F_readable(argv[0])) {
			putSstr(errfile, "can't open input file %s\n", argv[0]);
			immexit(-1);
		}
		else filearg= Yes;
		++argv; --argc;
	}
	/* initial setting flag interactive: */
	interactive= !filearg && f_interactive(stdin);
}

Visible Procedure run_abc(argc, argv) int argc; char **argv; {
	bool filearg= argc > 0;
	
	i_lino= 0;
	while (argc >= 0) {
		if (argc == 0 || (argv[0][0] == '-' && argv[0][1] == '\0')) {
			if (argc == 0 && filearg) break;
			release(iname);
			iname = Vnil;
			ifile = stdin;
			process();
		}
		else {
			filearg= Yes;
			release(iname);
			iname = mk_text(argv[0]);
			if (Isabspath(argv[0]))
				ifile= fopen(argv[0], "r");
			else {
				char *path= makepath(startdir, argv[0]);
				ifile= fopen(path, "r");
				freepath(path);
			}
			if (ifile != NULL) {
				process();
				fclose(ifile);
			}
			else {
				putSstr(errfile, "can't open input file %s\n", argv[0]);
				immexit(-1);
			}
		}
		++argv; --argc;
	}
}

Visible Procedure set_vars() {
	initmess();	/* set messbuf */
	initfmt();	/* set fmtbuf */
	initfile();	/* locate files (messages, keydefs, copybuffer, etc) */
	init_scr();	/* set outeractive and rd_interactive */
	initerr();	/* set errfile (!) */
}

Visible bool in_init= Yes;

extern bool use_bed;

Visible Procedure init(prompt_help) bool prompt_help; {
#ifdef SIGNAL
	initsig();	/* catch signals */
#endif /* SIGNAL */
	if (use_bed) {
		init_erro();	/* buffers for error messages from editor */
		initkeys();	/* read key definitions from termcap and file */
		initterm();	/* start trm module */
		initgram();	/* edi's grammar tables */
		initclasses();	/* suggestions for builtins */
		initbed();	/* top-ep's admin; read copybuffer */
	}
	
	initnum();
	initsyn();
#ifdef TYPE_CHECK
	initpol();
#endif
	initprmnv();
	/* start first output here,
	 * since trm module may start alternative screen ... */
	print_heading();
	if (interactive && prompt_help)
		putmess(errfile, MESS(1700, "Type '?' for help.\n"));
	/* ... and initbws() prints ">current_ws_name" */
	initbws();

	in_init= No;
}

Visible Procedure endall() {
	/* real tasks: */
	endbws();
	if (use_bed) {
		endbed();	/* save editor parsetree and copybuffer */
		endterm();	/* reset terminal */
	}

#ifdef MEMTRACE
	/* the following only free memory: */
	endstrval();	/* hack to free strval static store */
	endnoderepr();	/* hack to free noderepr static store */

#ifdef TYPE_CHECK
	endpol();
#endif
	endsta();
	endsyn();
	endnum();
#ifdef USERSUGG
	endclasses();
#endif
	end_erro();
	end_scr();
	endfile();
	endmess();
#endif /* MEMTRACE */
}

Visible Procedure crashend() {
	if (cntxt != In_wsgroup && cntxt != In_prmnv)
		endbws();
}
