#ifndef Plane_hpp
#define Plane_hpp

#include "Vector.hpp"

namespace swShader
{
	struct Matrix;
	struct Point;

	struct Plane
	{
		union
		{
			struct
			{
				float A;
				float B;
				float C;
			};
			struct
			{
				Vector n;
			};
		};

		float D;   // Distance to origin along normal

		Plane();
		Plane(const Plane &p);
		Plane(const Vector &n, float D);   // Normal and distance to origin
		Plane(const Vector &n, const Point &P);   // Normal and point on plane
		Plane(const Point &P0, const Point &P1, const Point &P2);   // Through three points
		Plane(float A, float B, float C, float D);   // Plane equation 
		Plane(const float ABCD[4]);

		Plane &operator=(const Plane &p);

		Plane operator+() const;
		Plane operator-() const;   // Flip normal

		Plane &operator*=(const Matrix &A);   // Transform plane by matrix (post-multiply)

		friend Plane operator*(const Plane &p, const Matrix &A);   // Transform plane by matrix (post-multiply)
		friend Plane operator*(const Matrix &A, const Plane &p);   // Transform plane by matrix (pre-multiply)

		friend float operator^(const Plane &p1, const Plane &p2);   // Angle between planes

		float d(const Point &P) const;   // Oriented distance between point and plane

		static float d(const Point &P, const Plane &p);   // Oriented distance between point and plane
		static float d(const Plane &p, const Point &P);   // Oriented distance between plane and point

		Plane &normalise();   // Normalise the Plane equation
	};
}

#endif   // Plane_hpp
