/* The GIMP -- an image manipulation program
 * Copyright (C) 1999 Ray Lehtiniemi
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "libgimp/gimp.h"
#include "server.h"
#include "interp.h"


static void
quit (void)
{
}

static void
query (void)
{
  static GParamDef server_args[] =
  {
    { PARAM_INT32,  "run_mode",  "[Interactive], non-interactive" },
    { PARAM_INT32,  "port",      "The port on which to listen for requests" },
    { PARAM_STRING, "logfile",   "The file to log server activity to" }
  };
  static gint nserver_args = sizeof (server_args) / sizeof (server_args[0]);

  gimp_install_procedure ("extension_guile_fu",
			  "Provides a server for remote guile operation",
			  "Provides a server for remote guile operation",
			  "Ray Lehtiniemi",
			  "Ray Lehtiniemi",
			  "1999",
			  "<Toolbox>/Xtns/Guile-Fu",
			  "",
			  PROC_EXTENSION,
			  nserver_args, 0,
			  server_args, NULL);
}

static void
run (gchar    *name,
     gint      nparams,
     GParam   *param,
     gint     *nreturn_vals,
     GParam  **return_vals)
{
  run_the_server (name, nparams, param, nreturn_vals, return_vals);
}

GPlugInInfo PLUG_IN_INFO =
{
  NULL,
  quit,
  query,
  run,
};

static int
inner_main (int argc, char * argv[])
{
  if ((argc >= 4) && (! strcmp (argv[1], "-gimp")))
    {
      return gimp_main (argc, argv);
    }
  else
    {
      interp_init ();
      interp_main ();
      return 0;
    }
}

int
main (int argc, char * argv[])
{
  gh_enter (argc, argv, inner_main);
  return 0;
}
