#!/usr/bin/perl -w

print <<EOF;
/* Generated by makegalias.pl */

#ifndef DISABLE_VISIBILITY

#include "glibconfig.h"

#ifdef G_HAVE_GNUC_VISIBILITY

#ifdef  G_DISABLE_DEPRECATED
#define WAS_NO_G_DEPR
#endif
#undef  G_DISABLE_DEPRECATED

#include "glib.h"

#include "gprintf.h"

#if !defined(G_OS_UNIX) || defined(G_STDIO_NO_WRAP_ON_UNIX)
#include "gstdio.h"
#endif

#ifdef G_OS_WIN32
#include "gwin32.h"
#endif

EOF

my $in_comment = 0;
my $in_skipped_section = 0;

while (<>) {

  # ignore empty lines
  next if /^\s*$/;

  # skip comments
  if ($_ =~ /^\s*\/\*/)
  {
      $in_comment = 1;
  }
  
  if ($in_comment)
  {
      if ($_ =~  /\*\/\s$/)
      {
	  $in_comment = 0;
      }
      
      next;
  }

  # handle ifdefs
  if ($_ =~ /^\#endif/)
  {
      if (!$in_skipped_section)
      {
	  print $_;
      }

      $in_skipped_section = 0;

      next;
  }

  if ($_ =~ /^\#ifdef\s+(INCLUDE_VARIABLES|INCLUDE_INTERNAL_SYMBOLS)/)
  {
      $in_skipped_section = 1;
  }

  if ($in_skipped_section)
  {
      next;
  }

  if ($_ =~ /^\#ifn?def\s+(G|DISABLE_MEM_POOLS)/)
  {
      print $_;
      
      next;
  }

  if ($_ =~ /^\#if.*G_STDIO_NO_WRAP_ON_UNIX/)
  {
      print $_;
      
      next;
  }

  chop;
  my $str = $_;
  my @words;
  my $attributes = "";

  @words = split(/ /, $str);
  $str = shift(@words);
  chomp($str);
  my $alias = "IA__".$str;
  
  # Drop any Win32 specific .def file syntax,  but keep attributes
  foreach $word (@words) {
      $attributes = "$attributes $word" unless $word eq "PRIVATE";
  }
      
  print <<EOF
extern __typeof ($str) $alias __attribute((visibility("hidden")))$attributes;
extern __typeof ($str) $str __attribute((alias("$alias"), visibility("default")));
\#define $str $alias

EOF
}

print <<EOF;

#ifdef  WAS_NO_G_DEPR
#define G_DISABLE_DEPRECATED
#undef  WAS_NO_G_DEPR
#endif

#endif /* G_HAVE_GNUC_VISIBILITY */

#endif /* DISABLE_VISIBILITY */
EOF


