/*
 * "p" - A very simple Project Manager using the GIMP Toolkit
 * Copyright (c) 1998  Elmar Ludwig - Universitaet Osnabrueck
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef MANAGER_H
#define MANAGER_H

#include <Foundation/NSObject.h>

#define TEXT_EDITOR	@"xterm -e vi"
#define LAUNCH_CMD	@"xterm -e"
#define DEBUG_CMD	@"xterm -e gdb"
#define MAKE_CMD	@"make 2>&1"
#define MAKEFILE_GEN	@"mfg"

@class GTKList, GTKListItem;
@class GTKOptionMenu;
@class GTKAction;
@class NSMutableDictionary;
@class NSArray, NSSring;

@interface Manager : NSObject
{
    GTKList *list1;
    GTKList *list2;
    GTKOptionMenu *target;

    NSMutableDictionary *files;
    NSArray *groups;
    NSString *program;
    NSString *path;
    NSString *filename;
}

- (void) info:sender;
- (void) select:sender;
- (void) selectFile:sender;
- (void) add:sender;
- (void) addFile:(GTKListItem *) group;
- (void) ok:sender;
- (void) cancel:sender;
- (void) remove:sender;
- (void) open:sender;
- (void) launch:sender;
- (void) debug:sender;
- (void) attrib:sender;
- (void) build:sender;
- (void) loadFromFile:(NSString *) filename;
- (void) save:sender;
- (void) saveToFile:(NSString *) filename;
@end

#endif
