/*
 * GtkMyToolbar Sample program by Kemal 'Disq' Hadimli
 * GtkMyToolbar modified from GtkToolbar by Federico Mena
 *
 * Coded for GTK - The GIMP Toolkit
 * Copyright (C) 1995-1997 Peter Mattis, Spencer Kimball and Josh MacDonald
 * GtkToolbar copyright (C) Federico Mena
 *
 *
 * WARNING: This _IS_ dirty code.
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include <stdio.h>
#include <gtk/gtk.h>
#include "a1.xpm"
#include "a2.xpm"
#include "b1.xpm"
#include "b2.xpm"
#include "c1.xpm"

#include "gtkmytoolbar.h"



GtkWidget *win; /* main window */
GtkWidget *tbar; /* our toolbar */


/* taken from testgtk */
GtkWidget* new_pixmap (gchar *name[], GdkWindow *window, GdkColor  *background)
{
  GtkWidget *wpixmap;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  pixmap = gdk_pixmap_create_from_xpm_d (window, &mask, background,name);
  wpixmap = gtk_pixmap_new (pixmap, mask);
  gdk_pixmap_unref (pixmap);
  return wpixmap;
}



gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  return (FALSE);
}

void destroy (GtkWidget *widget, gpointer data)
{
  gtk_main_quit ();
}


void Change_Style(GtkWidget *widget, int incdec)
{
  int i;
  i=(GTK_MYTOOLBAR(tbar)->style)+incdec;
  if (i<0) i+=3;
  gtk_mytoolbar_set_style(GTK_MYTOOLBAR(tbar), i%3);
}


void Print_Message(GtkWidget *widget, char *text)
{
  puts(text);
}



void create_main ()
{
  GtkWidget *handlebox;

  win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(win), "MyToolbar Test");
  gtk_window_set_policy(GTK_WINDOW(win), TRUE, TRUE, TRUE);
  gtk_signal_connect(GTK_OBJECT(win),"delete_event",GTK_SIGNAL_FUNC(delete_event),NULL);
  gtk_signal_connect(GTK_OBJECT(win),"destroy",GTK_SIGNAL_FUNC(destroy),NULL);


  gtk_widget_realize(win);

  handlebox = gtk_handle_box_new();
  gtk_widget_show(handlebox);
  gtk_container_add(GTK_CONTAINER(win), handlebox);

  tbar=gtk_mytoolbar_new(GTK_ORIENTATION_HORIZONTAL, GTK_MYTOOLBAR_BOTH);
  gtk_container_add (GTK_CONTAINER(handlebox), tbar);

  gtk_mytoolbar_append_item_2(GTK_MYTOOLBAR(tbar),"First", "two pixmaps, click to change style", "",
			       new_pixmap (a1_xpm, win->window, &win->style->bg[GTK_STATE_NORMAL]),
			       new_pixmap (a2_xpm, win->window, &win->style->bg[GTK_STATE_NORMAL]),
			       (GtkSignalFunc)Change_Style, (gpointer) 1);

  gtk_mytoolbar_append_item_2(GTK_MYTOOLBAR(tbar),"Second", "two pixmaps again, click to change style backwards", "",
			       new_pixmap (b1_xpm, win->window, &win->style->bg[GTK_STATE_NORMAL]),
			       new_pixmap (b2_xpm, win->window, &win->style->bg[GTK_STATE_NORMAL]),
			       (GtkSignalFunc)Change_Style, (gpointer) -1);

  gtk_mytoolbar_append_item(GTK_MYTOOLBAR(tbar),"Third", "this one's created with append_item, which is 100% compatible with gtk_toolbar_append_item", "",
			       new_pixmap (c1_xpm, win->window, &win->style->bg[GTK_STATE_NORMAL]),
			       (GtkSignalFunc)Print_Message, (gpointer) "You clicked to the Third button!");

  gtk_widget_show (tbar);
  gtk_widget_show(win);
}




int main (int argc, char *argv[])
{
  gtk_set_locale();
  gtk_init(&argc, &argv);

  create_main();

  gtk_main();
  return(0);
}
